/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.guiutil.LabeledValue;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.NodeSetExpr;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.command.XSearchFormInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SimpleXSearchForm
extends JPanel
implements ItemListener {
    private static final int AXIS_FOLLOWING = 0;
    private static final int AXIS_FOLLOWING_SIBLING = 1;
    private static final int AXIS_PRECEDING = 2;
    private static final int AXIS_PRECEDING_SIBLING = 3;
    private static final int AXIS_DESCENDANT = 4;
    private static final int AXIS_DESCENDANT_OR_SELF = 5;
    private static final int AXIS_CHILD = 6;
    private static final int AXIS_ANCESTOR = 7;
    private static final int AXIS_ANCESTOR_OR_SELF = 8;
    private static final int AXIS_PARENT = 9;
    private static final int AXIS_DESCENDANT_OF_DOCUMENT = 10;
    private static final int OP_EQUALS = 0;
    private static final int OP_CONTAINS = 1;
    private static final int OP_MATCHES = 2;
    private JComboBox axisCombo;
    private JTextField elementNameField;
    private JCheckBox attributeToggle;
    private JTextField attributeNameField;
    private JComboBox attributeOpCombo;
    private JTextField attributeValueField;
    private JCheckBox textToggle;
    private JComboBox textOpCombo;
    private JTextField textField;

    public SimpleXSearchForm() {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        HintLabel hintLabel = new HintLabel(Msg.msg("SXSF.emptyFieldMeansAny"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)hintLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("SXSF.find");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        LabeledValue[] labeledValueArray = new LabeledValue[]{new LabeledValue(Msg.msg("SXSF.following"), 0), new LabeledValue(Msg.msg("SXSF.followingSibling"), 1), new LabeledValue(Msg.msg("SXSF.preceding"), 2), new LabeledValue(Msg.msg("SXSF.precedingSibling"), 3), new LabeledValue(Msg.msg("SXSF.descendant"), 4), new LabeledValue(Msg.msg("SXSF.descendantOrSelf"), 5), new LabeledValue(Msg.msg("SXSF.child"), 6), new LabeledValue(Msg.msg("SXSF.ancestor"), 7), new LabeledValue(Msg.msg("SXSF.ancestorOrSelf"), 8), new LabeledValue(Msg.msg("SXSF.parent"), 9), new LabeledValue(Msg.msg("SXSF.descendantOfDocument"), 10)};
        this.axisCombo = new JComboBox<LabeledValue>(labeledValueArray);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.axisCombo, gridBagConstraints);
        jLabel.setLabelFor(this.axisCombo);
        string = Msg.msg("SXSF.elementName");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.elementNameField = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.elementNameField, gridBagConstraints);
        jLabel.setLabelFor(this.elementNameField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        string = Msg.msg("SXSF.havingAttribute");
        this.attributeToggle = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.attributeToggle, string);
        this.attributeToggle.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.attributeToggle, gridBagConstraints);
        this.attributeNameField = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.attributeNameField, gridBagConstraints);
        LabeledValue[] labeledValueArray2 = new LabeledValue[]{new LabeledValue(Msg.msg("SXSF.equals"), 0), new LabeledValue(Msg.msg("SXSF.contains"), 1), new LabeledValue(Msg.msg("SXSF.matches"), 2)};
        this.attributeOpCombo = new JComboBox<LabeledValue>(labeledValueArray2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.attributeOpCombo, gridBagConstraints);
        this.attributeValueField = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.attributeValueField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        string = Msg.msg("SXSF.containingText");
        this.textToggle = new JCheckBox(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.textToggle, string);
        this.textToggle.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)this.textToggle, gridBagConstraints);
        this.textOpCombo = new JComboBox<LabeledValue>(labeledValueArray2);
        ++gridBagConstraints.gridx;
        jPanel3.add((Component)this.textOpCombo, gridBagConstraints);
        this.textField = new JTextField(20);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 5;
        jPanel3.add((Component)this.textField, gridBagConstraints);
        this.toggleAttribute();
        this.toggleText();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.attributeToggle) {
            this.toggleAttribute();
        } else {
            this.toggleText();
        }
    }

    private void toggleAttribute() {
        boolean bl;
        Color color;
        if (this.attributeToggle.isSelected()) {
            color = this.elementNameField.getBackground();
            bl = true;
        } else {
            color = this.getBackground();
            bl = false;
        }
        if (!bl) {
            this.attributeNameField.setText("");
            this.attributeOpCombo.setSelectedIndex(0);
            this.attributeValueField.setText("");
        }
        this.attributeNameField.setBackground(color);
        this.attributeNameField.setEnabled(bl);
        this.attributeOpCombo.setEnabled(bl);
        this.attributeValueField.setBackground(color);
        this.attributeValueField.setEnabled(bl);
    }

    private void toggleText() {
        boolean bl;
        Color color;
        if (this.textToggle.isSelected()) {
            color = this.elementNameField.getBackground();
            bl = true;
        } else {
            color = this.getBackground();
            bl = false;
        }
        if (!bl) {
            this.textOpCombo.setSelectedIndex(0);
            this.textField.setText("");
        }
        this.textOpCombo.setEnabled(bl);
        this.textField.setBackground(color);
        this.textField.setEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.elementNameField.addActionListener(actionListener);
        this.attributeNameField.addActionListener(actionListener);
        this.attributeValueField.addActionListener(actionListener);
        this.textField.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.elementNameField.removeActionListener(actionListener);
        this.attributeNameField.removeActionListener(actionListener);
        this.attributeValueField.removeActionListener(actionListener);
        this.textField.removeActionListener(actionListener);
    }

    public void setActionCommand(String string) {
        this.elementNameField.setActionCommand(string);
        this.attributeNameField.setActionCommand(string);
        this.attributeValueField.setActionCommand(string);
        this.textField.setActionCommand(string);
    }

    public XSearchFormInfo getInfo(NamespacePrefixMap namespacePrefixMap, boolean bl) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        LabeledValue labeledValue = (LabeledValue)this.axisCombo.getSelectedItem();
        switch (labeledValue.intValue()) {
            case 0: {
                stringBuffer.append("following::");
                break;
            }
            case 1: {
                stringBuffer.append("following-sibling::");
                break;
            }
            case 2: {
                stringBuffer.append("preceding::");
                break;
            }
            case 3: {
                stringBuffer.append("preceding-sibling::");
                break;
            }
            case 4: {
                stringBuffer.append("descendant::");
                break;
            }
            case 5: {
                stringBuffer.append("descendant-or-self::");
                break;
            }
            case 6: {
                stringBuffer.append("child::");
                break;
            }
            case 7: {
                stringBuffer.append("ancestor::");
                break;
            }
            case 8: {
                stringBuffer.append("ancestor-or-self::");
                break;
            }
            case 9: {
                stringBuffer.append("parent::");
                break;
            }
            case 10: {
                stringBuffer.append("//");
            }
        }
        String string = this.elementNameField.getText().trim();
        if (string.length() == 0) {
            stringBuffer.append("*");
        } else {
            object2 = SimpleXSearchForm.parseName(string, false, namespacePrefixMap, bl);
            if (object2 == null) {
                DialogUtil.badField(this.elementNameField);
                return null;
            }
            if (!bl) {
                string = ((Name)object2).format(true, namespacePrefixMap);
            }
            stringBuffer.append(string);
        }
        if (this.attributeToggle.isSelected()) {
            stringBuffer.append('[');
            string = this.attributeNameField.getText().trim();
            if (string.length() == 0) {
                object2 = "*";
            } else {
                object = SimpleXSearchForm.parseName(string, true, namespacePrefixMap, bl);
                if (object == null) {
                    DialogUtil.badField(this.attributeNameField);
                    return null;
                }
                object2 = string;
            }
            string = this.attributeValueField.getText();
            if (string.length() == 0) {
                stringBuffer.append('@');
                stringBuffer.append((String)object2);
            } else {
                labeledValue = (LabeledValue)this.attributeOpCombo.getSelectedItem();
                switch (labeledValue.intValue()) {
                    case 0: {
                        stringBuffer.append('@');
                        stringBuffer.append((String)object2);
                        stringBuffer.append('=');
                        stringBuffer.append(SimpleXSearchForm.quoteString(string));
                        break;
                    }
                    case 1: {
                        stringBuffer.append("contains(@");
                        stringBuffer.append((String)object2);
                        stringBuffer.append(',');
                        stringBuffer.append(SimpleXSearchForm.quoteString(string));
                        stringBuffer.append(')');
                        break;
                    }
                    case 2: {
                        stringBuffer.append("matches(@");
                        stringBuffer.append((String)object2);
                        stringBuffer.append(',');
                        stringBuffer.append(SimpleXSearchForm.quoteString(string));
                        stringBuffer.append(')');
                    }
                }
            }
            stringBuffer.append(']');
        }
        if (this.textToggle.isSelected()) {
            stringBuffer.append('[');
            string = this.textField.getText();
            if (string.length() == 0) {
                stringBuffer.append("string(.)!=''");
            } else {
                labeledValue = (LabeledValue)this.textOpCombo.getSelectedItem();
                switch (labeledValue.intValue()) {
                    case 0: {
                        stringBuffer.append(".=");
                        stringBuffer.append(SimpleXSearchForm.quoteString(string));
                        break;
                    }
                    case 1: {
                        stringBuffer.append("contains(.,");
                        stringBuffer.append(SimpleXSearchForm.quoteString(string));
                        stringBuffer.append(')');
                        break;
                    }
                    case 2: {
                        stringBuffer.append("matches(.,");
                        stringBuffer.append(SimpleXSearchForm.quoteString(string));
                        stringBuffer.append(')');
                    }
                }
            }
            stringBuffer.append(']');
        }
        stringBuffer.append("[1]");
        object2 = stringBuffer.toString();
        try {
            object = ExprParser.parseNodeSetExpr((String)object2, namespacePrefixMap, bl);
        }
        catch (ParseException parseException) {
            Alert.showError(this, Msg.msg("SXSF.internalError", object2, MiscUtil.reason(parseException)));
            return null;
        }
        return new XSearchFormInfo((String)object2, (NodeSetExpr)object);
    }

    private static final Name parseName(String string, boolean bl, NamespacePrefixMap namespacePrefixMap, boolean bl2) {
        Name name = Name.parse(string, bl, namespacePrefixMap);
        if (name == null && bl2 && XMLUtil.isName(string)) {
            name = Name.get(string);
        }
        return name;
    }

    private static final String quoteString(String string) {
        if (string.indexOf(39) < 0) {
            return "'" + string + "'";
        }
        if (string.indexOf(34) < 0) {
            return "\"" + string + "\"";
        }
        return "\"" + StringUtil.replaceAll(string, "\"", "&#34;") + "\"";
    }
}

