/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.NodeSetExpr;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.command.XPathSearchDialog;
import com.xmlmind.xmleditapp.command.XPathSearchForm;
import com.xmlmind.xmleditapp.command.XSearchFormInfo;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.HashMap;

public class XPathSearch
extends RecordableCommand
implements PrefixToNamespace {
    private static boolean dialogHasHelp;
    private HashMap prefixToNamespaceMap = new HashMap();
    private ExprContext exprContext = new SimpleExprContext();
    private XPathSearchForm xpathSearchForm = null;
    private XNode contextNode;
    private String expression;
    private NodeSetExpr selector;

    public static void setDialogHasHelp(boolean bl) {
        dialogHasHelp = bl;
    }

    public static boolean getDialogHasHelp() {
        return dialogHasHelp;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        this.contextNode = null;
        this.expression = null;
        this.selector = null;
        DocumentView documentView = (DocumentView)gadget;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string != null && string.startsWith("[")) {
            int n3 = string.indexOf(32, 1);
            if (n3 > 0) {
                object3 = string.substring(0, n3);
                string = string.substring(n3 + 1);
            } else {
                object3 = string;
                string = null;
            }
            boolean bl3 = bl = ((String)object3).indexOf("[implicitElement]") >= 0;
            if (!bl) {
                boolean bl4 = bl2 = ((String)object3).indexOf("[implicitNode]") >= 0;
            }
        }
        if ((object3 = markManager.getSelected()) != null) {
            this.contextNode = ((NodeMark)object3).getNode();
            object2 = markManager.getSelected2();
            if (object2 != null && ((NodeMark)object2).getNode() != this.contextNode) {
                return false;
            }
        } else {
            if (!bl && !bl2) {
                return false;
            }
            object2 = markManager.getDot();
            if (object2 == null) {
                return false;
            }
            object = markManager.getMark();
            if (object != null && (((TextLocation)object).getTextNode() != ((TextLocation)object2).getTextNode() || ((TextLocation)object).getOffset() != ((TextLocation)object2).getOffset())) {
                return false;
            }
            this.contextNode = ((TextLocation)object2).getTextNode();
            if (bl) {
                this.contextNode = this.contextNode.parent();
            }
        }
        if (string != null && string.length() > 0) {
            if ((string = string.trim()).indexOf(123) >= 0) {
                this.prefixToNamespaceMap.clear();
                object = Long.toString(System.currentTimeMillis(), 36);
                this.expression = XPathSearch.substituteNamespaces(string, (String)object, this.prefixToNamespaceMap);
                object2 = this;
            } else {
                this.expression = string;
                object2 = this.contextNode.namespacePrefixMap();
            }
            boolean bl5 = !DocumentTypeUtil.isNamespaceAware((Document)this.contextNode.document());
            try {
                this.selector = ExprParser.parseNodeSetExpr(this.expression, (PrefixToNamespace)object2, bl5);
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    private static final String substituteNamespaces(String string, String string2, HashMap hashMap) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            switch (c) {
                case '{': {
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer();
                        break;
                    }
                    return string;
                }
                case '}': {
                    if (stringBuffer2 != null) {
                        String string3 = stringBuffer2.toString().trim();
                        if (string3.length() == 0) {
                            return string;
                        }
                        String string4 = (String)hashMap2.get(string3);
                        if (string4 == null) {
                            string4 = string2 + n++;
                            hashMap.put(string4, Namespace.get(string3));
                            hashMap2.put(string3, string4);
                        }
                        stringBuffer.append(string4);
                        stringBuffer.append(':');
                        stringBuffer2 = null;
                        break;
                    }
                    return string;
                }
                default: {
                    if (stringBuffer2 != null) {
                        stringBuffer2.append(c);
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        if (stringBuffer2 != null) {
            return string;
        }
        return stringBuffer.toString();
    }

    public Namespace prefixToNamespace(String string) {
        Namespace namespace = (Namespace)this.prefixToNamespaceMap.get(string);
        if (namespace == null) {
            namespace = this.contextNode.namespacePrefixMap().prefixToNamespace(string);
        }
        return namespace;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        boolean bl2 = bl = this.selector == null;
        if (bl) {
            if (this.xpathSearchForm == null) {
                this.xpathSearchForm = new XPathSearchForm();
                this.xpathSearchForm.setActionCommand("ok");
            }
            object4 = new XPathSearchDialog(documentView.getPanel(), Msg.msg("XS.title"), dialogHasHelp, this.xpathSearchForm);
            this.xpathSearchForm.addActionListener((ActionListener)object4);
            boolean bl3 = !DocumentTypeUtil.isNamespaceAware((Document)this.contextNode.document());
            object3 = ((XPathSearchDialog)object4).getInfo(this.contextNode.namespacePrefixMap(), bl3);
            this.xpathSearchForm.removeActionListener((ActionListener)object4);
            if (object3 == null) {
                return Command.EXECUTION_FAILED;
            }
            this.expression = ((XSearchFormInfo)object3).expression;
            this.selector = ((XSearchFormInfo)object3).selector;
            this.xpathSearchForm.getAdvancedXSearchForm().addToHistory(this.expression);
        }
        object4 = null;
        XNode xNode = null;
        object3 = null;
        try {
            object2 = this.selector.eval(this.contextNode, this.exprContext);
            while ((object = object2.next()) != null) {
                switch (object.type()) {
                    case 6: {
                        object = object.parent();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        if (object.parent().type() == 4) break;
                        object = null;
                        break;
                    }
                    default: {
                        object = null;
                    }
                }
                if (object == null) continue;
                if (object4 == null) {
                    object3 = object;
                    xNode = object3;
                } else {
                    if (object.preceding() != object4) {
                        object3 = xNode;
                        break;
                    }
                    object3 = object;
                }
                object4 = object;
            }
        }
        catch (EvalException evalException) {
            Alert.showError(documentView.getPanel(), Msg.msg("XS.cannotEval", ShowStatus.shorten(this.expression, 80), MiscUtil.reason(evalException)));
            return Command.EXECUTION_FAILED;
        }
        if (xNode == null) {
            ShowStatus.showStatus(Msg.msg("XS.notFound", ShowStatus.shorten(this.expression, 40)));
            return Command.EXECUTION_FAILED;
        }
        if (bl) {
            object2 = new StringBuffer();
            if (string != null && string.length() > 0) {
                ((StringBuffer)object2).append(string.trim());
                ((StringBuffer)object2).append(' ');
            }
            ((StringBuffer)object2).append(this.expression);
            string = ((StringBuffer)object2).toString();
        }
        documentView.addToCommandHistory(this, string, Msg.msg("XS.title"));
        if (object3 != xNode) {
            object2 = (Node)object3;
            documentView.selectNodeRange((Node)xNode, (Node)object2);
        } else {
            object2 = (Node)xNode;
            documentView.selectNode((Node)object2);
        }
        documentView.ensureViewIsExpanded((Node)object2);
        object = documentView.modelToView((Node)object2);
        if (object != null) {
            documentView.makeRectangleVisible((Rectangle)object);
        }
        return null;
    }
}

