/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.gadget.BindingBase;
import com.xmlmind.xmledit.gadget.UserInput;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.InfoUtil;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public final class BindingInfo
extends Info {
    public static CompareBindingByTrigger compareBindingByTrigger = new CompareBindingByTrigger();
    public HashMap specs = new HashMap();

    public BindingInfo() {
        this(null);
    }

    public BindingInfo(BindingSpec[] bindingSpecArray) {
        if (bindingSpecArray != null) {
            int n = 0;
            while (n < bindingSpecArray.length) {
                BindingSpec bindingSpec = bindingSpecArray[n];
                this.specs.put(bindingSpec, bindingSpec);
                ++n;
            }
        }
    }

    public BindingSpec[] getBindingSpecs() {
        BindingSpec[] bindingSpecArray = new BindingSpec[this.specs.size()];
        this.specs.values().toArray(bindingSpecArray);
        return bindingSpecArray;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Object object;
        UserInput[] userInputArray;
        UserInput[] userInputArray2 = new UserInput[3];
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        BindingSpec.Menu menu = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                userInputArray = (UserInput[])node;
                object = userInputArray.getName();
                UserInput userInput = null;
                boolean bl = true;
                if (object == Constants.MOUSE_PRESSED_ELEMENT) {
                    userInput = BindingInfo.parseMouseInput((Element)userInputArray, 501, 0);
                } else if (object == Constants.MOUSE_DRAGGED_ELEMENT) {
                    userInput = BindingInfo.parseMouseInput((Element)userInputArray, 506, 0);
                } else if (object == Constants.MOUSE_RELEASED_ELEMENT) {
                    userInput = BindingInfo.parseMouseInput((Element)userInputArray, 502, 0);
                } else if (object == Constants.MOUSE_CLICKED_ELEMENT) {
                    userInput = BindingInfo.parseMouseInput((Element)userInputArray, 500, 1);
                } else if (object == Constants.MOUSE_CLICKED2_ELEMENT) {
                    userInput = BindingInfo.parseMouseInput((Element)userInputArray, 500, 2);
                } else if (object == Constants.MOUSE_CLICKED3_ELEMENT) {
                    userInput = BindingInfo.parseMouseInput((Element)userInputArray, 500, 3);
                } else if (object == Constants.KEY_PRESSED_ELEMENT) {
                    userInput = BindingInfo.parseKeyInput((Element)userInputArray);
                } else if (object == Constants.CHAR_TYPED_ELEMENT) {
                    userInput = BindingInfo.parseCharInput((Element)userInputArray);
                } else if (object == Constants.APP_EVENT_ELEMENT) {
                    string = userInputArray.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
                    if (string == null || string.length() == 0) {
                        LoadError.add(arrayList, (Element)userInputArray, "invalidElement", "appEvent");
                        return false;
                    }
                    bl = false;
                } else if (object == Constants.COMMAND_ELEMENT) {
                    String[] stringArray = BindingInfo.parseCommand((Element)userInputArray);
                    if (stringArray == null) {
                        LoadError.add(arrayList, (Element)userInputArray, "invalidElement", "command");
                        return false;
                    }
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                    bl = false;
                } else if (object == Constants.MENU_ELEMENT) {
                    menu = InfoUtil.parseMenu((Element)userInputArray, false, arrayList);
                    if (menu == null) {
                        LoadError.add(arrayList, (Element)userInputArray, "invalidElement", "menu");
                        return false;
                    }
                    bl = false;
                } else {
                    LoadError.add(arrayList, (Element)userInputArray, "unknownElement", ((Name)object).getLocalPart());
                    return false;
                }
                if (bl) {
                    if (userInput == null) {
                        LoadError.add(arrayList, (Element)userInputArray, "invalidElement", ((Name)object).getLocalPart());
                        return false;
                    }
                    if (n == userInputArray2.length) {
                        LoadError.add(arrayList, element, "invalidElement", "binding");
                        return false;
                    }
                    userInputArray2[n++] = userInput;
                }
            }
            node = node.getNextSibling();
        }
        if (n == 0 && string == null || n != 0 && string != null || n != 1 && menu != null) {
            LoadError.add(arrayList, element, "invalidElement", "binding");
            return false;
        }
        if (n > 0 && n != userInputArray2.length) {
            userInputArray = new UserInput[n];
            System.arraycopy(userInputArray2, 0, userInputArray, 0, n);
            userInputArray2 = userInputArray;
        }
        boolean bl = false;
        if (string2 == null && menu == null) {
            bl = true;
            string2 = "";
        }
        try {
            object = string != null ? new BindingSpec(string, string2, string3) : (menu != null ? new BindingSpec(userInputArray2[0], menu) : new BindingSpec(userInputArray2, string2, string3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoadError.add(arrayList, element, "invalidElement2", "binding", illegalArgumentException.getMessage());
            return false;
        }
        if (bl) {
            this.specs.remove(object);
        } else {
            this.specs.put(object, object);
        }
        return true;
    }

    private static final UserInput parseMouseInput(Element element, int n, int n2) {
        int n3 = element.getIntAttribute(Constants.BUTTON_ATTRIBUTE, 1, 3, 1);
        switch (n3) {
            case 1: {
                n3 = 16;
                break;
            }
            case 2: {
                n3 = 8;
                break;
            }
            case 3: {
                n3 = 4;
            }
        }
        int n4 = BindingInfo.parseModifiers(element, true);
        if (n4 == -1) {
            return null;
        }
        return UserInput.get(n3, n4, n, n2);
    }

    private static final int parseModifiers(Element element, boolean bl) {
        String string = element.getAttribute(Constants.MODIFIERS_ATTRIBUTE);
        if (string == null) {
            return 0;
        }
        return InfoUtil.parseModifiers(string, bl);
    }

    private static final UserInput parseKeyInput(Element element) {
        String string = element.getTokenAttribute(Constants.CODE_ATTRIBUTE, null);
        if (string == null) {
            return null;
        }
        int n = InfoUtil.keyNameToCode(string);
        if (n < 0) {
            return null;
        }
        int n2 = BindingInfo.parseModifiers(element, false);
        if (n2 == -1) {
            return null;
        }
        return UserInput.get(n, n2);
    }

    private static final UserInput parseCharInput(Element element) {
        String string = element.getAttribute(Constants.CHAR_ATTRIBUTE);
        if (string == null || string.length() != 1) {
            return null;
        }
        return UserInput.get(string.charAt(0));
    }

    private static final String[] parseCommand(Element element) {
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = element.getAttribute(Constants.PARAMETER_ATTRIBUTE);
        return new String[]{string, string2};
    }

    public void translate(HashMap hashMap) {
        if (this.specs.size() == 0) {
            return;
        }
        Iterator iterator = this.specs.values().iterator();
        while (iterator.hasNext()) {
            BindingSpec bindingSpec = (BindingSpec)iterator.next();
            BindingSpec.Menu menu = bindingSpec.getMenu();
            if (menu == null) continue;
            InfoUtil.translate(menu, hashMap);
        }
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.specs.size() == 0) {
            return false;
        }
        BindingSpec[] bindingSpecArray = this.getBindingSpecs();
        if (bindingSpecArray.length > 1) {
            Arrays.sort(bindingSpecArray, compareBindingByTrigger);
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < bindingSpecArray.length) {
            Object object;
            BindingSpec bindingSpec = bindingSpecArray[n];
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "binding"));
            element.appendChild(element2);
            UserInput[] userInputArray = bindingSpec.getUserInputs();
            if (userInputArray != null) {
                int n2 = 0;
                while (n2 < userInputArray.length) {
                    BindingInfo.saveUserInput(userInputArray[n2], element2);
                    ++n2;
                }
            } else {
                object = new Element(Constants.APP_EVENT_ELEMENT);
                element2.appendChild((Node)object);
                ((Element)object).putAttribute(Constants.NAME_ATTRIBUTE, bindingSpec.getAppEventName());
            }
            object = bindingSpec.getMenu();
            if (object != null) {
                InfoUtil.saveMenu((BindingSpec.Menu)object, 0, element2);
            } else {
                InfoUtil.saveCommand(bindingSpec.getCommandName(), bindingSpec.getCommandParameter(), element2);
            }
            ++n;
        }
        return true;
    }

    private static final void saveUserInput(UserInput userInput, Element element) {
        Element element2;
        int n = userInput.getMouseEventId();
        char c = userInput.getKeyChar();
        if (n != 508) {
            int n2;
            Name name;
            block0 : switch (n) {
                case 506: {
                    name = Constants.MOUSE_DRAGGED_ELEMENT;
                    break;
                }
                case 502: {
                    name = Constants.MOUSE_RELEASED_ELEMENT;
                    break;
                }
                case 500: {
                    switch (userInput.getMouseClickCount()) {
                        case 2: {
                            name = Constants.MOUSE_CLICKED2_ELEMENT;
                            break block0;
                        }
                        case 3: {
                            name = Constants.MOUSE_CLICKED3_ELEMENT;
                            break block0;
                        }
                    }
                    name = Constants.MOUSE_CLICKED_ELEMENT;
                    break;
                }
                default: {
                    name = Constants.MOUSE_PRESSED_ELEMENT;
                }
            }
            element2 = new Element(name);
            switch (userInput.getMouseButton()) {
                case 8: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = 1;
                }
            }
            element2.putAttribute(Constants.BUTTON_ATTRIBUTE, Integer.toString(n2));
        } else if (c != '\uffff') {
            element2 = new Element(Constants.CHAR_TYPED_ELEMENT);
            element2.putAttribute(Constants.CHAR_ATTRIBUTE, Character.toString(c));
        } else {
            element2 = new Element(Constants.KEY_PRESSED_ELEMENT);
            element2.putAttribute(Constants.CODE_ATTRIBUTE, InfoUtil.keyCodeToName(userInput.getKeyCode()));
        }
        element.appendChild(element2);
        int n3 = userInput.getModifiers();
        if (n3 != 0) {
            element2.putAttribute(Constants.MODIFIERS_ATTRIBUTE, InfoUtil.formatModifiers(n3));
        }
    }

    public static class CompareBindingByTrigger
    implements Comparator {
        public int compare(Object object, Object object2) {
            BindingBase bindingBase = (BindingBase)object;
            BindingBase bindingBase2 = (BindingBase)object2;
            String string = bindingBase.triggerToString();
            String string2 = bindingBase2.triggerToString();
            return string.compareTo(string2);
        }
    }
}

