/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.command.CommandMenu;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.form.ImageDataTypes;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.InfoUtil;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Msg;
import com.xmlmind.xmleditapp.macro.MacroCommand;
import com.xmlmind.xmleditapp.process.ConvertImageItem;
import com.xmlmind.xmleditapp.process.CopyDocumentItem;
import com.xmlmind.xmleditapp.process.CopyItem;
import com.xmlmind.xmleditapp.process.CopyProcessResourcesItem;
import com.xmlmind.xmleditapp.process.DeleteItem;
import com.xmlmind.xmleditapp.process.InvokeItem;
import com.xmlmind.xmleditapp.process.JarItem;
import com.xmlmind.xmleditapp.process.MkdirItem;
import com.xmlmind.xmleditapp.process.PostItem;
import com.xmlmind.xmleditapp.process.PrintItem;
import com.xmlmind.xmleditapp.process.ProcessCommand;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessFOItem;
import com.xmlmind.xmleditapp.process.ReadItem;
import com.xmlmind.xmleditapp.process.RmdirItem;
import com.xmlmind.xmleditapp.process.ShellItem;
import com.xmlmind.xmleditapp.process.SubProcessItem;
import com.xmlmind.xmleditapp.process.TransformItem;
import com.xmlmind.xmleditapp.process.UploadItem;
import com.xmlmind.xmleditapp.process.ZipItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class CommandInfo
extends Info
implements ImageDataTypes {
    private HashMap nameToEntry = new HashMap();
    public static final String[] DATA_TYPE_ATTRIBUTE_VALUES = new String[]{"anyURI", "hexBinary", "base64Binary", "XML"};

    public CommandInfo() {
        this(null);
    }

    public CommandInfo(Entry[] entryArray) {
        if (entryArray != null) {
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                this.nameToEntry.put(entry.commandName, entry);
                ++n;
            }
        }
    }

    public Entry[] getEntries() {
        Entry[] entryArray = new Entry[this.nameToEntry.size()];
        this.nameToEntry.values().toArray(entryArray);
        return entryArray;
    }

    public void registerCommands() {
        this.registerCommands(null);
    }

    public void registerCommands(ArrayList arrayList) {
        Object object;
        Command command;
        String string;
        Entry entry;
        Iterator iterator = this.nameToEntry.values().iterator();
        while (iterator.hasNext()) {
            block7: {
                entry = (Entry)iterator.next();
                string = entry.commandName;
                if (Commands.isFinal(string)) continue;
                command = entry.macroCommand;
                if (command == null && (command = entry.processCommand) == null && entry.className != null) {
                    try {
                        object = Class.forName(entry.className);
                        command = (Command)((Class)object).newInstance();
                    }
                    catch (Exception exception) {
                        if (arrayList == null) break block7;
                        String string2 = Msg.msg("cannotRegisterCommand", string, MiscUtil.reason(exception));
                        arrayList.add(string2);
                    }
                }
            }
            if (command == null) continue;
            Commands.register(string, null, command, false);
        }
        iterator = this.nameToEntry.values().iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            string = entry.commandName;
            if (Commands.isFinal(string) || entry.commandMenu == null) continue;
            try {
                command = new CommandMenu(entry.commandMenu, entry.editMenuOption);
                Commands.register(string, null, command, false);
            }
            catch (Exception exception) {
                if (arrayList == null) continue;
                object = Msg.msg("cannotRegisterCommand", string, MiscUtil.reason(exception));
                arrayList.add(object);
            }
        }
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Entry entry = new Entry();
        entry.commandName = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (entry.commandName == null || entry.commandName.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return false;
        }
        Element element2 = element.getChildElement(0);
        if (element2 != null) {
            Name name = element2.getName();
            if (name == Constants.MACRO_ELEMENT) {
                entry.macroCommand = CommandInfo.parseMacro(element2, prefixToNamespace, arrayList);
            } else if (name == Constants.CLASS_ELEMENT) {
                String string = element2.getText();
                if (string != null && (string = XMLUtil.collapseWhiteSpace(string)).length() == 0) {
                    string = null;
                }
                entry.className = string;
            } else if (name == Constants.PROCESS_ELEMENT) {
                entry.processCommand = CommandInfo.parseProcess(element2, arrayList);
            } else if (name == Constants.MENU_ELEMENT) {
                entry.commandMenu = InfoUtil.parseMenu(element2, true, arrayList);
                if (entry.commandMenu != null) {
                    entry.editMenuOption = 0;
                    int n = element2.getChildElementCount();
                    if (n > 0) {
                        if (element2.getChildElement(0).getName() == Constants.EDIT_MENU_ELEMENT) {
                            entry.editMenuOption = 1;
                        } else if (element2.getChildElement(n - 1).getName() == Constants.EDIT_MENU_ELEMENT) {
                            entry.editMenuOption = 2;
                        }
                    }
                }
            }
        }
        if (entry.className == null && entry.macroCommand == null && entry.processCommand == null && entry.commandMenu == null) {
            LoadError.add(arrayList, element, "invalidElement", "command");
            return false;
        }
        this.nameToEntry.put(entry.commandName, entry);
        return true;
    }

    private static ProcessCommand parseProcess(Element element, ArrayList arrayList) {
        ProcessCommandItem[] processCommandItemArray;
        boolean bl = element.getBooleanAttribute(Constants.SHOW_PROGRESS_ATTRIBUTE, true);
        ArrayList<MkdirItem> arrayList2 = new ArrayList<MkdirItem>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                String string;
                Element element2 = (Element)node;
                processCommandItemArray = element2.getName();
                ProcessCommandItem processCommandItem = null;
                if (processCommandItemArray == Constants.MKDIR_ELEMENT) {
                    boolean bl2 = element2.getBooleanAttribute(Constants.QUIET_ATTRIBUTE, false);
                    String string2 = CommandInfo.getSubstAttribute(element2, Constants.DIR_ATTRIBUTE, null);
                    if (string2 != null && string2.length() > 0) {
                        processCommandItem = new MkdirItem(string2, bl2);
                    }
                } else if (processCommandItemArray == Constants.RMDIR_ELEMENT) {
                    boolean bl3 = element2.getBooleanAttribute(Constants.QUIET_ATTRIBUTE, false);
                    String string3 = CommandInfo.getSubstAttribute(element2, Constants.DIR_ATTRIBUTE, null);
                    if (string3 != null && string3.length() > 0) {
                        processCommandItem = new RmdirItem(string3, bl3);
                    }
                } else if (processCommandItemArray == Constants.DELETE_ELEMENT) {
                    boolean bl4 = element2.getBooleanAttribute(Constants.RECURSE_ATTRIBUTE, false);
                    boolean bl5 = element2.getBooleanAttribute(Constants.QUIET_ATTRIBUTE, false);
                    string = CommandInfo.getSubstAttribute(element2, Constants.FILES_ATTRIBUTE, null);
                    if (string != null && string.length() > 0) {
                        processCommandItem = new DeleteItem(string, bl4, bl5);
                    }
                } else if (processCommandItemArray == Constants.COPY_ELEMENT) {
                    boolean bl6 = element2.getBooleanAttribute(Constants.RECURSE_ATTRIBUTE, false);
                    boolean bl7 = element2.getBooleanAttribute(Constants.QUIET_ATTRIBUTE, false);
                    string = CommandInfo.getSubstAttribute(element2, Constants.FILES_ATTRIBUTE, null);
                    String string4 = CommandInfo.getSubstAttribute(element2, Constants.TO_ATTRIBUTE, null);
                    if (string != null && string.length() > 0 && string4 != null && string4.length() > 0) {
                        processCommandItem = new CopyItem(string, string4, bl6, bl7);
                    }
                } else if (processCommandItemArray == Constants.READ_ELEMENT) {
                    String string5 = CommandInfo.getSubstAttribute(element2, Constants.FILE_ATTRIBUTE, null);
                    String string6 = element2.getNmtokenAttribute(Constants.ENCODING_ATTRIBUTE, null);
                    if (string5 != null && string5.length() > 0 && string6 != null) {
                        if ("default".equals(string6)) {
                            string6 = null;
                        }
                        processCommandItem = new ReadItem(string5, string6);
                    }
                } else if (processCommandItemArray == Constants.SHELL_ELEMENT) {
                    String string7;
                    String string8 = CommandInfo.getSubstAttribute(element2, Constants.COMMAND_ATTRIBUTE, null);
                    if (!(string8 == null || string8.length() <= 0 || (string7 = element2.getEnumAttribute(Constants.PLATFORM_ATTRIBUTE, Constants.PLATFORM_ATTRIBUTE_VALUES, null)) == null && element2.hasAttribute(Constants.PLATFORM_ATTRIBUTE))) {
                        processCommandItem = new ShellItem(string8, string7);
                    }
                } else if (processCommandItemArray == Constants.INVOKE_ELEMENT) {
                    String string9 = element2.getTokenAttribute(Constants.METHOD_ATTRIBUTE, null);
                    if (string9 != null && string9.length() > 0) {
                        String string10 = element2.getAttribute(Constants.ARGUMENTS_ATTRIBUTE);
                        if (string10 == null) {
                            string10 = "";
                        }
                        try {
                            processCommandItem = new InvokeItem(string9, string10);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            LoadError.add(arrayList, element2, "invalidAttribute2", "method", noSuchMethodException.getMessage());
                            processCommandItem = null;
                        }
                    }
                } else if (processCommandItemArray == Constants.COPY_DOCUMENT_ELEMENT) {
                    processCommandItem = CommandInfo.parseCopyDocumentItem(element2, arrayList);
                } else if (processCommandItemArray == Constants.COPY_PROCESS_RESOURCES_ELEMENT) {
                    String string11 = CommandInfo.getSubstAttribute(element2, Constants.RESOURCES_ATTRIBUTE, null);
                    String string12 = CommandInfo.getSubstAttribute(element2, Constants.TO_ATTRIBUTE, null);
                    if (string11 != null && string11.length() > 0 && string12 != null && string12.length() > 0) {
                        processCommandItem = new CopyProcessResourcesItem(string11, string12);
                    }
                } else if (processCommandItemArray == Constants.UPLOAD_ELEMENT) {
                    processCommandItem = CommandInfo.parseUploadItem(element2);
                } else if (processCommandItemArray == Constants.TRANSFORM_ELEMENT) {
                    processCommandItem = CommandInfo.parseTransformItem(element2);
                } else if (processCommandItemArray == Constants.PROCESS_FO_ELEMENT) {
                    processCommandItem = CommandInfo.parseProcessFOItem(element2);
                } else if (processCommandItemArray == Constants.CONVERT_IMAGE_ELEMENT) {
                    processCommandItem = CommandInfo.parseConvertImageItem(element2);
                } else if (processCommandItemArray == Constants.ZIP_ELEMENT) {
                    processCommandItem = CommandInfo.parseZipItem(element2, false);
                } else if (processCommandItemArray == Constants.JAR_ELEMENT) {
                    processCommandItem = CommandInfo.parseZipItem(element2, true);
                } else if (processCommandItemArray == Constants.POST_ELEMENT) {
                    processCommandItem = CommandInfo.parsePostItem(element2);
                } else if (processCommandItemArray == Constants.PRINT_ELEMENT) {
                    String string13 = CommandInfo.getSubstAttribute(element2, Constants.PRINTER_ATTRIBUTE, null);
                    String string14 = CommandInfo.getSubstAttribute(element2, Constants.FILE_ATTRIBUTE, null);
                    if (string13 != null && string13.length() > 0 && string14 != null && string14.length() > 0) {
                        processCommandItem = new PrintItem(string13, string14);
                    }
                } else if (processCommandItemArray == Constants.SUB_PROCESS_ELEMENT) {
                    String string15 = CommandInfo.getSubstAttribute(element2, Constants.NAME_ATTRIBUTE, null);
                    if (string15 != null && string15.length() > 0) {
                        String string16 = element2.getAttribute(Constants.PARAMETER_ATTRIBUTE);
                        if (string16 != null) {
                            string16 = CommandInfo.trimWhiteSpace(string16);
                        }
                        processCommandItem = new SubProcessItem(string15, string16);
                    }
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", processCommandItemArray.getLocalPart());
                    return null;
                }
                if (processCommandItem == null) {
                    LoadError.add(arrayList, element2, "invalidElement", processCommandItemArray.getLocalPart());
                    return null;
                }
                arrayList2.add((MkdirItem)processCommandItem);
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", "process");
            return null;
        }
        processCommandItemArray = new ProcessCommandItem[n];
        arrayList2.toArray(processCommandItemArray);
        return new ProcessCommand(processCommandItemArray, bl, element.getLocation());
    }

    private static final String getSubstAttribute(Element element, Name name, String string) {
        String string2 = element.getAttribute(name);
        string2 = string2 != null ? CommandInfo.trimWhiteSpace(string2) : string;
        return string2;
    }

    private static final String trimWhiteSpace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!XMLUtil.isXMLSpace(string.charAt(n2))) break;
            ++n2;
        }
        int n3 = n - 1;
        while (n3 >= n2) {
            if (!XMLUtil.isXMLSpace(string.charAt(n3))) break;
            --n3;
        }
        if (n2 <= n3) {
            if (n2 == 0 && n3 == n - 1) {
                return string;
            }
            return string.substring(n2, n3 + 1);
        }
        return "";
    }

    private static final CopyDocumentItem parseCopyDocumentItem(Element element, ArrayList arrayList) {
        Object object;
        CopyDocumentItem.ExtractSpec[] extractSpecArray;
        ArrayList<CopyDocumentItem.ResourcesAction> arrayList2 = new ArrayList<CopyDocumentItem.ResourcesAction>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        boolean bl = element.getBooleanAttribute(Constants.SELECTION_ATTRIBUTE, false);
        boolean bl2 = element.getBooleanAttribute(Constants.PRESERVE_ENTITY_REFS_ATTRIBUTE, false);
        boolean bl3 = element.getBooleanAttribute(Constants.PRESERVE_XINCLUDES_ATTRIBUTE, false);
        boolean bl4 = element.getBooleanAttribute(Constants.SAVE_CHARS_AS_ENTITY_REFS_ATTRIBUTE, false);
        boolean bl5 = element.getBooleanAttribute(Constants.INDENT_ATTRIBUTE, false);
        String string = element.getEnumAttribute(Constants.ENCODING_ATTRIBUTE, DocumentWriter.KNOWN_ENCODINGS, "UTF-8");
        String string2 = CommandInfo.getSubstAttribute(element, Constants.TO_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                extractSpecArray = (CopyDocumentItem.ExtractSpec[])node;
                Name name = extractSpecArray.getName();
                if (name == Constants.RESOURCES_ELEMENT) {
                    object = CommandInfo.getSubstAttribute((Element)extractSpecArray, Constants.MATCH_ATTRIBUTE, null);
                    if (object == null || ((String)object).length() == 0) {
                        return null;
                    }
                    String string3 = CommandInfo.getSubstAttribute((Element)extractSpecArray, Constants.COPY_TO_ATTRIBUTE, null);
                    if (string3 != null && string3.length() == 0) {
                        return null;
                    }
                    String string4 = CommandInfo.getSubstAttribute((Element)extractSpecArray, Constants.REFERENCE_AS_ATTRIBUTE, null);
                    if (string4 != null && string4.length() == 0) {
                        return null;
                    }
                    arrayList2.add(new CopyDocumentItem.ResourcesAction((String)object, string3, string4));
                } else if (name == Constants.EXTRACT_ELEMENT) {
                    object = CommandInfo.parseExtractSpec((Element)extractSpecArray, arrayList);
                    if (object == null) {
                        return null;
                    }
                    arrayList3.add(object);
                } else {
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        extractSpecArray = null;
        int n = arrayList3.size();
        if (n > 0) {
            extractSpecArray = new CopyDocumentItem.ExtractSpec[n];
            arrayList3.toArray(extractSpecArray);
        }
        object = null;
        n = arrayList2.size();
        if (n > 0) {
            object = new CopyDocumentItem.ResourcesAction[n];
            arrayList2.toArray((T[])object);
        }
        return new CopyDocumentItem(bl, bl2, bl3, bl4, bl5, string, string2, extractSpecArray, (CopyDocumentItem.ResourcesAction[])object);
    }

    private static final CopyDocumentItem.ExtractSpec parseExtractSpec(Element element, ArrayList arrayList) {
        String string;
        XPath xPath = null;
        String string2 = element.getAttribute(Constants.XPATH_ATTRIBUTE);
        if (string2 != null) {
            xPath = XPath.fromString(string2, element, true);
        }
        if (xPath == null) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "xpath");
            return null;
        }
        int n = 0;
        if (element.hasAttribute(Constants.DATA_TYPE_ATTRIBUTE)) {
            string2 = element.getEnumAttribute(Constants.DATA_TYPE_ATTRIBUTE, DATA_TYPE_ATTRIBUTE_VALUES, null);
            if ("anyURI".equals(string2)) {
                n = 1;
            } else if ("hexBinary".equals(string2)) {
                n = 2;
            } else if ("base64Binary".equals(string2)) {
                n = 3;
            } else if ("XML".equals(string2)) {
                n = 4;
            } else {
                LoadError.add(arrayList, element, "invalidAttribute", "dataType");
                return null;
            }
        }
        if ((string = CommandInfo.getSubstAttribute(element, Constants.TO_DIR_ATTRIBUTE, null)) != null && string.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "toDir");
            return null;
        }
        String string3 = CommandInfo.getSubstAttribute(element, Constants.BASE_NAME_ATTRIBUTE, null);
        if (string3 != null && string3.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "baseName");
            return null;
        }
        String string4 = CommandInfo.getSubstAttribute(element, Constants.EXTENSION_ATTRIBUTE, null);
        if (string4 != null && string4.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "extension");
            return null;
        }
        ProcessingInstruction processingInstruction = null;
        Element element2 = null;
        if (element.getChildElementCount() == 1) {
            Element element3 = element.getChildElement(0);
            if (element3.getName() == Constants.PROCESSING_INSTRUCTION_ELEMENT) {
                String string5 = element3.getAttribute(Constants.TARGET_ATTRIBUTE);
                String string6 = element3.getAttribute(Constants.DATA_ATTRIBUTE);
                if (string5 == null || !XMLUtil.isName(string5 = string5.trim()) || string6 == null) {
                    LoadError.add(arrayList, element3, "invalidElement", "processingInstruction");
                    return null;
                }
                processingInstruction = new ProcessingInstruction(string5, string6);
            } else {
                element2 = InfoUtil.copyTemplateElement(element3);
            }
        }
        if (processingInstruction == null && element2 == null) {
            LoadError.add(arrayList, element, "invalidElement", "extract");
            return null;
        }
        return new CopyDocumentItem.ExtractSpec(xPath, n, string, string3, string4, processingInstruction, element2);
    }

    private static final UploadItem parseUploadItem(Element element) {
        Object object;
        ArrayList<UploadItem.CopyAction> arrayList = new ArrayList<UploadItem.CopyAction>();
        String string = CommandInfo.getSubstAttribute(element, Constants.BASE_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                String string2;
                String string3;
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.COPY_FILE_ELEMENT) {
                    string3 = CommandInfo.getSubstAttribute(element2, Constants.FILE_ATTRIBUTE, null);
                    if (string3 == null || string3.length() == 0) {
                        return null;
                    }
                    string2 = CommandInfo.getSubstAttribute(element2, Constants.TO_ATTRIBUTE, null);
                    if (string2 == null || string2.length() == 0) {
                        return null;
                    }
                    arrayList.add(new UploadItem.CopyAction(string3, string2, true));
                } else if (object == Constants.COPY_FILES_ELEMENT) {
                    string3 = CommandInfo.getSubstAttribute(element2, Constants.FILES_ATTRIBUTE, null);
                    if (string3 == null || string3.length() == 0) {
                        return null;
                    }
                    string2 = CommandInfo.getSubstAttribute(element2, Constants.TO_DIR_ATTRIBUTE, null);
                    if (string2 == null || string2.length() == 0) {
                        return null;
                    }
                    arrayList.add(new UploadItem.CopyAction(string3, string2, false));
                } else {
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        object = new UploadItem.CopyAction[n];
        arrayList.toArray((T[])object);
        return new UploadItem(string, (UploadItem.CopyAction[])object);
    }

    private static final TransformItem parseTransformItem(Element element) {
        String string = CommandInfo.getSubstAttribute(element, Constants.STYLESHEET_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = element.getBooleanAttribute(Constants.CACHE_STYLESHEET_ATTRIBUTE, false);
        String string2 = CommandInfo.getSubstAttribute(element, Constants.FILE_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = CommandInfo.getSubstAttribute(element, Constants.TO_ATTRIBUTE, null);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        String[] stringArray = InfoUtil.parseParameters(element, null);
        if (stringArray == null) {
            return null;
        }
        return new TransformItem(string, bl, string2, string3, stringArray);
    }

    private static final ProcessFOItem parseProcessFOItem(Element element) {
        String string = element.getTokenAttribute(Constants.PROCESSOR_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = CommandInfo.getSubstAttribute(element, Constants.FILE_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = CommandInfo.getSubstAttribute(element, Constants.TO_ATTRIBUTE, null);
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        Element[] elementArray = new Element[1];
        String[] stringArray = InfoUtil.parseParameters(element, elementArray);
        if (stringArray == null) {
            return null;
        }
        ProcessFOItem processFOItem = null;
        if (elementArray[0] != null && (processFOItem = CommandInfo.parseProcessFOItem(elementArray[0])) == null) {
            return null;
        }
        return new ProcessFOItem(string, string2, string3, stringArray, processFOItem);
    }

    private static final ConvertImageItem parseConvertImageItem(Element element) {
        String string = CommandInfo.getSubstAttribute(element, Constants.FROM_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = CommandInfo.getSubstAttribute(element, Constants.TO_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String[] stringArray = element.getListAttribute(Constants.SKIP_ATTRIBUTE, null);
        String[] stringArray2 = element.getListAttribute(Constants.FORMAT_ATTRIBUTE, null);
        String[] stringArray3 = InfoUtil.parseParameters(element, null);
        if (stringArray3 == null) {
            return null;
        }
        boolean bl = element.getBooleanAttribute(Constants.LENIENT_ATTRIBUTE, true);
        return new ConvertImageItem(string, stringArray, string2, stringArray2, stringArray3, bl);
    }

    private static final ZipItem parseZipItem(Element element, boolean bl) {
        Object object;
        String string = CommandInfo.getSubstAttribute(element, Constants.ARCHIVE_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<ZipItem.FileSet> arrayList = new ArrayList<ZipItem.FileSet>();
        String string2 = null;
        JarItem.ManifestAttribute[] manifestAttributeArray = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.ADD_ELEMENT) {
                    String string3 = CommandInfo.getSubstAttribute(element2, Constants.FILES_ATTRIBUTE, null);
                    if (string3 == null || string3.length() == 0) {
                        return null;
                    }
                    String string4 = CommandInfo.getSubstAttribute(element2, Constants.BASE_DIR_ATTRIBUTE, ".");
                    if (string4 == null || string4.length() == 0) {
                        return null;
                    }
                    arrayList.add(new ZipItem.FileSet(string3, string4));
                } else if (object == Constants.MANIFEST_FILE_ELEMENT && bl) {
                    if (string2 != null || manifestAttributeArray != null) {
                        return null;
                    }
                    string2 = element2.getText();
                    if (string2 == null || (string2 = CommandInfo.trimWhiteSpace(string2)).length() == 0) {
                        return null;
                    }
                } else if (object == Constants.MANIFEST_ELEMENT && bl) {
                    if (string2 != null || manifestAttributeArray != null) {
                        return null;
                    }
                    manifestAttributeArray = CommandInfo.parseManifestAttributes(element2);
                    if (manifestAttributeArray == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        object = new ZipItem.FileSet[n];
        arrayList.toArray((T[])object);
        if (bl) {
            if (string2 != null) {
                return new JarItem(string, (ZipItem.FileSet[])object, string2);
            }
            if (manifestAttributeArray != null) {
                return new JarItem(string, (ZipItem.FileSet[])object, manifestAttributeArray);
            }
            return new JarItem(string, (ZipItem.FileSet[])object);
        }
        return new ZipItem(string, (ZipItem.FileSet[])object);
    }

    private static final JarItem.ManifestAttribute[] parseManifestAttributes(Element element) {
        Object object;
        ArrayList<JarItem.ManifestAttribute> arrayList = new ArrayList<JarItem.ManifestAttribute>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.ATTRIBUTE_ELEMENT) {
                    String string = CommandInfo.getSubstAttribute(element2, Constants.NAME_ATTRIBUTE, null);
                    if (string == null || string.length() == 0) {
                        return null;
                    }
                    String string2 = element2.getText();
                    if (string2 == null) {
                        return null;
                    }
                    string2 = CommandInfo.trimWhiteSpace(string2);
                    arrayList.add(new JarItem.ManifestAttribute(string, string2));
                } else {
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        object = new JarItem.ManifestAttribute[n];
        arrayList.toArray((T[])object);
        return object;
    }

    private static final PostItem parsePostItem(Element element) {
        Object object;
        String string = CommandInfo.getSubstAttribute(element, Constants.URL_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = element.getNmtokenAttribute(Constants.VALUE_CHARSET_ATTRIBUTE, "ISO-8859-1");
        if (string2 == null) {
            return null;
        }
        boolean bl = element.getBooleanAttribute(Constants.READ_RESPONSE_ATTRIBUTE, false);
        ArrayList<PostItem.Field> arrayList = new ArrayList<PostItem.Field>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.FIELD_ELEMENT) {
                    PostItem.Field field = CommandInfo.parsePostField(element2);
                    if (field == null) {
                        return null;
                    }
                    arrayList.add(field);
                } else {
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        object = new PostItem.Field[n];
        arrayList.toArray((T[])object);
        return new PostItem(string, (PostItem.Field[])object, string2, bl);
    }

    private static final PostItem.Field parsePostField(Element element) {
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            return null;
        }
        Element element2 = element.getChildElement(0);
        if (element2 == null) {
            return null;
        }
        Name name = element2.getName();
        if (name == Constants.VALUE_ELEMENT) {
            String string2 = element2.getText();
            if (string2 == null) {
                return null;
            }
            string2 = CommandInfo.trimWhiteSpace(string2);
            return new PostItem.ValueField(string, string2);
        }
        if (name == Constants.FILE_ELEMENT) {
            String string3 = CommandInfo.getSubstAttribute(element2, Constants.NAME_ATTRIBUTE, null);
            if (string3 == null || string3.length() == 0) {
                return null;
            }
            String string4 = element2.getTokenAttribute(Constants.CONTENT_TYPE_ATTRIBUTE, null);
            if (string4 != null && string4.length() == 0) {
                return null;
            }
            return new PostItem.FileField(string, string3, string4);
        }
        return null;
    }

    private static MacroCommand parseMacro(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Object object;
        boolean bl = element.getBooleanAttribute(Constants.TRACE_ATTRIBUTE, false);
        boolean bl2 = element.getBooleanAttribute(Constants.REPEATABLE_ATTRIBUTE, false);
        boolean bl3 = element.getBooleanAttribute(Constants.UNDOABLE_ATTRIBUTE, false);
        String string = element.getTokenAttribute(Constants.LABEL_ATTRIBUTE, null);
        if (string != null && string.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "label");
            return null;
        }
        MacroCommand.GroupItem groupItem = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                object = (Element)node;
                Name name = ((Element)object).getName();
                MacroCommand.GroupItem groupItem2 = null;
                if (name != Constants.SEQUENCE_ELEMENT && name != Constants.CHOICE_ELEMENT) {
                    LoadError.add(arrayList, (Element)object, "unknownElement", name.getLocalPart());
                    return null;
                }
                groupItem2 = (MacroCommand.GroupItem)CommandInfo.parseGroupOrTest((Element)object, prefixToNamespace, arrayList);
                if (groupItem2 == null) {
                    return null;
                }
                if (groupItem == null) {
                    groupItem = groupItem2;
                } else {
                    groupItem = null;
                    break;
                }
            }
            node = node.getNextSibling();
        }
        if (groupItem == null) {
            LoadError.add(arrayList, element, "invalidElement", "macro");
            return null;
        }
        object = new MacroCommand(groupItem);
        if (bl) {
            ((MacroCommand)object).setTraced(true);
        }
        if (bl2) {
            ((MacroCommand)object).setRepeatable(true);
        }
        if (bl3) {
            ((MacroCommand)object).setUndoable(true);
        }
        if (string != null) {
            ((MacroCommand)object).setLabel(string);
        }
        return object;
    }

    private static MacroCommand.Item parseGroupOrTest(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Object object;
        MacroCommand.Item[] itemArray;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                itemArray = element2.getName();
                object = null;
                if (itemArray == Constants.SEQUENCE_ELEMENT || itemArray == Constants.CHOICE_ELEMENT || itemArray == Constants.PASS_ELEMENT || itemArray == Constants.FAIL_ELEMENT) {
                    object = CommandInfo.parseGroupOrTest(element2, prefixToNamespace, arrayList);
                } else if (itemArray == Constants.COMMAND_ELEMENT) {
                    object = CommandInfo.parseInvocation(element2, arrayList);
                } else if (itemArray == Constants.MATCH_ELEMENT || itemArray == Constants.TEST_ELEMENT || itemArray == Constants.GET_ELEMENT || itemArray == Constants.SET_ELEMENT) {
                    object = CommandInfo.parseXPathItem((Name)itemArray, element2, prefixToNamespace, arrayList);
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", itemArray.getLocalPart());
                    return null;
                }
                if (object == null) {
                    return null;
                }
                arrayList2.add(object);
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", element.getLocalName());
            return null;
        }
        itemArray = new MacroCommand.Item[n];
        arrayList2.toArray(itemArray);
        object = element.getName();
        if (object == Constants.CHOICE_ELEMENT) {
            return new MacroCommand.Choice(itemArray);
        }
        if (object == Constants.SEQUENCE_ELEMENT) {
            return new MacroCommand.Sequence(itemArray);
        }
        if (object == Constants.PASS_ELEMENT) {
            return new MacroCommand.Pass(itemArray);
        }
        return new MacroCommand.Fail(itemArray);
    }

    private static MacroCommand.Invocation parseInvocation(Element element, ArrayList arrayList) {
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return null;
        }
        String string2 = element.getAttribute(Constants.PARAMETER_ATTRIBUTE);
        return new MacroCommand.Invocation(string, string2);
    }

    private static MacroCommand.XPathItem parseXPathItem(Name name, Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Object object;
        block15: {
            String string = null;
            String string2 = null;
            boolean bl = false;
            String string3 = null;
            Name name2 = null;
            boolean bl2 = false;
            string = CommandInfo.getSubstAttribute(element, Constants.CONTEXT_ATTRIBUTE, null);
            if (string != null && string.length() == 0) {
                LoadError.add(arrayList, element, "invalidAttribute", "context");
                return null;
            }
            if (name == Constants.MATCH_ELEMENT) {
                string2 = CommandInfo.getSubstAttribute(element, Constants.PATTERN_ATTRIBUTE, null);
                if (string2 == null || string2.length() == 0) {
                    LoadError.add(arrayList, element, "missingOrInvalidAttribute", "pattern");
                    return null;
                }
                bl = element.getBooleanAttribute(Constants.ANTI_PATTERN_ATTRIBUTE, false);
            } else if (name == Constants.TEST_ELEMENT || name == Constants.GET_ELEMENT) {
                string3 = CommandInfo.getSubstAttribute(element, Constants.EXPRESSION_ATTRIBUTE, null);
                if (string3 == null || string3.length() == 0) {
                    LoadError.add(arrayList, element, "missingOrInvalidAttribute", "expression");
                    return null;
                }
            } else {
                bl2 = element.getBooleanAttribute(Constants.PLAIN_STRING_ATTRIBUTE, false);
                string3 = CommandInfo.getSubstAttribute(element, Constants.EXPRESSION_ATTRIBUTE, null);
                if (string3 == null || string3.length() == 0 && !bl2) {
                    LoadError.add(arrayList, element, "missingOrInvalidAttribute", "expression");
                    return null;
                }
                object = element.getAttribute(Constants.VARIABLE_ATTRIBUTE);
                if (object != null) {
                    name2 = Name.parse((String)object, true, element);
                }
                if (name2 == null) {
                    LoadError.add(arrayList, element, "missingOrInvalidAttribute", "variable");
                    return null;
                }
            }
            object = null;
            try {
                if (name == Constants.MATCH_ELEMENT) {
                    object = new MacroCommand.Match(string, string2, bl, prefixToNamespace);
                    break block15;
                }
                if (name == Constants.TEST_ELEMENT) {
                    object = new MacroCommand.Test(string, string3, prefixToNamespace);
                    break block15;
                }
                if (name == Constants.GET_ELEMENT) {
                    object = new MacroCommand.Get(string, string3, prefixToNamespace);
                    break block15;
                }
                object = new MacroCommand.Set(name2, string, string3, bl2, prefixToNamespace);
            }
            catch (ParseException parseException) {
                LoadError.add(arrayList, element, "invalidElement2", name.getLocalPart(), MiscUtil.reason(parseException));
            }
        }
        return object;
    }

    public void translate(HashMap hashMap) {
        Iterator iterator = this.nameToEntry.values().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            Entry entry = (Entry)iterator.next();
            BindingSpec.Menu menu = entry.commandMenu;
            if (menu != null) {
                InfoUtil.translate(menu, hashMap);
                continue;
            }
            MacroCommand macroCommand = entry.macroCommand;
            if (macroCommand == null || (string2 = macroCommand.getLabel()) == null || (string = (String)hashMap.get(string2)) == null) continue;
            macroCommand.setLabel(string);
        }
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.nameToEntry.size() == 0) {
            return false;
        }
        Object[] objectArray = this.getEntries();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "command"));
            element.appendChild(element2);
            element2.putAttribute(Constants.NAME_ATTRIBUTE, ((Entry)object).commandName);
            if (((Entry)object).macroCommand != null) {
                CommandInfo.saveMacro(((Entry)object).macroCommand, namespaceToPrefixes, element2);
            } else if (((Entry)object).processCommand != null) {
                CommandInfo.saveProcess(((Entry)object).processCommand, namespaceToPrefixes, element2);
            } else if (((Entry)object).commandMenu != null) {
                InfoUtil.saveMenu(((Entry)object).commandMenu, ((Entry)object).editMenuOption, element2);
            } else {
                Element element3 = new Element(Constants.CLASS_ELEMENT);
                element2.appendChild(element3);
                element3.appendChild(new Text(((Entry)object).className));
            }
            ++n;
        }
        return true;
    }

    private static final void saveMacro(MacroCommand macroCommand, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        String string;
        Element element2 = new Element(Constants.MACRO_ELEMENT);
        element.appendChild(element2);
        if (macroCommand.isTraced()) {
            element2.putAttribute(Constants.TRACE_ATTRIBUTE, "true");
        }
        if (macroCommand.isRepeatable()) {
            element2.putAttribute(Constants.REPEATABLE_ATTRIBUTE, "true");
        }
        if (macroCommand.isUndoable()) {
            element2.putAttribute(Constants.UNDOABLE_ATTRIBUTE, "true");
        }
        if ((string = macroCommand.getLabel()) != null) {
            element2.putAttribute(Constants.LABEL_ATTRIBUTE, string);
        }
        CommandInfo.saveGroupItem(macroCommand.getGroup(), namespaceToPrefixes, element2);
    }

    private static final void saveGroupItem(MacroCommand.GroupItem groupItem, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        Element element2 = new Element(groupItem instanceof MacroCommand.Choice ? Constants.CHOICE_ELEMENT : Constants.SEQUENCE_ELEMENT);
        element.appendChild(element2);
        MacroCommand.Item[] itemArray = groupItem.getItems();
        int n = 0;
        while (n < itemArray.length) {
            CommandInfo.saveItem(itemArray[n], namespaceToPrefixes, element2);
            ++n;
        }
    }

    private static final void saveTestItem(MacroCommand.TestItem testItem, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        Element element2 = new Element(testItem instanceof MacroCommand.Pass ? Constants.PASS_ELEMENT : Constants.FAIL_ELEMENT);
        element.appendChild(element2);
        MacroCommand.Item[] itemArray = testItem.getItems();
        int n = 0;
        while (n < itemArray.length) {
            CommandInfo.saveItem(itemArray[n], namespaceToPrefixes, element2);
            ++n;
        }
    }

    private static final void saveItem(MacroCommand.Item item, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        if (item instanceof MacroCommand.GroupItem) {
            CommandInfo.saveGroupItem((MacroCommand.GroupItem)item, namespaceToPrefixes, element);
        } else if (item instanceof MacroCommand.TestItem) {
            CommandInfo.saveTestItem((MacroCommand.TestItem)item, namespaceToPrefixes, element);
        } else if (item instanceof MacroCommand.XPathItem) {
            CommandInfo.saveXPathItem((MacroCommand.XPathItem)item, namespaceToPrefixes, element);
        } else {
            MacroCommand.Invocation invocation = (MacroCommand.Invocation)item;
            InfoUtil.saveCommand(invocation.getCommandName(), invocation.getParameter(), element);
        }
    }

    private static final void saveXPathItem(MacroCommand.XPathItem xPathItem, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        Object object;
        Name name;
        String string = null;
        boolean bl = false;
        String string2 = null;
        boolean bl2 = false;
        String string3 = null;
        if (xPathItem instanceof MacroCommand.Match) {
            name = Constants.MATCH_ELEMENT;
            object = (MacroCommand.Match)xPathItem;
            string = ((MacroCommand.Match)object).getPattern();
            bl = ((MacroCommand.Match)object).isAntiPattern();
        } else if (xPathItem instanceof MacroCommand.Test) {
            name = Constants.TEST_ELEMENT;
            object = (MacroCommand.Test)xPathItem;
            string2 = ((MacroCommand.Test)object).getExpression();
        } else if (xPathItem instanceof MacroCommand.Get) {
            name = Constants.GET_ELEMENT;
            object = (MacroCommand.Get)xPathItem;
            string2 = ((MacroCommand.Get)object).getExpression();
        } else {
            name = Constants.SET_ELEMENT;
            object = (MacroCommand.Set)xPathItem;
            string3 = ((MacroCommand.Set)object).getVariableName().format(true, namespaceToPrefixes);
            string2 = ((MacroCommand.Set)object).getExpression();
            bl2 = ((MacroCommand.Set)object).isPlainString();
        }
        object = new Element(name);
        element.appendChild((Node)object);
        String string4 = xPathItem.getContext();
        if (string4 != null) {
            ((Element)object).putAttribute(Constants.CONTEXT_ATTRIBUTE, string4);
        }
        if (string3 != null) {
            ((Element)object).putAttribute(Constants.VARIABLE_ATTRIBUTE, string3);
        }
        if (string != null) {
            ((Element)object).putAttribute(Constants.PATTERN_ATTRIBUTE, string);
        }
        if (bl) {
            ((Element)object).putAttribute(Constants.ANTI_PATTERN_ATTRIBUTE, "true");
        }
        if (string2 != null) {
            ((Element)object).putAttribute(Constants.EXPRESSION_ATTRIBUTE, string2);
        }
        if (bl2) {
            ((Element)object).putAttribute(Constants.PLAIN_STRING_ATTRIBUTE, "true");
        }
    }

    private static final void saveProcess(ProcessCommand processCommand, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        Element element2 = new Element(Constants.PROCESS_ELEMENT);
        element.appendChild(element2);
        if (!processCommand.isShowingProgress()) {
            element2.putAttribute(Constants.SHOW_PROGRESS_ATTRIBUTE, "false");
        }
        ProcessCommandItem[] processCommandItemArray = processCommand.getItems();
        int n = 0;
        while (n < processCommandItemArray.length) {
            ProcessCommandItem processCommandItem = processCommandItemArray[n];
            if (processCommandItem instanceof CopyDocumentItem) {
                CommandInfo.saveCopyDocumentItem((CopyDocumentItem)processCommandItem, namespaceToPrefixes, element2);
            } else if (processCommandItem instanceof CopyProcessResourcesItem) {
                CommandInfo.saveCopyProcessResourcesItem((CopyProcessResourcesItem)processCommandItem, element2);
            } else if (processCommandItem instanceof TransformItem) {
                CommandInfo.saveTransformItem((TransformItem)processCommandItem, element2);
            } else if (processCommandItem instanceof ProcessFOItem) {
                CommandInfo.saveProcessFOItem((ProcessFOItem)processCommandItem, element2);
            } else if (processCommandItem instanceof ConvertImageItem) {
                CommandInfo.saveConvertImageItem((ConvertImageItem)processCommandItem, element2);
            } else if (processCommandItem instanceof UploadItem) {
                CommandInfo.saveUploadItem((UploadItem)processCommandItem, element2);
            } else if (processCommandItem instanceof PostItem) {
                CommandInfo.savePostItem((PostItem)processCommandItem, element2);
            } else if (processCommandItem instanceof PrintItem) {
                CommandInfo.savePrintItem((PrintItem)processCommandItem, element2);
            } else if (processCommandItem instanceof ReadItem) {
                CommandInfo.saveReadItem((ReadItem)processCommandItem, element2);
            } else if (processCommandItem instanceof MkdirItem) {
                CommandInfo.saveMkdirItem((MkdirItem)processCommandItem, element2);
            } else if (processCommandItem instanceof RmdirItem) {
                CommandInfo.saveRmdirItem((RmdirItem)processCommandItem, element2);
            } else if (processCommandItem instanceof DeleteItem) {
                CommandInfo.saveDeleteItem((DeleteItem)processCommandItem, element2);
            } else if (processCommandItem instanceof CopyItem) {
                CommandInfo.saveCopyItem((CopyItem)processCommandItem, element2);
            } else if (processCommandItem instanceof ZipItem) {
                CommandInfo.saveZipItem((ZipItem)processCommandItem, element2);
            } else if (processCommandItem instanceof ShellItem) {
                CommandInfo.saveShellItem((ShellItem)processCommandItem, element2);
            } else if (processCommandItem instanceof InvokeItem) {
                CommandInfo.saveInvokeItem((InvokeItem)processCommandItem, element2);
            } else if (processCommandItem instanceof SubProcessItem) {
                CommandInfo.saveSubProcessItem((SubProcessItem)processCommandItem, element2);
            }
            ++n;
        }
    }

    private static final void saveCopyDocumentItem(CopyDocumentItem copyDocumentItem, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        CopyDocumentItem.ResourcesAction[] resourcesActionArray;
        String string;
        Element element2 = new Element(Constants.COPY_DOCUMENT_ELEMENT);
        element.appendChild(element2);
        if (copyDocumentItem.isSelection()) {
            element2.putAttribute(Constants.SELECTION_ATTRIBUTE, "true");
        }
        if (copyDocumentItem.getPreserveEntityRefs()) {
            element2.putAttribute(Constants.PRESERVE_ENTITY_REFS_ATTRIBUTE, "true");
        }
        if (copyDocumentItem.getPreserveXIncludes()) {
            element2.putAttribute(Constants.PRESERVE_XINCLUDES_ATTRIBUTE, "true");
        }
        if (copyDocumentItem.getSaveCharsAsEntityRefs()) {
            element2.putAttribute(Constants.SAVE_CHARS_AS_ENTITY_REFS_ATTRIBUTE, "true");
        }
        if (copyDocumentItem.getIndent()) {
            element2.putAttribute(Constants.INDENT_ATTRIBUTE, "true");
        }
        if (!"UTF-8".equals(string = copyDocumentItem.getEncoding())) {
            element2.putAttribute(Constants.ENCODING_ATTRIBUTE, string);
        }
        element2.putAttribute(Constants.TO_ATTRIBUTE, copyDocumentItem.getDestinationPath());
        CopyDocumentItem.ExtractSpec[] extractSpecArray = copyDocumentItem.getExtractSpecs();
        if (extractSpecArray != null) {
            int n = 0;
            while (n < extractSpecArray.length) {
                CommandInfo.saveExtractSpec(extractSpecArray[n], namespaceToPrefixes, element2);
                ++n;
            }
        }
        if ((resourcesActionArray = copyDocumentItem.getResourceActions()) != null) {
            int n = 0;
            while (n < resourcesActionArray.length) {
                CopyDocumentItem.ResourcesAction resourcesAction = resourcesActionArray[n];
                Element element3 = new Element(Constants.RESOURCES_ELEMENT);
                element2.appendChild(element3);
                element3.putAttribute(Constants.MATCH_ATTRIBUTE, resourcesAction.getPattern());
                String string2 = resourcesAction.getCopyTo();
                if (string2 != null) {
                    element3.putAttribute(Constants.COPY_TO_ATTRIBUTE, string2);
                }
                if ((string2 = resourcesAction.getReferenceAs()) != null) {
                    element3.putAttribute(Constants.REFERENCE_AS_ATTRIBUTE, string2);
                }
                ++n;
            }
        }
    }

    private static final void saveExtractSpec(CopyDocumentItem.ExtractSpec extractSpec, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        ProcessingInstruction processingInstruction;
        String string;
        String string2;
        String string3;
        Element element2 = new Element(Constants.EXTRACT_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.XPATH_ATTRIBUTE, extractSpec.getXPath().toString(namespaceToPrefixes));
        String string4 = null;
        switch (extractSpec.getDataType()) {
            case 1: {
                string4 = "anyURI";
                break;
            }
            case 2: {
                string4 = "hexBinary";
                break;
            }
            case 3: {
                string4 = "base64Binary";
                break;
            }
            case 4: {
                string4 = "XML";
            }
        }
        if (string4 != null) {
            element2.putAttribute(Constants.DATA_TYPE_ATTRIBUTE, string4);
        }
        if ((string3 = extractSpec.getToDir()) != null) {
            element2.putAttribute(Constants.TO_DIR_ATTRIBUTE, string3);
        }
        if ((string2 = extractSpec.getBaseName()) != null) {
            element2.putAttribute(Constants.BASE_NAME_ATTRIBUTE, string2);
        }
        if ((string = extractSpec.getExtension()) != null) {
            element2.putAttribute(Constants.EXTENSION_ATTRIBUTE, string);
        }
        if ((processingInstruction = extractSpec.getAddedPI()) != null) {
            Element element3 = new Element(Constants.PROCESSING_INSTRUCTION_ELEMENT);
            element2.appendChild(element3);
            element3.putAttribute(Constants.TARGET_ATTRIBUTE, processingInstruction.getTarget());
            element3.putAttribute(Constants.DATA_ATTRIBUTE, processingInstruction.getText());
        } else {
            element2.appendChild(extractSpec.getReplacementElement().copy());
        }
    }

    private static final void saveConvertImageItem(ConvertImageItem convertImageItem, Element element) {
        String[] stringArray;
        Element element2 = new Element(Constants.CONVERT_IMAGE_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.FROM_ATTRIBUTE, convertImageItem.getFrom());
        String[] stringArray2 = convertImageItem.getSkip();
        if (stringArray2 != null) {
            element2.putAttribute(Constants.SKIP_ATTRIBUTE, StringUtil.join(stringArray2, ' '));
        }
        element2.putAttribute(Constants.TO_ATTRIBUTE, convertImageItem.getTo());
        String[] stringArray3 = convertImageItem.getFormat();
        if (stringArray3 != null) {
            element2.putAttribute(Constants.FORMAT_ATTRIBUTE, StringUtil.join(stringArray3, ' '));
        }
        if (!convertImageItem.isLenient()) {
            element2.putAttribute(Constants.LENIENT_ATTRIBUTE, "false");
        }
        if ((stringArray = convertImageItem.getParameters()) != null) {
            InfoUtil.saveParameters(stringArray, element2);
        }
    }

    private static final void saveCopyProcessResourcesItem(CopyProcessResourcesItem copyProcessResourcesItem, Element element) {
        Element element2 = new Element(Constants.COPY_PROCESS_RESOURCES_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.RESOURCES_ATTRIBUTE, copyProcessResourcesItem.getSourcePath());
        element2.putAttribute(Constants.TO_ATTRIBUTE, copyProcessResourcesItem.getDestinationPath());
    }

    private static final void saveTransformItem(TransformItem transformItem, Element element) {
        Element element2 = new Element(Constants.TRANSFORM_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.STYLESHEET_ATTRIBUTE, transformItem.getStyleSheet());
        if (transformItem.isStyleSheetCached()) {
            element2.putAttribute(Constants.CACHE_STYLESHEET_ATTRIBUTE, "true");
        }
        element2.putAttribute(Constants.FILE_ATTRIBUTE, transformItem.getInput());
        element2.putAttribute(Constants.TO_ATTRIBUTE, transformItem.getOutput());
        String[] stringArray = transformItem.getParameters();
        if (stringArray != null) {
            InfoUtil.saveParameters(stringArray, element2);
        }
    }

    private static final void saveProcessFOItem(ProcessFOItem processFOItem, Element element) {
        ProcessFOItem processFOItem2;
        Element element2 = new Element(Constants.PROCESS_FO_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.PROCESSOR_ATTRIBUTE, processFOItem.getProcessorName());
        element2.putAttribute(Constants.FILE_ATTRIBUTE, processFOItem.getInput());
        element2.putAttribute(Constants.TO_ATTRIBUTE, processFOItem.getOutput());
        String[] stringArray = processFOItem.getParameters();
        if (stringArray != null) {
            InfoUtil.saveParameters(stringArray, element2);
        }
        if ((processFOItem2 = processFOItem.getFallback()) != null) {
            CommandInfo.saveProcessFOItem(processFOItem2, element2);
        }
    }

    private static final void saveReadItem(ReadItem readItem, Element element) {
        Element element2 = new Element(Constants.READ_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.FILE_ATTRIBUTE, readItem.getPath());
        String string = readItem.getEncoding();
        if (string == null) {
            string = "default";
        }
        element2.putAttribute(Constants.ENCODING_ATTRIBUTE, string);
    }

    private static final void saveMkdirItem(MkdirItem mkdirItem, Element element) {
        Element element2 = new Element(Constants.MKDIR_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.DIR_ATTRIBUTE, mkdirItem.getPath());
        if (mkdirItem.isQuiet()) {
            element2.putAttribute(Constants.QUIET_ATTRIBUTE, "true");
        }
    }

    private static final void saveRmdirItem(RmdirItem rmdirItem, Element element) {
        Element element2 = new Element(Constants.RMDIR_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.DIR_ATTRIBUTE, rmdirItem.getPath());
        if (rmdirItem.isQuiet()) {
            element2.putAttribute(Constants.QUIET_ATTRIBUTE, "true");
        }
    }

    private static final void saveDeleteItem(DeleteItem deleteItem, Element element) {
        Element element2 = new Element(Constants.DELETE_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.FILES_ATTRIBUTE, deleteItem.getPattern());
        if (deleteItem.isRecursive()) {
            element2.putAttribute(Constants.RECURSE_ATTRIBUTE, "true");
        }
        if (deleteItem.isQuiet()) {
            element2.putAttribute(Constants.QUIET_ATTRIBUTE, "true");
        }
    }

    private static final void saveCopyItem(CopyItem copyItem, Element element) {
        Element element2 = new Element(Constants.COPY_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.FILES_ATTRIBUTE, copyItem.getSourcePattern());
        element2.putAttribute(Constants.TO_ATTRIBUTE, copyItem.getDestinationPath());
        if (copyItem.isRecursive()) {
            element2.putAttribute(Constants.RECURSE_ATTRIBUTE, "true");
        }
        if (copyItem.isQuiet()) {
            element2.putAttribute(Constants.QUIET_ATTRIBUTE, "true");
        }
    }

    private static final void saveShellItem(ShellItem shellItem, Element element) {
        Element element2 = new Element(Constants.SHELL_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.COMMAND_ATTRIBUTE, shellItem.getCommand());
        String string = shellItem.getPlatform();
        if (string != null) {
            element2.putAttribute(Constants.PLATFORM_ATTRIBUTE, string);
        }
    }

    private static final void saveInvokeItem(InvokeItem invokeItem, Element element) {
        Element element2 = new Element(Constants.INVOKE_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.METHOD_ATTRIBUTE, invokeItem.getMethodName());
        String string = invokeItem.getArguments();
        if (string.length() > 0) {
            element2.putAttribute(Constants.ARGUMENTS_ATTRIBUTE, string);
        }
    }

    private static final void saveUploadItem(UploadItem uploadItem, Element element) {
        Element element2 = new Element(Constants.UPLOAD_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.BASE_ATTRIBUTE, uploadItem.getBase());
        UploadItem.CopyAction[] copyActionArray = uploadItem.getCopyActions();
        int n = 0;
        while (n < copyActionArray.length) {
            Element element3;
            UploadItem.CopyAction copyAction = copyActionArray[n];
            if (copyAction.isSingleFile()) {
                element3 = new Element(Constants.COPY_FILE_ELEMENT);
                element2.appendChild(element3);
                element3.putAttribute(Constants.FILE_ATTRIBUTE, copyAction.getPattern());
                element3.putAttribute(Constants.TO_ATTRIBUTE, copyAction.getDestination());
            } else {
                element3 = new Element(Constants.COPY_FILES_ELEMENT);
                element2.appendChild(element3);
                element3.putAttribute(Constants.FILES_ATTRIBUTE, copyAction.getPattern());
                element3.putAttribute(Constants.TO_DIR_ATTRIBUTE, copyAction.getDestination());
            }
            ++n;
        }
    }

    private static final void saveZipItem(ZipItem zipItem, Element element) {
        Object object;
        Object object2;
        boolean bl = zipItem instanceof JarItem;
        Element element2 = new Element(bl ? Constants.JAR_ELEMENT : Constants.ZIP_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.ARCHIVE_ATTRIBUTE, zipItem.getArchive());
        ZipItem.FileSet[] fileSetArray = zipItem.getFileSets();
        int n = 0;
        while (n < fileSetArray.length) {
            object2 = fileSetArray[n];
            object = new Element(Constants.ADD_ELEMENT);
            element2.appendChild((Node)object);
            ((Element)object).putAttribute(Constants.FILES_ATTRIBUTE, ((ZipItem.FileSet)object2).files);
            if (!".".equals(((ZipItem.FileSet)object2).baseDir)) {
                ((Element)object).putAttribute(Constants.BASE_DIR_ATTRIBUTE, ((ZipItem.FileSet)object2).baseDir);
            }
            ++n;
        }
        if (bl) {
            object2 = (JarItem)zipItem;
            object = ((JarItem)object2).getManifestFile();
            if (object != null) {
                Element element3 = new Element(Constants.MANIFEST_FILE_ELEMENT);
                element2.appendChild(element3);
                element3.appendChild(new Text((String)object));
            } else {
                JarItem.ManifestAttribute[] manifestAttributeArray = ((JarItem)object2).getManifestAttributes();
                if (manifestAttributeArray != null) {
                    Element element4 = new Element(Constants.MANIFEST_ELEMENT);
                    element2.appendChild(element4);
                    int n2 = 0;
                    while (n2 < manifestAttributeArray.length) {
                        JarItem.ManifestAttribute manifestAttribute = manifestAttributeArray[n2];
                        Element element5 = new Element(Constants.ATTRIBUTE_ELEMENT);
                        element4.appendChild(element5);
                        element5.putAttribute(Constants.NAME_ATTRIBUTE, manifestAttribute.name);
                        element5.appendChild(new Text(manifestAttribute.value));
                        ++n2;
                    }
                }
            }
        }
    }

    private static final void savePostItem(PostItem postItem, Element element) {
        Element element2 = new Element(Constants.POST_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.URL_ATTRIBUTE, postItem.getURL());
        String string = postItem.getValueCharset();
        if (!"ISO-8859-1".equals(string)) {
            element2.putAttribute(Constants.VALUE_CHARSET_ATTRIBUTE, string);
        }
        if (postItem.isReadingResponse()) {
            element2.putAttribute(Constants.READ_RESPONSE_ATTRIBUTE, "true");
        }
        PostItem.Field[] fieldArray = postItem.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Element element3;
            PostItem.Field field;
            PostItem.Field field2 = fieldArray[n];
            Element element4 = new Element(Constants.FIELD_ELEMENT);
            element2.appendChild(element4);
            element4.putAttribute(Constants.NAME_ATTRIBUTE, field2.name);
            if (field2 instanceof PostItem.FileField) {
                field = (PostItem.FileField)field2;
                element3 = new Element(Constants.FILE_ELEMENT);
                element4.appendChild(element3);
                element3.putAttribute(Constants.NAME_ATTRIBUTE, field.file);
                if (field.contentType != null) {
                    element3.putAttribute(Constants.CONTENT_TYPE_ATTRIBUTE, field.contentType);
                }
            } else {
                field = (PostItem.ValueField)field2;
                element3 = new Element(Constants.VALUE_ELEMENT);
                element4.appendChild(element3);
                element3.appendChild(new Text(((PostItem.ValueField)field).value));
            }
            ++n;
        }
    }

    private static final void savePrintItem(PrintItem printItem, Element element) {
        Element element2 = new Element(Constants.PRINT_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.PRINTER_ATTRIBUTE, printItem.getPrinter());
        element2.putAttribute(Constants.FILE_ATTRIBUTE, printItem.getFile());
    }

    private static final void saveSubProcessItem(SubProcessItem subProcessItem, Element element) {
        Element element2 = new Element(Constants.SUB_PROCESS_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.NAME_ATTRIBUTE, subProcessItem.getCommandName());
        String string = subProcessItem.getCommandParameter();
        if (string != null) {
            element2.putAttribute(Constants.PARAMETER_ATTRIBUTE, string);
        }
    }

    public static final class Entry
    implements Comparable {
        public String commandName;
        public String className;
        public MacroCommand macroCommand;
        public ProcessCommand processCommand;
        public BindingSpec.Menu commandMenu;
        public int editMenuOption;

        public Entry(String string, String string2) {
            this.commandName = string;
            this.className = string2;
        }

        public Entry(String string, MacroCommand macroCommand) {
            this.commandName = string;
            this.macroCommand = macroCommand;
        }

        public Entry(String string, ProcessCommand processCommand) {
            this.commandName = string;
            this.processCommand = processCommand;
        }

        public Entry(String string, BindingSpec.Menu menu, int n) {
            this.commandName = string;
            this.commandMenu = menu;
            this.editMenuOption = n;
        }

        private Entry() {
        }

        public int compareTo(Object object) {
            return this.commandName.compareTo(((Entry)object).commandName);
        }
    }
}

