/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.edit.Formatter;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xsd.load.SchemaLoader;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Loader;
import com.xmlmind.xmleditapp.config.Location;
import com.xmlmind.xmleditapp.config.TranslationInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Configuration
implements Constants {
    public static final String INFO_PACKAGE_NAMES_PROPERTY = "XXE_INFO_PACKAGE_NAMES";
    private static String[] infoPackageNames;
    private static HashMap typeNameToClass;
    protected String name;
    protected URL url;
    protected HashMap typeToInfo = new HashMap();
    private static DocumentType configDocType;
    private static boolean configDocTypeLoaded;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public Info replace(Info info) {
        return this.typeToInfo.put(info.getType(), info);
    }

    public boolean add(Info info) {
        String string = info.getType();
        Info info2 = (Info)this.typeToInfo.get(string);
        if (info2 != null) {
            return false;
        }
        this.typeToInfo.put(string, info);
        return true;
    }

    public Info add(String string) {
        Info info = (Info)this.typeToInfo.get(string);
        if (info != null) {
            return info;
        }
        info = Configuration.create(string);
        if (info != null) {
            this.typeToInfo.put(string, info);
        }
        return info;
    }

    public static Info create(String string) {
        Object object;
        block8: {
            Class<?> clazz = (Class<?>)typeNameToClass.get(string);
            if (clazz == null) {
                object = Configuration.getInfoPackageNames();
                int n = 0;
                while (n < ((String[])object).length) {
                    String string2 = object[n];
                    StringBuffer stringBuffer = new StringBuffer();
                    if (string2.length() > 0) {
                        stringBuffer.append(string2);
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(StringUtil.capitalize(string));
                    stringBuffer.append("Info");
                    try {
                        clazz = Class.forName(stringBuffer.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clazz != null) {
                        typeNameToClass.put(string, clazz);
                        break;
                    }
                    ++n;
                }
            }
            object = null;
            if (clazz == null) break block8;
            try {
                object = (Info)clazz.newInstance();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public static void addInfoPackageName(String string) {
        if (!StringUtil.contains(infoPackageNames, string)) {
            infoPackageNames = StringUtil.prepend(infoPackageNames, string);
            typeNameToClass.clear();
        }
    }

    public static String[] getInfoPackageNames() {
        return infoPackageNames;
    }

    public Info remove(String string) {
        return (Info)this.typeToInfo.remove(string);
    }

    public Info get(String string) {
        return (Info)this.typeToInfo.get(string);
    }

    public Info[] getAll() {
        Info[] infoArray = new Info[this.typeToInfo.size()];
        this.typeToInfo.values().toArray(infoArray);
        return infoArray;
    }

    public boolean load(Document document, PreferredPrefix preferredPrefix, ArrayList arrayList) throws IOException {
        Element element = document.getRootElement();
        if (element.getName() != Constants.CONFIGURATION_ELEMENT) {
            LoadError.add(arrayList, element, "notAConfiguration", element.getLocation());
            return false;
        }
        Document.loadPreferredPrefixes(element, false, false, preferredPrefix);
        boolean bl = true;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Object object;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Constants.INCLUDE_ELEMENT) {
                    object = null;
                    String string = element2.getAnyURIAttribute(Constants.LOCATION_ATTRIBUTE, null);
                    if (string != null && string.length() > 0) {
                        try {
                            object = Location.toURL(string, element2.getLocation());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (object == null) {
                        LoadError.add(arrayList, element2, "missingOrInvalidAttribute", "location");
                        bl = false;
                    } else {
                        Document document2 = Loader.createDocumentLoader().load((URL)object);
                        if (!this.load(document2, preferredPrefix, arrayList)) {
                            bl = false;
                        }
                    }
                } else {
                    object = this.add(name.getLocalPart());
                    if (object == null) {
                        LoadError.add(arrayList, element2, "unknownElement", name.getLocalPart());
                        bl = false;
                    } else if (!((Info)object).load(element2, preferredPrefix, arrayList)) {
                        bl = false;
                    }
                }
            }
            node = node.getNextSibling();
        }
        return bl;
    }

    public boolean translate() {
        Object object;
        HashMap hashMap = null;
        TranslationInfo translationInfo = (TranslationInfo)this.typeToInfo.get("translation");
        if (translationInfo != null) {
            hashMap = translationInfo.getMessageMap();
        }
        if (hashMap == null || hashMap.size() == 0) {
            return false;
        }
        if (this.name != null && (object = (String)hashMap.get(this.name)) != null) {
            this.name = object;
        }
        object = this.typeToInfo.values().iterator();
        while (object.hasNext()) {
            Info info = (Info)object.next();
            info.translate(hashMap);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PrefixEntry[] prefixEntryArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.save(prefixEntryArray, null, fileOutputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public void save(PrefixEntry[] prefixEntryArray, String string, OutputStream outputStream) throws IOException {
        Document document = this.createDocument();
        NamespaceToPrefixesImpl namespaceToPrefixesImpl = new NamespaceToPrefixesImpl(prefixEntryArray);
        this.save(namespaceToPrefixesImpl, document);
        Configuration.saveDocument(document, namespaceToPrefixesImpl.getPreferredPrefixes(), string, outputStream);
    }

    public Document createDocument() {
        Document document = new Document();
        Element element = new Element(Constants.CONFIGURATION_ELEMENT);
        if (this.name != null) {
            element.putAttribute(Constants.NAME_ATTRIBUTE, this.name);
        }
        document.appendChild(element);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocument(Document document, PrefixEntry[] prefixEntryArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            Configuration.saveDocument(document, prefixEntryArray, null, fileOutputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public static void saveDocument(Document document, PrefixEntry[] prefixEntryArray, String string, OutputStream outputStream) throws IOException {
        PrefixEntry[] prefixEntryArray2;
        DocumentWriter documentWriter;
        DocumentType documentType = Configuration.loadDocumentType();
        if (documentType == null) {
            documentWriter = new DocumentWriter();
        } else {
            prefixEntryArray2 = new Formatter(documentType);
            prefixEntryArray2.setFavorInteroperability(false);
            prefixEntryArray2.setIndent(2);
            prefixEntryArray2.setMaxLineLength(78);
            prefixEntryArray2.setAddingOpenLines(true);
            documentWriter = prefixEntryArray2;
        }
        if (string == null && !DocumentWriter.isKnownEncoding(string = FileUtil.defaultEncoding())) {
            string = "UTF-8";
        }
        documentWriter.setEncoding(string);
        if (prefixEntryArray != null) {
            prefixEntryArray2 = PreferredPrefix.merge(new PrefixEntry[]{new PrefixEntry("cfg", Namespace.CONFIGURATION), new PrefixEntry("xsi", Namespace.XSI)}, prefixEntryArray);
            documentWriter.setPreferredPrefixes(prefixEntryArray2);
        }
        documentWriter.writeDocument(document, outputStream);
        outputStream.flush();
    }

    public static DocumentType loadDocumentType() {
        block2: {
            if (configDocTypeLoaded) break block2;
            configDocTypeLoaded = true;
            try {
                URL uRL = Location.toURL("xxe-config:configuration/xsd/configuration.xsd", null);
                configDocType = new SchemaLoader().load(uRL);
            }
            catch (Exception exception) {}
        }
        return configDocType;
    }

    public void save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        Info[] infoArray = this.getAll();
        if (infoArray.length > 1) {
            Arrays.sort(infoArray, Info.compareInfoByType);
        }
        int n = 0;
        while (n < infoArray.length) {
            infoArray[n].save(namespaceToPrefixes, document);
            ++n;
        }
    }

    static {
        String string = System.getProperty(INFO_PACKAGE_NAMES_PROPERTY);
        if (string == null) {
            infoPackageNames = new String[]{"com.xmlmind.xmleditapp.config"};
        } else {
            infoPackageNames = StringUtil.split(string, ';');
            if (!StringUtil.contains(infoPackageNames, "com.xmlmind.xmleditapp.config")) {
                infoPackageNames = StringUtil.append(infoPackageNames, "com.xmlmind.xmleditapp.config");
            }
        }
        typeNameToClass = new HashMap();
        configDocType = null;
        configDocTypeLoaded = false;
    }

    public static final class NamespaceToPrefixesImpl
    implements NamespaceToPrefixes {
        private PreferredPrefix preferredPrefixes;

        public NamespaceToPrefixesImpl(PrefixEntry[] prefixEntryArray) {
            this.preferredPrefixes = new PreferredPrefix(prefixEntryArray);
        }

        public PrefixEntry[] getPreferredPrefixes() {
            return this.preferredPrefixes.getAll();
        }

        public String[] namespaceToPrefixes(Namespace namespace) {
            String[] stringArray = this.preferredPrefixes.namespaceToPrefixes(namespace);
            if (stringArray == null) {
                this.preferredPrefixes.add(namespace, "ns");
                stringArray = this.preferredPrefixes.namespaceToPrefixes(namespace);
            }
            return stringArray;
        }
    }
}

