/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;

public final class DetectInfo
extends Info {
    public static final int SCHEMA_TYPE_NONE = 0;
    public static final int SCHEMA_TYPE_DTD = 1;
    public static final int SCHEMA_TYPE_SCHEMA = 2;
    public static final int SCHEMA_TYPE_RELAXNG = 3;
    private Test test;

    public DetectInfo() {
        this(null);
    }

    public DetectInfo(Test test) {
        this.test = test;
    }

    public Test getTest() {
        return this.test;
    }

    public boolean match(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
        return this.test.test(string, namespace, n, string2, string3, string4, string5);
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Test test = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                if (test != null) {
                    test = null;
                    break;
                }
                test = DetectInfo.loadTest((Element)node, arrayList);
                if (test == null) {
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        if (test == null) {
            LoadError.add(arrayList, element, "invalidElement", "detect");
            return false;
        }
        this.test = test;
        return true;
    }

    private static final Test loadTest(Element element, ArrayList arrayList) {
        Test test;
        Name name = element.getName();
        if (name == Constants.ROOT_ELEMENT_LOCAL_NAME_ELEMENT) {
            test = new RootElementLocalName();
        } else if (name == Constants.ROOT_ELEMENT_NAMESPACE_ELEMENT) {
            test = new RootElementNamespace();
        } else if (name == Constants.SCHEMA_TYPE_ELEMENT) {
            test = new SchemaType();
        } else if (name == Constants.DTD_PUBLIC_ID_ELEMENT) {
            test = new DTDPublicId();
        } else if (name == Constants.DTD_SYSTEM_ID_ELEMENT) {
            test = new DTDSystemId();
        } else if (name == Constants.FILE_NAME_EXTENSION_ELEMENT) {
            test = new FileNameExtension();
        } else if (name == Constants.MIME_TYPE_ELEMENT) {
            test = new MimeType();
        } else if (name == Constants.AND_ELEMENT) {
            test = new And();
        } else if (name == Constants.OR_ELEMENT) {
            test = new Or();
        } else if (name == Constants.NOT_ELEMENT) {
            test = new Not();
        } else {
            LoadError.add(arrayList, element, "unknownElement", name.getLocalPart());
            return null;
        }
        if (!((Test)test).load(element, arrayList)) {
            return null;
        }
        return test;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.test == null) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "detect"));
        document.getRootElement().appendChild(element);
        this.test.save(namespaceToPrefixes, element);
        return true;
    }

    public static final class Not
    extends Test {
        private Test test;

        public Test getTest() {
            return this.test;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return !this.test.test(string, namespace, n, string2, string3, string4, string5);
        }

        public boolean load(Element element, ArrayList arrayList) {
            Element element2 = element.getChildElement(0);
            if (element2 == null) {
                LoadError.add(arrayList, element, "invalidElement", "not");
                return false;
            }
            this.test = DetectInfo.loadTest(element2, arrayList);
            return this.test != null;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.NOT_ELEMENT);
            element.appendChild(element2);
            this.test.save(namespaceToPrefixes, element2);
        }
    }

    public static final class Or
    extends Test {
        private Test[] tests;

        public Test[] getTests() {
            return this.tests;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            int n2 = 0;
            while (n2 < this.tests.length) {
                if (this.tests[n2].test(string, namespace, n, string2, string3, string4, string5)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean load(Element element, ArrayList arrayList) {
            ArrayList<Test> arrayList2 = new ArrayList<Test>();
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Test test = DetectInfo.loadTest((Element)node, arrayList);
                    if (test == null) {
                        return false;
                    }
                    arrayList2.add(test);
                }
                node = node.getNextSibling();
            }
            int n = arrayList2.size();
            if (n == 0) {
                LoadError.add(arrayList, element, "invalidElement", "or");
                return false;
            }
            this.tests = new Test[n];
            arrayList2.toArray(this.tests);
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.OR_ELEMENT);
            element.appendChild(element2);
            int n = 0;
            while (n < this.tests.length) {
                this.tests[n].save(namespaceToPrefixes, element2);
                ++n;
            }
        }
    }

    public static final class And
    extends Test {
        private Test[] tests;

        public Test[] getTests() {
            return this.tests;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            int n2 = 0;
            while (n2 < this.tests.length) {
                if (!this.tests[n2].test(string, namespace, n, string2, string3, string4, string5)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean load(Element element, ArrayList arrayList) {
            ArrayList<Test> arrayList2 = new ArrayList<Test>();
            Node node = element.getFirstChild();
            while (node != null) {
                if (node instanceof Element) {
                    Test test = DetectInfo.loadTest((Element)node, arrayList);
                    if (test == null) {
                        return false;
                    }
                    arrayList2.add(test);
                }
                node = node.getNextSibling();
            }
            int n = arrayList2.size();
            if (n == 0) {
                LoadError.add(arrayList, element, "invalidElement", "and");
                return false;
            }
            this.tests = new Test[n];
            arrayList2.toArray(this.tests);
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.AND_ELEMENT);
            element.appendChild(element2);
            int n = 0;
            while (n < this.tests.length) {
                this.tests[n].save(namespaceToPrefixes, element2);
                ++n;
            }
        }
    }

    public static final class MimeType
    extends Test {
        private String value;

        public String getValue() {
            return this.value;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return this.value.equals(string5);
        }

        public boolean load(Element element, ArrayList arrayList) {
            String string = element.getText();
            if (string == null || (string = string.trim()).length() == 0) {
                LoadError.add(arrayList, element, "invalidElement", "mimeType");
                return false;
            }
            this.value = string;
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.MIME_TYPE_ELEMENT);
            element.appendChild(element2);
            element2.appendChild(new Text(this.value));
        }
    }

    public static final class FileNameExtension
    extends Test {
        private String value;

        public String getValue() {
            return this.value;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return this.value.equals(string4);
        }

        public boolean load(Element element, ArrayList arrayList) {
            String string = element.getText();
            if (string == null || (string = string.trim()).length() == 0) {
                LoadError.add(arrayList, element, "invalidElement", "fileNameExtension");
                return false;
            }
            this.value = string;
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.FILE_NAME_EXTENSION_ELEMENT);
            element.appendChild(element2);
            element2.appendChild(new Text(this.value));
        }
    }

    public static final class DTDSystemId
    extends Test {
        private String value;

        public String getValue() {
            return this.value;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return this.value.equals(string3);
        }

        public boolean load(Element element, ArrayList arrayList) {
            String string = element.getText();
            if (string == null || (string = string.trim()).length() == 0) {
                LoadError.add(arrayList, element, "invalidElement", "dtdSystemId");
                return false;
            }
            this.value = string;
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.DTD_SYSTEM_ID_ELEMENT);
            element.appendChild(element2);
            element2.appendChild(new Text(this.value));
        }
    }

    public static final class DTDPublicId
    extends Test {
        private String value;
        private boolean substring;

        public String getValue() {
            return this.value;
        }

        public boolean isSubstring() {
            return this.substring;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return this.substring && string2 != null && string2.indexOf(this.value) >= 0 || !this.substring && this.value.equals(string2);
        }

        public boolean load(Element element, ArrayList arrayList) {
            String string = element.getText();
            if (string == null || (string = XMLUtil.collapseWhiteSpace(string)).length() == 0) {
                LoadError.add(arrayList, element, "invalidElement", "dtdPublicId");
                return false;
            }
            this.value = string;
            this.substring = element.getBooleanAttribute(Constants.SUBSTRING_ATTRIBUTE, false);
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.DTD_PUBLIC_ID_ELEMENT);
            element.appendChild(element2);
            if (this.substring) {
                element2.putAttribute(Constants.SUBSTRING_ATTRIBUTE, "true");
            }
            element2.appendChild(new Text(this.value));
        }
    }

    public static final class SchemaType
    extends Test {
        private int value;

        public int getValue() {
            return this.value;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return this.value == n;
        }

        public boolean load(Element element, ArrayList arrayList) {
            String string = element.getText();
            if (string == null) {
                LoadError.add(arrayList, element, "invalidElement", "schemaType");
                return false;
            }
            if ((string = string.trim()).length() == 0) {
                this.value = 0;
            } else if ("dtd".equals(string)) {
                this.value = 1;
            } else if ("schema".equals(string)) {
                this.value = 2;
            } else if ("relaxng".equals(string)) {
                this.value = 3;
            } else {
                LoadError.add(arrayList, element, "invalidElement", "schemaType");
                return false;
            }
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            String string;
            Element element2 = new Element(Constants.SCHEMA_TYPE_ELEMENT);
            element.appendChild(element2);
            switch (this.value) {
                case 1: {
                    string = "dtd";
                    break;
                }
                case 2: {
                    string = "schema";
                    break;
                }
                case 3: {
                    string = "relaxng";
                    break;
                }
                default: {
                    element2.putAttribute(Name.XSI_NIL, "true");
                    return;
                }
            }
            element2.appendChild(new Text(string));
        }
    }

    public static final class RootElementNamespace
    extends Test {
        private Namespace value;

        public Namespace getValue() {
            return this.value;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return this.value == namespace;
        }

        public boolean load(Element element, ArrayList arrayList) {
            String string = element.getText();
            if (string == null) {
                LoadError.add(arrayList, element, "invalidElement", "rootElementNamespace");
                return false;
            }
            this.value = (string = string.trim()).length() == 0 ? Namespace.NONE : Namespace.get(string);
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.ROOT_ELEMENT_NAMESPACE_ELEMENT);
            element.appendChild(element2);
            if (this.value == Namespace.NONE) {
                element2.putAttribute(Name.XSI_NIL, "true");
            } else {
                element2.appendChild(new Text(this.value.getURI()));
            }
        }
    }

    public static final class RootElementLocalName
    extends Test {
        private String value;

        public String getValue() {
            return this.value;
        }

        public boolean test(String string, Namespace namespace, int n, String string2, String string3, String string4, String string5) {
            return this.value.equals(string);
        }

        public boolean load(Element element, ArrayList arrayList) {
            String string = element.getText();
            if (string == null || !XMLUtil.isName(string = string.trim())) {
                LoadError.add(arrayList, element, "invalidElement", "rootElementLocalName");
                return false;
            }
            this.value = string;
            return true;
        }

        public void save(NamespaceToPrefixes namespaceToPrefixes, Element element) {
            Element element2 = new Element(Constants.ROOT_ELEMENT_LOCAL_NAME_ELEMENT);
            element.appendChild(element2);
            element2.appendChild(new Text(this.value));
        }
    }

    public static abstract class Test {
        public abstract boolean test(String var1, Namespace var2, int var3, String var4, String var5, String var6, String var7);

        public abstract boolean load(Element var1, ArrayList var2);

        public abstract void save(NamespaceToPrefixes var1, Element var2);
    }
}

