/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.dochook.DocumentHook;
import java.util.ArrayList;

public final class DocumentHookInfo
extends Info {
    private ArrayList entryList = new ArrayList();
    private DocumentHook[] documentHooks;

    public DocumentHookInfo() {
        this(null);
    }

    public DocumentHookInfo(Entry[] entryArray) {
        if (entryArray != null) {
            int n = 0;
            while (n < entryArray.length) {
                this.entryList.add(entryArray[n]);
                ++n;
            }
        }
    }

    public DocumentHook[] getDocumentHooks() {
        if (this.documentHooks == null) {
            int n = this.entryList.size();
            this.documentHooks = new DocumentHook[n];
            int n2 = 0;
            while (n2 < n) {
                this.documentHooks[n2] = ((Entry)this.entryList.get(n2)).documentHook;
                ++n2;
            }
        }
        return this.documentHooks;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Object object;
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string != null && string.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "name");
            return false;
        }
        String string2 = null;
        Element element2 = element.getChildElement(0);
        if (element2 != null && (object = element2.getName()) == Constants.CLASS_ELEMENT && (string2 = element2.getText()) != null && (string2 = XMLUtil.collapseWhiteSpace(string2)).length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            if (string == null) {
                LoadError.add(arrayList, element, "invalidElement", "documentHook");
                return false;
            }
            this.removeEntry(string);
            return true;
        }
        try {
            object = (DocumentHook)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            LoadError.add(arrayList, element, "invalidElement2", "documentHook", MiscUtil.reason(exception));
            return false;
        }
        this.putEntry(string, (DocumentHook)object);
        return true;
    }

    private void removeEntry(String string) {
        int n = this.indexOfEntry(string);
        if (n < 0) {
            return;
        }
        this.entryList.remove(n);
        this.documentHooks = null;
    }

    private int indexOfEntry(String string) {
        int n = this.entryList.size();
        int n2 = 0;
        while (n2 < n) {
            Entry entry = (Entry)this.entryList.get(n2);
            if (string.equals(entry.name)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void putEntry(String string, DocumentHook documentHook) {
        int n;
        if (string == null || (n = this.indexOfEntry(string)) < 0) {
            this.entryList.add(new Entry(string, documentHook));
        } else {
            Entry entry = (Entry)this.entryList.get(n);
            entry.documentHook = documentHook;
        }
        this.documentHooks = null;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        int n = this.entryList.size();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            Entry entry = (Entry)this.entryList.get(n2);
            Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "documentHook"));
            document.getRootElement().appendChild(element);
            if (entry.name != null) {
                element.putAttribute(Constants.NAME_ATTRIBUTE, entry.name);
            }
            Element element2 = new Element(Constants.CLASS_ELEMENT);
            element.appendChild(element2);
            element2.appendChild(new Text(entry.documentHook.getClass().getName()));
            ++n2;
        }
        return true;
    }

    public static final class Entry {
        private String name;
        private DocumentHook documentHook;

        public Entry(String string, DocumentHook documentHook) {
            this.name = string;
            this.documentHook = documentHook;
        }

        public String getName() {
            return this.name;
        }

        public DocumentHook getDocumentHook() {
            return this.documentHook;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.name == null || entry.name == null) {
                return this == entry;
            }
            return this.name.equals(entry.name);
        }
    }
}

