/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.XNodeSelector;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.edit.DocumentResource;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;

public final class DocumentResourcesInfo
extends Info {
    private DocumentResource[] resources;
    private static final String[] ACTIONS = new String[]{"auto", "reference", "copy"};

    public DocumentResourcesInfo() {
        this(new DocumentResource[0]);
    }

    public DocumentResourcesInfo(DocumentResource[] documentResourceArray) {
        this.resources = documentResourceArray;
    }

    public DocumentResource[] getDocumentResources() {
        return this.resources;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        ArrayList<DocumentResource> arrayList2 = new ArrayList<DocumentResource>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                XNodeSelector xNodeSelector;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Constants.RESOURCE_ELEMENT) {
                    xNodeSelector = null;
                    String string = element2.getAttribute(Constants.PATH_ATTRIBUTE);
                    if (string != null && (string = string.trim()).length() > 0) {
                        xNodeSelector = XPath.fromString(string, element2, true);
                    }
                    if (xNodeSelector == null) {
                        LoadError.add(arrayList, element2, "missingOrInvalidAttribute", "path");
                        return false;
                    }
                    arrayList2.add(new DocumentResource(xNodeSelector, DocumentResourcesInfo.getAction(element2)));
                } else if (name == Constants.SELECTOR_ELEMENT) {
                    xNodeSelector = DocumentResourcesInfo.getSelector(element2, arrayList);
                    if (xNodeSelector == null) {
                        return false;
                    }
                    arrayList2.add(new DocumentResource(xNodeSelector, DocumentResourcesInfo.getAction(element2)));
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", name.getLocalPart());
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", "documentResources");
            return false;
        }
        this.resources = new DocumentResource[n];
        arrayList2.toArray(this.resources);
        return true;
    }

    private static final int getAction(Element element) {
        String string = element.getEnumAttribute(Constants.ACTION_ATTRIBUTE, ACTIONS, "auto");
        return StringUtil.indexOf(ACTIONS, string);
    }

    private static final XNodeSelector getSelector(Element element, ArrayList arrayList) {
        Object object;
        String string = null;
        Element element2 = element.getChildElement(0);
        if (element2 != null && (object = element2.getName()) == Constants.CLASS_ELEMENT && (string = element2.getText()) != null && (string = XMLUtil.collapseWhiteSpace(string)).length() == 0) {
            string = null;
        }
        if (string == null) {
            LoadError.add(arrayList, element, "invalidElement", "selector");
            return null;
        }
        try {
            object = (XNodeSelector)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            LoadError.add(arrayList, element2, "invalidElement2", "class", MiscUtil.reason(exception));
            return null;
        }
        return object;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.resources.length == 0) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "documentResources"));
        document.getRootElement().appendChild(element);
        int n = 0;
        while (n < this.resources.length) {
            Element element2;
            DocumentResource documentResource = this.resources[n];
            XNodeSelector xNodeSelector = documentResource.getSelector();
            if (xNodeSelector instanceof XPath) {
                element2 = new Element(Constants.RESOURCE_ELEMENT);
                element2.putAttribute(Constants.PATH_ATTRIBUTE, ((XPath)xNodeSelector).toString(namespaceToPrefixes));
            } else {
                element2 = new Element(Constants.SELECTOR_ELEMENT);
                Element element3 = new Element(Constants.CLASS_ELEMENT);
                element2.appendChild(element3);
                element3.appendChild(new Text(xNodeSelector.getClass().getName()));
            }
            element.appendChild(element2);
            int n2 = documentResource.getAction();
            switch (n2) {
                case 1: 
                case 2: {
                    element2.putAttribute(Constants.ACTION_ATTRIBUTE, ACTIONS[n2]);
                }
            }
            ++n;
        }
        return true;
    }
}

