/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import java.net.MalformedURLException;
import java.util.ArrayList;

public final class DtdInfo
extends Info {
    private String publicId;
    private Location systemId;

    public DtdInfo() {
        this(null, null);
    }

    public DtdInfo(String string, Location location) {
        this.publicId = string;
        this.systemId = location;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public Location getSystemId() {
        return this.systemId;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Location location = null;
        String string = element.getAnyURIAttribute(Constants.SYSTEM_ID_ATTRIBUTE, null);
        if (string != null && string.length() > 0) {
            try {
                location = new Location(string, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (location == null) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "systemId");
            return false;
        }
        String string2 = element.getTokenAttribute(Constants.PUBLIC_ID_ATTRIBUTE, null);
        if (string2 != null && string2.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "publicId");
            return false;
        }
        this.publicId = string2;
        this.systemId = location;
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.systemId == null) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "dtd"));
        document.getRootElement().appendChild(element);
        element.putAttribute(Constants.SYSTEM_ID_ATTRIBUTE, this.systemId.getSystemId());
        if (this.publicId != null) {
            element.putAttribute(Constants.PUBLIC_ID_ATTRIBUTE, this.publicId);
        }
        return true;
    }
}

