/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.edit.ElementTemplate;
import com.xmlmind.xmledit.edit.ElementTemplates;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.InfoUtil;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public final class ElementTemplateInfo
extends Info {
    public static CompareTemplateByNameAndTitle compareTemplateByNameAndTitle = new CompareTemplateByNameAndTitle();
    private ElementTemplates elementTemplates;
    private static final String[] SELECTABLE_VALUES = new String[]{"false", "true", "override"};

    public ElementTemplateInfo() {
        this(new ElementTemplates());
    }

    public ElementTemplateInfo(ElementTemplates elementTemplates) {
        this.elementTemplates = elementTemplates;
    }

    public ElementTemplates getElementTemplates() {
        return this.elementTemplates;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        String string = element.getNmtokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return false;
        }
        XPath xPath = null;
        String string2 = element.getAttribute(Constants.PARENT_ATTRIBUTE);
        if (string2 != null && (xPath = XPath.fromString(string2, element, true)) == null) {
            LoadError.add(arrayList, element, "invalidAttribute", "parent");
            return false;
        }
        string2 = element.getEnumAttribute(Constants.SELECTABLE_ATTRIBUTE, SELECTABLE_VALUES, "true");
        int n = StringUtil.indexOf(SELECTABLE_VALUES, string2);
        Element element2 = element.getChildElement(0);
        if (element2 == null) {
            this.elementTemplates.removeAll(string);
        } else {
            element2 = InfoUtil.copyTemplateElement(element2);
            ElementTemplate elementTemplate = new ElementTemplate(string, string, element2, xPath, n);
            this.elementTemplates.put(elementTemplate);
        }
        return true;
    }

    public void translate(HashMap hashMap) {
        if (this.elementTemplates.size() == 0) {
            return;
        }
        ElementTemplates elementTemplates = new ElementTemplates();
        ElementTemplate[] elementTemplateArray = this.elementTemplates.getAll();
        int n = 0;
        while (n < elementTemplateArray.length) {
            ElementTemplate elementTemplate = elementTemplateArray[n];
            String string = elementTemplate.getTitle();
            String string2 = (String)hashMap.get(string);
            if (string2 != null && XMLUtil.isNmtoken(string2)) {
                ElementTemplate elementTemplate2 = new ElementTemplate(string, string2, elementTemplate.getElement(), elementTemplate.getParentXPath(), elementTemplate.getSelectable());
                elementTemplates.put(elementTemplate2);
            } else {
                elementTemplates.put(elementTemplate);
            }
            ++n;
        }
        this.elementTemplates = elementTemplates;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.elementTemplates.size() == 0) {
            return false;
        }
        ElementTemplate[] elementTemplateArray = this.elementTemplates.getAll();
        if (elementTemplateArray.length > 1) {
            Arrays.sort(elementTemplateArray, compareTemplateByNameAndTitle);
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < elementTemplateArray.length) {
            XPath xPath;
            ElementTemplate elementTemplate = elementTemplateArray[n];
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "elementTemplate"));
            element.appendChild(element2);
            element2.appendChild(elementTemplate.copyElement());
            element2.putAttribute(Constants.NAME_ATTRIBUTE, elementTemplate.getTitle());
            int n2 = elementTemplate.getSelectable();
            if (n2 != 1) {
                element2.putAttribute(Constants.SELECTABLE_ATTRIBUTE, SELECTABLE_VALUES[n2]);
            }
            if ((xPath = elementTemplate.getParentXPath()) != null) {
                element2.putAttribute(Constants.PARENT_ATTRIBUTE, xPath.toString(namespaceToPrefixes));
            }
            ++n;
        }
        return true;
    }

    public static class CompareTemplateByNameAndTitle
    implements Comparator {
        public int compare(Object object, Object object2) {
            Name name;
            ElementTemplate elementTemplate = (ElementTemplate)object;
            ElementTemplate elementTemplate2 = (ElementTemplate)object2;
            Name name2 = elementTemplate.getElementName();
            if (name2 == (name = elementTemplate2.getElementName())) {
                return elementTemplate.getTitle().compareTo(elementTemplate2.getTitle());
            }
            return name2.compareTo(name);
        }
    }
}

