/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import java.net.MalformedURLException;
import java.util.ArrayList;

public final class HelpInfo
extends Info {
    private Location location;

    public HelpInfo() {
        this(null);
    }

    public HelpInfo(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Location location = null;
        String string = element.getAnyURIAttribute(Constants.LOCATION_ATTRIBUTE, null);
        if (string != null && string.length() > 0) {
            try {
                location = new Location(string, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (location == null) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "location");
            return false;
        }
        this.location = location;
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.location == null) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "help"));
        document.getRootElement().appendChild(element);
        element.putAttribute(Constants.LOCATION_ATTRIBUTE, this.location.getSystemId());
        return true;
    }
}

