/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.imagetoolkit.ExternalImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.Base16;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;

public final class ImageToolkitInfo
extends Info {
    private ArrayList imageToolkits = new ArrayList();

    public ImageToolkitInfo() {
        this(null);
    }

    public ImageToolkitInfo(ExternalImageToolkit[] externalImageToolkitArray) {
        if (externalImageToolkitArray != null) {
            int n = 0;
            while (n < externalImageToolkitArray.length) {
                this.putToolkit(externalImageToolkitArray[n]);
                ++n;
            }
        }
    }

    public void putToolkit(ExternalImageToolkit externalImageToolkit) {
        String string = externalImageToolkit.getName();
        int n = this.imageToolkits.size();
        int n2 = 0;
        while (n2 < n) {
            ImageToolkit imageToolkit = (ImageToolkit)this.imageToolkits.get(n2);
            if (imageToolkit.getName().equals(string)) {
                this.imageToolkits.remove(n2);
                break;
            }
            ++n2;
        }
        this.imageToolkits.add(externalImageToolkit);
    }

    public ExternalImageToolkit[] getToolkits() {
        ExternalImageToolkit[] externalImageToolkitArray = new ExternalImageToolkit[this.imageToolkits.size()];
        this.imageToolkits.toArray(externalImageToolkitArray);
        return externalImageToolkitArray;
    }

    public void registerToolkits() {
        int n = this.imageToolkits.size();
        int n2 = 0;
        while (n2 < n) {
            ImageToolkits.register((ImageToolkit)this.imageToolkits.get(n2));
            ++n2;
        }
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Object object;
        Object object2;
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return false;
        }
        ExternalImageToolkit.Converter[] converterArray = null;
        ArrayList<ExternalImageToolkit.Converter[]> arrayList2 = new ArrayList<ExternalImageToolkit.Converter[]>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                object2 = element2.getName();
                if (object2 == Constants.CONVERTER_ELEMENT) {
                    object = ImageToolkitInfo.parseConverter(element2, arrayList);
                    if (object == null) {
                        return false;
                    }
                    arrayList2.add((ExternalImageToolkit.Converter[])object);
                } else if (object2 == Constants.DESCRIPTION_ELEMENT) {
                    object = element2.getText();
                    if (object == null) {
                        LoadError.add(arrayList, element, "invalidElement", "description");
                        return false;
                    }
                    converterArray = object;
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", ((Name)object2).getLocalPart());
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", element.getLocalName());
            return false;
        }
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            object = (ExternalImageToolkit.Converter)object2.next();
            if (object.getCommandTemplate().length() != 0) continue;
            object2.remove();
        }
        n = arrayList2.size();
        if (n == 0) {
            return true;
        }
        object = new ExternalImageToolkit.Converter[n];
        arrayList2.toArray((T[])object);
        this.putToolkit(new ExternalImageToolkit(string, (String)converterArray, (ExternalImageToolkit.Converter[])object, element.getLocation()));
        return true;
    }

    private static final ExternalImageToolkit.Converter parseConverter(Element element, ArrayList arrayList) {
        String string;
        Object object;
        Object object2 = null;
        Object object3 = null;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Object object4;
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.INPUT_ELEMENT || object == Constants.OUTPUT_ELEMENT) {
                    object4 = ImageToolkitInfo.parseFormat(element2, arrayList);
                    if (object4 == null) {
                        return null;
                    }
                    if (object == Constants.INPUT_ELEMENT) {
                        object2 = object4;
                    } else {
                        object3 = object4;
                    }
                } else if (object == Constants.SHELL_ELEMENT) {
                    object4 = element2.getAttribute(Constants.COMMAND_ATTRIBUTE);
                    if (object4 != null && ((String)(object4 = ((String)object4).trim())).length() == 0) {
                        object4 = null;
                    }
                    string = "";
                    if (element2.hasAttribute(Constants.PLATFORM_ATTRIBUTE)) {
                        string = element2.getEnumAttribute(Constants.PLATFORM_ATTRIBUTE, Constants.PLATFORM_ATTRIBUTE_VALUES, null);
                    }
                    if (object4 == null || string == null) {
                        LoadError.add(arrayList, element2, "invalidElement", "shell");
                        return null;
                    }
                    arrayList2.add(object4);
                    arrayList2.add(string);
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", ((Name)object).getLocalPart());
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (object2 == null || object3 == null || n == 0) {
            LoadError.add(arrayList, element, "invalidElement", element.getLocalName());
            return null;
        }
        object = "";
        int n2 = 0;
        while (n2 < n) {
            string = (String)arrayList2.get(n2 + 1);
            if (string.length() == 0 || "windows".equalsIgnoreCase(string) && PlatformUtil.IS_WINDOWS || "unix".equalsIgnoreCase(string) && !PlatformUtil.IS_WINDOWS || "mac".equalsIgnoreCase(string) && PlatformUtil.IS_MAC_OS || "genericunix".equalsIgnoreCase(string) && PlatformUtil.IS_GENERIC_UNIX) {
                object = (String)arrayList2.get(n2);
                break;
            }
            n2 += 2;
        }
        return new ExternalImageToolkit.Converter((ExternalImageToolkit.Format)object2, (ExternalImageToolkit.Format)object3, (String)object);
    }

    private static final ExternalImageToolkit.Format parseFormat(Element element, ArrayList arrayList) {
        Object object;
        int n;
        Object object2;
        int n2;
        String[] stringArray = element.getListAttribute(Constants.EXTENSIONS_ATTRIBUTE, null);
        if (stringArray == null || stringArray.length == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "extensions");
            return null;
        }
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        String[] stringArray2 = element.getListAttribute(Constants.MAGIC_STRINGS_ATTRIBUTE, null);
        if (stringArray2 != null && stringArray2.length > 0) {
            n2 = 0;
            while (n2 < stringArray2.length) {
                object2 = stringArray2[n2];
                n = ((String)object2).length();
                object = new byte[n];
                int n3 = 0;
                while (n3 < n) {
                    char c = ((String)object2).charAt(n3);
                    if (c >= '\u0080') {
                        object = null;
                        break;
                    }
                    object[n3] = (byte)c;
                    ++n3;
                }
                if (object == null) {
                    LoadError.add(arrayList, element, "invalidAttribute", "magicStrings");
                    return null;
                }
                arrayList2.add((byte[])object);
                ++n2;
            }
        }
        if ((stringArray2 = element.getListAttribute(Constants.MAGIC_NUMBERS_ATTRIBUTE, null)) != null && stringArray2.length > 0) {
            n2 = 0;
            while (n2 < stringArray2.length) {
                object2 = stringArray2[n2];
                byte[] byArray = null;
                try {
                    byArray = Base16.decode((String)object2);
                }
                catch (InvalidDataException invalidDataException) {
                    // empty catch block
                }
                if (byArray == null) {
                    LoadError.add(arrayList, element, "invalidAttribute", "magicNumbers");
                    return null;
                }
                arrayList2.add(byArray);
                ++n2;
            }
        }
        ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
        stringArray2 = element.getListAttribute(Constants.ROOT_NAMES_ATTRIBUTE, null);
        if (stringArray2 != null && stringArray2.length > 0) {
            int n4 = 0;
            while (n4 < stringArray2.length) {
                String string = stringArray2[n4];
                object = null;
                if (string.startsWith("xml:")) {
                    String string2 = string.substring(4);
                    if (XMLUtil.isNCName(string2)) {
                        object = Name.get(Namespace.XML, string2);
                    }
                } else if (XMLUtil.isName(string)) {
                    object = Name.get(Namespace.NONE, string);
                }
                if (object == null) {
                    LoadError.add(arrayList, element, "invalidAttribute", "rootNames");
                    return null;
                }
                arrayList3.add((byte[])object);
                ++n4;
            }
        }
        if ((stringArray2 = element.getListAttribute(Constants.ROOT_QNAMES_ATTRIBUTE, null)) != null && stringArray2.length > 0) {
            int n5 = 0;
            while (n5 < stringArray2.length) {
                String string = stringArray2[n5];
                object = Name.parse(string, false, element);
                if (object == null) {
                    LoadError.add(arrayList, element, "invalidAttribute", "rootQNames");
                    return null;
                }
                arrayList3.add((byte[])object);
                ++n5;
            }
        }
        object2 = null;
        n = arrayList2.size();
        if (n > 0) {
            object2 = new byte[n][];
            arrayList2.toArray((T[])object2);
        }
        object = null;
        n = arrayList3.size();
        if (n > 0) {
            object = new Name[n];
            arrayList3.toArray((T[])object);
        }
        return new ExternalImageToolkit.Format(stringArray, (byte[][])object2, (Name[])object);
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        int n = this.imageToolkits.size();
        if (n == 0) {
            return false;
        }
        Element element = document.getRootElement();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            ExternalImageToolkit externalImageToolkit = (ExternalImageToolkit)this.imageToolkits.get(n2);
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "imageToolkit"));
            element.appendChild(element2);
            element2.putAttribute(Constants.NAME_ATTRIBUTE, externalImageToolkit.getName());
            String string = externalImageToolkit.getDescription();
            if (string != null) {
                object = new Element(Constants.DESCRIPTION_ELEMENT);
                element2.appendChild((Node)object);
                ((Tree)object).appendChild(new Text(string));
            }
            object = externalImageToolkit.getConverters();
            int n3 = 0;
            while (n3 < ((ExternalImageToolkit.Converter[])object).length) {
                ImageToolkitInfo.saveConverter(object[n3], namespaceToPrefixes, element2);
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    private static final void saveConverter(ExternalImageToolkit.Converter converter, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        Element element2 = new Element(Constants.CONVERTER_ELEMENT);
        element.appendChild(element2);
        ImageToolkitInfo.saveFormat(converter.getInputFormat(), Constants.INPUT_ELEMENT, namespaceToPrefixes, element2);
        ImageToolkitInfo.saveFormat(converter.getOutputFormat(), Constants.OUTPUT_ELEMENT, namespaceToPrefixes, element2);
        Element element3 = new Element(Constants.SHELL_ELEMENT);
        element2.appendChild(element3);
        element3.putAttribute(Constants.COMMAND_ATTRIBUTE, converter.getCommandTemplate());
    }

    private static final void saveFormat(ExternalImageToolkit.Format format, Name name, NamespaceToPrefixes namespaceToPrefixes, Element element) {
        Name[] nameArray;
        Element element2 = new Element(name);
        element.appendChild(element2);
        element2.putAttribute(Constants.EXTENSIONS_ATTRIBUTE, StringUtil.join(format.getExtensions(), ' '));
        byte[][] byArray = format.getMagicNumbers();
        if (byArray.length > 0) {
            element2.putAttribute(Constants.MAGIC_NUMBERS_ATTRIBUTE, ImageToolkitInfo.joinMagicNumbers(byArray));
        }
        if ((nameArray = format.getRootNames()).length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            while (n < nameArray.length) {
                Name name2 = nameArray[n];
                String string = name2.getLocalPart();
                if (!XMLUtil.isNCName(string)) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(string);
                } else {
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(' ');
                    }
                    stringBuffer2.append(name2.format(true, namespaceToPrefixes));
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                element2.putAttribute(Constants.ROOT_NAMES_ATTRIBUTE, stringBuffer.toString());
            }
            if (stringBuffer2.length() > 0) {
                element2.putAttribute(Constants.ROOT_QNAMES_ATTRIBUTE, stringBuffer2.toString());
            }
        }
    }

    private static final String joinMagicNumbers(byte[][] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            byte[] byArray2 = byArray[n];
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Base16.encode(byArray2));
            ++n;
        }
        return stringBuffer.toString();
    }
}

