/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;
import java.util.HashMap;

final class InfoUtil
implements Constants {
    private static KeyCodeInfo[] KEY_CODE_INFO = new KeyCodeInfo[]{new KeyCodeInfo("0", 48), new KeyCodeInfo("1", 49), new KeyCodeInfo("2", 50), new KeyCodeInfo("3", 51), new KeyCodeInfo("4", 52), new KeyCodeInfo("5", 53), new KeyCodeInfo("6", 54), new KeyCodeInfo("7", 55), new KeyCodeInfo("8", 56), new KeyCodeInfo("9", 57), new KeyCodeInfo("A", 65), new KeyCodeInfo("ACCEPT", 30), new KeyCodeInfo("ADD", 107), new KeyCodeInfo("AGAIN", 65481), new KeyCodeInfo("ALL_CANDIDATES", 256), new KeyCodeInfo("ALPHANUMERIC", 240), new KeyCodeInfo("AMPERSAND", 150), new KeyCodeInfo("ASTERISK", 151), new KeyCodeInfo("AT", 512), new KeyCodeInfo("B", 66), new KeyCodeInfo("BACK_QUOTE", 192), new KeyCodeInfo("BACK_SLASH", 92), new KeyCodeInfo("BACK_SPACE", 8), new KeyCodeInfo("BRACELEFT", 161), new KeyCodeInfo("BRACERIGHT", 162), new KeyCodeInfo("C", 67), new KeyCodeInfo("CANCEL", 3), new KeyCodeInfo("CAPS_LOCK", 20), new KeyCodeInfo("CIRCUMFLEX", 514), new KeyCodeInfo("CLEAR", 12), new KeyCodeInfo("CLOSE_BRACKET", 93), new KeyCodeInfo("CODE_INPUT", 258), new KeyCodeInfo("COLON", 513), new KeyCodeInfo("COMMA", 44), new KeyCodeInfo("COMPOSE", 65312), new KeyCodeInfo("CONVERT", 28), new KeyCodeInfo("COPY", 65485), new KeyCodeInfo("CUT", 65489), new KeyCodeInfo("D", 68), new KeyCodeInfo("DEAD_ABOVEDOT", 134), new KeyCodeInfo("DEAD_ABOVERING", 136), new KeyCodeInfo("DEAD_ACUTE", 129), new KeyCodeInfo("DEAD_BREVE", 133), new KeyCodeInfo("DEAD_CARON", 138), new KeyCodeInfo("DEAD_CEDILLA", 139), new KeyCodeInfo("DEAD_CIRCUMFLEX", 130), new KeyCodeInfo("DEAD_DIAERESIS", 135), new KeyCodeInfo("DEAD_DOUBLEACUTE", 137), new KeyCodeInfo("DEAD_GRAVE", 128), new KeyCodeInfo("DEAD_IOTA", 141), new KeyCodeInfo("DEAD_MACRON", 132), new KeyCodeInfo("DEAD_OGONEK", 140), new KeyCodeInfo("DEAD_SEMIVOICED_SOUND", 143), new KeyCodeInfo("DEAD_TILDE", 131), new KeyCodeInfo("DEAD_VOICED_SOUND", 142), new KeyCodeInfo("DECIMAL", 110), new KeyCodeInfo("DELETE", 127), new KeyCodeInfo("DIVIDE", 111), new KeyCodeInfo("DOLLAR", 515), new KeyCodeInfo("DOWN", 40), new KeyCodeInfo("E", 69), new KeyCodeInfo("END", 35), new KeyCodeInfo("ENTER", 10), new KeyCodeInfo("EQUALS", 61), new KeyCodeInfo("ESCAPE", 27), new KeyCodeInfo("EURO_SIGN", 516), new KeyCodeInfo("EXCLAMATION_MARK", 517), new KeyCodeInfo("F", 70), new KeyCodeInfo("F1", 112), new KeyCodeInfo("F10", 121), new KeyCodeInfo("F11", 122), new KeyCodeInfo("F12", 123), new KeyCodeInfo("F13", 61440), new KeyCodeInfo("F14", 61441), new KeyCodeInfo("F15", 61442), new KeyCodeInfo("F16", 61443), new KeyCodeInfo("F17", 61444), new KeyCodeInfo("F18", 61445), new KeyCodeInfo("F19", 61446), new KeyCodeInfo("F2", 113), new KeyCodeInfo("F20", 61447), new KeyCodeInfo("F21", 61448), new KeyCodeInfo("F22", 61449), new KeyCodeInfo("F23", 61450), new KeyCodeInfo("F24", 61451), new KeyCodeInfo("F3", 114), new KeyCodeInfo("F4", 115), new KeyCodeInfo("F5", 116), new KeyCodeInfo("F6", 117), new KeyCodeInfo("F7", 118), new KeyCodeInfo("F8", 119), new KeyCodeInfo("F9", 120), new KeyCodeInfo("FINAL", 24), new KeyCodeInfo("FIND", 65488), new KeyCodeInfo("FULL_WIDTH", 243), new KeyCodeInfo("G", 71), new KeyCodeInfo("GREATER", 160), new KeyCodeInfo("H", 72), new KeyCodeInfo("HALF_WIDTH", 244), new KeyCodeInfo("HELP", 156), new KeyCodeInfo("HIRAGANA", 242), new KeyCodeInfo("HOME", 36), new KeyCodeInfo("I", 73), new KeyCodeInfo("INPUT_METHOD_ON_OFF", 263), new KeyCodeInfo("INSERT", 155), new KeyCodeInfo("INVERTED_EXCLAMATION_MARK", 518), new KeyCodeInfo("J", 74), new KeyCodeInfo("JAPANESE_HIRAGANA", 260), new KeyCodeInfo("JAPANESE_KATAKANA", 259), new KeyCodeInfo("JAPANESE_ROMAN", 261), new KeyCodeInfo("K", 75), new KeyCodeInfo("KANA", 21), new KeyCodeInfo("KANA_LOCK", 262), new KeyCodeInfo("KANJI", 25), new KeyCodeInfo("KATAKANA", 241), new KeyCodeInfo("KP_DOWN", 225), new KeyCodeInfo("KP_LEFT", 226), new KeyCodeInfo("KP_RIGHT", 227), new KeyCodeInfo("KP_UP", 224), new KeyCodeInfo("L", 76), new KeyCodeInfo("LEFT", 37), new KeyCodeInfo("LEFT_PARENTHESIS", 519), new KeyCodeInfo("LESS", 153), new KeyCodeInfo("M", 77), new KeyCodeInfo("MINUS", 45), new KeyCodeInfo("MODECHANGE", 31), new KeyCodeInfo("MULTIPLY", 106), new KeyCodeInfo("N", 78), new KeyCodeInfo("NONCONVERT", 29), new KeyCodeInfo("NUMBER_SIGN", 520), new KeyCodeInfo("NUMPAD0", 96), new KeyCodeInfo("NUMPAD1", 97), new KeyCodeInfo("NUMPAD2", 98), new KeyCodeInfo("NUMPAD3", 99), new KeyCodeInfo("NUMPAD4", 100), new KeyCodeInfo("NUMPAD5", 101), new KeyCodeInfo("NUMPAD6", 102), new KeyCodeInfo("NUMPAD7", 103), new KeyCodeInfo("NUMPAD8", 104), new KeyCodeInfo("NUMPAD9", 105), new KeyCodeInfo("NUM_LOCK", 144), new KeyCodeInfo("O", 79), new KeyCodeInfo("OPEN_BRACKET", 91), new KeyCodeInfo("P", 80), new KeyCodeInfo("PAGE_DOWN", 34), new KeyCodeInfo("PAGE_UP", 33), new KeyCodeInfo("PASTE", 65487), new KeyCodeInfo("PAUSE", 19), new KeyCodeInfo("PERIOD", 46), new KeyCodeInfo("PLUS", 521), new KeyCodeInfo("PREVIOUS_CANDIDATE", 257), new KeyCodeInfo("PRINTSCREEN", 154), new KeyCodeInfo("PROPS", 65482), new KeyCodeInfo("Q", 81), new KeyCodeInfo("QUOTE", 222), new KeyCodeInfo("QUOTEDBL", 152), new KeyCodeInfo("R", 82), new KeyCodeInfo("RIGHT", 39), new KeyCodeInfo("RIGHT_PARENTHESIS", 522), new KeyCodeInfo("ROMAN_CHARACTERS", 245), new KeyCodeInfo("S", 83), new KeyCodeInfo("SCROLL_LOCK", 145), new KeyCodeInfo("SEMICOLON", 59), new KeyCodeInfo("SEPARATOR", 108), new KeyCodeInfo("SLASH", 47), new KeyCodeInfo("SPACE", 32), new KeyCodeInfo("STOP", 65480), new KeyCodeInfo("SUBTRACT", 109), new KeyCodeInfo("T", 84), new KeyCodeInfo("TAB", 9), new KeyCodeInfo("U", 85), new KeyCodeInfo("UNDERSCORE", 523), new KeyCodeInfo("UNDO", 65483), new KeyCodeInfo("UP", 38), new KeyCodeInfo("V", 86), new KeyCodeInfo("W", 87), new KeyCodeInfo("X", 88), new KeyCodeInfo("Y", 89), new KeyCodeInfo("Z", 90)};
    private static HashMap nameToCode = new HashMap(200);
    private static HashMap codeToName = new HashMap(200);
    private static KeyCodeInfo probe;

    InfoUtil() {
    }

    public static String[] parseParameters(Element element) {
        return InfoUtil.parseParameters(element, null);
    }

    public static String[] parseParameters(Element element, Element[] elementArray) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.PARAMETER_ELEMENT || object == Constants.PARAMETER_GROUP_ELEMENT) {
                    String string;
                    String string2 = element2.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
                    if (string2 == null || string2.length() == 0) {
                        return null;
                    }
                    if (object == Constants.PARAMETER_ELEMENT) {
                        string = element2.getText();
                        if (string == null) {
                            return null;
                        }
                    } else {
                        string = null;
                    }
                    arrayList.add(string2);
                    arrayList.add(string);
                } else {
                    if (object == Constants.PROCESS_FO_ELEMENT && elementArray != null) {
                        elementArray[0] = element2;
                        break;
                    }
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList.size();
        object = new String[n];
        arrayList.toArray((T[])object);
        return object;
    }

    public static void saveParameters(String[] stringArray, Element element) {
        int n = 0;
        while (n < stringArray.length) {
            Element element2;
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            if (string2 == null) {
                element2 = new Element(Constants.PARAMETER_GROUP_ELEMENT);
                element.appendChild(element2);
                element2.putAttribute(Constants.NAME_ATTRIBUTE, string);
            } else {
                element2 = new Element(Constants.PARAMETER_ELEMENT);
                element.appendChild(element2);
                element2.putAttribute(Constants.NAME_ATTRIBUTE, string);
                element2.appendChild(new Text(string2));
            }
            n += 2;
        }
    }

    public static int keyNameToCode(String string) {
        KeyCodeInfo keyCodeInfo = (KeyCodeInfo)nameToCode.get(string);
        return keyCodeInfo == null ? -1 : keyCodeInfo.code;
    }

    public static String keyCodeToName(int n) {
        InfoUtil.probe.code = n;
        return (String)codeToName.get(probe);
    }

    public static int parseModifiers(String string, boolean bl) {
        int n = 0;
        String[] stringArray = XMLUtil.splitList(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string2.equals("ctrl")) {
                n |= 2;
            } else if (string2.equals("shift")) {
                n |= 1;
            } else if (string2.equals("alt")) {
                n |= 8;
            } else if (string2.equals("meta")) {
                n |= 4;
            } else if (string2.equals("altGr")) {
                n |= 0x20;
            } else if (string2.equals("mod")) {
                n |= PlatformUtil.IS_MAC_OS ? 4 : 2;
            } else {
                return -1;
            }
            ++n2;
        }
        return n;
    }

    public static String formatModifiers(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 2) != 0) {
            stringBuffer.append("ctrl");
        }
        if ((n & 1) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("shift");
        }
        if ((n & 8) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("alt");
        }
        if ((n & 4) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("meta");
        }
        if ((n & 0x20) != 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("altGr");
        }
        return stringBuffer.toString();
    }

    public static BindingSpec.Menu parseMenu(Element element, boolean bl, ArrayList arrayList) {
        Object object;
        String string = element.getTokenAttribute(Constants.LABEL_ATTRIBUTE, null);
        ArrayList<BindingSpec.MenuItem> arrayList2 = new ArrayList<BindingSpec.MenuItem>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                BindingSpec.MenuItem menuItem;
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.ITEM_ELEMENT) {
                    menuItem = InfoUtil.parseMenuItem(element2, arrayList);
                    if (menuItem == null) {
                        return null;
                    }
                    arrayList2.add(menuItem);
                } else if (object == Constants.SEPARATOR_ELEMENT) {
                    arrayList2.add(new BindingSpec.MenuItem());
                } else if (object == Constants.MENU_ELEMENT) {
                    menuItem = InfoUtil.parseMenu(element2, false, arrayList);
                    if (menuItem == null) {
                        return null;
                    }
                    if (((BindingSpec.Menu)menuItem).label == null) {
                        LoadError.add(arrayList, element2, "invalidElement2", "menu", "a label is required in sub-menu");
                        return null;
                    }
                    arrayList2.add(menuItem);
                } else if (object != Constants.EDIT_MENU_ELEMENT || !bl) {
                    LoadError.add(arrayList, element2, "unknownElement", object.getLocalPart());
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            return null;
        }
        object = new BindingSpec.MenuItem[n];
        arrayList2.toArray((T[])object);
        return new BindingSpec.Menu(string, (BindingSpec.MenuItem[])object);
    }

    private static BindingSpec.MenuItem parseMenuItem(Element element, ArrayList arrayList) {
        String string = element.getTokenAttribute(Constants.LABEL_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "label");
            return null;
        }
        String string2 = element.getTokenAttribute(Constants.COMMAND_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "command");
            return null;
        }
        String string3 = element.getAttribute(Constants.PARAMETER_ATTRIBUTE);
        return new BindingSpec.MenuItem(string, string2, string3);
    }

    public static void translate(BindingSpec.Menu menu, HashMap hashMap) {
        BindingSpec.MenuItem[] menuItemArray = menu.items;
        int n = 0;
        while (n < menuItemArray.length) {
            String string;
            BindingSpec.MenuItem menuItem = menuItemArray[n];
            if (menuItem.label != null && (string = (String)hashMap.get(menuItem.label)) != null) {
                menuItem.label = string;
            }
            if (menuItem instanceof BindingSpec.Menu) {
                InfoUtil.translate((BindingSpec.Menu)menuItem, hashMap);
            }
            ++n;
        }
    }

    public static void saveMenu(BindingSpec.Menu menu, int n, Element element) {
        Element element2 = new Element(Constants.MENU_ELEMENT);
        element.appendChild(element2);
        if (menu.label != null) {
            element2.putAttribute(Constants.LABEL_ATTRIBUTE, menu.label);
        }
        if (n == 1) {
            element2.appendChild(new Element(Constants.EDIT_MENU_ELEMENT));
        }
        BindingSpec.MenuItem[] menuItemArray = menu.items;
        int n2 = 0;
        while (n2 < menuItemArray.length) {
            BindingSpec.MenuItem menuItem = menuItemArray[n2];
            if (menuItem instanceof BindingSpec.Menu) {
                InfoUtil.saveMenu((BindingSpec.Menu)menuItem, 0, element2);
            } else if (menuItem.label == null) {
                element2.appendChild(new Element(Constants.SEPARATOR_ELEMENT));
            } else {
                InfoUtil.saveMenuItem(menuItem, element2);
            }
            ++n2;
        }
        if (n == 2) {
            element2.appendChild(new Element(Constants.EDIT_MENU_ELEMENT));
        }
    }

    public static void saveMenuItem(BindingSpec.MenuItem menuItem, Element element) {
        Element element2 = new Element(Constants.ITEM_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.LABEL_ATTRIBUTE, menuItem.label);
        element2.putAttribute(Constants.COMMAND_ATTRIBUTE, menuItem.commandName);
        if (menuItem.commandParameter != null) {
            element2.putAttribute(Constants.PARAMETER_ATTRIBUTE, menuItem.commandParameter);
        }
    }

    public static final void saveCommand(String string, String string2, Element element) {
        Element element2 = new Element(Constants.COMMAND_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.NAME_ATTRIBUTE, string);
        if (string2 != null) {
            element2.putAttribute(Constants.PARAMETER_ATTRIBUTE, string2);
        }
    }

    public static Element copyTemplateElement(Element element) {
        Element element2 = (Element)element.copy();
        element2.removeProperties(7);
        return element2;
    }

    static {
        int n = 0;
        while (n < KEY_CODE_INFO.length) {
            KeyCodeInfo keyCodeInfo = KEY_CODE_INFO[n];
            nameToCode.put(keyCodeInfo.name, keyCodeInfo);
            codeToName.put(keyCodeInfo, keyCodeInfo.name);
            ++n;
        }
        probe = new KeyCodeInfo(null, -1);
    }

    private static final class KeyCodeInfo {
        public String name;
        public int code;

        public KeyCodeInfo(String string, int n) {
            this.name = string;
            this.code = n;
        }

        public int hashCode() {
            return this.code;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof KeyCodeInfo)) {
                return false;
            }
            return this.code == ((KeyCodeInfo)object).code;
        }
    }
}

