/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.jclark.xml.parse.OpenEntity;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.LoadError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public final class Loader
implements Constants {
    private PrefixEntry[] preferredPrefixes = NO_PREFIX_ENTRIES;
    private LoadError[] errors = NO_ERRORS;
    private static final PrefixEntry[] NO_PREFIX_ENTRIES = new PrefixEntry[0];
    private static final LoadError[] NO_ERRORS = new LoadError[0];

    public Configuration loadTranslated(File file) throws IOException {
        return this.loadTranslated(FileUtil.fileToURL(file));
    }

    public Configuration loadTranslated(URL uRL) throws IOException {
        Configuration configuration = this.load(uRL);
        if (configuration != null) {
            configuration.translate();
        }
        return configuration;
    }

    public Configuration load(File file) throws IOException {
        return this.load(FileUtil.fileToURL(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration load(URL uRL) throws IOException {
        boolean bl;
        Configuration configuration = new Configuration();
        configuration.setURL(uRL);
        InputStream inputStream = uRL.openStream();
        try {
            bl = this.load(new OpenEntity(inputStream, uRL.toExternalForm(), uRL, null), configuration);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return bl ? configuration : null;
    }

    public boolean load(OpenEntity openEntity, Configuration configuration) throws IOException {
        Document document = Loader.createDocumentLoader().load(openEntity);
        return this.load(document, configuration);
    }

    public static DocumentLoader createDocumentLoader() {
        DocumentLoader documentLoader = new DocumentLoader();
        documentLoader.setNamespaceMode(1);
        documentLoader.setAddedProperties(7);
        return documentLoader;
    }

    public boolean load(Document document, Configuration configuration) throws IOException {
        this.preferredPrefixes = NO_PREFIX_ENTRIES;
        this.errors = NO_ERRORS;
        PreferredPrefix preferredPrefix = new PreferredPrefix();
        ArrayList arrayList = new ArrayList();
        Element element = document.getRootElement();
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string != null && string.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "name");
            string = null;
        }
        configuration.setName(string);
        boolean bl = configuration.load(document, preferredPrefix, arrayList);
        if (arrayList.size() > 0) {
            this.errors = arrayList.toArray(NO_ERRORS);
            arrayList.clear();
        } else {
            this.preferredPrefixes = preferredPrefix.getAll();
        }
        return bl;
    }

    public LoadError[] getErrors() {
        return this.errors;
    }

    public PrefixEntry[] getPreferredPrefixes() {
        return this.preferredPrefixes;
    }
}

