/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.InfoUtil;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import com.xmlmind.xmleditapp.config.Msg;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public final class MenuInfo
extends Info {
    private HashMap nameToEntry = new HashMap();

    public MenuInfo() {
        this(null);
    }

    public MenuInfo(Entry[] entryArray) {
        if (entryArray != null) {
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                this.nameToEntry.put(entry.name, entry);
                ++n;
            }
        }
    }

    public Entry[] getEntries() {
        Entry[] entryArray = new Entry[this.nameToEntry.size()];
        this.nameToEntry.values().toArray(entryArray);
        return entryArray;
    }

    public MenuSpec getMenuSpec(String string) {
        Entry entry;
        if (string == null) {
            string = "";
        }
        return (entry = (Entry)this.nameToEntry.get(string)) == null ? null : entry.getMenuSpec();
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        String string = "";
        if (element.hasAttribute(Constants.NAME_ATTRIBUTE) && (string = element.getNmtokenAttribute(Constants.NAME_ATTRIBUTE, null)) == null) {
            LoadError.add(arrayList, element, "invalidAttribute", "name");
            return false;
        }
        boolean[] blArray = new boolean[1];
        MenuSpec menuSpec = this.parseMenuSpec(element, string, blArray, arrayList);
        if (menuSpec == null) {
            return false;
        }
        this.nameToEntry.put(string, new Entry(string, menuSpec));
        return true;
    }

    private MenuSpec parseMenuSpec(Element element, String string, boolean[] blArray, ArrayList arrayList) {
        String string2 = element.getTokenAttribute(Constants.LABEL_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "label");
            return null;
        }
        MenuSpec menuSpec = new MenuSpec();
        menuSpec.label = string2;
        ArrayList<MenuItemSpec> arrayList2 = new ArrayList<MenuItemSpec>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                MenuItemSpec menuItemSpec;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Constants.ITEM_ELEMENT) {
                    menuItemSpec = MenuInfo.parseMenuItemSpec(element2, arrayList);
                    if (menuItemSpec == null) {
                        return null;
                    }
                    arrayList2.add(menuItemSpec);
                } else if (name == Constants.SEPARATOR_ELEMENT) {
                    arrayList2.add(new MenuItemSpec());
                } else if (name == Constants.INSERT_ELEMENT) {
                    if (blArray[0]) {
                        LoadError.add(arrayList, element, "invalidElement2", "menu", Msg.msg("multipleChild", "insert"));
                        return null;
                    }
                    blArray[0] = true;
                    menuItemSpec = this.getMenuSpec(string);
                    if (menuItemSpec == null) {
                        LoadError.add(arrayList, element, "invalidElement2", "menu", Msg.msg("previousDefinitionNotFound", "menu", string));
                        return null;
                    }
                    MenuItemSpec[] menuItemSpecArray = ((MenuSpec)menuItemSpec).items;
                    int n = 0;
                    while (n < menuItemSpecArray.length) {
                        arrayList2.add(menuItemSpecArray[n]);
                        ++n;
                    }
                } else if (name == Constants.MENU_ELEMENT) {
                    menuItemSpec = this.parseMenuSpec(element2, string, blArray, arrayList);
                    if (menuItemSpec == null) {
                        return null;
                    }
                    arrayList2.add(menuItemSpec);
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", name.getLocalPart());
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", "menu");
            return null;
        }
        menuSpec.items = new MenuItemSpec[n];
        arrayList2.toArray(menuSpec.items);
        return menuSpec;
    }

    private static final MenuItemSpec parseMenuItemSpec(Element element, ArrayList arrayList) {
        Object object;
        Object object2;
        String string = element.getTokenAttribute(Constants.LABEL_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "label");
            return null;
        }
        String string2 = element.getTokenAttribute(Constants.COMMAND_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "command");
            return null;
        }
        MenuItemSpec menuItemSpec = new MenuItemSpec();
        menuItemSpec.label = string;
        menuItemSpec.commandName = string2;
        menuItemSpec.commandParameter = element.getAttribute(Constants.PARAMETER_ATTRIBUTE);
        String string3 = element.getAnyURIAttribute(Constants.ICON_ATTRIBUTE, null);
        if (string3 != null && string3.length() > 0) {
            object2 = null;
            object = null;
            try {
                object = new Location(string3, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (object != null && ((ImageIcon)(object2 = new ImageIcon(((Location)object).getURL()))).getImageLoadStatus() != 8) {
                object2 = null;
            }
            if (object2 == null) {
                LoadError.add(arrayList, element, "invalidAttribute", "icon");
                return null;
            }
            menuItemSpec.icon = object2;
            menuItemSpec.iconLocation = object;
        }
        if ((object2 = element.getChildElement(0)) != null) {
            object = ((Element)object2).getName();
            if (object == Constants.ACCELERATOR_ELEMENT) {
                menuItemSpec.accelerator = MenuInfo.parseAccelerator((Element)object2, arrayList);
                if (menuItemSpec.accelerator == null) {
                    return null;
                }
            } else {
                LoadError.add(arrayList, (Element)object2, "unknownElement", ((Name)object).getLocalPart());
                return null;
            }
        }
        return menuItemSpec;
    }

    private static final KeyStroke parseAccelerator(Element element, ArrayList arrayList) {
        int n = -1;
        String string = element.getTokenAttribute(Constants.CODE_ATTRIBUTE, null);
        if (string != null) {
            n = InfoUtil.keyNameToCode(string);
        }
        if (n < 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "code");
            return null;
        }
        int n2 = 0;
        string = element.getAttribute(Constants.MODIFIERS_ATTRIBUTE);
        if (string != null && (n2 = InfoUtil.parseModifiers(string, false)) == -1) {
            LoadError.add(arrayList, element, "invalidAttribute", "modifiers");
            return null;
        }
        return KeyStroke.getKeyStroke(n, n2);
    }

    public void translate(HashMap hashMap) {
        Iterator iterator = this.nameToEntry.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            MenuInfo.translateMenuSpec(entry.menuSpec, hashMap);
        }
    }

    private static final void translateMenuSpec(MenuSpec menuSpec, HashMap hashMap) {
        Object object;
        if (menuSpec.label != null && (object = (String)hashMap.get(menuSpec.label)) != null) {
            menuSpec.label = object;
        }
        object = menuSpec.items;
        int n = 0;
        while (n < ((MenuItemSpec[])object).length) {
            String string;
            MenuItemSpec menuItemSpec = object[n];
            if (menuItemSpec.label != null && (string = (String)hashMap.get(menuItemSpec.label)) != null) {
                menuItemSpec.label = string;
            }
            if (menuItemSpec instanceof MenuSpec) {
                MenuInfo.translateMenuSpec((MenuSpec)menuItemSpec, hashMap);
            }
            ++n;
        }
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        Object[] objectArray = this.getEntries();
        if (objectArray.length == 0) {
            return false;
        }
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            MenuInfo.saveMenuSpec(((Entry)object).menuSpec, ((Entry)object).name, document.getRootElement());
            ++n;
        }
        return true;
    }

    private static final void saveMenuSpec(MenuSpec menuSpec, String string, Element element) {
        Element element2 = new Element(Constants.MENU_ELEMENT);
        element.appendChild(element2);
        if (string != null && string.length() > 0) {
            element2.putAttribute(Constants.NAME_ATTRIBUTE, string);
        }
        element2.putAttribute(Constants.LABEL_ATTRIBUTE, menuSpec.label);
        MenuItemSpec[] menuItemSpecArray = menuSpec.items;
        int n = 0;
        while (n < menuItemSpecArray.length) {
            MenuItemSpec menuItemSpec = menuItemSpecArray[n];
            if (menuItemSpec.label == null) {
                element2.appendChild(new Element(Constants.SEPARATOR_ELEMENT));
            } else if (menuItemSpec instanceof MenuSpec) {
                MenuInfo.saveMenuSpec((MenuSpec)menuItemSpec, null, element2);
            } else {
                MenuInfo.saveMenuItemSpec(menuItemSpec, element2);
            }
            ++n;
        }
    }

    private static final void saveMenuItemSpec(MenuItemSpec menuItemSpec, Element element) {
        Element element2 = new Element(Constants.ITEM_ELEMENT);
        element.appendChild(element2);
        element2.putAttribute(Constants.LABEL_ATTRIBUTE, menuItemSpec.label);
        if (menuItemSpec.iconLocation != null) {
            element2.putAttribute(Constants.ICON_ATTRIBUTE, menuItemSpec.iconLocation.getSystemId());
        }
        element2.putAttribute(Constants.COMMAND_ATTRIBUTE, menuItemSpec.commandName);
        if (menuItemSpec.commandParameter != null) {
            element2.putAttribute(Constants.PARAMETER_ATTRIBUTE, menuItemSpec.commandParameter);
        }
        if (menuItemSpec.accelerator != null) {
            Element element3 = new Element(Constants.ACCELERATOR_ELEMENT);
            element2.appendChild(element3);
            int n = menuItemSpec.accelerator.getKeyCode();
            int n2 = menuItemSpec.accelerator.getModifiers();
            element3.putAttribute(Constants.CODE_ATTRIBUTE, InfoUtil.keyCodeToName(n));
            if (n2 != 0) {
                element3.putAttribute(Constants.MODIFIERS_ATTRIBUTE, InfoUtil.formatModifiers(n2));
            }
        }
    }

    public static final class Entry
    implements Comparable {
        private String name;
        private MenuSpec menuSpec;

        public Entry(String string, MenuSpec menuSpec) {
            this.name = string;
            this.menuSpec = menuSpec;
        }

        public String getName() {
            return this.name;
        }

        public MenuSpec getMenuSpec() {
            return this.menuSpec;
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((Entry)object).name);
        }
    }

    public static class MenuSpec
    extends MenuItemSpec {
        public MenuItemSpec[] items = new MenuItemSpec[0];
    }

    public static class MenuItemSpec {
        public String label;
        public ImageIcon icon;
        public Location iconLocation;
        public KeyStroke accelerator;
        public String commandName;
        public String commandParameter;
    }
}

