/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.InfoUtil;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.process.ParameterGroups;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class ParameterGroupInfo
extends Info {
    private HashMap nameToGroup = new HashMap();

    public ParameterGroupInfo() {
        this(null);
    }

    public ParameterGroupInfo(Group[] groupArray) {
        if (groupArray != null) {
            int n = 0;
            while (n < groupArray.length) {
                Group group = groupArray[n];
                this.nameToGroup.put(group.name, group);
                ++n;
            }
        }
    }

    public Group[] getGroups() {
        Group[] groupArray = new Group[this.nameToGroup.size()];
        this.nameToGroup.values().toArray(groupArray);
        return groupArray;
    }

    public void registerGroups() {
        Iterator iterator = this.nameToGroup.values().iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            ParameterGroups.register(group.name, group.parameters);
        }
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return false;
        }
        String[] stringArray = InfoUtil.parseParameters(element);
        if (stringArray == null) {
            LoadError.add(arrayList, element, "invalidElement", "parameterGroup");
            return false;
        }
        this.nameToGroup.put(string, new Group(string, stringArray));
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.nameToGroup.size() == 0) {
            return false;
        }
        Object[] objectArray = this.getGroups();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            Element element2 = new Element(Constants.PARAMETER_GROUP_ELEMENT);
            element.appendChild(element2);
            element2.putAttribute(Constants.NAME_ATTRIBUTE, ((Group)object).name);
            InfoUtil.saveParameters(((Group)object).parameters, element2);
            ++n;
        }
        return true;
    }

    public static final class Group
    implements Comparable {
        private String name;
        private String[] parameters;

        public Group(String string, String[] stringArray) {
            this.name = string;
            this.parameters = stringArray;
        }

        public String getName() {
            return this.name;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((Group)object).name);
        }
    }
}

