/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementMatcher;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;

public final class PreserveSpaceInfo
extends Info {
    private ElementMatcher matcher;

    public PreserveSpaceInfo() {
        this(new XPath[0]);
    }

    public PreserveSpaceInfo(XPath[] xPathArray) {
        this.matcher = new ElementMatcher(xPathArray);
    }

    public XPath[] getXPaths() {
        return this.matcher.getXPaths();
    }

    public ElementMatcher getElementMatcher() {
        return this.matcher;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        XPath[] xPathArray = null;
        String[] stringArray = element.getListAttribute(Constants.ELEMENTS_ATTRIBUTE, null);
        if (stringArray != null) {
            xPathArray = new XPath[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                xPathArray[n] = XPath.fromString(stringArray[n], element, true);
                if (xPathArray[n] == null) {
                    LoadError.add(arrayList, element, "invalidAttribute", "elements");
                    return false;
                }
                ++n;
            }
        }
        if (xPathArray == null || xPathArray.length == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "elements");
            return false;
        }
        this.matcher = new ElementMatcher(xPathArray);
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        XPath[] xPathArray = this.matcher.getXPaths();
        if (xPathArray.length == 0) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "preserveSpace"));
        document.getRootElement().appendChild(element);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < xPathArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(xPathArray[n].toString(namespaceToPrefixes));
            ++n;
        }
        element.putAttribute(Constants.ELEMENTS_ATTRIBUTE, stringBuffer.toString());
        return true;
    }
}

