/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class PropertyInfo
extends Info {
    private HashMap nameToEntry = new HashMap();

    public PropertyInfo() {
        this(null);
    }

    public PropertyInfo(Entry[] entryArray) {
        if (entryArray != null) {
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                this.nameToEntry.put(entry.name, entry);
                ++n;
            }
        }
    }

    public Entry[] getEntries() {
        Entry[] entryArray = new Entry[this.nameToEntry.size()];
        this.nameToEntry.values().toArray(entryArray);
        return entryArray;
    }

    public void setSystemProperties() {
        Iterator iterator = this.nameToEntry.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            String string = entry.value instanceof Location ? ((Location)entry.value).getURL().toExternalForm() : (String)entry.value;
            System.setProperty(entry.name, string);
        }
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return false;
        }
        Object object = null;
        String string2 = element.getText();
        if (string2 != null) {
            if (element.getBooleanAttribute(Constants.URL_ATTRIBUTE, false)) {
                if ((string2 = string2.trim()).length() > 0) {
                    try {
                        object = new Location(string2, element.getLocation());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else {
                object = string2;
            }
        }
        if (object == null) {
            LoadError.add(arrayList, element, "invalidElement", "property");
            return false;
        }
        this.nameToEntry.put(string, new Entry(string, object));
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.nameToEntry.size() == 0) {
            return false;
        }
        Object[] objectArray = this.getEntries();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < objectArray.length) {
            String string;
            Object object = objectArray[n];
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "property"));
            element.appendChild(element2);
            element2.putAttribute(Constants.NAME_ATTRIBUTE, ((Entry)object).name);
            if (((Entry)object).value instanceof Location) {
                element2.putAttribute(Constants.URL_ATTRIBUTE, "true");
                string = ((Location)((Entry)object).value).getSystemId();
            } else {
                string = (String)((Entry)object).value;
            }
            element2.appendChild(new Text(string));
            ++n;
        }
        return true;
    }

    public static final class Entry
    implements Comparable {
        private String name;
        private Object value;

        public Entry(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((Entry)object).name);
        }
    }
}

