/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.RelaxngSyntax;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import java.net.MalformedURLException;
import java.util.ArrayList;

public final class RelaxngInfo
extends Info
implements RelaxngSyntax {
    private Location location;
    private String name;
    private byte syntax;
    private String encoding;

    public RelaxngInfo() {
        this(null, null, 0, null);
    }

    public RelaxngInfo(Location location, String string, int n, String string2) {
        this.location = location;
        this.name = string;
        this.syntax = (byte)n;
        this.encoding = string2;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Location location = null;
        String string = element.getAnyURIAttribute(Constants.LOCATION_ATTRIBUTE, null);
        if (string != null && string.length() > 0) {
            try {
                location = new Location(string, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (location == null) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "location");
            return false;
        }
        String string2 = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string2 != null && string2.length() == 0) {
            LoadError.add(arrayList, element, "invalidAttribute", "name");
            return false;
        }
        int n = 0;
        if (element.hasAttribute(Constants.COMPACT_SYNTAX_ATTRIBUTE)) {
            n = element.getBooleanAttribute(Constants.COMPACT_SYNTAX_ATTRIBUTE, false) ? 2 : 1;
        }
        String string3 = null;
        if (element.hasAttribute(Constants.ENCODING_ATTRIBUTE) && (string3 = element.getNmtokenAttribute(Constants.ENCODING_ATTRIBUTE, null)) == null) {
            LoadError.add(arrayList, element, "invalidAttribute", "encoding");
            return false;
        }
        this.location = location;
        this.name = string2;
        this.syntax = (byte)n;
        this.encoding = string3;
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.location == null) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "relaxng"));
        document.getRootElement().appendChild(element);
        element.putAttribute(Constants.LOCATION_ATTRIBUTE, this.location.getSystemId());
        if (this.name != null) {
            element.putAttribute(Constants.NAME_ATTRIBUTE, this.name);
        }
        if (this.syntax != 0) {
            element.putAttribute(Constants.COMPACT_SYNTAX_ATTRIBUTE, this.syntax == 2 ? "true" : "false");
        }
        if (this.encoding != null) {
            element.putAttribute(Constants.ENCODING_ATTRIBUTE, this.encoding);
        }
        return true;
    }
}

