/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.CharRange;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import java.util.ArrayList;

public final class SaveOptionsInfo
extends Info {
    public static final int ENCODING_OPTION = 1;
    public static final int INDENT_OPTION = 2;
    public static final int MAX_LINE_LENGTH_OPTION = 4;
    public static final int ADD_OPEN_LINES_OPTION = 8;
    public static final int CDATA_SECTION_ELEMENTS_OPTION = 16;
    public static final int SAVE_CHARS_AS_ENTITY_REFS_OPTION = 32;
    public static final int CHARS_SAVED_AS_ENTITY_REFS_OPTION = 64;
    public static final int FAVOR_INTEROPERABILITY_OPTION = 128;
    private int options = 0;
    private String encoding;
    private int indent;
    private int maxLineLength;
    private boolean addOpenLines;
    private XPath[] cdataSectionElements;
    private boolean saveCharsAsEntityRefs;
    private CharRange[] charsSavedAsEntityRefs;
    private boolean favorInteroperability;

    public int getOptions() {
        return this.options;
    }

    public boolean hasOption(int n) {
        return (this.options & n) != 0;
    }

    public void unsetOption(int n) {
        this.options &= ~n;
    }

    public void setEncoding(String string) {
        if (string == null || !StringUtil.contains(DocumentWriter.KNOWN_ENCODINGS, string)) {
            this.encoding = null;
            this.options &= 0xFFFFFFFE;
        } else {
            this.encoding = string;
            this.options |= 1;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setIndent(int n) {
        this.indent = n;
        this.options |= 2;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setMaxLineLength(int n) {
        if (n <= 0) {
            this.maxLineLength = 0;
            this.options &= 0xFFFFFFFB;
        } else {
            this.maxLineLength = n;
            this.options |= 4;
        }
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setAddingOpenLines(boolean bl) {
        this.addOpenLines = bl;
        this.options |= 8;
    }

    public boolean isAddingOpenLines() {
        return this.addOpenLines;
    }

    public void setCdataSectionElements(XPath[] xPathArray) {
        if (xPathArray == null || xPathArray.length == 0) {
            this.cdataSectionElements = null;
            this.options &= 0xFFFFFFEF;
        } else {
            this.cdataSectionElements = xPathArray;
            this.options |= 0x10;
        }
    }

    public XPath[] getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public void setSaveCharsAsEntityRefs(boolean bl) {
        this.saveCharsAsEntityRefs = bl;
        this.options |= 0x20;
    }

    public boolean getSaveCharsAsEntityRefs() {
        return this.saveCharsAsEntityRefs;
    }

    public void setCharsSavedAsEntityRefs(CharRange[] charRangeArray) {
        if (charRangeArray == null || charRangeArray.length == 0) {
            this.charsSavedAsEntityRefs = null;
            this.options &= 0xFFFFFFBF;
        } else {
            this.charsSavedAsEntityRefs = charRangeArray;
            this.options |= 0x40;
        }
    }

    public CharRange[] getCharsSavedAsEntityRefs() {
        return this.charsSavedAsEntityRefs;
    }

    public void setFavorInteroperability(boolean bl) {
        this.favorInteroperability = bl;
        this.options |= 0x80;
    }

    public boolean getFavorInteroperability() {
        return this.favorInteroperability;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        XPath[] xPathArray;
        String[] stringArray;
        int n;
        int n2;
        String string = element.getEnumAttribute(Constants.ENCODING_ATTRIBUTE, DocumentWriter.KNOWN_ENCODINGS, null);
        if (string != null) {
            this.setEncoding(string);
        }
        if ((n2 = element.getIntAttribute(Constants.INDENT_ATTRIBUTE, 0, Integer.MAX_VALUE, -1)) < 0) {
            String string2 = element.getTokenAttribute(Constants.INDENT_ATTRIBUTE, null);
            if ("none".equals(string2)) {
                this.setIndent(-1);
            }
        } else {
            this.setIndent(n2);
        }
        if ((n = element.getIntAttribute(Constants.MAX_LINE_LENGTH_ATTRIBUTE, 1, Integer.MAX_VALUE, -1)) < 0) {
            stringArray = element.getTokenAttribute(Constants.MAX_LINE_LENGTH_ATTRIBUTE, null);
            if ("unbounded".equals(stringArray)) {
                this.setMaxLineLength(Integer.MAX_VALUE);
            }
        } else {
            this.setMaxLineLength(n);
        }
        if (element.hasAttribute(Constants.ADD_OPEN_LINES_ATTRIBUTE)) {
            this.setAddingOpenLines(element.getBooleanAttribute(Constants.ADD_OPEN_LINES_ATTRIBUTE, false));
        }
        if ((stringArray = element.getListAttribute(Constants.CDATA_SECTION_ELEMENTS_ATTRIBUTE, null)) != null) {
            xPathArray = new XPath[stringArray.length];
            int n3 = 0;
            while (n3 < stringArray.length) {
                xPathArray[n3] = XPath.fromString(stringArray[n3], element, true);
                if (xPathArray[n3] == null) {
                    LoadError.add(arrayList, element, "invalidAttribute", "cdataSectionElements");
                    return false;
                }
                ++n3;
            }
            this.setCdataSectionElements(xPathArray);
        }
        if (element.hasAttribute(Constants.SAVE_CHARS_AS_ENTITY_REFS_ATTRIBUTE)) {
            this.setSaveCharsAsEntityRefs(element.getBooleanAttribute(Constants.SAVE_CHARS_AS_ENTITY_REFS_ATTRIBUTE, false));
        }
        if ((xPathArray = element.getAttribute(Constants.CHARS_SAVED_AS_ENTITY_REFS_ATTRIBUTE)) != null) {
            CharRange[] charRangeArray = CharRange.parseRanges((String)xPathArray);
            if (charRangeArray == null) {
                LoadError.add(arrayList, element, "invalidAttribute", "charsSavedAsEntityRefs");
                return false;
            }
            this.setCharsSavedAsEntityRefs(charRangeArray);
        }
        if (element.hasAttribute(Constants.FAVOR_INTEROPERABILITY_ATTRIBUTE)) {
            this.setFavorInteroperability(element.getBooleanAttribute(Constants.FAVOR_INTEROPERABILITY_ATTRIBUTE, false));
        }
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        int n;
        StringBuffer stringBuffer;
        if (this.options == 0) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "saveOptions"));
        document.getRootElement().appendChild(element);
        if ((this.options & 1) != 0) {
            element.putAttribute(Constants.ENCODING_ATTRIBUTE, this.encoding);
        }
        if ((this.options & 2) != 0) {
            element.putAttribute(Constants.INDENT_ATTRIBUTE, this.indent < 0 ? "none" : Integer.toString(this.indent));
        }
        if ((this.options & 4) != 0) {
            element.putAttribute(Constants.MAX_LINE_LENGTH_ATTRIBUTE, this.maxLineLength == Integer.MAX_VALUE ? "unbounded" : Integer.toString(this.maxLineLength));
        }
        if ((this.options & 8) != 0) {
            element.putAttribute(Constants.ADD_OPEN_LINES_ATTRIBUTE, Boolean.toString(this.addOpenLines));
        }
        if ((this.options & 0x10) != 0) {
            stringBuffer = new StringBuffer();
            n = 0;
            while (n < this.cdataSectionElements.length) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.cdataSectionElements[n].toString(namespaceToPrefixes));
                ++n;
            }
            element.putAttribute(Constants.CDATA_SECTION_ELEMENTS_ATTRIBUTE, stringBuffer.toString());
        }
        if ((this.options & 0x20) != 0) {
            element.putAttribute(Constants.SAVE_CHARS_AS_ENTITY_REFS_ATTRIBUTE, Boolean.toString(this.saveCharsAsEntityRefs));
        }
        if ((this.options & 0x40) != 0) {
            stringBuffer = new StringBuffer();
            n = 0;
            while (n < this.charsSavedAsEntityRefs.length) {
                CharRange charRange = this.charsSavedAsEntityRefs[n];
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                if (charRange.getFirst() == charRange.getLast()) {
                    stringBuffer.append((int)charRange.getFirst());
                } else {
                    stringBuffer.append((int)charRange.getFirst());
                    stringBuffer.append(':');
                    stringBuffer.append((int)charRange.getLast());
                }
                ++n;
            }
            element.putAttribute(Constants.CHARS_SAVED_AS_ENTITY_REFS_ATTRIBUTE, stringBuffer.toString());
        }
        if ((this.options & 0x80) != 0) {
            element.putAttribute(Constants.FAVOR_INTEROPERABILITY_ATTRIBUTE, Boolean.toString(this.favorInteroperability));
        }
        return true;
    }
}

