/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.NamespaceURLPair;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import java.net.MalformedURLException;
import java.util.ArrayList;

public final class SchemaInfo
extends Info {
    private Entry[] entries;
    private NamespaceURLPair[] pairs;

    public SchemaInfo() {
        this(new Entry[0]);
    }

    public SchemaInfo(Entry[] entryArray) {
        this.entries = entryArray;
        this.pairs = null;
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public NamespaceURLPair[] getLocations() {
        if (this.pairs == null) {
            this.pairs = new NamespaceURLPair[this.entries.length];
            int n = 0;
            while (n < this.entries.length) {
                NamespaceURLPair namespaceURLPair;
                Entry entry = this.entries[n];
                this.pairs[n] = namespaceURLPair = new NamespaceURLPair(entry.namespace, entry.location.getURL());
                ++n;
            }
        }
        return this.pairs;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Object object;
                String string;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Constants.LOCATION_ELEMENT) {
                    boolean bl = false;
                    string = element2.getText();
                    if (string != null) {
                        object = XMLUtil.splitList(string);
                        if (((String[])object).length > 0 && ((String[])object).length % 2 == 0) {
                            int n = 0;
                            while (n < ((String[])object).length) {
                                String string2 = object[n];
                                String string3 = object[n + 1];
                                Location location = null;
                                try {
                                    location = new Location(string3, element2.getLocation());
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                                if (location == null) {
                                    bl = true;
                                    break;
                                }
                                Entry entry = new Entry(Namespace.get(string2), location);
                                if (!arrayList2.contains(entry)) {
                                    arrayList2.add(entry);
                                }
                                n += 2;
                            }
                        } else {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        LoadError.add(arrayList, element2, "invalidElement", "location");
                        return false;
                    }
                } else if (name == Constants.NO_NAMESPACE_LOCATION_ELEMENT) {
                    Location location = null;
                    string = element2.getText();
                    if (string != null && (string = string.trim()).length() > 0) {
                        try {
                            location = new Location(string, element2.getLocation());
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (location == null) {
                        LoadError.add(arrayList, element2, "invalidElement", "noNamespaceLocation");
                        return false;
                    }
                    object = new Entry(Namespace.NONE, location);
                    if (!arrayList2.contains(object)) {
                        arrayList2.add(object);
                    }
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", name.getLocalPart());
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", "schema");
            return false;
        }
        this.entries = new Entry[n];
        arrayList2.toArray(this.entries);
        this.pairs = null;
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        Object object;
        if (this.entries.length == 0) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "schema"));
        document.getRootElement().appendChild(element);
        boolean bl = false;
        int n = 0;
        while (n < this.entries.length) {
            object = this.entries[n];
            if (((Entry)object).namespace == Namespace.NONE) {
                Element element2 = new Element(Constants.NO_NAMESPACE_LOCATION_ELEMENT);
                element.appendChild(element2);
                element2.appendChild(new Text(((Entry)object).location.getSystemId()));
            } else {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            Object object2;
            object = new StringBuffer();
            int n2 = 0;
            while (n2 < this.entries.length) {
                object2 = this.entries[n2];
                if (((Entry)object2).namespace != Namespace.NONE) {
                    if (((StringBuffer)object).length() > 0) {
                        ((StringBuffer)object).append(' ');
                    }
                    ((StringBuffer)object).append(((Entry)object2).namespace.getURI());
                    ((StringBuffer)object).append(' ');
                    ((StringBuffer)object).append(((Entry)object2).location.getSystemId());
                }
                ++n2;
            }
            object2 = new Element(Constants.LOCATION_ELEMENT);
            element.appendChild((Node)object2);
            ((Tree)object2).appendChild(new Text(((StringBuffer)object).toString()));
        }
        return true;
    }

    public static final class Entry {
        private Namespace namespace;
        private Location location;

        public Entry(Namespace namespace, Location location) {
            this.namespace = namespace;
            this.location = location;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            return this.namespace == ((Entry)object).namespace;
        }
    }
}

