/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import com.xmlmind.xmleditapp.config.Msg;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunction;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public final class SpreadsheetFunctionsInfo
extends Info {
    private HashMap functionsLocations = new HashMap();
    private FormulaFunctions formulaFunctions = null;
    private String[] formulaFunctionsErrors = StringUtil.EMPTY_LIST;

    public SpreadsheetFunctionsInfo() {
        this(null);
    }

    public SpreadsheetFunctionsInfo(Location[] locationArray) {
        if (locationArray != null) {
            int n = 0;
            while (n < locationArray.length) {
                Location location = locationArray[n];
                this.functionsLocations.put(location, location);
                ++n;
            }
        }
    }

    public Location[] getLocations() {
        Location[] locationArray = new Location[this.functionsLocations.size()];
        this.functionsLocations.values().toArray(locationArray);
        return locationArray;
    }

    public FormulaFunctions getFormulaFunctions() {
        if (this.functionsLocations.size() == 0) {
            return null;
        }
        if (this.formulaFunctions == null && this.formulaFunctionsErrors.length == 0) {
            this.formulaFunctions = new FormulaFunctions();
            ArrayList<String> arrayList = new ArrayList<String>();
            Location[] locationArray = this.getLocations();
            int n = 0;
            while (n < locationArray.length) {
                block9: {
                    FormulaFunction[] formulaFunctionArray;
                    URL uRL = locationArray[n].getURL();
                    try {
                        formulaFunctionArray = FormulaFunctions.load(uRL);
                    }
                    catch (IOException iOException) {
                        arrayList.add(Msg.msg("cannotLoadFunctions", uRL, iOException.getMessage()));
                        break block9;
                    }
                    int n2 = 0;
                    while (n2 < formulaFunctionArray.length) {
                        try {
                            this.formulaFunctions.register(formulaFunctionArray[n2]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            arrayList.add(Msg.msg("cannotRegisterFunction", formulaFunctionArray[n2].getName(), illegalArgumentException.getMessage()));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            int n3 = arrayList.size();
            if (n3 > 0) {
                this.formulaFunctions = null;
                this.formulaFunctionsErrors = new String[n3];
                arrayList.toArray(this.formulaFunctionsErrors);
            }
        }
        return this.formulaFunctions;
    }

    public String[] getFormulaFunctionsErrors() {
        return this.formulaFunctionsErrors;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Location location = null;
        String string = element.getAnyURIAttribute(Constants.LOCATION_ATTRIBUTE, null);
        if (string != null && string.length() > 0) {
            try {
                location = new Location(string, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (location == null) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "location");
            return false;
        }
        this.functionsLocations.put(location, location);
        this.formulaFunctions = null;
        this.formulaFunctionsErrors = StringUtil.EMPTY_LIST;
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.functionsLocations.size() == 0) {
            return false;
        }
        Object[] objectArray = this.getLocations();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "spreadsheetFunctions"));
            element.appendChild(element2);
            element2.putAttribute(Constants.LOCATION_ATTRIBUTE, ((Location)object).getSystemId());
            ++n;
        }
        return true;
    }
}

