/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class TemplateInfo
extends Info {
    private HashMap nameToEntry = new HashMap();

    public TemplateInfo() {
        this(null);
    }

    public TemplateInfo(Entry[] entryArray) {
        if (entryArray != null) {
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                this.nameToEntry.put(entry.name, entry);
                ++n;
            }
        }
    }

    public Entry[] getEntries() {
        Entry[] entryArray = new Entry[this.nameToEntry.size()];
        this.nameToEntry.values().toArray(entryArray);
        return entryArray;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return false;
        }
        Location location = null;
        String string2 = element.getAnyURIAttribute(Constants.LOCATION_ATTRIBUTE, null);
        if (string2 != null && string2.length() > 0) {
            try {
                location = new Location(string2, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                LoadError.add(arrayList, element, "missingOrInvalidAttribute", "location");
                return false;
            }
        }
        if (location == null) {
            this.nameToEntry.remove(string);
        } else {
            this.nameToEntry.put(string, new Entry(string, location));
        }
        return true;
    }

    public void translate(HashMap hashMap) {
        HashMap<String, Entry> hashMap2 = new HashMap<String, Entry>();
        Iterator iterator = this.nameToEntry.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            String string = entry.getName();
            String string2 = (String)hashMap.get(string);
            if (string2 == null) {
                hashMap2.put(string, entry);
                continue;
            }
            hashMap2.put(string2, new Entry(string2, entry.getLocation()));
        }
        this.nameToEntry = hashMap2;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.nameToEntry.size() == 0) {
            return false;
        }
        Object[] objectArray = this.getEntries();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "template"));
            element.appendChild(element2);
            element2.putAttribute(Constants.NAME_ATTRIBUTE, ((Entry)object).name);
            element2.putAttribute(Constants.LOCATION_ATTRIBUTE, ((Entry)object).location.getSystemId());
            ++n;
        }
        return true;
    }

    public static final class Entry
    implements Comparable {
        private String name;
        private Location location;

        public Entry(String string, Location location) {
            this.name = string;
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public Location getLocation() {
            return this.location;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((Entry)object).name);
        }
    }
}

