/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import com.xmlmind.xmleditapp.config.Msg;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;

public final class ToolBarInfo
extends Info {
    private HashMap nameToEntry = new HashMap();

    public ToolBarInfo() {
        this(null);
    }

    public ToolBarInfo(Entry[] entryArray) {
        if (entryArray != null) {
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                this.nameToEntry.put(entry.name, entry);
                ++n;
            }
        }
    }

    public Entry[] getEntries() {
        Entry[] entryArray = new Entry[this.nameToEntry.size()];
        this.nameToEntry.values().toArray(entryArray);
        return entryArray;
    }

    public ButtonSpec[] getButtonSpecs(String string) {
        Entry entry;
        if (string == null) {
            string = "";
        }
        return (entry = (Entry)this.nameToEntry.get(string)) == null ? null : entry.getButtonSpecs();
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        ButtonSpec[] buttonSpecArray;
        ArrayList<ButtonSpec> arrayList2 = new ArrayList<ButtonSpec>();
        boolean bl = false;
        String string = "";
        if (element.hasAttribute(Constants.NAME_ATTRIBUTE) && (string = element.getNmtokenAttribute(Constants.NAME_ATTRIBUTE, null)) == null) {
            LoadError.add(arrayList, element, "invalidAttribute", "name");
            return false;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Constants.BUTTON_ELEMENT) {
                    ButtonSpec buttonSpec = ToolBarInfo.parseButtonSpec(element2, arrayList);
                    if (buttonSpec == null) {
                        return false;
                    }
                    arrayList2.add(buttonSpec);
                } else if (name == Constants.SEPARATOR_ELEMENT) {
                    arrayList2.add(new ButtonSpec());
                } else if (name == Constants.INSERT_ELEMENT) {
                    if (bl) {
                        LoadError.add(arrayList, element, "invalidElement2", "toolBar", Msg.msg("multipleChild", "insert"));
                        return false;
                    }
                    bl = true;
                    buttonSpecArray = this.getButtonSpecs(string);
                    if (buttonSpecArray == null) {
                        LoadError.add(arrayList, element, "invalidElement2", "toolBar", Msg.msg("previousDefinitionNotFound", "toolBar", string));
                        return false;
                    }
                    int n = 0;
                    while (n < buttonSpecArray.length) {
                        arrayList2.add(buttonSpecArray[n]);
                        ++n;
                    }
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", name.getLocalPart());
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", "toolBar");
            return false;
        }
        buttonSpecArray = new ButtonSpec[n];
        arrayList2.toArray(buttonSpecArray);
        this.nameToEntry.put(string, new Entry(string, buttonSpecArray));
        return true;
    }

    private static final ButtonSpec parseButtonSpec(Element element, ArrayList arrayList) {
        ImageIcon imageIcon = null;
        Location location = null;
        String string = element.getAnyURIAttribute(Constants.ICON_ATTRIBUTE, null);
        if (string != null && string.length() > 0) {
            try {
                location = new Location(string, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (location != null && (imageIcon = new ImageIcon(location.getURL())).getImageLoadStatus() != 8) {
                imageIcon = null;
            }
        }
        if (imageIcon == null) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "icon");
            return null;
        }
        ButtonSpec buttonSpec = new ButtonSpec();
        buttonSpec.icon = imageIcon;
        buttonSpec.iconLocation = location;
        string = element.getTokenAttribute(Constants.TOOL_TIP_ATTRIBUTE, null);
        if (string != null && string.length() == 0) {
            string = null;
        }
        buttonSpec.toolTip = string;
        Element element2 = element.getChildElement(0);
        if (element2 != null) {
            Name name = element2.getName();
            if (name == Constants.COMMAND_ELEMENT) {
                ToolBarInfo.parseCommand(element2, buttonSpec, arrayList);
            } else if (name == Constants.MENU_ELEMENT) {
                buttonSpec.menu = ToolBarInfo.parseMenu(element2, arrayList);
            }
        }
        if (buttonSpec.commandName == null && buttonSpec.menu == null) {
            LoadError.add(arrayList, element, "invalidElement", "button");
            return null;
        }
        return buttonSpec;
    }

    private static final MenuItemSpec[] parseMenu(Element element, ArrayList arrayList) {
        Object object;
        ArrayList<MenuItemSpec> arrayList2 = new ArrayList<MenuItemSpec>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                object = element2.getName();
                if (object == Constants.ITEM_ELEMENT) {
                    MenuItemSpec menuItemSpec = ToolBarInfo.parseItem(element2, arrayList);
                    if (menuItemSpec == null) {
                        return null;
                    }
                    arrayList2.add(menuItemSpec);
                } else if (object == Constants.SEPARATOR_ELEMENT) {
                    arrayList2.add(new MenuItemSpec());
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", object.getLocalPart());
                    return null;
                }
            }
            node = node.getNextSibling();
        }
        int n = arrayList2.size();
        if (n == 0) {
            LoadError.add(arrayList, element, "invalidElement", "menu");
            return null;
        }
        object = new MenuItemSpec[n];
        arrayList2.toArray((T[])object);
        return object;
    }

    private static final MenuItemSpec parseItem(Element element, ArrayList arrayList) {
        String string = element.getTokenAttribute(Constants.LABEL_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "label");
            return null;
        }
        String string2 = element.getTokenAttribute(Constants.COMMAND_ATTRIBUTE, null);
        if (string2 == null || string2.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "command");
            return null;
        }
        MenuItemSpec menuItemSpec = new MenuItemSpec();
        menuItemSpec.label = string;
        menuItemSpec.commandName = string2;
        menuItemSpec.commandParameter = element.getAttribute(Constants.PARAMETER_ATTRIBUTE);
        ImageIcon imageIcon = null;
        Location location = null;
        String string3 = element.getAnyURIAttribute(Constants.ICON_ATTRIBUTE, null);
        if (string3 != null && string3.length() > 0) {
            try {
                location = new Location(string3, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (location != null && (imageIcon = new ImageIcon(location.getURL())).getImageLoadStatus() != 8) {
                imageIcon = null;
            }
            if (imageIcon == null) {
                LoadError.add(arrayList, element, "missingOrInvalidAttribute", "icon");
                return null;
            }
        }
        menuItemSpec.icon = imageIcon;
        menuItemSpec.iconLocation = location;
        return menuItemSpec;
    }

    private static boolean parseCommand(Element element, ButtonSpec buttonSpec, ArrayList arrayList) {
        String string = element.getTokenAttribute(Constants.NAME_ATTRIBUTE, null);
        if (string == null || string.length() == 0) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "name");
            return false;
        }
        buttonSpec.commandName = string;
        buttonSpec.commandParameter = element.getAttribute(Constants.PARAMETER_ATTRIBUTE);
        return true;
    }

    public void translate(HashMap hashMap) {
        Iterator iterator = this.nameToEntry.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            ToolBarInfo.translateEntry(entry, hashMap);
        }
    }

    private static final void translateEntry(Entry entry, HashMap hashMap) {
        ButtonSpec[] buttonSpecArray = entry.buttonSpecs;
        int n = 0;
        while (n < buttonSpecArray.length) {
            Object object;
            ButtonSpec buttonSpec = buttonSpecArray[n];
            if (buttonSpec.toolTip != null && (object = (String)hashMap.get(buttonSpec.toolTip)) != null) {
                buttonSpec.toolTip = object;
            }
            if ((object = buttonSpec.menu) != null) {
                int n2 = 0;
                while (n2 < ((MenuItemSpec[])object).length) {
                    MenuItemSpec menuItemSpec = object[n2];
                    String string = (String)hashMap.get(menuItemSpec.label);
                    if (string != null) {
                        menuItemSpec.label = string;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        Object[] objectArray = this.getEntries();
        if (objectArray.length == 0) {
            return false;
        }
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        int n = 0;
        while (n < objectArray.length) {
            ToolBarInfo.saveEntry((Entry)objectArray[n], document);
            ++n;
        }
        return true;
    }

    private static final void saveEntry(Entry entry, Document document) {
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "toolBar"));
        document.getRootElement().appendChild(element);
        if (entry.name.length() > 0) {
            element.putAttribute(Constants.NAME_ATTRIBUTE, entry.name);
        }
        ButtonSpec[] buttonSpecArray = entry.buttonSpecs;
        int n = 0;
        while (n < buttonSpecArray.length) {
            ButtonSpec buttonSpec = buttonSpecArray[n];
            if (buttonSpec.icon == null) {
                element.appendChild(new Element(Constants.SEPARATOR_ELEMENT));
            } else {
                Element element2;
                Element element3 = new Element(Constants.BUTTON_ELEMENT);
                element.appendChild(element3);
                element3.putAttribute(Constants.ICON_ATTRIBUTE, buttonSpec.iconLocation.getSystemId());
                if (buttonSpec.toolTip != null) {
                    element3.putAttribute(Constants.TOOL_TIP_ATTRIBUTE, buttonSpec.toolTip);
                }
                if (buttonSpec.menu != null) {
                    element2 = new Element(Constants.MENU_ELEMENT);
                    element3.appendChild(element2);
                    MenuItemSpec[] menuItemSpecArray = buttonSpec.menu;
                    int n2 = 0;
                    while (n2 < menuItemSpecArray.length) {
                        MenuItemSpec menuItemSpec = menuItemSpecArray[n2];
                        if (menuItemSpec.label == null) {
                            element2.appendChild(new Element(Constants.SEPARATOR_ELEMENT));
                        } else {
                            Element element4 = new Element(Constants.ITEM_ELEMENT);
                            element2.appendChild(element4);
                            element4.putAttribute(Constants.LABEL_ATTRIBUTE, menuItemSpec.label);
                            if (menuItemSpec.icon != null) {
                                element4.putAttribute(Constants.ICON_ATTRIBUTE, menuItemSpec.iconLocation.getSystemId());
                            }
                            element4.putAttribute(Constants.COMMAND_ATTRIBUTE, menuItemSpec.commandName);
                            if (menuItemSpec.commandParameter != null) {
                                element4.putAttribute(Constants.PARAMETER_ATTRIBUTE, menuItemSpec.commandParameter);
                            }
                        }
                        ++n2;
                    }
                } else {
                    element2 = new Element(Constants.COMMAND_ELEMENT);
                    element3.appendChild(element2);
                    element2.putAttribute(Constants.NAME_ATTRIBUTE, buttonSpec.commandName);
                    if (buttonSpec.commandParameter != null) {
                        element2.putAttribute(Constants.PARAMETER_ATTRIBUTE, buttonSpec.commandParameter);
                    }
                }
            }
            ++n;
        }
    }

    public static final class Entry
    implements Comparable {
        private String name;
        private ButtonSpec[] buttonSpecs;

        public Entry(String string, ButtonSpec[] buttonSpecArray) {
            this.name = string;
            this.buttonSpecs = buttonSpecArray;
        }

        public String getName() {
            return this.name;
        }

        public ButtonSpec[] getButtonSpecs() {
            return this.buttonSpecs;
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((Entry)object).name);
        }
    }

    public static class ButtonSpec {
        public ImageIcon icon;
        public Location iconLocation;
        public String toolTip;
        public String commandName;
        public String commandParameter;
        public MenuItemSpec[] menu;
    }

    public static class MenuItemSpec {
        public String label;
        public ImageIcon icon;
        public Location iconLocation;
        public String commandName;
        public String commandParameter;
    }
}

