/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.LanguageType;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public final class TranslationInfo
extends Info {
    private Location[] locations;
    private static HashMap urlToMessageMap = new HashMap();
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$config$TranslationInfo;

    public TranslationInfo() {
        this(null);
    }

    public TranslationInfo(Location[] locationArray) {
        if (locationArray == null) {
            locationArray = new Location[]{};
        }
        this.locations = locationArray;
    }

    public void addLocation(Location location) {
        int n = this.locations.length;
        Location[] locationArray = new Location[n + 1];
        System.arraycopy(this.locations, 0, locationArray, 0, n);
        locationArray[n] = location;
        this.locations = locationArray;
    }

    public Location[] getLocations() {
        return this.locations;
    }

    public HashMap getMessageMap() {
        Serializable serializable;
        if (this.locations.length == 0) {
            return null;
        }
        HashMap[] hashMapArray = new HashMap[this.locations.length];
        int n = 0;
        while (n < this.locations.length) {
            serializable = this.locations[n].getURL();
            HashMap hashMap = (HashMap)urlToMessageMap.get(serializable);
            if (hashMap == null) {
                hashMap = new HashMap();
                urlToMessageMap.put(serializable, hashMap);
                TranslationInfo.initMessageMap((URL)serializable, hashMap);
            }
            hashMapArray[n] = hashMap;
            ++n;
        }
        if (hashMapArray.length == 1) {
            return hashMapArray[0];
        }
        serializable = new HashMap();
        int n2 = 0;
        while (n2 < hashMapArray.length) {
            ((HashMap)serializable).putAll(hashMapArray[n2]);
            ++n2;
        }
        return serializable;
    }

    private static final void initMessageMap(URL uRL, HashMap hashMap) {
        int n;
        URL uRL2 = URLUtil.getDirectory(uRL);
        String string = URIUtil.unescape(URLUtil.getRawBaseName(uRL));
        if (!string.endsWith(".properties")) {
            return;
        }
        int n2 = string.lastIndexOf(95);
        if (n2 < 0) {
            return;
        }
        if ((n = string.indexOf(46, ++n2)) != n2 + 2) {
            return;
        }
        String string2 = string.substring(n2, n);
        if (!LanguageType.isKnownLanguage(string2)) {
            return;
        }
        String string3 = Locale.getDefault().getLanguage();
        if (string2.equals(string3)) {
            return;
        }
        Properties properties = TranslationInfo.loadProperties(uRL);
        if (properties == null) {
            return;
        }
        String string4 = string.substring(0, n2) + string3 + string.substring(n);
        URL uRL3 = null;
        try {
            uRL3 = new URL(uRL2, URIUtil.quotePath(string4));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Properties properties2 = null;
        if ((uRL3 == null || (properties2 = TranslationInfo.loadProperties(uRL3)) == null) && (uRL3 = (class$com$xmlmind$xmleditapp$config$TranslationInfo == null ? (class$com$xmlmind$xmleditapp$config$TranslationInfo = TranslationInfo.class$("com.xmlmind.xmleditapp.config.TranslationInfo")) : class$com$xmlmind$xmleditapp$config$TranslationInfo).getClassLoader().getResource(string4)) != null) {
            properties2 = TranslationInfo.loadProperties(uRL3);
        }
        if (properties2 == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string5 = properties2.getProperty((String)entry.getKey());
            if (string5 == null) continue;
            hashMap.put(entry.getValue(), string5);
        }
    }

    private static final Properties loadProperties(URL uRL) {
        Properties properties = new Properties();
        try {
            TranslationInfo.loadProperties(uRL, properties);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadProperties(URL uRL, Properties properties) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            properties.load(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        Location location = null;
        String string = element.getAnyURIAttribute(Constants.LOCATION_ATTRIBUTE, null);
        if (string != null && string.length() > 0) {
            try {
                location = new Location(string, element.getLocation());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (location == null) {
            LoadError.add(arrayList, element, "missingOrInvalidAttribute", "location");
            return false;
        }
        this.addLocation(location);
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.locations.length == 0) {
            return false;
        }
        Element element = document.getRootElement();
        int n = 0;
        while (n < this.locations.length) {
            Location location = this.locations[n];
            Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "translation"));
            element.appendChild(element2);
            element2.putAttribute(Constants.LOCATION_ATTRIBUTE, location.getSystemId());
            ++n;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

