/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.config;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Msg;
import java.util.ArrayList;

public final class WindowLayoutInfo
extends Info {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    public static final int LEFT = 4;
    private Pane[] panes;
    private static final double DEFAULT_SIZE = 0.25;

    public WindowLayoutInfo() {
        this(null);
    }

    public WindowLayoutInfo(Pane[] paneArray) {
        if (paneArray == null) {
            paneArray = new Pane[]{};
        }
        this.panes = paneArray;
    }

    public Pane[] getPanes() {
        return this.panes;
    }

    public Pane[] getPanes(StyleSheetInfo[] styleSheetInfoArray) {
        Pane[] paneArray;
        boolean bl = false;
        Pane[] paneArray2 = new Pane[this.panes.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.panes.length) {
            paneArray = this.panes[n2];
            if (((Pane)paneArray).cssName == null) {
                paneArray2[n++] = paneArray.copy();
                if (((Pane)paneArray).position == 0) {
                    bl = true;
                }
            } else if (styleSheetInfoArray != null) {
                int n3 = 0;
                while (n3 < styleSheetInfoArray.length) {
                    StyleSheetInfo styleSheetInfo = styleSheetInfoArray[n3];
                    if (((Pane)paneArray).cssName.equals(styleSheetInfo.title)) {
                        Pane pane = paneArray.copy();
                        pane.styleSheetInfo = styleSheetInfo;
                        if (((Pane)paneArray).position == 0) {
                            bl = true;
                        }
                        paneArray2[n++] = pane;
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        if (n != paneArray2.length) {
            paneArray = new Pane[n];
            System.arraycopy(paneArray2, 0, paneArray, 0, n);
            paneArray2 = paneArray;
        }
        return paneArray2;
    }

    public boolean load(Element element, PrefixToNamespace prefixToNamespace, ArrayList arrayList) {
        ArrayList<Pane> arrayList2 = new ArrayList<Pane>();
        boolean bl = false;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Constants.CENTER_ELEMENT || name == Constants.TOP_ELEMENT || name == Constants.BOTTOM_ELEMENT || name == Constants.LEFT_ELEMENT || name == Constants.RIGHT_ELEMENT) {
                    String string = element2.getTokenAttribute(Constants.CSS_ATTRIBUTE, null);
                    if (string != null && string.length() == 0) {
                        LoadError.add(arrayList, element2, "invalidAttribute", "css");
                        return false;
                    }
                    double d = 0.25;
                    if (name == Constants.CENTER_ELEMENT) {
                        bl = true;
                    } else if (element2.hasAttribute(Constants.SIZE_ATTRIBUTE) && (d = element2.getDoubleAttribute(Constants.SIZE_ATTRIBUTE, 0.001, 0.999, -1.0)) < 0.0) {
                        LoadError.add(arrayList, element2, "invalidAttribute", "size");
                        return false;
                    }
                    int n = name == Constants.TOP_ELEMENT ? 1 : (name == Constants.BOTTOM_ELEMENT ? 3 : (name == Constants.LEFT_ELEMENT ? 4 : (name == Constants.RIGHT_ELEMENT ? 2 : 0)));
                    Pane pane = new Pane(n, string, d);
                    if (arrayList2.contains(pane)) {
                        LoadError.add(arrayList, element, "invalidElement2", "windowLayout", Msg.msg("multipleChild", name.getLocalPart()));
                        return false;
                    }
                    arrayList2.add(pane);
                } else {
                    LoadError.add(arrayList, element2, "unknownElement", name.getLocalPart());
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        if (!bl) {
            LoadError.add(arrayList, element, "invalidElement2", "windowLayout", Msg.msg("missingChild", "center"));
            return false;
        }
        this.panes = new Pane[arrayList2.size()];
        arrayList2.toArray(this.panes);
        return true;
    }

    public boolean save(NamespaceToPrefixes namespaceToPrefixes, Document document) {
        if (this.panes.length == 0) {
            return false;
        }
        Element element = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, "windowLayout"));
        document.getRootElement().appendChild(element);
        int n = 0;
        while (n < this.panes.length) {
            this.savePane(this.panes[n], element);
            ++n;
        }
        return true;
    }

    private void savePane(Pane pane, Element element) {
        String string;
        switch (pane.position) {
            case 1: {
                string = "top";
                break;
            }
            case 3: {
                string = "bottom";
                break;
            }
            case 4: {
                string = "left";
                break;
            }
            case 2: {
                string = "right";
                break;
            }
            default: {
                string = "center";
            }
        }
        Element element2 = new Element(Name.get(Constants.CONFIGURATION_NAMESPACE, string));
        element.appendChild(element2);
        if (pane.cssName != null) {
            element2.putAttribute(Constants.CSS_ATTRIBUTE, pane.cssName);
        }
        if (pane.position != 0 && pane.size != 0.25) {
            element2.putAttribute(Constants.SIZE_ATTRIBUTE, Double.toString(pane.size));
        }
    }

    public static final class Pane
    implements Cloneable,
    Comparable {
        private int position;
        private String cssName;
        private double size;
        private StyleSheetInfo styleSheetInfo;

        public Pane(int n, String string, double d) {
            this.position = n;
            this.cssName = string;
            this.size = d;
        }

        public int getPosition() {
            return this.position;
        }

        public String getCSSName() {
            return this.cssName;
        }

        public double getSize() {
            return this.size;
        }

        public void setStyleSheetInfo(StyleSheetInfo styleSheetInfo) {
            this.styleSheetInfo = styleSheetInfo;
        }

        public StyleSheetInfo getStyleSheetInfo() {
            return this.styleSheetInfo;
        }

        public Pane copy() {
            try {
                return (Pane)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Pane)) {
                return false;
            }
            return this.position == ((Pane)object).position;
        }

        public int compareTo(Object object) {
            return this.position - ((Pane)object).position;
        }
    }
}

