/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.dialog;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmleditapp.dialog.AuthenticationDialog;
import com.xmlmind.xmleditapp.dialog.Msg;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class AuthenticatorImpl
extends Authenticator {
    private HashMap entries = new HashMap();
    private Entry probe = new Entry();
    private Component dialogParent;
    private AuthenticationDialog dialog;

    public void setDialogParent(Component component) {
        this.dialogParent = component;
    }

    public Component getDialogParent() {
        return this.dialogParent;
    }

    public void loadPasswords(Preferences preferences) {
        this.entries.clear();
        String string = preferences.getString("passwords", null);
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        Entry[] entryArray = Entry.parse(string);
        if (entryArray == null) {
            return;
        }
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            entry.save = true;
            this.entries.put(entry, entry);
            ++n;
        }
    }

    public void savePasswords(Preferences preferences) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.save) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(entry);
        }
        preferences.putString("passwords", stringBuffer.toString());
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        Object object;
        this.probe.host = this.getRequestingHost();
        if (this.probe.host == null) {
            object = this.getRequestingSite();
            if (object != null) {
                this.probe.host = ((InetAddress)object).getHostAddress();
            }
        } else {
            this.probe.host = this.probe.host.toLowerCase();
        }
        this.probe.port = this.getRequestingPort();
        this.probe.prompt = this.getRequestingPrompt();
        this.probe.scheme = this.getRequestingScheme();
        if (this.probe.scheme != null) {
            this.probe.scheme = this.probe.scheme.toLowerCase();
        }
        if ((object = (Entry)this.entries.get(this.probe)) == null) {
            object = new Entry();
            ((Entry)object).host = this.probe.host;
            ((Entry)object).port = this.probe.port;
            ((Entry)object).prompt = this.probe.prompt;
            ((Entry)object).scheme = this.probe.scheme;
            ((Entry)object).userName = null;
            ((Entry)object).password = null;
            ((Entry)object).save = false;
            ((Entry)object).use = 0;
        }
        if (((Entry)object).use == 1) {
            ++((Entry)object).use;
            return new PasswordAuthentication(((Entry)object).userName, ((Entry)object).password);
        }
        boolean bl = this.dialogParent != null ? this.askUser((Entry)object) : this.promptUser((Entry)object);
        if (!bl) {
            return null;
        }
        ++((Entry)object).use;
        this.entries.put(object, object);
        return new PasswordAuthentication(((Entry)object).userName, ((Entry)object).password);
    }

    private boolean askUser(Entry entry) {
        final AuthenticationDialog.Info info = new AuthenticationDialog.Info();
        info.prompt = entry.prompt;
        info.userName = entry.userName;
        info.password = entry.password;
        info.save = entry.save;
        final AuthenticationDialog.Info[] infoArray = new AuthenticationDialog.Info[1];
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (AuthenticatorImpl.this.dialog == null) {
                            AuthenticatorImpl.this.dialog = new AuthenticationDialog(AuthenticatorImpl.this.dialogParent);
                        }
                        infoArray[0] = AuthenticatorImpl.this.dialog.getPassword(info);
                    }
                });
            }
            catch (Exception exception) {
                infoArray[0] = null;
            }
        } else {
            if (this.dialog == null) {
                this.dialog = new AuthenticationDialog(this.dialogParent);
            }
            infoArray[0] = this.dialog.getPassword(info);
        }
        if (infoArray[0] == null) {
            return false;
        }
        entry.userName = infoArray[0].userName;
        entry.password = infoArray[0].password;
        entry.save = infoArray[0].save;
        return true;
    }

    private boolean promptUser(Entry entry) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println(Msg.msg("auth.prompt1"));
        System.out.println(Msg.msg("auth.prompt2", entry.prompt));
        System.out.flush();
        String string = Msg.msg("yes");
        String string2 = Msg.msg("no");
        String string3 = Msg.msg("cancel");
        String[] stringArray = new String[]{DialogUtil.buttonLabel(Msg.msg("auth.userName")), entry.userName, DialogUtil.buttonLabel(Msg.msg("auth.password")), entry.password == null ? null : new String(entry.password), DialogUtil.buttonLabel(Msg.msg("auth.savePassword")) + " (" + string + "/" + string2 + "/" + string3 + ")", entry.save ? string : string2};
        boolean[] blArray = new boolean[]{false, false, true};
        String[] stringArray2 = new String[3];
        int n = 0;
        while (n < stringArray2.length) {
            block8: {
                String string4 = stringArray[2 * n];
                String string5 = stringArray[2 * n + 1];
                boolean bl = blArray[n];
                do {
                    System.out.print(string4);
                    if (string5 != null) {
                        System.out.print(" [" + string5 + ']');
                    }
                    System.out.print(": ");
                    System.out.flush();
                    try {
                        stringArray2[n] = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (stringArray2[n] == null) {
                        return false;
                    }
                    stringArray2[n] = stringArray2[n].trim();
                    if (stringArray2[n].length() == 0) {
                        if (string5 != null) {
                            stringArray2[n] = string5;
                            break block8;
                        }
                        return false;
                    }
                    if (!bl || string.equals(stringArray2[n]) || string2.equals(stringArray2[n])) break block8;
                } while (!string3.equals(stringArray2[n]));
                return false;
            }
            ++n;
        }
        entry.userName = stringArray2[0];
        entry.password = stringArray2[1].toCharArray();
        entry.save = string.equals(stringArray2[2]);
        return true;
    }

    private static final class Entry {
        public String host;
        public int port = -1;
        public String prompt;
        public String scheme;
        public String userName;
        public char[] password;
        public boolean save;
        public int use;

        private Entry() {
        }

        public int hashCode() {
            int n = 0;
            if (this.host != null) {
                n ^= this.host.hashCode();
            }
            if (this.port >= 0) {
                n ^= this.port;
            }
            if (this.prompt != null) {
                n ^= this.prompt.hashCode();
            }
            if (this.scheme != null) {
                n ^= this.scheme.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return Entry.eq(this.host, entry.host) && this.port == entry.port && Entry.eq(this.prompt, entry.prompt) && Entry.eq(this.scheme, entry.scheme);
        }

        private static boolean eq(Object object, Object object2) {
            return object == null && object2 == null || object != null && object.equals(object2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            this.toString(stringBuffer);
            return stringBuffer.toString();
        }

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append("host=");
            if (this.host != null) {
                stringBuffer.append(this.host);
            }
            stringBuffer.append('\n');
            stringBuffer.append("port=");
            if (this.port >= 0) {
                stringBuffer.append(this.port);
            }
            stringBuffer.append('\n');
            stringBuffer.append("prompt=");
            if (this.prompt != null) {
                stringBuffer.append(this.prompt);
            }
            stringBuffer.append('\n');
            stringBuffer.append("scheme=");
            if (this.scheme != null) {
                stringBuffer.append(this.scheme);
            }
            stringBuffer.append('\n');
            stringBuffer.append("userName=");
            stringBuffer.append(this.userName);
            stringBuffer.append('\n');
            stringBuffer.append("password=");
            try {
                byte[] byArray = new String(this.password).getBytes("UTF-8");
                int n = 0;
                while (n < byArray.length) {
                    String string = Integer.toHexString(byArray[n]);
                    int n2 = string.length();
                    while (n2 < 2) {
                        stringBuffer.append('0');
                        ++n2;
                    }
                    stringBuffer.append(string);
                    ++n;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }

        public static Entry[] parse(String string) {
            Object object;
            String[] stringArray = StringUtil.split(string, '\n');
            if (stringArray.length == 0 || stringArray.length % 6 != 0) {
                return null;
            }
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            int n = 0;
            while (n < stringArray.length) {
                block21: {
                    Entry entry = new Entry();
                    object = stringArray[n];
                    if (((String)object).startsWith("host=")) {
                        if (((String)object).length() > 5) {
                            entry.host = ((String)object).substring(5);
                        }
                        if (((String)(object = stringArray[n + 1])).startsWith("port=")) {
                            if (((String)object).length() > 5) {
                                try {
                                    entry.port = Integer.parseInt(((String)object).substring(5));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    break block21;
                                }
                            }
                            if (((String)(object = stringArray[n + 2])).startsWith("prompt=")) {
                                if (((String)object).length() > 7) {
                                    entry.prompt = ((String)object).substring(7);
                                }
                                if (((String)(object = stringArray[n + 3])).startsWith("scheme=")) {
                                    if (((String)object).length() > 7) {
                                        entry.scheme = ((String)object).substring(7);
                                    }
                                    if (((String)(object = stringArray[n + 4])).startsWith("userName=") && ((String)object).length() != 9) {
                                        String string2;
                                        int n2;
                                        entry.userName = ((String)object).substring(9);
                                        object = stringArray[n + 5];
                                        if (((String)object).startsWith("password=") && ((String)object).length() != 9 && (n2 = (string2 = ((String)object).substring(9)).length()) != 0 && n2 % 2 == 0) {
                                            byte[] byArray = new byte[n2 / 2];
                                            int n3 = 0;
                                            int n4 = 0;
                                            while (n4 < n2) {
                                                try {
                                                    int n5 = Integer.parseInt(string2.substring(n4, n4 + 2), 16);
                                                    byArray[n3++] = (byte)(n5 & 0xFF);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    // empty catch block
                                                }
                                                n4 += 2;
                                            }
                                            if (n3 == byArray.length) {
                                                try {
                                                    entry.password = new String(byArray, "UTF-8").toCharArray();
                                                }
                                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                                    break block21;
                                                }
                                                arrayList.add(entry);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                n += 6;
            }
            int n6 = arrayList.size();
            if (n6 == 0) {
                return null;
            }
            object = new Entry[n6];
            arrayList.toArray((T[])object);
            return object;
        }
    }
}

