/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.dialog;

import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesChangeEvent;
import com.xmlmind.xmleditapp.dialog.PreferencesChangeListener;
import com.xmlmind.xmleditapp.dialog.PreferencesSheet;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PreferencesEditor
extends JPanel
implements TreeSelectionListener {
    private HashMap nameToSheet;
    private boolean sheetsAdded;
    private JTree sheetTree;
    private JLabel sheetTitle;
    private JScrollPane sheetScroller;
    private Preferences preferences = null;
    private boolean selectingSheet = false;
    private PreferencesSheet selectedSheet = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener;

    public PreferencesEditor() {
        this.setLayout(new BorderLayout(5, 5));
        this.nameToSheet = new HashMap();
        this.sheetsAdded = false;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.sheetTree = new JTree(defaultMutableTreeNode);
        this.sheetTree.setEditable(false);
        this.sheetTree.setRootVisible(false);
        this.sheetTree.setShowsRootHandles(true);
        this.sheetTree.setToggleClickCount(2);
        this.sheetTree.getSelectionModel().setSelectionMode(1);
        this.sheetTree.addTreeSelectionListener(this);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        this.sheetTree.setCellRenderer(defaultTreeCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.sheetTree);
        this.add((Component)jScrollPane, "West");
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        this.sheetTitle = new JLabel();
        this.sheetTitle.setHorizontalAlignment(2);
        Font font = this.sheetTitle.getFont();
        this.sheetTitle.setFont(new Font(font.getFamily(), 1, font.getSize() + 4));
        Color color = this.getBackground();
        this.sheetTitle.setOpaque(true);
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.sheetTitle.setBackground(Color.getHSBColor(fArray[0], fArray[1], fArray[2] * 0.9f));
        this.sheetTitle.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(5, 5, 5, 5)));
        jPanel.add((Component)this.sheetTitle, "North");
        this.sheetScroller = new JScrollPane();
        jPanel.add((Component)this.sheetScroller, "Center");
        this.sheetScroller.getViewport().setBackground(jPanel.getBackground());
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.selectingSheet) {
            this.select(treeSelectionEvent.getPath());
        }
    }

    public boolean addSheet(PreferencesSheet preferencesSheet, String string) {
        String string2 = preferencesSheet.getName();
        if (this.nameToSheet.containsKey(string2)) {
            return false;
        }
        this.nameToSheet.put(string2, preferencesSheet);
        preferencesSheet.editor = this;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
        if (string != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                PreferencesSheet preferencesSheet2 = (PreferencesSheet)defaultMutableTreeNode3.getUserObject();
                if (preferencesSheet2 == null || !string.equals(preferencesSheet2.getName())) continue;
                defaultMutableTreeNode = defaultMutableTreeNode3;
                break;
            }
        }
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(preferencesSheet));
        this.sheetsAdded = true;
        return true;
    }

    public Dimension getPreferredSize() {
        if (this.sheetsAdded) {
            this.sheetsAdded = false;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.sheetTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            this.sheetTree.setPreferredSize(this.sheetTree.getPreferredSize());
        }
        return super.getPreferredSize();
    }

    public boolean containsSheet(String string) {
        return this.nameToSheet.containsKey(string);
    }

    public PreferencesSheet getSheet(String string) {
        return (PreferencesSheet)this.nameToSheet.get(string);
    }

    public PreferencesSheet[] getSheets() {
        PreferencesSheet[] preferencesSheetArray = new PreferencesSheet[this.nameToSheet.size()];
        this.nameToSheet.values().toArray(preferencesSheetArray);
        return preferencesSheetArray;
    }

    public void setSelectedSheet(PreferencesSheet preferencesSheet) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            PreferencesSheet preferencesSheet2 = (PreferencesSheet)defaultMutableTreeNode2.getUserObject();
            if (preferencesSheet2 != preferencesSheet) continue;
            treePath = new TreePath(defaultMutableTreeNode2.getPath());
            break;
        }
        if (treePath != null) {
            this.select(treePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void select(TreePath treePath) {
        PreferencesSheetPane preferencesSheetPane;
        Serializable serializable;
        PreferencesSheet preferencesSheet;
        block4: {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            preferencesSheet = (PreferencesSheet)defaultMutableTreeNode.getUserObject();
            if (preferencesSheet.pane == null) {
                serializable = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    preferencesSheetPane = preferencesSheet.getPane();
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.setCursor((Cursor)serializable);
                    throw throwable;
                }
                this.setCursor((Cursor)serializable);
                {
                    break block4;
                }
            }
            preferencesSheetPane = preferencesSheet.pane;
        }
        if (this.preferences != null && !preferencesSheet.filled) {
            preferencesSheet.filled = true;
            preferencesSheet.fillPane(this.preferences);
        }
        this.selectedSheet = preferencesSheet;
        this.selectingSheet = true;
        this.sheetTree.setSelectionPath(treePath);
        this.selectingSheet = false;
        this.sheetTree.scrollPathToVisible(treePath);
        this.sheetTitle.setText(preferencesSheet.getLabel());
        serializable = this.sheetScroller.getViewport();
        ((JViewport)serializable).setView(preferencesSheetPane);
        ((JViewport)serializable).scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    public PreferencesSheet getSelectedSheet() {
        return this.selectedSheet;
    }

    public void addPreferencesChangeListener(PreferencesChangeListener preferencesChangeListener) {
        this.listenerList.add(class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener == null ? (class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener = PreferencesEditor.class$("com.xmlmind.xmleditapp.dialog.PreferencesChangeListener")) : class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener, preferencesChangeListener);
    }

    public void removePreferencesChangeListener(PreferencesChangeListener preferencesChangeListener) {
        this.listenerList.remove(class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener == null ? (class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener = PreferencesEditor.class$("com.xmlmind.xmleditapp.dialog.PreferencesChangeListener")) : class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener, preferencesChangeListener);
    }

    public void edit(Preferences preferences) {
        Object object;
        if (this.nameToSheet.size() == 0) {
            return;
        }
        this.preferences = preferences;
        Iterator iterator = this.nameToSheet.values().iterator();
        while (iterator.hasNext()) {
            object = (PreferencesSheet)iterator.next();
            ((PreferencesSheet)object).filled = false;
        }
        if (this.selectedSheet == null) {
            object = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getFirstChild();
            this.selectedSheet = (PreferencesSheet)defaultMutableTreeNode.getUserObject();
        }
        this.setSelectedSheet(this.selectedSheet);
    }

    public boolean commit() {
        PreferencesChangeEvent preferencesChangeEvent = new PreferencesChangeEvent(this, this.preferences);
        boolean bl = true;
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            PreferencesSheet preferencesSheet = (PreferencesSheet)defaultMutableTreeNode2.getUserObject();
            if (preferencesSheet == null || !preferencesSheet.filled) continue;
            Preferences preferences = new Preferences();
            if (!preferencesSheet.validatePane(preferences)) {
                bl = false;
                break;
            }
            if (!PreferencesEditor.checkChanges(this.preferences, preferences)) continue;
            preferencesChangeEvent.addChange(preferencesSheet.getName(), preferences);
            bl2 = true;
        }
        if (bl && bl2) {
            this.firePreferencesChange(preferencesChangeEvent);
        }
        return bl;
    }

    private static final boolean checkChanges(Preferences preferences, Preferences preferences2) {
        boolean bl = false;
        String[] stringArray = preferences2.getAll();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n + 1];
            String string2 = stringArray[n];
            String string3 = preferences.getString(string2, null);
            if (!string.equals(string3)) {
                bl = true;
            } else {
                preferences2.remove(string2);
            }
            n += 2;
        }
        return bl;
    }

    private void firePreferencesChange(PreferencesChangeEvent preferencesChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener == null ? PreferencesEditor.class$("com.xmlmind.xmleditapp.dialog.PreferencesChangeListener") : class$com$xmlmind$xmleditapp$dialog$PreferencesChangeListener)) {
                ((PreferencesChangeListener)objectArray[n + 1]).preferencesChange(preferencesChangeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

