/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.dndview;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmleditapp.dndview.FileDropHandler;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class FileDropSupport
implements DropTargetListener {
    private FileDropHandler handler;
    private DropTarget dropTarget;
    private static final int JAVA_FILE_LIST = 0;
    private static final int TEXT_PLAIN = 1;
    private static final int STRING = 2;
    private DataFlavor[] fileFlavors = new DataFlavor[3];

    public FileDropSupport(FileDropHandler fileDropHandler, Component component) {
        this.handler = fileDropHandler;
        this.dropTarget = new DropTarget(component, this);
        this.dropTarget.setActive(true);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.dragging(dropTargetDragEvent);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.dragging(dropTargetDragEvent);
    }

    private boolean dragging(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl;
        int n = dropTargetDragEvent.getSourceActions();
        boolean bl2 = bl = (n & 0x40000000) != 0;
        if (FileDropSupport.findFileFlavors(dropTargetDragEvent.getCurrentDataFlavors(), this.fileFlavors, true)) {
            dropTargetDragEvent.acceptDrag(bl ? 0x40000000 : 1);
            return true;
        }
        dropTargetDragEvent.rejectDrag();
        return false;
    }

    private static final boolean findFileFlavors(DataFlavor[] dataFlavorArray, DataFlavor[] dataFlavorArray2, boolean bl) {
        int n = 0;
        while (n < dataFlavorArray2.length) {
            dataFlavorArray2[n] = null;
            ++n;
        }
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < dataFlavorArray.length) {
            DataFlavor dataFlavor = dataFlavorArray[n2];
            if (dataFlavor.isFlavorJavaFileListType()) {
                dataFlavorArray2[0] = dataFlavor;
                bl2 = true;
            } else if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                dataFlavorArray2[2] = dataFlavor;
                bl2 = true;
            } else if (dataFlavor.isFlavorTextType() && dataFlavorArray2[1] == null && dataFlavor.isMimeTypeEqual("text/plain")) {
                dataFlavorArray2[1] = dataFlavor;
                bl2 = true;
            }
            if (bl2 && bl) break;
            ++n2;
        }
        return bl2;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Object object2;
        boolean bl;
        int n = dropTargetDropEvent.getSourceActions();
        boolean bl2 = bl = (n & 0x40000000) != 0;
        if (!FileDropSupport.findFileFlavors(dropTargetDropEvent.getCurrentDataFlavors(), this.fileFlavors, false)) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        dropTargetDropEvent.acceptDrop(bl ? 0x40000000 : 1);
        URL uRL = null;
        if (uRL == null && (this.fileFlavors[2] != null || this.fileFlavors[1] != null)) {
            object2 = null;
            if (this.fileFlavors[2] != null) {
                try {
                    object2 = (String)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.stringFlavor);
                }
                catch (Exception exception) {}
            } else {
                try {
                    object2 = FileDropSupport.loadText(this.fileFlavors[1].getReaderForText(dropTargetDropEvent.getTransferable()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                try {
                    uRL = new URL((String)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL == null && ((File)(object = new File((String)object2))).isFile() && ((File)object).isAbsolute()) {
                    uRL = FileUtil.fileToURL((File)object);
                }
            }
        }
        if (uRL == null && this.fileFlavors[0] != null) {
            object2 = null;
            try {
                object = (List)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                object2 = (File)object.get(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 != null && ((File)object2).isFile()) {
                uRL = FileUtil.fileToURL((File)object2);
            }
        }
        if (uRL == null) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        boolean bl3 = this.handler.handleFileDrop(uRL, dropTargetDropEvent.getLocation());
        dropTargetDropEvent.dropComplete(bl3);
    }

    private static final String loadText(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }
}

