/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.command.RegisterAll;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.UserInput;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.ShowLog;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.util.Log;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.PropertySet;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.view.DefaultBindingSpecs;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.config.BindingInfo;
import com.xmlmind.xmleditapp.config.CommandInfo;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.Constants;
import com.xmlmind.xmleditapp.config.HelpInfo;
import com.xmlmind.xmleditapp.config.ImageToolkitInfo;
import com.xmlmind.xmleditapp.config.LoadError;
import com.xmlmind.xmleditapp.config.Loader;
import com.xmlmind.xmleditapp.config.ParameterGroupInfo;
import com.xmlmind.xmleditapp.config.PropertyInfo;
import com.xmlmind.xmleditapp.config.SpreadsheetFunctionsInfo;
import com.xmlmind.xmleditapp.dialog.PreferencesSheet;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.CloseDocumentAction;
import com.xmlmind.xmleditapp.kit.EditAction;
import com.xmlmind.xmleditapp.kit.Editor;
import com.xmlmind.xmleditapp.kit.EditorEvent;
import com.xmlmind.xmleditapp.kit.EditorListener;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.OpenDocumentAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.OpenedDocumentHook;
import com.xmlmind.xmleditapp.kit.XMLLoader;
import com.xmlmind.xmleditapp.process.FOProcessor;
import com.xmlmind.xmleditapp.process.FOProcessors;
import com.xmlmind.xmleditapp.process.ParameterGroups;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunction;
import com.xmlmind.xmleditapp.spreadsheet.FormulaFunctions;
import com.xmlmind.xmleditapp.structformat.StructuredFormat;
import com.xmlmind.xmleditapp.structformat.StructuredFormats;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public abstract class App
extends PropertySet
implements ShowStatus.StatusWindow {
    protected boolean initialized;
    protected String[] formatPluginClassNames;
    protected String[] foProcessorPluginClassNames;
    protected String[] imageToolkitPluginClassNames;
    protected URL[] configurationURLs;
    protected URL[] xmlCatalogURLs;
    protected URL[] dictionaryURLs;
    protected String[] startErrors;
    protected String[] commandLineArguments = new String[0];
    protected File installDirectory;
    protected File userPreferencesDirectory;
    protected Preferences preferences;
    protected XMLLoader xmlLoader;
    protected BindingSpec[] defaultBindingSpecs;
    protected HashMap reservedUserInput;
    protected HashMap commandToUserInput;
    protected Binding[] defaultBindings;
    protected OpenedDocumentHook[] openedDocumentHooks;
    protected EditorListener[] editorListeners;
    protected EditorEvent editorEvent;
    protected HashMap parts;
    protected AppPart[] allParts;
    protected AppPart[] editingContextSensitiveParts;
    protected PreferencesSheetInfo[] preferencesSheetInfos;
    protected Configuration[] configurations;
    protected String title;
    protected String defaultTitle;
    protected Image icon;
    protected Image defaultIcon;
    protected Timer statusTimeout;
    protected ShowStatus.StatusWindow statusWindow;
    protected static final String USER_CONFIGURATION_NAME = "customize.xxe";
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$kit$App;

    protected App(HashMap hashMap) {
        this();
        this.formatPluginClassNames = (String[])hashMap.get("formatPluginClassNames");
        if (this.formatPluginClassNames != null) {
            this.initFormatPluginClassNames(this.formatPluginClassNames);
        }
        this.foProcessorPluginClassNames = (String[])hashMap.get("foProcessorPluginClassNames");
        if (this.foProcessorPluginClassNames != null) {
            this.initFOProcessorPluginClassNames(this.foProcessorPluginClassNames);
        }
        this.imageToolkitPluginClassNames = (String[])hashMap.get("imageToolkitPluginClassNames");
        if (this.imageToolkitPluginClassNames != null) {
            this.initImageToolkitPluginClassNames(this.imageToolkitPluginClassNames);
        }
        this.configurationURLs = (URL[])hashMap.get("configurationURLs");
        if (this.configurationURLs != null) {
            this.initConfigurationURLs(this.configurationURLs);
        }
        this.xmlCatalogURLs = (URL[])hashMap.get("xmlCatalogURLs");
        if (this.xmlCatalogURLs != null) {
            this.initXMLCatalogURLs(this.xmlCatalogURLs);
        }
        this.dictionaryURLs = (URL[])hashMap.get("dictionaryURLs");
        if (this.dictionaryURLs != null) {
            this.initDictionaryURLs(this.dictionaryURLs);
        }
        this.startErrors = (String[])hashMap.get("startErrors");
        if (this.startErrors != null) {
            this.initStartErrors(this.startErrors);
        }
        this.commandLineArguments = (String[])hashMap.get("commandLineArguments");
        if (this.commandLineArguments != null) {
            this.initCommandLineArguments(this.commandLineArguments);
        }
        this.installDirectory = (File)hashMap.get("installDirectory");
        if (this.installDirectory != null) {
            this.initInstallDirectory(this.installDirectory);
        }
        this.userPreferencesDirectory = (File)hashMap.get("userPreferencesDirectory");
        if (this.userPreferencesDirectory != null) {
            this.initUserPreferencesDirectory(this.userPreferencesDirectory);
        }
    }

    protected App() {
        this.startErrors = this.commandLineArguments;
        this.imageToolkitPluginClassNames = this.commandLineArguments;
        this.foProcessorPluginClassNames = this.commandLineArguments;
        this.formatPluginClassNames = this.commandLineArguments;
        this.dictionaryURLs = new URL[0];
        this.xmlCatalogURLs = this.dictionaryURLs;
        this.configurationURLs = this.dictionaryURLs;
        this.openedDocumentHooks = new OpenedDocumentHook[0];
        this.editorListeners = new EditorListener[0];
        this.editorEvent = new EditorEvent(this, 2, null);
        this.parts = new HashMap();
        this.preferencesSheetInfos = new PreferencesSheetInfo[0];
        ShowStatus.setStatusWindow(this);
    }

    public void initFormatPluginClassNames(String[] stringArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.formatPluginClassNames = stringArray;
    }

    public String[] getFormatPluginClassNames() {
        return this.formatPluginClassNames;
    }

    public void initFOProcessorPluginClassNames(String[] stringArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.foProcessorPluginClassNames = stringArray;
    }

    public String[] getFOProcessorPluginClassNames() {
        return this.foProcessorPluginClassNames;
    }

    public void initImageToolkitPluginClassNames(String[] stringArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.imageToolkitPluginClassNames = stringArray;
    }

    public String[] getImageToolkitPluginClassNames() {
        return this.imageToolkitPluginClassNames;
    }

    public void initConfigurationURLs(URL[] uRLArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (uRLArray == null) {
            uRLArray = new URL[]{};
        }
        this.configurationURLs = uRLArray;
    }

    public URL[] getConfigurationURLs() {
        return this.configurationURLs;
    }

    public void initXMLCatalogURLs(URL[] uRLArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (uRLArray == null) {
            uRLArray = new URL[]{};
        }
        this.xmlCatalogURLs = uRLArray;
    }

    public URL[] getXMLCatalogURLs() {
        return this.xmlCatalogURLs;
    }

    public void initDictionaryURLs(URL[] uRLArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (uRLArray == null) {
            uRLArray = new URL[]{};
        }
        this.dictionaryURLs = uRLArray;
    }

    public URL[] getDictionaryURLs() {
        return this.dictionaryURLs;
    }

    public void initStartErrors(String[] stringArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.startErrors = stringArray;
    }

    public String[] getStartErrors() {
        return this.startErrors;
    }

    public void initCommandLineArguments(String[] stringArray) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.commandLineArguments = stringArray;
    }

    public String[] getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public void initInstallDirectory(File file) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.installDirectory = file;
    }

    public File getInstallDirectory() {
        return this.installDirectory;
    }

    public void initUserPreferencesDirectory(File file) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.userPreferencesDirectory = file;
    }

    public File getUserPreferencesDirectory() {
        return this.userPreferencesDirectory;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.initialized = true;
        this.doInitialize();
    }

    protected void doInitialize() {
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        final LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        this.doInitialize1(linkedHashMap, linkedHashMap2);
        Timer timer = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                App.this.doInitialize2(linkedHashMap, linkedHashMap2);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    protected void doInitialize1(HashMap hashMap, HashMap hashMap2) {
        this.doInitialize1a(hashMap, hashMap2);
        this.doInitialize1b(hashMap, hashMap2);
        this.doInitialize1c(hashMap, hashMap2);
        this.doInitialize1d(hashMap, hashMap2);
        this.doInitialize1e(hashMap, hashMap2);
    }

    protected void doInitialize1a(HashMap hashMap, HashMap hashMap2) {
        this.preferences = this.loadPreferences();
    }

    protected void doInitialize1b(HashMap hashMap, HashMap hashMap2) {
        this.xmlLoader = this.createXMLLoader();
        this.registerCommands();
    }

    protected void doInitialize1c(HashMap hashMap, HashMap hashMap2) {
        this.loadUserConfigurations(hashMap2);
    }

    protected void doInitialize1d(HashMap hashMap, HashMap hashMap2) {
        this.initHelp();
        this.createGUI(hashMap);
    }

    protected void doInitialize1e(HashMap hashMap, HashMap hashMap2) {
        this.compileParts();
        this.compileDefaultBindings(hashMap2);
    }

    protected void doInitialize2(HashMap hashMap, HashMap hashMap2) {
        this.waitCursor(true);
        this.doInitialize2a(hashMap, hashMap2);
        this.doInitialize2b(hashMap, hashMap2);
        this.doInitialize2c(hashMap, hashMap2);
        this.waitCursor(false);
    }

    protected void doInitialize2a(HashMap hashMap, HashMap hashMap2) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.registerPlugins(linkedHashMap);
        this.loadConfigurations(true, hashMap2);
        if (this.startErrors.length > 0 || hashMap.size() > 0 || linkedHashMap.size() > 0 || hashMap2.size() > 0) {
            this.showConfigErrors(this.startErrors, hashMap, linkedHashMap, hashMap2);
        }
    }

    protected void doInitialize2b(HashMap hashMap, HashMap hashMap2) {
        this.applyPreferences();
    }

    protected void doInitialize2c(HashMap hashMap, HashMap hashMap2) {
        this.activeEditorChanged();
    }

    protected Preferences loadPreferences() {
        return new Preferences();
    }

    protected XMLLoader createXMLLoader() {
        return new XMLLoader(this);
    }

    protected void registerCommands() {
        RegisterAll.registerAll();
        com.xmlmind.xmleditapp.spreadsheet.RegisterAll.registerAll();
        com.xmlmind.xmleditapp.command.RegisterAll.registerAll();
    }

    protected void initHelp() {
    }

    protected abstract void createGUI(HashMap var1);

    protected void compileParts() {
        if (this.allParts != null) {
            throw new IllegalStateException();
        }
        this.allParts = new AppPart[this.parts.size()];
        this.parts.values().toArray(this.allParts);
        ArrayList<AppPart> arrayList = new ArrayList<AppPart>();
        Iterator iterator = this.parts.values().iterator();
        while (iterator.hasNext()) {
            AppPart appPart = (AppPart)iterator.next();
            if (appPart.isEditingContextSensitive()) {
                if (appPart instanceof EditAction) {
                    String string = ((EditAction)appPart).getParameter();
                    if (string == null || string.indexOf("nto") < 0) {
                        arrayList.add(0, appPart);
                    } else {
                        arrayList.add(appPart);
                    }
                } else {
                    arrayList.add(appPart);
                }
            }
            if (!(appPart instanceof ShowStatus.StatusWindow)) continue;
            this.statusWindow = (ShowStatus.StatusWindow)((Object)appPart);
        }
        this.editingContextSensitiveParts = new AppPart[arrayList.size()];
        arrayList.toArray(this.editingContextSensitiveParts);
    }

    protected void compileDefaultBindings(HashMap hashMap) {
        Binding[] bindingArray;
        this.defaultBindings = new Binding[this.defaultBindingSpecs.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.defaultBindingSpecs.length) {
            bindingArray = this.defaultBindingSpecs[n2];
            Binding binding = bindingArray.toBinding();
            if (binding != null) {
                this.defaultBindings[n++] = binding;
            } else {
                App.addError(hashMap, USER_CONFIGURATION_NAME, Msg.msg("badBinding", bindingArray.triggerToString()));
            }
            ++n2;
        }
        if (n == 0) {
            this.defaultBindings = null;
        } else if (n != this.defaultBindings.length) {
            bindingArray = new Binding[n];
            System.arraycopy(this.defaultBindings, 0, bindingArray, 0, n);
            this.defaultBindings = bindingArray;
        }
    }

    protected static final void addError(HashMap hashMap, Object object, String string) {
        ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            hashMap.put(object, arrayList);
        }
        arrayList.add(string);
    }

    protected void loadUserConfigurations(HashMap hashMap) {
        Object object;
        int n;
        Object object2;
        Object object3;
        BindingSpec[] bindingSpecArray = this.getFactoryBindingSpecs();
        Configuration configuration = null;
        PreferredPrefix preferredPrefix = null;
        ArrayList arrayList = null;
        DocumentLoader documentLoader = null;
        int n2 = this.configurationURLs.length - 1;
        while (n2 >= 0) {
            block20: {
                object3 = this.configurationURLs[n2];
                if (USER_CONFIGURATION_NAME.equals(URLUtil.getRawBaseName((URL)object3))) {
                    this.showStatus(Msg.msg("loadingConfig", URLUtil.toLabel((URL)object3)), false);
                    if (configuration == null) {
                        configuration = new Configuration();
                        configuration.add(new BindingInfo(bindingSpecArray));
                        documentLoader = Loader.createDocumentLoader();
                        preferredPrefix = new PreferredPrefix();
                        arrayList = new ArrayList();
                    }
                    try {
                        object2 = documentLoader.load((URL)object3);
                        arrayList.clear();
                        configuration.load((Document)object2, preferredPrefix, arrayList);
                    }
                    catch (IOException iOException) {
                        App.addError(hashMap, object3, Msg.msg("cannotLoadConfig", URLUtil.toLabel((URL)object3), MiscUtil.reason(iOException)));
                        break block20;
                    }
                    int n3 = arrayList.size();
                    n = 0;
                    while (n < n3) {
                        object = (LoadError)arrayList.get(n);
                        App.addError(hashMap, object3, ((LoadError)object).getMessageWithLocation());
                        ++n;
                    }
                }
            }
            --n2;
        }
        this.defaultBindingSpecs = null;
        if (configuration != null) {
            SpreadsheetFunctionsInfo spreadsheetFunctionsInfo;
            ParameterGroupInfo parameterGroupInfo;
            BindingInfo bindingInfo;
            configuration.translate();
            object3 = (PropertyInfo)configuration.get("property");
            if (object3 != null) {
                ((PropertyInfo)object3).setSystemProperties();
            }
            if ((object2 = (CommandInfo)configuration.get("command")) != null) {
                arrayList.clear();
                ((CommandInfo)object2).registerCommands(arrayList);
                int n4 = arrayList.size();
                n = 0;
                while (n < n4) {
                    App.addError(hashMap, USER_CONFIGURATION_NAME, (String)arrayList.get(n));
                    ++n;
                }
            }
            if ((bindingInfo = (BindingInfo)configuration.get("binding")) != null) {
                this.defaultBindingSpecs = bindingInfo.getBindingSpecs();
            }
            if ((parameterGroupInfo = (ParameterGroupInfo)configuration.get("parameterGroup")) != null) {
                parameterGroupInfo.registerGroups();
            }
            if ((object = (ImageToolkitInfo)configuration.get("imageToolkit")) != null) {
                ((ImageToolkitInfo)object).registerToolkits();
            }
            if ((spreadsheetFunctionsInfo = (SpreadsheetFunctionsInfo)configuration.get("spreadsheetFunctions")) != null) {
                FormulaFunctions formulaFunctions = spreadsheetFunctionsInfo.getFormulaFunctions();
                String[] stringArray = spreadsheetFunctionsInfo.getFormulaFunctionsErrors();
                int n5 = 0;
                while (n5 < stringArray.length) {
                    App.addError(hashMap, USER_CONFIGURATION_NAME, stringArray[n5]);
                    ++n5;
                }
                if (formulaFunctions != null) {
                    FormulaFunctions formulaFunctions2 = FormulaFunctions.getRegistry();
                    Iterator iterator = formulaFunctions.iterator();
                    while (iterator.hasNext()) {
                        FormulaFunction formulaFunction = (FormulaFunction)iterator.next();
                        try {
                            formulaFunctions2.register(formulaFunction);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            App.addError(hashMap, USER_CONFIGURATION_NAME, Msg.msg("cannotRegisterSpreadsheetFunction", formulaFunction.getName(), illegalArgumentException.getMessage()));
                        }
                    }
                }
            }
        }
        if (this.defaultBindingSpecs == null) {
            this.defaultBindingSpecs = bindingSpecArray;
        }
        this.reserveUserInput();
        this.showStatus("", true);
    }

    protected BindingSpec[] getFactoryBindingSpecs() {
        BindingSpec[] bindingSpecArray = new BindingSpec[]{new BindingSpec("left-margin-click1", "selectBlockAtY", "orParent"), new BindingSpec("right-margin-click1", "selectBlockAtY", "orParent"), new BindingSpec("left-margin-popup-trigger", "editMenu", null), new BindingSpec("right-margin-popup-trigger", "editMenu", null)};
        BindingSpec[] bindingSpecArray2 = this.getExtraBindingSpecs();
        if (bindingSpecArray2 != null && bindingSpecArray2.length > 0) {
            BindingSpec[] bindingSpecArray3 = new BindingSpec[bindingSpecArray.length + bindingSpecArray2.length];
            System.arraycopy(bindingSpecArray, 0, bindingSpecArray3, 0, bindingSpecArray.length);
            System.arraycopy(bindingSpecArray2, 0, bindingSpecArray3, bindingSpecArray.length, bindingSpecArray2.length);
            bindingSpecArray = bindingSpecArray3;
        }
        if (this.preferences.getBoolean("button2PastesSystemSelection", false)) {
            BindingSpec[] bindingSpecArray4;
            int n = bindingSpecArray.length;
            if (PlatformUtil.IS_MAC_OS) {
                bindingSpecArray4 = new BindingSpec[n + 2];
                bindingSpecArray4[n + 1] = new BindingSpec(UserInput.get(16, 8, 500), "pasteSystemSelection", null);
            } else {
                bindingSpecArray4 = new BindingSpec[n + 1];
            }
            System.arraycopy(bindingSpecArray, 0, bindingSpecArray4, 0, n);
            bindingSpecArray4[n] = new BindingSpec(UserInput.get(8, 0, 500), "pasteSystemSelection", null);
            bindingSpecArray = bindingSpecArray4;
        }
        return BindingSpec.merge(DefaultBindingSpecs.ALL, bindingSpecArray);
    }

    protected BindingSpec[] getExtraBindingSpecs() {
        return null;
    }

    protected void reserveUserInput() {
        this.reservedUserInput = new HashMap();
        this.commandToUserInput = new HashMap();
        int n = 0;
        while (n < this.defaultBindingSpecs.length) {
            String string;
            BindingSpec bindingSpec = this.defaultBindingSpecs[n];
            UserInput[] userInputArray = bindingSpec.getUserInputs();
            if (userInputArray != null && userInputArray.length == 1 && userInputArray[0].getKeyCode() != 0 && (string = bindingSpec.getCommandName()) != null) {
                String string2 = bindingSpec.getCommandParameter();
                StringBuffer stringBuffer = new StringBuffer(string);
                if (string2 != null) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                }
                Binding binding = new Binding(userInputArray, null, null);
                this.reservedUserInput.put(binding, Boolean.FALSE);
                this.commandToUserInput.put(stringBuffer.toString(), binding);
            }
            ++n;
        }
    }

    protected void registerPlugins(HashMap hashMap) {
        int n = 0;
        while (n < this.formatPluginClassNames.length) {
            this.registerFormatPlugin(this.formatPluginClassNames[n], hashMap);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.foProcessorPluginClassNames.length) {
            this.registerFOProcessorPlugin(this.foProcessorPluginClassNames[n2], hashMap);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.imageToolkitPluginClassNames.length) {
            this.registerImageToolkitPlugin(this.imageToolkitPluginClassNames[n3], hashMap);
            ++n3;
        }
        this.showStatus("", true);
    }

    protected void registerFormatPlugin(String string, HashMap hashMap) {
        this.showStatus(Msg.msg("registeringFormatPlugin", string), false);
        try {
            StructuredFormat structuredFormat = (StructuredFormat)Class.forName(string).newInstance();
            StructuredFormats.register(structuredFormat);
            structuredFormat.setPreferences(this.preferences);
            PreferencesSheet preferencesSheet = structuredFormat.getPreferencesSheet();
            if (preferencesSheet != null) {
                this.checkAddOnPreferencesSheet();
                this.addPreferencesSheet(preferencesSheet, "addon");
            }
            this.addHelpSet(structuredFormat.getName().toLowerCase() + "_format_help");
        }
        catch (Throwable throwable) {
            App.addError(hashMap, string, Msg.msg("cannotCreateFormatPlugin", string, MiscUtil.reason(throwable)));
        }
    }

    protected void checkAddOnPreferencesSheet() {
        if (this.getPreferencesSheet("addon") != null) {
            return;
        }
        this.addPreferencesSheet(new PreferencesSheet("addon", Msg.msg("addonOptionsTitle")), null);
    }

    protected void registerFOProcessorPlugin(String string, HashMap hashMap) {
        this.showStatus(Msg.msg("registeringFOProcessorPlugin", string), false);
        try {
            FOProcessors.register((FOProcessor)Class.forName(string).newInstance());
        }
        catch (Throwable throwable) {
            App.addError(hashMap, string, Msg.msg("cannotCreateFOProcessorPlugin", string, MiscUtil.reason(throwable)));
        }
    }

    protected void registerImageToolkitPlugin(String string, HashMap hashMap) {
        this.showStatus(Msg.msg("registeringImageToolkitPlugin", string), false);
        try {
            ImageToolkits.register((ImageToolkit)Class.forName(string).newInstance());
        }
        catch (Throwable throwable) {
            App.addError(hashMap, string, Msg.msg("cannotCreateImageToolkitPlugin", string, MiscUtil.reason(throwable)));
        }
    }

    protected void loadConfigurations(boolean bl, HashMap hashMap) {
        String string;
        Configuration[] configurationArray = new Configuration[this.configurationURLs.length];
        HashSet<String> hashSet = new HashSet<String>();
        Loader loader = new Loader();
        int n = this.configurationURLs.length - 1;
        while (n >= 0) {
            block15: {
                URL uRL = this.configurationURLs[n];
                if (!USER_CONFIGURATION_NAME.equals(URLUtil.getRawBaseName(uRL))) {
                    Configuration configuration;
                    this.showStatus(Msg.msg("loadingConfig", URLUtil.toLabel(uRL)), false);
                    try {
                        configuration = loader.loadTranslated(uRL);
                    }
                    catch (IOException iOException) {
                        App.addError(hashMap, uRL, Msg.msg("cannotLoadConfig", URLUtil.toLabel(uRL), MiscUtil.reason(iOException)));
                        break block15;
                    }
                    LoadError[] loadErrorArray = loader.getErrors();
                    int n2 = 0;
                    while (n2 < loadErrorArray.length) {
                        App.addError(hashMap, uRL, loadErrorArray[n2].getMessageWithLocation());
                        ++n2;
                    }
                    if (configuration != null && loadErrorArray.length <= 0 && (string = configuration.getName()) != null && configuration.get("detect") != null) {
                        URL uRL2;
                        String string2;
                        int n3;
                        Constants constants;
                        int n4 = configurationArray.length - 1;
                        while (n4 > n) {
                            constants = configurationArray[n4];
                            if (constants != null && ((Configuration)constants).getName().equals(string)) {
                                configurationArray[n4] = null;
                                break;
                            }
                            --n4;
                        }
                        configurationArray[n] = configuration;
                        if (hashSet != null && (constants = (HelpInfo)configuration.get("help")) != null && (n3 = (string2 = URLUtil.getRawBaseName(uRL2 = ((HelpInfo)constants).getLocation().getURL())).length()) > 4 && string2.endsWith(".jar")) {
                            string2 = string2.substring(0, n3 - 4);
                            hashSet.add(string2);
                        }
                    }
                }
            }
            --n;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < configurationArray.length) {
            if (configurationArray[n6] != null) {
                ++n5;
            }
            ++n6;
        }
        this.configurations = new Configuration[n5];
        n5 = 0;
        int n7 = 0;
        while (n7 < configurationArray.length) {
            if (configurationArray[n7] != null) {
                this.configurations[n5++] = configurationArray[n7];
            }
            ++n7;
        }
        if (bl) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.addHelpSet(string);
            }
        }
        this.showStatus("", true);
    }

    protected void showConfigErrors(String[] stringArray, HashMap hashMap, HashMap hashMap2, HashMap hashMap3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>\n");
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("<h1>" + XMLUtil.escapeXML(Msg.msg("startErrors")) + "</h1>\n");
            stringBuffer.append("<ul>\n");
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                stringBuffer.append("<li>");
                stringBuffer.append(XMLUtil.escapeXML(string));
                stringBuffer.append("</li>\n");
                ++n;
            }
            stringBuffer.append("</ul>\n");
        }
        if (hashMap != null && hashMap.size() > 0) {
            stringBuffer.append("<h1>" + XMLUtil.escapeXML(Msg.msg("guiErrors")) + "</h1>\n");
            App.appendConfigErrors(stringBuffer, hashMap);
        }
        if (hashMap2 != null && hashMap2.size() > 0) {
            stringBuffer.append("<h1>" + XMLUtil.escapeXML(Msg.msg("pluginErrors")) + "</h1>\n");
            App.appendConfigErrors(stringBuffer, hashMap2);
        }
        if (hashMap3 != null && hashMap3.size() > 0) {
            stringBuffer.append("<h1>" + XMLUtil.escapeXML(Msg.msg("configErrors")) + "</h1>\n");
            App.appendConfigErrors(stringBuffer, hashMap3);
        }
        stringBuffer.append("</body></html>\n");
        Alert.showWarningHTML(this.getDialogParent(), Msg.msg("configurationHasErrors"), stringBuffer.toString(), 600, 400);
    }

    protected static final void appendConfigErrors(StringBuffer stringBuffer, HashMap hashMap) {
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            ArrayList arrayList = (ArrayList)entry.getValue();
            stringBuffer.append("<p><b>" + XMLUtil.escapeXML(k.toString()) + "</b></p>\n");
            stringBuffer.append("<ul>\n");
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)arrayList.get(n2);
                stringBuffer.append("<li>");
                stringBuffer.append(XMLUtil.escapeXML(string));
                stringBuffer.append("</li>\n");
                ++n2;
            }
            stringBuffer.append("</ul>\n");
        }
    }

    protected void applyPreferences() {
        this.xmlLoader.applySchemaPreferences();
        this.xmlLoader.applyOpenPreferences();
        int n = 0;
        while (n < this.allParts.length) {
            this.allParts[n].applyPreferences();
            ++n;
        }
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public XMLLoader getXMLLoader() {
        return this.xmlLoader;
    }

    public Configuration[] getConfigurations() {
        return this.configurations;
    }

    public void reloadAllConfigurations() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ParameterGroups.unregisterAll();
        ImageToolkits.unregisterAllExternal();
        FormulaFunctions.getRegistry().unregisterAllNonPredefined();
        this.loadUserConfigurations(linkedHashMap);
        this.compileDefaultBindings(linkedHashMap);
        this.loadConfigurations(false, linkedHashMap);
        if (linkedHashMap.size() > 0) {
            this.showConfigErrors(null, null, null, linkedHashMap);
        }
    }

    public Binding[] getDefaultBindings() {
        return this.defaultBindings;
    }

    public boolean isReservedKeyStroke(KeyStroke keyStroke) {
        int n = keyStroke.getKeyCode();
        if (n != 0) {
            Binding binding = new Binding(UserInput.get(n, keyStroke.getModifiers()), null, null);
            return this.reservedUserInput.containsKey(binding);
        }
        return false;
    }

    public boolean isMenuAccelerator(UserInput[] userInputArray) {
        Binding binding = new Binding(userInputArray, null, null);
        Boolean bl = (Boolean)this.reservedUserInput.get(binding);
        return bl != null && bl != false;
    }

    public KeyStroke getAccelerator(AppAction appAction, KeyStroke keyStroke) {
        Object object;
        KeyStroke keyStroke2 = null;
        if (appAction instanceof EditAction) {
            object = (EditAction)appAction;
            Binding binding = App.getExpectedBinding((EditAction)object, this.commandToUserInput);
            KeyStroke keyStroke3 = null;
            if (binding != null) {
                keyStroke3 = App.bindingToKeyStroke(binding);
            }
            if (keyStroke3 != null) {
                keyStroke2 = keyStroke3;
                this.reservedUserInput.put(binding, Boolean.TRUE);
                keyStroke = null;
            }
        }
        if (keyStroke != null && (object = App.keyStrokeToBinding(keyStroke)) != null && !this.reservedUserInput.containsKey(object)) {
            keyStroke2 = keyStroke;
            this.reservedUserInput.put(object, Boolean.TRUE);
        }
        return keyStroke2;
    }

    protected static final Binding getExpectedBinding(EditAction editAction, HashMap hashMap) {
        StringBuffer stringBuffer = new StringBuffer(editAction.getCommandName());
        String string = editAction.getParameter();
        if (string != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return (Binding)hashMap.get(stringBuffer.toString());
    }

    protected static final KeyStroke bindingToKeyStroke(Binding binding) {
        int n;
        UserInput[] userInputArray = binding.getUserInputs();
        if (userInputArray == null || userInputArray.length != 1 || (n = userInputArray[0].getKeyCode()) == 0) {
            return null;
        }
        return KeyStroke.getKeyStroke(n, userInputArray[0].getModifiers());
    }

    protected static final Binding keyStrokeToBinding(KeyStroke keyStroke) {
        int n = keyStroke.getKeyCode();
        if (n == 0) {
            return null;
        }
        return new Binding(UserInput.get(n, keyStroke.getModifiers()), null, null);
    }

    public void addOpenedDocumentHook(OpenedDocumentHook openedDocumentHook) {
        if (this.indexOfHook(openedDocumentHook) >= 0) {
            return;
        }
        int n = this.openedDocumentHooks.length;
        OpenedDocumentHook[] openedDocumentHookArray = new OpenedDocumentHook[n + 1];
        if (n > 0) {
            System.arraycopy(this.openedDocumentHooks, 0, openedDocumentHookArray, 0, n);
        }
        openedDocumentHookArray[n] = openedDocumentHook;
        this.openedDocumentHooks = openedDocumentHookArray;
    }

    protected int indexOfHook(OpenedDocumentHook openedDocumentHook) {
        int n = this.openedDocumentHooks.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.openedDocumentHooks[n2] == openedDocumentHook) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removeOpenedDocumentHook(OpenedDocumentHook openedDocumentHook) {
        int n;
        int n2;
        int n3 = this.indexOfHook(openedDocumentHook);
        if (n3 < 0) {
            return;
        }
        int n4 = this.openedDocumentHooks.length;
        OpenedDocumentHook[] openedDocumentHookArray = new OpenedDocumentHook[n4 - 1];
        if (n3 > 0) {
            System.arraycopy(this.openedDocumentHooks, 0, openedDocumentHookArray, 0, n3);
        }
        if ((n2 = n4 - (n = n3 + 1)) > 0) {
            System.arraycopy(this.openedDocumentHooks, n, openedDocumentHookArray, n3, n2);
        }
        this.openedDocumentHooks = openedDocumentHookArray;
    }

    public OpenedDocumentHook[] getOpenedDocumentHooks() {
        return this.openedDocumentHooks;
    }

    public Editor createEditor() {
        return new Editor(this);
    }

    public void addEditorListener(EditorListener editorListener) {
        if (this.indexOfListener(editorListener) >= 0) {
            return;
        }
        int n = this.editorListeners.length;
        EditorListener[] editorListenerArray = new EditorListener[n + 1];
        if (n > 0) {
            System.arraycopy(this.editorListeners, 0, editorListenerArray, 0, n);
        }
        editorListenerArray[n] = editorListener;
        this.editorListeners = editorListenerArray;
    }

    protected int indexOfListener(EditorListener editorListener) {
        int n = this.editorListeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.editorListeners[n2] == editorListener) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removeEditorListener(EditorListener editorListener) {
        int n;
        int n2;
        int n3 = this.indexOfListener(editorListener);
        if (n3 < 0) {
            return;
        }
        int n4 = this.editorListeners.length;
        EditorListener[] editorListenerArray = new EditorListener[n4 - 1];
        if (n3 > 0) {
            System.arraycopy(this.editorListeners, 0, editorListenerArray, 0, n3);
        }
        if ((n2 = n4 - (n = n3 + 1)) > 0) {
            System.arraycopy(this.editorListeners, n, editorListenerArray, n3, n2);
        }
        this.editorListeners = editorListenerArray;
    }

    public EditorListener[] getEditorListeners() {
        return this.editorListeners;
    }

    protected void addingEditor(Editor editor) {
        this.editorEvent.initialize(this, 0, editor);
        EditorListener[] editorListenerArray = this.editorListeners;
        int n = 0;
        while (n < editorListenerArray.length) {
            editorListenerArray[n].addingEditor(this.editorEvent);
            ++n;
        }
    }

    protected void editorAdded(Editor editor) {
        this.editorEvent.initialize(this, 1, editor);
        EditorListener[] editorListenerArray = this.editorListeners;
        int n = 0;
        while (n < editorListenerArray.length) {
            editorListenerArray[n].editorAdded(this.editorEvent);
            ++n;
        }
    }

    protected void editorActivated(Editor editor) {
        this.editorEvent.initialize(this, 2, editor);
        EditorListener[] editorListenerArray = this.editorListeners;
        int n = 0;
        while (n < editorListenerArray.length) {
            editorListenerArray[n].editorActivated(this.editorEvent);
            ++n;
        }
    }

    protected void editorDeactivated(Editor editor) {
        this.editorEvent.initialize(this, 3, editor);
        EditorListener[] editorListenerArray = this.editorListeners;
        int n = 0;
        while (n < editorListenerArray.length) {
            editorListenerArray[n].editorDeactivated(this.editorEvent);
            ++n;
        }
    }

    protected void removingEditor(Editor editor) {
        this.editorEvent.initialize(this, 4, editor);
        EditorListener[] editorListenerArray = this.editorListeners;
        int n = 0;
        while (n < editorListenerArray.length) {
            editorListenerArray[n].removingEditor(this.editorEvent);
            ++n;
        }
    }

    protected void editorRemoved(Editor editor) {
        this.editorEvent.initialize(this, 5, editor);
        EditorListener[] editorListenerArray = this.editorListeners;
        int n = 0;
        while (n < editorListenerArray.length) {
            editorListenerArray[n].editorRemoved(this.editorEvent);
            ++n;
        }
    }

    public void addPreferencesSheet(PreferencesSheet preferencesSheet, String string) {
        int n = this.preferencesSheetInfos.length;
        PreferencesSheetInfo[] preferencesSheetInfoArray = new PreferencesSheetInfo[n + 1];
        System.arraycopy(this.preferencesSheetInfos, 0, preferencesSheetInfoArray, 0, n);
        preferencesSheetInfoArray[n] = new PreferencesSheetInfo(preferencesSheet, string);
        this.preferencesSheetInfos = preferencesSheetInfoArray;
        if (preferencesSheet instanceof AppPreferencesSheet) {
            ((AppPreferencesSheet)preferencesSheet).initApp(this);
        }
    }

    public PreferencesSheetInfo[] getPreferencesSheetInfo() {
        return this.preferencesSheetInfos;
    }

    public PreferencesSheet getPreferencesSheet(String string) {
        int n = 0;
        while (n < this.preferencesSheetInfos.length) {
            PreferencesSheet preferencesSheet = this.preferencesSheetInfos[n].preferencesSheet;
            if (preferencesSheet.getName().equals(string)) {
                return preferencesSheet;
            }
            ++n;
        }
        return null;
    }

    public void addPart(AppPart appPart, String string) {
        if (this.allParts != null) {
            throw new IllegalStateException();
        }
        this.parts.put(string, appPart);
        appPart.initApp(this, string);
    }

    public AppPart[] getParts() {
        return this.allParts;
    }

    public AppPart getPart(String string) {
        return (AppPart)this.parts.get(string);
    }

    public OpenDocumentAction getOpenDocumentAction() {
        AppPart appPart = this.getPart("openAction");
        if (appPart == null || !(appPart instanceof OpenDocumentAction)) {
            return null;
        }
        return (OpenDocumentAction)((Object)appPart);
    }

    public CloseDocumentAction getCloseDocumentAction() {
        AppPart appPart = this.getPart("closeAction");
        if (appPart == null || !(appPart instanceof CloseDocumentAction)) {
            return null;
        }
        return (CloseDocumentAction)((Object)appPart);
    }

    public AppPart ensurePartIsVisible(String string) {
        AppPart appPart = (AppPart)this.parts.get(string);
        if (appPart != null) {
            this.ensurePartIsVisible(appPart);
        }
        return appPart;
    }

    public void ensurePartIsVisible(AppPart appPart) {
    }

    public OpenedDocument createOpenedDocument() {
        return new OpenedDocument(this);
    }

    public abstract void addOpenedDocument(OpenedDocument var1);

    public abstract void removeOpenedDocument(OpenedDocument var1);

    public void removeAllOpenedDocuments() {
        OpenedDocument[] openedDocumentArray = this.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            this.removeOpenedDocument(openedDocumentArray[n]);
            ++n;
        }
    }

    public int getOpenedDocumentCount() {
        return this.getOpenedDocuments().length;
    }

    public abstract OpenedDocument[] getOpenedDocuments();

    public OpenedDocument getOpenedDocument(URL uRL) {
        OpenedDocument[] openedDocumentArray = this.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            if (openedDocumentArray[n].getLocation().equals(uRL)) {
                return openedDocumentArray[n];
            }
            ++n;
        }
        return null;
    }

    public OpenedDocument getOpenedDocument(Document document) {
        OpenedDocument[] openedDocumentArray = this.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            if (openedDocumentArray[n].getDocument() == document) {
                return openedDocumentArray[n];
            }
            ++n;
        }
        return null;
    }

    public void setActiveOpenedDocument(OpenedDocument openedDocument) {
        Editor editor = this.getActiveEditor();
        if (editor != null && editor.getOpenedDocument() == openedDocument) {
            return;
        }
        Editor[] editorArray = this.getEditors(openedDocument);
        if (editorArray.length > 0) {
            this.setActiveEditor(editorArray[0]);
        }
    }

    public OpenedDocument getActiveOpenedDocument() {
        Editor editor = this.getActiveEditor();
        return editor == null ? null : editor.getOpenedDocument();
    }

    public Document getActiveDocument() {
        Editor editor = this.getActiveEditor();
        return editor == null ? null : editor.getDocument();
    }

    public abstract void addEditor(Editor var1, Object var2);

    public abstract void removeEditor(Editor var1);

    public int getEditorCount() {
        return this.getEditors().length;
    }

    public abstract Editor[] getEditors();

    public int getEditorCount(OpenedDocument openedDocument) {
        return this.getEditors(openedDocument).length;
    }

    public Editor[] getEditors(OpenedDocument openedDocument) {
        Editor[] editorArray;
        Editor[] editorArray2 = this.getEditors();
        Editor[] editorArray3 = new Editor[editorArray2.length];
        int n = 0;
        int n2 = 0;
        while (n2 < editorArray2.length) {
            editorArray = editorArray2[n2];
            if (editorArray.getOpenedDocument() == openedDocument) {
                editorArray3[n++] = editorArray;
            }
            ++n2;
        }
        if (n != editorArray3.length) {
            editorArray = new Editor[n];
            System.arraycopy(editorArray3, 0, editorArray, 0, n);
            editorArray3 = editorArray;
        }
        return editorArray3;
    }

    public abstract void setActiveEditor(Editor var1);

    public abstract Editor getActiveEditor();

    public DocumentView getActiveDocumentView() {
        Editor editor = this.getActiveEditor();
        return editor == null ? null : editor.getDocumentView();
    }

    protected void activeEditorChanged() {
        int n = 0;
        while (n < this.allParts.length) {
            this.allParts[n].activeEditorChanged();
            ++n;
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.getDefaultTitle();
    }

    protected String getDefaultTitle() {
        if (this.defaultTitle == null) {
            StringBuffer stringBuffer = new StringBuffer("XMLmind XML Editor ");
            stringBuffer.append("Professional");
            stringBuffer.append(" Edition ");
            stringBuffer.append("V3.0p1");
            this.defaultTitle = stringBuffer.toString();
        }
        return this.defaultTitle;
    }

    public void setIcon(Image image) {
        this.icon = image;
    }

    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        return this.getDefaultIcon();
    }

    protected Image getDefaultIcon() {
        if (this.defaultIcon == null) {
            this.defaultIcon = ImageResource.get(class$com$xmlmind$xmleditapp$kit$App == null ? (class$com$xmlmind$xmleditapp$kit$App = App.class$("com.xmlmind.xmleditapp.kit.App")) : class$com$xmlmind$xmleditapp$kit$App, "appIcon.gif");
        }
        return this.defaultIcon;
    }

    public abstract Component getDialogParent();

    public abstract void waitCursor(boolean var1);

    public void addHelpSet(String string) {
    }

    public void setHelpId(Component component, String string) {
    }

    public void showStatus(String string) {
        this.showStatus(string, true);
    }

    public void showStatus(String string, boolean bl) {
        if (this.statusTimeout != null) {
            this.statusTimeout.stop();
            this.statusTimeout = null;
        }
        this.doShowStatus(string);
        if (string != null && string.length() > 0) {
            Log.log(ShowLog.LOG_STATUS, string);
            if (bl) {
                this.statusTimeout = new Timer(10000, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        App.this.doShowStatus(null);
                    }
                });
                this.statusTimeout.setRepeats(false);
                this.statusTimeout.start();
            }
        }
    }

    protected void doShowStatus(String string) {
        if (this.statusWindow != null) {
            this.statusWindow.showStatus(string == null ? "" : string);
        }
    }

    public void namespacePrefixesChanged(OpenedDocument openedDocument) {
        if (openedDocument != this.getActiveOpenedDocument()) {
            return;
        }
        int n = 0;
        while (n < this.allParts.length) {
            this.allParts[n].namespacePrefixesChanged();
            ++n;
        }
        Editor[] editorArray = this.getEditors();
        int n2 = 0;
        while (n2 < editorArray.length) {
            Editor editor = editorArray[n2];
            if (editor.getOpenedDocument() == openedDocument) {
                DocumentView documentView = editor.getDocumentView();
                if (editor.getStyleSheetInfo() == null) {
                    documentView.refresh();
                } else {
                    documentView.rebuildView(documentView.getDocument().getRootElement());
                }
            }
            ++n2;
        }
    }

    public void saveStateChanged(OpenedDocument openedDocument) {
        if (openedDocument != this.getActiveOpenedDocument()) {
            return;
        }
        int n = 0;
        while (n < this.allParts.length) {
            this.allParts[n].saveStateChanged();
            ++n;
        }
    }

    public void validityStateChanged(OpenedDocument openedDocument) {
        if (openedDocument != this.getActiveOpenedDocument()) {
            return;
        }
        int n = 0;
        while (n < this.allParts.length) {
            this.allParts[n].validityStateChanged();
            ++n;
        }
    }

    public void undoStateChanged(OpenedDocument openedDocument) {
        if (openedDocument != this.getActiveOpenedDocument()) {
            return;
        }
        int n = 0;
        while (n < this.allParts.length) {
            this.allParts[n].undoStateChanged();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editingContextChanged(OpenedDocument openedDocument) {
        if (openedDocument != this.getActiveOpenedDocument()) {
            return;
        }
        Clipboard.beginGet();
        try {
            int n = 0;
            while (n < this.editingContextSensitiveParts.length) {
                this.editingContextSensitiveParts[n].editingContextChanged();
                ++n;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Clipboard.endGet();
            throw throwable;
        }
        Clipboard.endGet();
    }

    public void dispose() {
        this.removeAllOpenedDocuments();
        this.savePreferences();
    }

    public void savePreferences() {
        this.flushPreferences();
        this.preferences.save();
    }

    public void flushPreferences() {
        int n = 0;
        while (n < this.allParts.length) {
            this.allParts[n].flushPreferences();
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class PreferencesSheetInfo {
        private PreferencesSheet preferencesSheet;
        private String parentName;

        public PreferencesSheetInfo(PreferencesSheet preferencesSheet, String string) {
            this.preferencesSheet = preferencesSheet;
            this.parentName = string;
        }

        public PreferencesSheet getPreferencesSheet() {
            return this.preferencesSheet;
        }

        public String getParentName() {
            return this.parentName;
        }
    }
}

