/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmleditapp.kit.AppAction;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public abstract class CancelableAction
extends AppAction
implements Runnable {
    private Thread worker;
    private ProgressMonitor progressMonitor;

    public void doIt() {
        this.worker = null;
        this.progressMonitor = null;
        if (!this.init()) {
            return;
        }
        this.worker = new Thread(this);
        this.worker.start();
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                this.exec();
            }
            catch (Exception exception) {
                System.err.println("internal error in " + this.getClass().getName());
                System.err.println("---------------------------------------");
                exception.printStackTrace();
                System.err.println("---------------------------------------");
            }
            SwingUtilities.invokeLater(this);
        } else {
            this.worker = null;
            if (this.progressMonitor != null) {
                this.progressMonitor.close();
                this.progressMonitor = null;
            }
            this.finish();
        }
    }

    protected abstract boolean init();

    protected abstract void exec();

    protected abstract void finish();

    protected void progress(final String string, final String string2, final int n, final int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doProgress(string, string2, n, n2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CancelableAction.this.doProgress(string, string2, n, n2);
                }
            });
        }
    }

    protected void doProgress(String string, String string2, int n, int n2) {
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressMonitor(this.app.getDialogParent(), string, string2, n, n2);
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.progressMonitor.setMillisToPopup(0);
        } else {
            this.progressMonitor.setProgress(n);
            this.progressMonitor.setNote(string2);
        }
    }

    protected boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled();
        }
        return false;
    }
}

