/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;

public class ContextualAction
extends AppAction {
    private String[] configurationNames;
    private AppAction[] configurationSpecificActions;
    private AppAction defaultAction;
    private boolean editingContextSensitive;
    private AppAction currentAction;

    public ContextualAction(String[] stringArray, AppAction[] appActionArray, AppAction appAction, boolean bl) {
        this.configurationNames = stringArray;
        this.configurationSpecificActions = appActionArray;
        this.defaultAction = appAction;
        this.currentAction = appAction;
    }

    public String[] getConfigurationNames() {
        return this.configurationNames;
    }

    public AppAction[] getConfigurationSpecificActions() {
        return this.configurationSpecificActions;
    }

    public AppAction getDefaultAction() {
        return this.defaultAction;
    }

    public void doIt() {
        this.currentAction.doIt();
    }

    public void updateEnabled() {
        this.currentAction.updateEnabled();
        this.setEnabled(this.currentAction.isEnabled());
    }

    public void initApp(App app, String string) {
        super.initApp(app, string);
        int n = 0;
        int n2 = 0;
        while (n2 < this.configurationSpecificActions.length) {
            AppAction appAction = this.configurationSpecificActions[n2];
            appAction.initApp(app, ContextualAction.makeId(string, n++));
            appAction.setLabel(this.getLabel());
            appAction.setIcon(this.getIcon());
            ++n2;
        }
        this.defaultAction.initApp(app, ContextualAction.makeId(string, n++));
        this.defaultAction.setLabel(this.getLabel());
        this.defaultAction.setIcon(this.getIcon());
    }

    private static final String makeId(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('.');
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }

    public void namespacePrefixesChanged() {
        this.currentAction.namespacePrefixesChanged();
    }

    public void saveStateChanged() {
        this.currentAction.saveStateChanged();
    }

    public void validityStateChanged() {
        this.currentAction.validityStateChanged();
    }

    public void undoStateChanged() {
        this.currentAction.undoStateChanged();
    }

    public boolean isEditingContextSensitive() {
        return this.editingContextSensitive;
    }

    public void activeEditorChanged() {
        Configuration configuration;
        this.currentAction = null;
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument != null && (configuration = openedDocument.getConfiguration()) != null) {
            String string = configuration.getName();
            int n = 0;
            while (n < this.configurationNames.length) {
                if (string.equals(this.configurationNames[n])) {
                    this.currentAction = this.configurationSpecificActions[n];
                    break;
                }
                ++n;
            }
        }
        if (this.currentAction == null) {
            this.currentAction = this.defaultAction;
        }
        super.activeEditorChanged();
    }
}

