/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.SavedDocumentBase;
import com.xmlmind.xmleditapp.structformat.StructuredFormat;
import com.xmlmind.xmleditapp.upload.DAVClient;
import com.xmlmind.xmleditapp.upload.DAVLock;
import com.xmlmind.xmleditapp.upload.DAVProperties;
import com.xmlmind.xmleditapp.upload.DAVUpload;
import com.xmlmind.xmleditapp.upload.UploadDialog;
import java.net.URL;
import javax.swing.JOptionPane;

public class DAVSavedDocument
extends SavedDocumentBase {
    private String lockOwner = null;
    private int lockScope = -1;
    private String lockToken = null;
    private DAVClient uploadClient = null;
    private static final int FAIL = 0;
    private static final int NOT_FOUND = 1;
    private static final int OK = 2;

    public DAVSavedDocument(App app, Document document, StructuredFormat structuredFormat, Configuration configuration) {
        super(app, document, structuredFormat, configuration);
    }

    public void dispose() {
        if (this.lockToken != null) {
            DAVClient dAVClient = this.getDAVClient(this.url, false);
            if (dAVClient == null) {
                return;
            }
            try {
                dAVClient.unlock(this.url.getPath(), this.lockToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lockToken = null;
        }
    }

    private DAVClient getDAVClient(URL uRL, boolean bl) {
        DAVClient dAVClient = null;
        String string = null;
        try {
            dAVClient = new DAVClient(uRL.getProtocol(), uRL.getHost(), uRL.getPort());
            if (!dAVClient.isDAVEnabled(uRL.getPath())) {
                dAVClient = null;
            }
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (dAVClient == null) {
            if (bl) {
                if (string != null) {
                    Alert.showError(this.app.getDialogParent(), Msg.msg("cannotConnectToServer", URLUtil.getRoot(uRL, true).toExternalForm(), string));
                } else {
                    Alert.showError(this.app.getDialogParent(), Msg.msg("notDAVEnabled", URLUtil.toDisplayForm(uRL)));
                }
            }
        } else {
            if (this.lockOwner == null) {
                this.lockOwner = DAVClient.getDefaultLockOwner();
            }
            dAVClient.setLockOwner(this.lockOwner);
        }
        return dAVClient;
    }

    public boolean initialize() {
        super.initialize();
        DAVClient dAVClient = this.getDAVClient(this.url, true);
        if (dAVClient == null) {
            return false;
        }
        if (this.initLock(dAVClient, this.url) == 0) {
            return false;
        }
        try {
            dAVClient.unlock(this.url.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lockScope == -1 || this.lock(dAVClient, this.url);
    }

    private int initLock(DAVClient dAVClient, URL uRL) {
        int n = 0;
        String string = null;
        try {
            n = this.doInitLock(dAVClient, uRL);
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (string != null) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotCheckLock", URLUtil.toDisplayForm(uRL), string));
            return 0;
        }
        return n;
    }

    private int doInitLock(DAVClient dAVClient, URL uRL) throws Exception {
        int n;
        CharSequence charSequence;
        DAVProperties dAVProperties;
        this.lockScope = -1;
        this.lockToken = null;
        String string = this.app.getPreferences().getString("davLockScope", "exclusive");
        if ("exclusive".equals(string)) {
            this.lockScope = 32;
        } else if ("shared".equals(string)) {
            this.lockScope = 16;
        }
        if (this.lockScope == 32 || this.lockScope == 16) {
            dAVProperties = null;
            boolean bl = false;
            charSequence = uRL.getPath();
            while (charSequence != null) {
                dAVProperties = dAVClient.getProperties((String)charSequence, 128);
                if (dAVProperties != null) break;
                charSequence = DAVClient.parentPath((String)charSequence);
            }
            if (dAVProperties != null && dAVProperties.supportedlock != null) {
                byte[] byArray = dAVProperties.supportedlock;
                n = 0;
                while (n < byArray.length) {
                    if ((byArray[n] & this.lockScope) != 0) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                Alert.showInfo(this.app.getDialogParent(), Msg.msg("lockNotSupported", string, URLUtil.toDisplayForm(uRL)));
                return 0;
            }
        }
        if ((dAVProperties = dAVClient.getProperties(uRL.getPath(), 256)) == null) {
            return 1;
        }
        DAVLock[] dAVLockArray = dAVProperties.lockdiscovery;
        if (dAVLockArray == null || dAVLockArray.length == 0) {
            return 2;
        }
        charSequence = new StringBuffer();
        boolean bl = false;
        n = 0;
        while (n < dAVLockArray.length) {
            String string2 = dAVLockArray[n].owner;
            if (string2 == null || (string2 = string2.trim()).length() == 0) {
                String string3 = string2 = "???".equals(this.lockOwner) ? "\"???\"" : "???";
            }
            if (!this.lockOwner.equals(string2)) {
                if (((StringBuffer)charSequence).length() > 0) {
                    ((StringBuffer)charSequence).append('\n');
                }
                ((StringBuffer)charSequence).append(string2);
                if ((dAVLockArray[n].lockscope & 0x20) != 0) {
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            Alert.showInfo(this.app.getDialogParent(), Msg.msg("exclusivelyLockedDocument", URLUtil.toDisplayForm(uRL), ((StringBuffer)charSequence).toString()));
            return 0;
        }
        if (((StringBuffer)charSequence).length() > 0) {
            if (this.lockScope != 16) {
                Alert.showInfo(this.app.getDialogParent(), Msg.msg("cannotShareLock", URLUtil.toDisplayForm(uRL), ((StringBuffer)charSequence).toString(), string));
                return 0;
            }
            int n2 = JOptionPane.showConfirmDialog(this.app.getDialogParent(), Msg.msg("sharedLockedDocument", URLUtil.toDisplayForm(uRL), ((StringBuffer)charSequence).toString()), Msg.msg("confirm"), 0);
            return n2 == 0 ? 2 : 0;
        }
        return 2;
    }

    private boolean lock(DAVClient dAVClient, URL uRL) {
        this.lockToken = null;
        String string = null;
        try {
            DAVLock dAVLock = dAVClient.lock(uRL.getPath(), 1, this.lockScope, 0, -1);
            this.lockToken = dAVLock.locktoken;
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (string != null) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotLock", URLUtil.toDisplayForm(uRL), string));
            return false;
        }
        return true;
    }

    public boolean update() {
        DAVClient dAVClient = this.getDAVClient(this.url, true);
        if (dAVClient == null) {
            return false;
        }
        if (this.lockToken != null) {
            try {
                dAVClient.unlock(this.url.getPath(), this.lockToken);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lockToken = null;
        }
        this.uploadClient = dAVClient;
        boolean bl = super.update();
        this.uploadClient = null;
        if (!bl) {
            return false;
        }
        if (this.lockScope != -1) {
            this.lock(dAVClient, this.url);
        }
        return true;
    }

    public boolean initialize(URL uRL) {
        DAVClient dAVClient = this.getDAVClient(uRL, true);
        if (dAVClient == null) {
            return false;
        }
        if (this.initLock(dAVClient, uRL) == 0) {
            return false;
        }
        try {
            dAVClient.unlock(uRL.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.uploadClient = dAVClient;
        boolean bl = super.initialize(uRL);
        this.uploadClient = null;
        if (!bl) {
            return false;
        }
        return this.lockScope == -1 || this.lock(dAVClient, uRL);
    }

    protected boolean copy(URL[] uRLArray) {
        String string;
        DAVUpload dAVUpload = new DAVUpload();
        dAVUpload.setDAVClient(this.uploadClient);
        if (uRLArray.length == 2) {
            dAVUpload.setInvoker(this);
            string = dAVUpload.upload(uRLArray, true);
        } else {
            UploadDialog uploadDialog = this.newUploadDialog();
            string = uploadDialog.upload(dAVUpload, uRLArray, true);
        }
        if (string != null) {
            Alert.showError(this.app.getDialogParent(), string);
            return false;
        }
        return true;
    }
}

