/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.edit.DetectedDocumentType;
import com.xmlmind.xmledit.edit.DocumentTypeDetector;
import com.xmlmind.xmledit.rng.doctype.DocumentTypeImpl;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTD;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.DetectInfo;
import com.xmlmind.xmleditapp.config.DtdInfo;
import com.xmlmind.xmleditapp.config.Info;
import com.xmlmind.xmleditapp.config.PreserveSpaceInfo;
import com.xmlmind.xmleditapp.config.RelaxngInfo;
import com.xmlmind.xmleditapp.config.SchemaInfo;
import java.net.URL;

public class DocumentTypeDetectorImpl
implements DocumentTypeDetector {
    protected Configuration[] configurations;
    protected boolean detect;
    protected Configuration detectedConfig;

    public DocumentTypeDetectorImpl() {
        this(null);
    }

    public DocumentTypeDetectorImpl(Configuration[] configurationArray) {
        this.setConfigurations(configurationArray);
        this.resetDetectedConfiguration();
    }

    public void setConfigurations(Configuration[] configurationArray) {
        this.configurations = configurationArray;
    }

    public Configuration[] getConfigurations() {
        return this.configurations;
    }

    public void resetDetectedConfiguration() {
        this.detect = true;
        this.detectedConfig = null;
    }

    public Configuration getDetectedConfiguration() {
        return this.detectedConfig;
    }

    public DetectedDocumentType detectDocumentType(Element element, URL uRL) {
        Configuration[] configurationArray = this.getConfigurations();
        if (configurationArray == null || configurationArray.length == 0) {
            return null;
        }
        DetectedDocumentType detectedDocumentType = null;
        Configuration configuration = DocumentTypeDetectorImpl.detectConfiguration(element, uRL, null, configurationArray);
        if (configuration != null) {
            Info info;
            SchemaInfo schemaInfo = (SchemaInfo)configuration.get("schema");
            if (schemaInfo != null) {
                if (this.detect) {
                    this.detectedConfig = configuration;
                }
                detectedDocumentType = new DetectedDocumentType();
                detectedDocumentType.wxsLocations = schemaInfo.getLocations();
                DocumentTypeDetectorImpl.addPreserveSpaceInfo(configuration, detectedDocumentType);
                DocumentTypeDetectorImpl.addDTDInfo(configuration, detectedDocumentType);
            }
            if (detectedDocumentType == null && (info = (RelaxngInfo)configuration.get("relaxng")) != null) {
                if (this.detect) {
                    this.detectedConfig = configuration;
                }
                detectedDocumentType = new DetectedDocumentType();
                detectedDocumentType.rngLocation = ((RelaxngInfo)info).getLocation().getURL();
                detectedDocumentType.rngName = ((RelaxngInfo)info).getName();
                detectedDocumentType.rngSyntax = ((RelaxngInfo)info).getSyntax();
                detectedDocumentType.rncEncoding = ((RelaxngInfo)info).getEncoding();
                DocumentTypeDetectorImpl.addPreserveSpaceInfo(configuration, detectedDocumentType);
                DocumentTypeDetectorImpl.addDTDInfo(configuration, detectedDocumentType);
            }
            if (detectedDocumentType == null && (info = (DtdInfo)configuration.get("dtd")) != null) {
                if (this.detect) {
                    this.detectedConfig = configuration;
                }
                detectedDocumentType = new DetectedDocumentType();
                detectedDocumentType.dtdSystemId = ((DtdInfo)info).getSystemId().getURL();
                detectedDocumentType.dtdPublicId = ((DtdInfo)info).getPublicId();
                DocumentTypeDetectorImpl.addPreserveSpaceInfo(configuration, detectedDocumentType);
            }
        }
        this.detect = false;
        return detectedDocumentType;
    }

    public static Configuration detectConfiguration(Element element, URL uRL, String string, Configuration[] configurationArray) {
        Object object;
        Name name = element.getName();
        String string2 = name.getLocalPart();
        Namespace namespace = name.getNamespace();
        int n = 0;
        String string3 = null;
        String string4 = null;
        Document document = element.getDocument();
        if (document != null && (object = (DocumentType)document.getProperty("DOCUMENT_TYPE")) != null) {
            if (object instanceof Schema) {
                if (object.isDTD()) {
                    n = 1;
                    DTD dTD = (DTD)object;
                    string3 = dTD.getPublicId();
                    string4 = dTD.getSystemId();
                } else {
                    n = 2;
                }
            } else if (object instanceof DocumentTypeImpl) {
                n = 3;
            }
        }
        object = URIUtil.unescape(URLUtil.getRawExtension(uRL));
        int n2 = 0;
        while (n2 < configurationArray.length) {
            Configuration configuration = configurationArray[n2];
            DetectInfo detectInfo = (DetectInfo)configuration.get("detect");
            if (detectInfo.match(string2, namespace, n, string3, string4, (String)object, string)) {
                return configuration;
            }
            ++n2;
        }
        return null;
    }

    protected static final void addDTDInfo(Configuration configuration, DetectedDocumentType detectedDocumentType) {
        DtdInfo dtdInfo = (DtdInfo)configuration.get("dtd");
        if (dtdInfo != null) {
            detectedDocumentType.dtdSystemId = dtdInfo.getSystemId().getURL();
            detectedDocumentType.dtdPublicId = dtdInfo.getPublicId();
        }
    }

    protected static final void addPreserveSpaceInfo(Configuration configuration, DetectedDocumentType detectedDocumentType) {
        PreserveSpaceInfo preserveSpaceInfo = (PreserveSpaceInfo)configuration.get("preserveSpace");
        if (preserveSpaceInfo != null) {
            detectedDocumentType.preserveSpaceElements = preserveSpaceInfo.getElementMatcher();
        }
    }
}

