/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.gadget.AppEvent;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.UserInput;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledDocumentPane;
import com.xmlmind.xmledit.styledview.StyledDocumentView;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleSheet;
import com.xmlmind.xmledit.stylesheet.StyleSheetLoader;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.view.DocumentPane;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.JScrollPaneSupport;
import com.xmlmind.xmledit.view.TreeViewFactory;
import com.xmlmind.xmleditapp.config.BindingInfo;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.NewElementContentInfo;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.EditorEvent;
import com.xmlmind.xmleditapp.kit.EditorListener;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class Editor
extends JScrollPane {
    protected App app;
    protected StyledDocumentView docView;
    protected JScrollPaneSupport scrollPaneSupport;
    protected OpenedDocument openedDoc;
    protected StyleSheetInfo styleSheetInfo;
    private static final int BORDER_WIDTH = 10;

    public Editor(App app) {
        this.app = app;
        final StyledDocumentPane styledDocumentPane = this.createStyledDocumentPane();
        this.scrollPaneSupport = styledDocumentPane.addToScrollPane(this);
        styledDocumentPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && mouseEvent.isPopupTrigger()) {
                    this.marginMouseClick(mouseEvent, true);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && mouseEvent.isPopupTrigger()) {
                    this.marginMouseClick(mouseEvent, true);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed()) {
                    this.marginMouseClick(mouseEvent, false);
                }
            }

            private void marginMouseClick(MouseEvent mouseEvent, boolean bl) {
                AppEvent appEvent;
                boolean bl2;
                if (styledDocumentPane.getBorder() == null) {
                    return;
                }
                int n = mouseEvent.getX();
                boolean bl3 = bl2 = n < 10;
                if ((bl2 || n >= styledDocumentPane.getWidth() - 10) && styledDocumentPane.handleAppEvent(appEvent = new AppEvent(styledDocumentPane, Editor.appEventName(mouseEvent, bl, bl2), n, mouseEvent.getY()))) {
                    mouseEvent.consume();
                }
            }
        });
        this.docView = styledDocumentPane.getStyledDocumentView();
    }

    protected StyledDocumentPane createStyledDocumentPane() {
        return new StyledDocumentPane();
    }

    protected static final String appEventName(MouseEvent mouseEvent, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl2 ? "left-margin" : "right-margin");
        if (bl) {
            stringBuffer.append("-popup-trigger");
        } else {
            int n = mouseEvent.getModifiers();
            if ((n & 0x20) != 0) {
                stringBuffer.append("-altgr");
            }
            if ((n & 8) != 0) {
                stringBuffer.append("-alt");
            }
            if ((n & 4) != 0) {
                stringBuffer.append("-meta");
            }
            if ((n & 2) != 0) {
                stringBuffer.append("-ctrl");
            }
            if ((n & 1) != 0) {
                stringBuffer.append("-shift");
            }
            int n2 = mouseEvent.getClickCount();
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    stringBuffer.append("-double");
                    break;
                }
                case 3: {
                    stringBuffer.append("-triple");
                    break;
                }
                case 4: {
                    stringBuffer.append("-quadruple");
                    break;
                }
                default: {
                    stringBuffer.append('-');
                    stringBuffer.append(n2);
                }
            }
            if ((n & 0x10) != 0) {
                stringBuffer.append("-click1");
            }
            if ((n & 8) != 0) {
                stringBuffer.append("-click2");
            }
            if ((n & 4) != 0) {
                stringBuffer.append("-click3");
            }
        }
        return stringBuffer.toString();
    }

    public void open(OpenedDocument openedDocument, StyleSheetInfo styleSheetInfo) {
        this.openedDoc = openedDocument;
        this.styleSheetInfo = styleSheetInfo;
        this.configureDocumentView();
        this.docView.setDocument(openedDocument.getDocument());
    }

    public String getLabel() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.openedDoc == null) {
            stringBuffer.append("(newly created or disposed Editor ");
            stringBuffer.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuffer.append(')');
        } else {
            stringBuffer.append(this.openedDoc.getName());
            stringBuffer.append(" : ");
            if (this.styleSheetInfo != null) {
                stringBuffer.append(this.styleSheetInfo.getLabel());
            }
            stringBuffer.append(" : ");
            Configuration configuration = this.openedDoc.getConfiguration();
            if (configuration != null) {
                stringBuffer.append(configuration.getName());
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getLabel();
    }

    protected void configureDocumentView() {
        Configuration configuration;
        StyleSheet styleSheet;
        Preferences preferences = this.app.getPreferences();
        StyledViewFactory styledViewFactory = this.docView.getStyledViewFactory();
        Editor.setStyleDefaults(styledViewFactory, preferences);
        if (this.styleSheetInfo == null) {
            Editor.setTreeViewSettings(styledViewFactory, preferences);
            styleSheet = null;
        } else {
            Editor.resetTreeViewSettings(styledViewFactory);
            styleSheet = this.loadStyleSheet();
        }
        this.setStyleSheet(styledViewFactory, styleSheet);
        Binding[] bindingArray = this.app.getDefaultBindings();
        if (bindingArray != null) {
            this.docView.setBindings(bindingArray);
        }
        if ((configuration = this.openedDoc.getConfiguration()) != null) {
            this.configureEditing(configuration);
            this.configureBindings(configuration);
        }
    }

    protected static final void setStyleDefaults(StyledViewFactory styledViewFactory, Preferences preferences) {
        String string = preferences.getString("serifFontFamily", "Serif");
        String string2 = preferences.getString("sansSerifFontFamily", "SansSerif");
        String string3 = preferences.getString("monospaceFontFamily", "Monospaced");
        boolean bl = preferences.getBoolean("defaultFontIsSerif", false);
        int n = preferences.getInt("defaultFontSize", 10, 20, 12);
        Color color = preferences.getColor("defaultBackground", Color.white);
        Color color2 = preferences.getColor("defaultForeground", Color.black);
        styledViewFactory.setSerifFontFamily(string);
        styledViewFactory.setSansSerifFontFamily(string2);
        styledViewFactory.setMonospaceFontFamily(string3);
        Style style = new Style();
        style.paddingLeft = 5;
        style.paddingBottom = 5;
        style.paddingRight = 5;
        style.paddingTop = 5;
        style.font = new Font(bl ? string : string2, 0, n);
        style.backgroundColor = color;
        style.color = color2;
        styledViewFactory.setDefaultStyle(style);
    }

    protected static final void resetTreeViewSettings(TreeViewFactory treeViewFactory) {
        TreeViewFactory.Settings settings = treeViewFactory.getSettings();
        settings.showAttribute = true;
        settings.showText = true;
        settings.showComment = true;
        settings.showPI = true;
    }

    protected static final void setTreeViewSettings(TreeViewFactory treeViewFactory, Preferences preferences) {
        TreeViewFactory.Settings settings = treeViewFactory.getSettings();
        settings.showAttribute = preferences.getBoolean("treeViewShowAttribute", true);
        settings.showText = preferences.getBoolean("treeViewShowText", true);
        settings.showComment = preferences.getBoolean("treeViewShowComment", true);
        settings.showPI = preferences.getBoolean("treeViewShowPI", true);
    }

    protected StyleSheet loadStyleSheet() {
        StyleSheetLoader.useDefaultBuiltInRules();
        StyleSheetLoader styleSheetLoader = new StyleSheetLoader();
        StyleSheet styleSheet = null;
        String string = null;
        try {
            styleSheet = this.styleSheetInfo.content == null ? styleSheetLoader.load(this.styleSheetInfo.url, null) : styleSheetLoader.load(this.styleSheetInfo.content, this.styleSheetInfo.url, null);
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (styleSheet == null) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotLoadStyleSheet", URLUtil.toLabel(this.styleSheetInfo.url), string));
        } else {
            StyleSheetLoader.Warning[] warningArray = styleSheetLoader.getWarnings();
            if (warningArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < warningArray.length) {
                    StyleSheetLoader.Warning warning = warningArray[n];
                    stringBuffer.append(warning.url);
                    stringBuffer.append(':');
                    stringBuffer.append(warning.lineNumber);
                    stringBuffer.append(':');
                    stringBuffer.append(warning.columnNumber);
                    stringBuffer.append(": ");
                    stringBuffer.append(warning.message);
                    stringBuffer.append("\n\n");
                    ++n;
                }
                Alert.showWarning(this.app.getDialogParent(), Msg.msg("styleSheetHasErrors", URLUtil.toLabel(this.styleSheetInfo.url)), stringBuffer.toString(), true, 10, 40);
            }
        }
        return styleSheet;
    }

    protected void setStyleSheet(StyledViewFactory styledViewFactory, StyleSheet styleSheet) {
        boolean bl = styleSheet != null && this.app.getPreferences().getBoolean("addInteractiveMargins", false);
        DocumentPane documentPane = this.getDocumentPane();
        if (bl) {
            if (documentPane.getBorder() == null) {
                documentPane.setBorder(new EmptyBorder(0, 10, 0, 10));
            }
        } else if (documentPane.getBorder() != null) {
            documentPane.setBorder(null);
        }
        Document document = styledViewFactory.getDocumentView().getDocument();
        DocumentUtil.commitChanges(document);
        styledViewFactory.setStyleSheet(styleSheet);
    }

    protected void configureEditing(Configuration configuration) {
        NewElementContentInfo newElementContentInfo = (NewElementContentInfo)configuration.get("newElementContent");
        if (newElementContentInfo == null) {
            return;
        }
        this.docView.getElementEditor().setCreateInstanceOptions(newElementContentInfo.getCreateInstanceOptions());
        this.docView.getTextEditor().setCreateInstanceOptions(newElementContentInfo.getCreateInstanceOptions());
    }

    protected void configureBindings(Configuration configuration) {
        block5: {
            BindingInfo bindingInfo = (BindingInfo)configuration.get("binding");
            if (bindingInfo == null) {
                return;
            }
            ArrayList<BindingSpec> arrayList = new ArrayList<BindingSpec>();
            BindingSpec[] bindingSpecArray = bindingInfo.getBindingSpecs();
            int n = 0;
            while (n < bindingSpecArray.length) {
                BindingSpec bindingSpec = bindingSpecArray[n];
                UserInput[] userInputArray = bindingSpec.getUserInputs();
                if (userInputArray == null || !this.app.isMenuAccelerator(userInputArray)) {
                    arrayList.add(bindingSpec);
                }
                ++n;
            }
            int n2 = arrayList.size();
            if (n2 <= 0) break block5;
            bindingSpecArray = new BindingSpec[n2];
            arrayList.toArray(bindingSpecArray);
            try {
                this.docView.replaceBindings(bindingSpecArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                final String string = Msg.msg("configHasInvalidBindings", configuration.getName(), MiscUtil.reason(illegalArgumentException));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Alert.showWarning(Editor.this.app.getDialogParent(), string);
                    }
                });
            }
        }
    }

    public void close() {
        this.app.removeEditor(this);
    }

    public void dispose() {
        this.docView.setDocument(null);
        this.openedDoc = null;
        this.styleSheetInfo = null;
        EditorListener[] editorListenerArray = this.app.getEditorListeners();
        if (editorListenerArray.length > 0) {
            EditorEvent editorEvent = new EditorEvent(this.app, 6, this);
            int n = 0;
            while (n < editorListenerArray.length) {
                editorListenerArray[n].editorDisposed(editorEvent);
                ++n;
            }
        }
    }

    public App getApp() {
        return this.app;
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public DocumentPane getDocumentPane() {
        return (DocumentPane)this.docView.getPanel();
    }

    public OpenedDocument getOpenedDocument() {
        return this.openedDoc;
    }

    public Document getDocument() {
        return this.openedDoc.getDocument();
    }

    public StyleSheetInfo getStyleSheetInfo() {
        return this.styleSheetInfo;
    }

    public void applyTreeViewSettings() {
        if (this.styleSheetInfo != null) {
            return;
        }
        StyledViewFactory styledViewFactory = this.docView.getStyledViewFactory();
        Editor.setTreeViewSettings(styledViewFactory, this.app.getPreferences());
        styledViewFactory.applySettings();
    }

    public void applyStyleDefaults() {
        StyledViewFactory styledViewFactory = this.docView.getStyledViewFactory();
        Editor.setStyleDefaults(styledViewFactory, this.app.getPreferences());
        styledViewFactory.applyStyleDefaults();
    }

    public boolean reloadStyleSheet() {
        if (this.styleSheetInfo == null) {
            return false;
        }
        StyledViewFactory styledViewFactory = this.docView.getStyledViewFactory();
        StyleSheet styleSheet = this.loadStyleSheet();
        this.setStyleSheet(styledViewFactory, styleSheet);
        return styleSheet != null;
    }

    public boolean setStyleSheet(StyleSheetInfo styleSheetInfo) {
        boolean bl;
        StyleSheet styleSheet;
        this.styleSheetInfo = styleSheetInfo;
        StyledViewFactory styledViewFactory = this.docView.getStyledViewFactory();
        if (styleSheetInfo == null) {
            Editor.setTreeViewSettings(styledViewFactory, this.app.getPreferences());
            styleSheet = null;
            bl = true;
        } else {
            Editor.resetTreeViewSettings(styledViewFactory);
            styleSheet = this.loadStyleSheet();
            bl = styleSheet != null;
        }
        this.setStyleSheet(styledViewFactory, styleSheet);
        return bl;
    }

    public void setViewportWidthTracked(boolean bl) {
        this.scrollPaneSupport.setViewportWidthTracked(bl);
    }
}

