/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.SavedDocumentBase;
import com.xmlmind.xmleditapp.structformat.StructuredFormat;
import com.xmlmind.xmleditapp.upload.FileUpload;
import com.xmlmind.xmleditapp.upload.UploadDialog;
import java.io.File;
import java.net.URL;

public class FileSavedDocument
extends SavedDocumentBase {
    public FileSavedDocument(App app, Document document, StructuredFormat structuredFormat, Configuration configuration) {
        super(app, document, structuredFormat, configuration);
    }

    public boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        File file = FileUtil.urlToFile(this.url);
        if (!file.canWrite()) {
            Alert.showInfo(this.app.getDialogParent(), Msg.msg("readOnlyDocument", file));
            return false;
        }
        return true;
    }

    public boolean initialize(URL uRL) {
        return super.initialize(uRL);
    }

    public boolean update() {
        boolean bl;
        File file = FileUtil.urlToFile(this.url);
        File file2 = new File(file.getPath() + Long.toString(System.currentTimeMillis(), 36));
        String string = null;
        try {
            this.saveDocument(this.document, file2);
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (string != null) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotSave", file, string));
            file2.delete();
            return false;
        }
        boolean bl2 = bl = this.firstUpdate && this.app.getPreferences().getBoolean("makeBackupFiles", true);
        if (bl && file.exists()) {
            File file3 = new File(file.getPath() + '~');
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
        }
        if (file.exists()) {
            file.delete();
        }
        file2.renameTo(file);
        this.firstUpdate = false;
        return true;
    }

    protected boolean copy(URL[] uRLArray) {
        String string;
        FileUpload fileUpload = new FileUpload();
        if (uRLArray.length == 2) {
            fileUpload.setInvoker(this);
            string = fileUpload.upload(uRLArray, true);
        } else {
            UploadDialog uploadDialog = this.newUploadDialog();
            string = uploadDialog.upload(fileUpload, uRLArray, true);
        }
        if (string != null) {
            Alert.showError(this.app.getDialogParent(), string);
            return false;
        }
        return true;
    }
}

