/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.DisabledCommand;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.AppAction;

public class LazyEditAction
extends AppAction {
    protected String commandName;
    protected String parameter;
    protected boolean editingContextSensitive;
    private Command command;

    public LazyEditAction(String string, String string2, boolean bl) {
        this.commandName = string;
        this.parameter = string2;
        this.editingContextSensitive = bl;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getParameter() {
        return this.parameter;
    }

    public final Command getCommand() {
        if (this.command == null) {
            this.command = Commands.getCommand(this.commandName);
            if (this.command == null) {
                System.err.println("'" + this.commandName + "' unknown command");
                this.command = DisabledCommand.INSTANCE;
            }
        }
        return this.command;
    }

    public void doIt() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView == null) {
            return;
        }
        Command command = this.getCommand();
        if (command.prepareCommand(documentView, this.parameter, -1, -1)) {
            command.executeCommand(documentView, this.parameter, -1, -1);
            documentView.requestFocus();
        }
    }

    public void updateEnabled() {
        boolean bl;
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView == null) {
            bl = false;
        } else {
            Command command = this.getCommand();
            bl = command.prepareCommand(documentView, this.parameter, -1, -1);
        }
        this.setEnabled(bl);
    }

    public boolean isEditingContextSensitive() {
        return this.editingContextSensitive;
    }
}

