/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.dialog.DiagnosticsUtil;
import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.InclusionStatus;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doctype.Diagnostic;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.ContextChangeEvent;
import com.xmlmind.xmledit.edit.ContextChangeListener;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.edit.UndoManagerEvent;
import com.xmlmind.xmledit.edit.UndoManagerListener;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.PropertySet;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.config.CommandInfo;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.CssInfo;
import com.xmlmind.xmleditapp.config.DocumentHookInfo;
import com.xmlmind.xmleditapp.config.DocumentResourcesInfo;
import com.xmlmind.xmleditapp.config.ElementTemplateInfo;
import com.xmlmind.xmleditapp.config.ImageToolkitInfo;
import com.xmlmind.xmleditapp.config.NewElementContentInfo;
import com.xmlmind.xmleditapp.config.ParameterGroupInfo;
import com.xmlmind.xmleditapp.config.PropertyInfo;
import com.xmlmind.xmleditapp.config.SpreadsheetFunctionsInfo;
import com.xmlmind.xmleditapp.dochook.DocumentHook;
import com.xmlmind.xmleditapp.dochook.Status;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.DAVSavedDocument;
import com.xmlmind.xmleditapp.kit.DocumentTypeDetectorImpl;
import com.xmlmind.xmleditapp.kit.EditAction;
import com.xmlmind.xmleditapp.kit.FTPSavedDocument;
import com.xmlmind.xmleditapp.kit.FileSavedDocument;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.OpenedDocumentHook;
import com.xmlmind.xmleditapp.kit.SavedDocument;
import com.xmlmind.xmleditapp.kit.SavedDocumentBase;
import com.xmlmind.xmleditapp.kit.URLHistory;
import com.xmlmind.xmleditapp.spreadsheet.SpreadsheetHelper;
import com.xmlmind.xmleditapp.structformat.StructuredFormat;
import com.xmlmind.xmleditapp.structformat.StructuredFormatException;
import com.xmlmind.xmleditapp.structformat.StructuredFormats;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;

public class OpenedDocument
extends PropertySet
implements DocumentListener,
ContextChangeListener,
UndoManagerListener,
Status {
    public static final String NAME_PROPERTY = "NAME";
    public static final String SHORT_LABEL_PROPERTY = "SHORT_LABEL";
    public static final String LABEL_PROPERTY = "LABEL";
    protected App app;
    protected Document document;
    protected URL location;
    protected StructuredFormat structuredFormat;
    protected Configuration configuration;
    protected boolean needSave;
    protected int modificationCount;
    protected long lastModified;
    protected SavedDocument savedDoc;
    protected long lastSaved;
    protected Diagnostic[] diagnostics;
    protected boolean batchEditing;
    protected boolean batchModified;
    protected static final int OP_NEW_FROM_TEMPLATE = 1;
    protected static final int OP_OPEN_AS_TEMPLATE = 2;
    protected static final int OP_OPEN = 3;

    public OpenedDocument(App app) {
        this.app = app;
        this.lastModified = -1L;
        this.lastSaved = -1L;
    }

    public App getApp() {
        return this.app;
    }

    public Document getDocument() {
        return this.document;
    }

    public URL getLocation() {
        return this.location;
    }

    public void setName(String string) {
        if (string == null) {
            this.removeProperty(NAME_PROPERTY);
        } else {
            this.putProperty(NAME_PROPERTY, string);
        }
    }

    public String getName() {
        String string = (String)this.getProperty(NAME_PROPERTY);
        if (string != null) {
            return string;
        }
        if (this.location == null) {
            return null;
        }
        String string2 = URLUtil.getRawBaseName(this.location);
        if (string2 == null || string2.length() == 0) {
            return Msg.msg("untitled");
        }
        return URIUtil.unescape(string2);
    }

    public void setShortLabel(String string) {
        if (string == null) {
            this.removeProperty(SHORT_LABEL_PROPERTY);
        } else {
            this.putProperty(SHORT_LABEL_PROPERTY, string);
        }
    }

    public String getShortLabel() {
        String string = (String)this.getProperty(SHORT_LABEL_PROPERTY);
        if (string != null) {
            return string;
        }
        if (this.location == null) {
            return null;
        }
        return URLUtil.toShortLabel(this.location, 40);
    }

    public void setLabel(String string) {
        if (string == null) {
            this.removeProperty(LABEL_PROPERTY);
        } else {
            this.putProperty(LABEL_PROPERTY, string);
        }
    }

    public String getLabel() {
        String string = (String)this.getProperty(LABEL_PROPERTY);
        if (string != null) {
            return string;
        }
        if (this.location == null) {
            return null;
        }
        return URLUtil.toLabel(this.location);
    }

    public StructuredFormat getStructuredFormat() {
        return this.structuredFormat;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isSaveNeeded() {
        return this.needSave;
    }

    public void markAsModified() {
        if (this.modificationCount <= 0) {
            this.setModified(1, System.currentTimeMillis());
        }
    }

    public void unmarkAsModified() {
        if (this.modificationCount > 0) {
            this.setModified(0, -1L);
        }
    }

    public void setModified(int n, long l) {
        this.modificationCount = n;
        this.lastModified = l;
    }

    public boolean isModified() {
        return this.modificationCount > 0;
    }

    public int getModificationCount() {
        return this.modificationCount;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public boolean isSaveAsNeeded() {
        return this.savedDoc == null;
    }

    public long lastSaved() {
        return this.lastSaved;
    }

    public StyleSheetInfo[] getStyleSheetInfo() {
        if (this.document == null) {
            return null;
        }
        return (StyleSheetInfo[])this.document.getProperty("STYLE_SHEET_INFO");
    }

    public boolean creating(boolean bl, URL uRL) {
        boolean bl2 = true;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                bl2 = openedDocumentHookArray[n].creatingDocument(this, bl, uRL);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            if (!bl2) {
                int n2 = 0;
                while (n2 <= n) {
                    try {
                        openedDocumentHookArray[n2].documentCreated(this, 1);
                    }
                    catch (Throwable throwable) {
                        OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        return bl2;
    }

    protected static final void reportHookError(Object object, Throwable throwable) {
        String string = object instanceof DocumentHook ? "documentHook" : "openedDocumentHook";
        System.err.println("Error in " + string + " " + object.getClass().getName() + ": " + MiscUtil.reason(throwable));
        System.err.println("----------------------------------------");
        throwable.printStackTrace();
        System.err.println("----------------------------------------");
    }

    public boolean newFromTemplate(URL uRL) {
        Object[] objectArray = this.load(uRL);
        if (objectArray == null) {
            return this.created(3, true, uRL);
        }
        Document document = (Document)objectArray[0];
        StructuredFormat structuredFormat = (StructuredFormat)objectArray[1];
        Configuration configuration = (Configuration)objectArray[2];
        this.setDocument(document, 1, uRL, structuredFormat, configuration);
        this.needSave = false;
        this.savedDoc = null;
        this.lastSaved = -1L;
        return true;
    }

    protected boolean created(int n, boolean bl, URL uRL) {
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n2 = 0;
        while (n2 < openedDocumentHookArray.length) {
            try {
                openedDocumentHookArray[n2].documentCreated(this, n);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
            }
            ++n2;
        }
        if (n != 2) {
            return false;
        }
        DocumentHook[] documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].documentCreated(this.document, bl, uRL);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return true;
    }

    public boolean openAsTemplate(URL uRL) {
        NewElementContentInfo newElementContentInfo;
        Object[] objectArray = this.load(uRL);
        if (objectArray == null) {
            return this.created(3, false, uRL);
        }
        Document document = (Document)objectArray[0];
        StructuredFormat structuredFormat = (StructuredFormat)objectArray[1];
        Configuration configuration = (Configuration)objectArray[2];
        int n = 29;
        if (configuration != null && (newElementContentInfo = (NewElementContentInfo)configuration.get("newElementContent")) != null) {
            n = newElementContentInfo.getCreateInstanceOptions();
        }
        document = DocumentUtil.documentFromTemplate(document, n);
        document.putLocationInfo(uRL.toExternalForm(), false);
        this.setDocument(document, 2, uRL, structuredFormat, configuration);
        this.needSave = false;
        this.savedDoc = null;
        this.lastSaved = -1L;
        return true;
    }

    public boolean opening(URL uRL) {
        return this.opening(uRL, null);
    }

    public boolean open(URL uRL) {
        return this.open(uRL, null);
    }

    public boolean opening(URL uRL, OpenedDocument openedDocument) {
        boolean bl = true;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                bl = openedDocumentHookArray[n].openingDocument(this, uRL, openedDocument);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            if (!bl) {
                int n2 = 0;
                while (n2 <= n) {
                    try {
                        openedDocumentHookArray[n2].documentOpened(this, 1);
                    }
                    catch (Throwable throwable) {
                        OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        return bl;
    }

    public boolean open(URL uRL, OpenedDocument openedDocument) {
        Object[] objectArray = this.load(uRL);
        if (objectArray == null) {
            return this.opened(3);
        }
        Document document = (Document)objectArray[0];
        StructuredFormat structuredFormat = (StructuredFormat)objectArray[1];
        Configuration configuration = (Configuration)objectArray[2];
        if (!this.checkInclusionStatus(document)) {
            return this.opened(4);
        }
        this.setDocument(document, 3, uRL, structuredFormat, configuration);
        this.needSave = false;
        this.savedDoc = this.createSavedDocument(this.document, uRL);
        if (this.savedDoc != null && !this.savedDoc.initialize()) {
            this.savedDoc = null;
        }
        this.updateLastSaved();
        return true;
    }

    protected boolean opened(int n) {
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n2 = 0;
        while (n2 < openedDocumentHookArray.length) {
            try {
                openedDocumentHookArray[n2].documentOpened(this, n);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
            }
            ++n2;
        }
        if (n != 2) {
            return false;
        }
        DocumentHook[] documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].documentOpened(this.document);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return true;
    }

    protected SavedDocument createSavedDocument(Document document, URL uRL) {
        SavedDocumentBase savedDocumentBase;
        boolean bl = false;
        boolean bl2 = false;
        String string = uRL.getProtocol();
        if ("file".equals(string)) {
            savedDocumentBase = new FileSavedDocument(this.app, document, this.structuredFormat, this.configuration);
        } else if ("http".equals(string) || "https".equals(string)) {
            if ("Professional".equals("Standard")) {
                bl = true;
                savedDocumentBase = null;
            } else {
                savedDocumentBase = new DAVSavedDocument(this.app, document, this.structuredFormat, this.configuration);
            }
        } else if ("ftp".equals(string)) {
            if ("Professional".equals("Standard")) {
                bl = true;
                savedDocumentBase = null;
            } else {
                savedDocumentBase = new FTPSavedDocument(this.app, document, this.structuredFormat, this.configuration);
            }
        } else {
            bl2 = true;
            savedDocumentBase = null;
        }
        if (bl || bl2) {
            String string2 = Msg.msg("saveNotSupported", URLUtil.toLabel(uRL));
            if (bl) {
                string2 = string2 + "\n\n" + Msg.msg("notRestrictedInProEdition");
            }
            Alert.showInfo(this.app.getDialogParent(), string2);
        }
        return savedDocumentBase;
    }

    protected void updateLastSaved() {
        File file;
        this.lastSaved = -1L;
        if (this.savedDoc != null && (file = FileUtil.urlToFile(this.location)) != null) {
            this.lastSaved = file.lastModified();
        }
    }

    protected boolean checkInclusionStatus(Document document) {
        Object[] objectArray;
        Preferences preferences = this.app.getPreferences();
        boolean bl = preferences.getBoolean("warnAboutLossOfPhysicalStructure", true);
        boolean bl2 = preferences.getBoolean("infoAboutReadOnlyInclusions", true);
        if (!bl && !bl2) {
            return true;
        }
        InclusionStatus inclusionStatus = (InclusionStatus)document.removeProperty("INCLUSION_STATUS");
        if (inclusionStatus == null) {
            return true;
        }
        if (bl && inclusionStatus.notManaged != null) {
            objectArray = new Object[]{Msg.msg("confirmLossOfPhysicalStructure", URLUtil.toShortLabel(document.getLocation(), 40), inclusionStatus.notManaged), this.createToggle("warnAboutLossOfPhysicalStructure")};
            String string = DialogUtil.buttonLabel(Msg.msg("editAnyway"));
            String string2 = DialogUtil.buttonLabel(Msg.msg("cancel"));
            Object[] objectArray2 = new String[]{string, string2};
            int n = JOptionPane.showOptionDialog(this.app.getDialogParent(), objectArray, Msg.msg("confirm"), 0, 3, null, objectArray2, string);
            if (n == 1) {
                return false;
            }
        }
        if (bl2 && inclusionStatus.managed != null) {
            objectArray = new Object[]{Msg.msg("noticeReadOnlyInclusions", URLUtil.toShortLabel(document.getLocation(), 40), inclusionStatus.managed), this.createToggle("infoAboutReadOnlyInclusions")};
            JOptionPane.showMessageDialog(this.app.getDialogParent(), objectArray, Msg.msg("information"), 1);
        }
        return true;
    }

    protected JCheckBox createToggle(final String string) {
        final JCheckBox jCheckBox = new JCheckBox(DialogUtil.buttonLabel(Msg.msg("doNotShowThisDialogAgain")));
        jCheckBox.setBorder(new EmptyBorder(20, 1, 1, 1));
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpenedDocument.this.app.getPreferences().putBoolean(string, !jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    protected Object[] load(URL uRL) {
        Object[] objectArray;
        Document document;
        Configuration configuration;
        StructuredFormat structuredFormat;
        String string = URIUtil.unescape(URLUtil.getRawExtension(uRL));
        StructuredFormat structuredFormat2 = structuredFormat = string.length() > 0 ? StructuredFormats.getByExtension(string) : null;
        if (structuredFormat != null) {
            configuration = null;
            try {
                document = OpenedDocument.loadDocument(structuredFormat, uRL);
            }
            catch (Exception exception) {
                document = null;
                Alert.showError(this.app.getDialogParent(), Msg.msg("cannotOpen", URLUtil.toLabel(uRL), MiscUtil.reason(exception)));
            }
        } else {
            Object[] objectArray2 = this.app.getXMLLoader().load(uRL);
            if (objectArray2 == null) {
                document = null;
                configuration = null;
            } else {
                document = (Document)objectArray2[0];
                configuration = (Configuration)objectArray2[1];
            }
        }
        if (document == null) {
            objectArray = null;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = document;
            objectArray3[1] = structuredFormat;
            objectArray = objectArray3;
            objectArray3[2] = configuration;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Document loadDocument(StructuredFormat structuredFormat, URL uRL) throws IOException, StructuredFormatException {
        Document document;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            document = structuredFormat.loadDocument(inputStream, uRL, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return document;
    }

    protected void setDocument(Document document, int n, URL uRL, StructuredFormat structuredFormat, Configuration configuration) {
        Object object;
        Object object2;
        Object object3;
        this.document = document;
        this.location = n == 3 ? uRL : this.untitledURL(uRL);
        this.structuredFormat = structuredFormat;
        if (configuration == null) {
            object3 = structuredFormat == null ? null : structuredFormat.getMimeType();
            configuration = DocumentTypeDetectorImpl.detectConfiguration(document.getRootElement(), uRL, (String)object3, this.app.getConfigurations());
        }
        this.configuration = configuration;
        OpenedDocument.setStyleSheetInfo(this.document, this.configuration);
        if (this.configuration != null) {
            Object object4;
            SpreadsheetFunctionsInfo spreadsheetFunctionsInfo;
            ImageToolkitInfo imageToolkitInfo;
            ParameterGroupInfo parameterGroupInfo;
            CommandInfo commandInfo;
            object3 = (PropertyInfo)this.configuration.remove("property");
            if (object3 != null) {
                ((PropertyInfo)object3).setSystemProperties();
            }
            if ((commandInfo = (CommandInfo)this.configuration.remove("command")) != null) {
                object2 = new ArrayList();
                commandInfo.registerCommands((ArrayList)object2);
                if (((ArrayList)object2).size() > 0) {
                    object = new String[((ArrayList)object2).size()];
                    ((ArrayList)object2).toArray((T[])object);
                    Alert.showError(this.app.getDialogParent(), Msg.msg("cannotRegisterCommands"), (String[])object);
                }
            }
            if ((object2 = (ElementTemplateInfo)this.configuration.get("elementTemplate")) != null) {
                this.document.putProperty("ELEMENT_TEMPLATES", ((ElementTemplateInfo)object2).getElementTemplates());
            }
            if ((object = (DocumentResourcesInfo)this.configuration.get("documentResources")) != null) {
                this.document.putProperty("DOCUMENT_RESOURCES", ((DocumentResourcesInfo)object).getDocumentResources());
            }
            if ((parameterGroupInfo = (ParameterGroupInfo)this.configuration.remove("parameterGroup")) != null) {
                parameterGroupInfo.registerGroups();
            }
            if ((imageToolkitInfo = (ImageToolkitInfo)this.configuration.remove("imageToolkit")) != null) {
                imageToolkitInfo.registerToolkits();
            }
            if ((spreadsheetFunctionsInfo = (SpreadsheetFunctionsInfo)this.configuration.get("spreadsheetFunctions")) != null) {
                String[] stringArray;
                object4 = spreadsheetFunctionsInfo.getFormulaFunctions();
                if (object4 != null) {
                    this.document.putProperty("com.xmlmind.xmleditapp.spreadsheet.FORMULA_FUNCTIONS", object4);
                }
                if ((stringArray = spreadsheetFunctionsInfo.getFormulaFunctionsErrors()).length > 0) {
                    Alert.showError(this.app.getDialogParent(), Msg.msg("cannotLoadSpreadsheetFunctions"), stringArray);
                    this.configuration.remove("spreadsheetFunctions");
                }
            }
            if ((object4 = (DocumentHookInfo)this.configuration.get("documentHook")) != null) {
                this.document.putProperty("DOCUMENT_HOOKS", ((DocumentHookInfo)object4).getDocumentHooks());
            }
        }
        this.document.putLocationInfo(this.location.toExternalForm(), false);
        if (n == 3) {
            this.opened(2);
        } else {
            this.created(2, n == 1, uRL);
        }
        this.document.addDocumentListener(this, false);
        object3 = new MarkManager(document);
        this.document.putProperty("MARK_MANAGER", object3);
        ((MarkManager)object3).addContextChangeListener(this);
        int n2 = this.app.getPreferences().getInt("maxUndo", 1, 100, 20);
        object2 = new UndoManager(document, n2);
        this.document.putProperty("UNDO_MANAGER", object2);
        ((UndoManager)object2).addUndoManagerListener(this);
        this.document.putProperty("COMMAND_HISTORY", new CommandHistory());
        object = (String[])this.document.removeProperty("XXE_PROCESSING_INSTRUCTIONS");
        if (object != null && StringUtil.contains((String[])object, "xxe-formula")) {
            SpreadsheetHelper.setSpreadsheet(this.document, this.app.getDialogParent());
        }
    }

    protected URL untitledURL(URL uRL) {
        Object object;
        String string;
        String string2;
        String string3 = Msg.msg("untitled");
        String string4 = ".xml";
        if (uRL != null && (string2 = URIUtil.unescape(URLUtil.getRawExtension(uRL))).length() != 0) {
            string4 = "." + string2;
        }
        string2 = string3 + string4;
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        int n = 0;
        while (n < 10) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < openedDocumentArray.length) {
                string = URIUtil.unescape(URLUtil.getRawBaseName(openedDocumentArray[n2].getLocation()));
                if (string2.equals(string)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                string3 = string2;
                break;
            }
            string2 = string3 + Integer.toString(2 + n) + string4;
            ++n;
        }
        URL uRL2 = null;
        Preferences preferences = this.app.getPreferences();
        if (preferences.getBoolean("putNewDocInLastUsedDir", true)) {
            boolean bl = preferences.getBoolean("useURLChooser", false);
            object = null;
            URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
            if (uRLHistory != null) {
                URL[] uRLArray = uRLHistory.getAll();
                int n3 = 0;
                while (n3 < uRLArray.length) {
                    URL uRL3 = uRLArray[n3];
                    if (bl || "file".equals(uRL3.getProtocol())) {
                        object = uRL3;
                        break;
                    }
                    ++n3;
                }
            }
            if (object != null) {
                try {
                    uRL2 = new URL(URLUtil.getDirectory((URL)object), URIUtil.quotePath(string3));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (uRL2 == null) {
            object = System.getProperty("user.home");
            string = object != null ? (String)object + File.separatorChar + string3 : string3;
            uRL2 = FileUtil.fileToURL(new File(string));
        }
        return uRL2;
    }

    protected static void setStyleSheetInfo(Document document, Configuration configuration) {
        StyleSheetInfo[] styleSheetInfoArray;
        StyleSheetInfo styleSheetInfo;
        CssInfo cssInfo;
        StyleSheetInfo[] styleSheetInfoArray2 = (StyleSheetInfo[])document.getProperty("STYLE_SHEET_INFO");
        boolean bl = false;
        if (styleSheetInfoArray2 != null) {
            int n = 0;
            while (n < styleSheetInfoArray2.length) {
                StyleSheetInfo styleSheetInfo2 = styleSheetInfoArray2[n];
                if ("text/css".equals(styleSheetInfo2.type) && (styleSheetInfo2.media == null || styleSheetInfo2.media.equals("screen"))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if (!bl && configuration != null && (cssInfo = (CssInfo)configuration.get("css")) != null) {
            styleSheetInfoArray2 = cssInfo.getStyleSheetInfo();
        }
        if (styleSheetInfoArray2 == null || styleSheetInfoArray2.length == 0) {
            return;
        }
        StyleSheetInfo[] styleSheetInfoArray3 = new StyleSheetInfo[styleSheetInfoArray2.length];
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < styleSheetInfoArray2.length) {
            styleSheetInfo = styleSheetInfoArray2[n3];
            if ("text/css".equals(styleSheetInfo.type) && (styleSheetInfo.media == null || styleSheetInfo.media.equals("screen"))) {
                if (!styleSheetInfo.alternate && n2 < 0) {
                    n2 = n;
                }
                styleSheetInfoArray3[n++] = styleSheetInfo;
            }
            ++n3;
        }
        if (n == styleSheetInfoArray3.length) {
            styleSheetInfoArray = styleSheetInfoArray3;
        } else {
            styleSheetInfoArray = new StyleSheetInfo[n];
            System.arraycopy(styleSheetInfoArray3, 0, styleSheetInfoArray, 0, n);
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 != 0) {
            styleSheetInfo = styleSheetInfoArray3[n2];
            styleSheetInfoArray[n2] = styleSheetInfoArray[0];
            styleSheetInfoArray[0] = styleSheetInfo;
        }
        if (styleSheetInfoArray.length > 0) {
            document.putProperty("STYLE_SHEET_INFO", styleSheetInfoArray);
        } else {
            document.removeProperty("STYLE_SHEET_INFO");
        }
    }

    public boolean saving() {
        DocumentHook[] documentHookArray;
        DocumentUtil.commitChanges(this.document);
        boolean bl = true;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                bl = openedDocumentHookArray[n].savingDocument(this);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            if (!bl) {
                int n2 = 0;
                while (n2 <= n) {
                    try {
                        openedDocumentHookArray[n2].documentSaved(this, 1);
                    }
                    catch (Throwable throwable) {
                        OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (bl && (documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS")) != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].savingDocument(this.document);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return bl;
    }

    public boolean save() {
        if (this.savedDoc == null) {
            Alert.showInfo(this.app.getDialogParent(), Msg.msg("needSaveAs", this.getLabel()));
            return this.saved(4);
        }
        boolean bl = this.savedDoc.update();
        if (bl) {
            this.setNeedSave(false);
            this.updateLastSaved();
            return this.saved(2);
        }
        return this.saved(3);
    }

    protected boolean saved(int n) {
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n2 = 0;
        while (n2 < openedDocumentHookArray.length) {
            try {
                openedDocumentHookArray[n2].documentSaved(this, n);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
            }
            ++n2;
        }
        DocumentHook[] documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].documentSaved(this.document, n);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return n == 2;
    }

    public boolean savingAs(URL uRL) {
        DocumentHook[] documentHookArray;
        if (this.savedDoc != null && this.location.equals(uRL)) {
            return this.saving();
        }
        DocumentUtil.commitChanges(this.document);
        boolean bl = true;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                bl = openedDocumentHookArray[n].savingDocumentAs(this, uRL);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            if (!bl) {
                int n2 = 0;
                while (n2 <= n) {
                    try {
                        openedDocumentHookArray[n2].documentSavedAs(this, 1);
                    }
                    catch (Throwable throwable) {
                        OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (bl && (documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS")) != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].savingDocumentAs(this.document, uRL);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return bl;
    }

    public boolean saveAs(URL uRL) {
        if (this.savedDoc != null && this.location.equals(uRL)) {
            return this.save();
        }
        SavedDocument savedDocument = this.createSavedDocument(this.document, uRL);
        if (savedDocument == null) {
            return this.savedAs(3);
        }
        boolean bl = savedDocument.initialize(uRL);
        if (bl) {
            this.location = uRL;
            if (this.savedDoc != null) {
                this.savedDoc.dispose();
            }
            this.savedDoc = savedDocument;
            this.setNeedSave(false);
            this.updateLastSaved();
            return this.savedAs(2);
        }
        return this.savedAs(3);
    }

    protected boolean savedAs(int n) {
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n2 = 0;
        while (n2 < openedDocumentHookArray.length) {
            try {
                openedDocumentHookArray[n2].documentSavedAs(this, n);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
            }
            ++n2;
        }
        DocumentHook[] documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].documentSavedAs(this.document, n);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return n == 2;
    }

    public Document savingCopy(URL uRL) {
        DocumentHook[] documentHookArray;
        if (this.savedDoc != null && this.location.equals(uRL)) {
            return this.saving() ? new Document() : null;
        }
        DocumentUtil.commitChanges(this.document);
        Document document = (Document)this.document.copy();
        document.removeProperties(2432);
        boolean bl = true;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                bl = openedDocumentHookArray[n].savingDocumentCopy(this, document, uRL);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            if (!bl) {
                int n2 = 0;
                while (n2 <= n) {
                    try {
                        openedDocumentHookArray[n2].documentCopySaved(this, 1);
                    }
                    catch (Throwable throwable) {
                        OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (bl && (documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS")) != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].savingDocumentCopy(this.document, document, uRL);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return bl ? document : null;
    }

    public boolean saveCopy(Document document, URL uRL) {
        if (this.savedDoc != null && this.location.equals(uRL)) {
            return this.save();
        }
        SavedDocument savedDocument = this.createSavedDocument(document, uRL);
        if (savedDocument == null) {
            return this.copySaved(3);
        }
        boolean bl = savedDocument.initialize(uRL);
        if (bl) {
            this.copySaved(2);
            savedDocument.dispose();
            return true;
        }
        return this.copySaved(3);
    }

    protected boolean copySaved(int n) {
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n2 = 0;
        while (n2 < openedDocumentHookArray.length) {
            try {
                openedDocumentHookArray[n2].documentCopySaved(this, n);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
            }
            ++n2;
        }
        DocumentHook[] documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].documentCopySaved(this.document, n);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return n == 2;
    }

    public void setDiagnostics(Diagnostic[] diagnosticArray) {
        if (diagnosticArray != null && diagnosticArray.length == 0) {
            diagnosticArray = null;
        }
        this.diagnostics = diagnosticArray;
        this.app.validityStateChanged(this);
    }

    public Diagnostic[] getDiagnostics() {
        return this.diagnostics;
    }

    public int getDiagnosticSeverity() {
        if (this.diagnostics == null) {
            return 0;
        }
        return DiagnosticsUtil.getDiagnosticSeverity(this.diagnostics);
    }

    public boolean canCheckValidity() {
        return DiagnosticsUtil.canCheckDocument(this.document);
    }

    public Diagnostic[] checkValidity() {
        this.app.showStatus(Msg.msg("checkingDocument", this.getLabel()), false);
        if (!this.checkingValidity()) {
            this.app.showStatus("");
            return null;
        }
        Diagnostic[] diagnosticArray = DiagnosticsUtil.checkDocument(this.document);
        diagnosticArray = this.validityChecked(2, diagnosticArray);
        this.setDiagnostics(diagnosticArray);
        if (diagnosticArray == null || diagnosticArray.length == 0) {
            this.app.showStatus(Msg.msg("documentChecked", this.getLabel()), true);
            return null;
        }
        this.app.showStatus(Msg.msg("documentNotChecked", this.getLabel()), true);
        return diagnosticArray;
    }

    protected boolean checkingValidity() {
        DocumentHook[] documentHookArray;
        DocumentUtil.commitChanges(this.document);
        boolean bl = true;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                bl = openedDocumentHookArray[n].checkingDocument(this);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            if (!bl) {
                int n2 = 0;
                while (n2 <= n) {
                    try {
                        openedDocumentHookArray[n2].documentChecked(this, 1, null);
                    }
                    catch (Throwable throwable) {
                        OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (bl && (documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS")) != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].checkingDocument(this.document);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return bl;
    }

    protected Diagnostic[] validityChecked(int n, Diagnostic[] diagnosticArray) {
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n2 = 0;
        while (n2 < openedDocumentHookArray.length) {
            try {
                diagnosticArray = openedDocumentHookArray[n2].documentChecked(this, n, diagnosticArray);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
            }
            ++n2;
        }
        DocumentHook[] documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    diagnosticArray = documentHookArray[n3].documentChecked(this.document, n, diagnosticArray);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return diagnosticArray;
    }

    public boolean closing() {
        DocumentHook[] documentHookArray;
        boolean bl = true;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                bl = openedDocumentHookArray[n].closingDocument(this);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            if (!bl) {
                int n2 = 0;
                while (n2 <= n) {
                    try {
                        openedDocumentHookArray[n2].documentClosed(this, 1);
                    }
                    catch (Throwable throwable) {
                        OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
                    }
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (bl && (documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS")) != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].closingDocument(this.document);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return bl;
    }

    public void close() {
        this.app.removeOpenedDocument(this);
    }

    public void dispose() {
        if (this.savedDoc != null) {
            this.savedDoc.dispose();
            this.savedDoc = null;
        }
        this.document = null;
        this.location = null;
        this.structuredFormat = null;
        this.configuration = null;
        this.needSave = false;
        this.modificationCount = 0;
        this.lastSaved = -1L;
        this.lastModified = -1L;
        this.diagnostics = null;
        this.batchModified = false;
        this.batchEditing = false;
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n = 0;
        while (n < openedDocumentHookArray.length) {
            try {
                openedDocumentHookArray[n].documentDisposed(this);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n], throwable);
            }
            ++n;
        }
    }

    public boolean closed(int n) {
        OpenedDocumentHook[] openedDocumentHookArray = this.app.getOpenedDocumentHooks();
        int n2 = 0;
        while (n2 < openedDocumentHookArray.length) {
            try {
                openedDocumentHookArray[n2].documentClosed(this, n);
            }
            catch (Throwable throwable) {
                OpenedDocument.reportHookError(openedDocumentHookArray[n2], throwable);
            }
            ++n2;
        }
        DocumentHook[] documentHookArray = (DocumentHook[])this.document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            int n3 = 0;
            while (n3 < documentHookArray.length) {
                try {
                    documentHookArray[n3].documentClosed(this.document, n);
                }
                catch (Throwable throwable) {
                    OpenedDocument.reportHookError(documentHookArray[n3], throwable);
                }
                ++n3;
            }
        }
        return n == 2;
    }

    public void batchEditingStarted(BatchEditingEvent batchEditingEvent, int n) {
        this.batchEditing = true;
        this.batchModified = false;
    }

    public void batchEditingCompleted(BatchEditingEvent batchEditingEvent, int n) {
        this.batchEditing = false;
        if (this.batchModified) {
            this.batchModified = false;
            ++this.modificationCount;
            this.lastModified = System.currentTimeMillis();
            if (!this.needSave) {
                this.setNeedSave(true);
            }
        }
    }

    protected void setNeedSave(boolean bl) {
        this.needSave = bl;
        this.app.saveStateChanged(this);
    }

    public void textChanged(TextEvent textEvent, int n) {
        if (this.batchEditing) {
            this.batchModified = true;
        } else {
            ++this.modificationCount;
            this.lastModified = System.currentTimeMillis();
            if (!this.needSave) {
                this.setNeedSave(true);
            }
        }
    }

    public void elementAttributeChanged(ElementAttributeEvent elementAttributeEvent, int n) {
        if (this.batchEditing) {
            this.batchModified = true;
        } else {
            ++this.modificationCount;
            this.lastModified = System.currentTimeMillis();
            if (!this.needSave) {
                this.setNeedSave(true);
            }
        }
    }

    public void elementStructureChanged(ElementStructureEvent elementStructureEvent, int n) {
        if (this.batchEditing) {
            this.batchModified = true;
        } else {
            ++this.modificationCount;
            this.lastModified = System.currentTimeMillis();
            if (!this.needSave) {
                this.setNeedSave(true);
            }
        }
    }

    public void processingInstructionChanged(ProcessingInstructionEvent processingInstructionEvent, int n) {
        if (this.batchEditing) {
            this.batchModified = true;
        } else {
            ++this.modificationCount;
            this.lastModified = System.currentTimeMillis();
            if (!this.needSave) {
                this.setNeedSave(true);
            }
        }
    }

    public void customEventHappened(DocumentEvent documentEvent, int n) {
        switch (documentEvent.getId()) {
            case 103: {
                if (this.needSave) break;
                this.setNeedSave(true);
                break;
            }
            case 105: {
                ++this.modificationCount;
                this.lastModified = System.currentTimeMillis();
                this.app.namespacePrefixesChanged(this);
                if (this.needSave) break;
                this.setNeedSave(true);
                break;
            }
            case 150: {
                this.updateEditActions("recordMacro");
                break;
            }
            case 200: 
            case 201: 
            case 202: 
            case 203: {
                this.updateEditActions("spreadsheet");
            }
        }
    }

    protected void updateEditActions(String string) {
        if (this != this.app.getActiveOpenedDocument()) {
            return;
        }
        AppPart[] appPartArray = this.app.getParts();
        int n = 0;
        while (n < appPartArray.length) {
            EditAction editAction;
            AppPart appPart = appPartArray[n];
            if (appPart instanceof EditAction && (editAction = (EditAction)appPart).getCommandName().equals(string)) {
                editAction.updateEnabled();
            }
            ++n;
        }
    }

    public void contextChanged(ContextChangeEvent contextChangeEvent) {
        this.app.editingContextChanged(this);
    }

    public void undoManagerChange(UndoManagerEvent undoManagerEvent) {
        this.app.undoStateChanged(this);
    }
}

