/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.jclark.xml.parse.NotWellFormedException;
import com.xmlmind.xmledit.edit.ResourceScanner;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.kit.Msg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ResourceScannerDialog
extends JDialog
implements ActionListener {
    private Component dialogAnchor;
    private JLabel message1;
    private JLabel message2;
    private JLabel message3;
    private JTextPane console;
    private JButton cancelButton;
    private static final int ENTITY_RESOURCE_STYLE = 0;
    private static final int XINCLUDE_RESOURCE_STYLE = 1;
    private static final int APPLICATION_RESOURCE_STYLE = 2;
    private static final int ERROR_STYLE = 3;
    private static final int INFO_STYLE = 4;
    SimpleAttributeSet entityResourceStyle;
    SimpleAttributeSet xincludeResourceStyle;
    SimpleAttributeSet errorStyle;
    SimpleAttributeSet infoStyle;
    private boolean autoCloseWhenDone;
    private static final int SCANNING = 0;
    private static final int CANCELING = 1;
    private static final int DONE = 2;
    private int state;
    private ResourceScanner.Resource[] result;
    private static final String NO_MESSAGE = "\u00a0\u00a0\u00a0";
    private static final int WORKING = 0;
    private static final int SUCCESS = 1;
    private static final int FAILED = 2;
    private static final int CANCELED = 3;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$kit$ResourceScannerDialog;

    public ResourceScannerDialog(Dialog dialog) {
        super(dialog, Msg.msg("scan.title"), true);
        this.initialize(dialog);
    }

    public ResourceScannerDialog(Component component) {
        super(AWTUtil.getFrame(component), Msg.msg("scan.title"), true);
        this.initialize(component);
    }

    private void initialize(Component component) {
        this.dialogAnchor = AWTUtil.getDialogAnchor(component);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ResourceScannerDialog.this.cancel();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(new ImageIcon((class$com$xmlmind$xmleditapp$kit$ResourceScannerDialog == null ? (class$com$xmlmind$xmleditapp$kit$ResourceScannerDialog = ResourceScannerDialog.class$("com.xmlmind.xmleditapp.kit.ResourceScannerDialog")) : class$com$xmlmind$xmleditapp$kit$ResourceScannerDialog).getResource("scanning.gif")));
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.message1 = new JLabel("________________________________________");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.message1, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.message2 = new JLabel("________________________________________");
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)this.message2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.message3 = new JLabel("________________________________________");
        jPanel.add((Component)this.message3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.console = new JTextPane();
        this.console.setFont(new Font("SansSerif", 0, 10));
        this.console.setBackground(Color.white);
        this.console.setForeground(Color.black);
        this.console.setEditable(false);
        this.entityResourceStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.entityResourceStyle, new Color(0, 128, 0));
        this.xincludeResourceStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.xincludeResourceStyle, new Color(0, 0, 128));
        this.errorStyle = new SimpleAttributeSet();
        StyleConstants.setBackground(this.errorStyle, new Color(255, 192, 192));
        StyleConstants.setBold(this.errorStyle, true);
        this.infoStyle = new SimpleAttributeSet();
        StyleConstants.setBold(this.infoStyle, true);
        JScrollPane jScrollPane = new JScrollPane(this.console);
        FontMetrics fontMetrics = this.console.getFontMetrics(this.console.getFont());
        jScrollPane.setPreferredSize(new Dimension(fontMetrics.charWidth('x') * 81, fontMetrics.getHeight() * 21));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.cancelButton = new JButton();
        DialogUtil.setCancelText(this.cancelButton);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.pack();
        this.setResizable(true);
    }

    public ResourceScanner.Resource[] getResources(ResourceScanner resourceScanner, URL[] uRLArray, boolean bl) {
        this.autoCloseWhenDone = bl;
        this.setMessages(Msg.msg("scan.scanning"), uRLArray.length > 0 ? URLUtil.toShortLabel(uRLArray[0], 40) : NO_MESSAGE, Msg.msg("scan.pleaseWait"));
        Document document = this.console.getEditorKit().createDefaultDocument();
        this.console.setDocument(document);
        this.console.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.setLocationRelativeTo(this.dialogAnchor);
        this.pack();
        this.state = 0;
        ScanThread scanThread = new ScanThread(resourceScanner, uRLArray);
        scanThread.start();
        this.setVisible(true);
        return this.result;
    }

    private void setMessages(String string, String string2, String string3) {
        this.message1.setText(string);
        this.message2.setText(string2);
        this.message3.setText(string3);
    }

    private void addLines(String[] stringArray, int[] nArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addLine(stringArray[n], nArray[n]);
            ++n;
        }
    }

    private void addLine(String string, int n) {
        SimpleAttributeSet simpleAttributeSet;
        switch (n) {
            case 0: {
                simpleAttributeSet = this.entityResourceStyle;
                break;
            }
            case 1: {
                simpleAttributeSet = this.xincludeResourceStyle;
                break;
            }
            case 3: {
                simpleAttributeSet = this.errorStyle;
                break;
            }
            case 4: {
                simpleAttributeSet = this.infoStyle;
                break;
            }
            default: {
                simpleAttributeSet = null;
            }
        }
        Document document = this.console.getDocument();
        try {
            document.insertString(document.getLength(), string + "\n", simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("cancel")) {
            this.cancel();
        }
    }

    private void cancel() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.cancelButton.setEnabled(false);
                DialogUtil.setCloseText(this.cancelButton);
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void setDone(int n, ResourceScanner.Resource[] resourceArray) {
        this.state = 2;
        this.result = resourceArray;
        DialogUtil.setCloseText(this.cancelButton);
        this.cancelButton.setEnabled(true);
        if (n == 1 && this.autoCloseWhenDone) {
            Timer timer = new Timer(500, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceScannerDialog.this.setVisible(false);
                    ResourceScannerDialog.this.dispose();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$300(ResourceScannerDialog resourceScannerDialog, String string, String string2, String string3) {
        resourceScannerDialog.setMessages(string, string2, string3);
    }

    static /* synthetic */ void access$400(ResourceScannerDialog resourceScannerDialog, String[] stringArray, int[] nArray) {
        resourceScannerDialog.addLines(stringArray, nArray);
    }

    static /* synthetic */ void access$500(ResourceScannerDialog resourceScannerDialog, int n, ResourceScanner.Resource[] resourceArray) {
        resourceScannerDialog.setDone(n, resourceArray);
    }

    private final class ScanThread
    extends Thread {
        private ResourceScanner scanner;
        private URL[] docURLs;

        public ScanThread(ResourceScanner resourceScanner, URL[] uRLArray) {
            this.scanner = resourceScanner;
            this.docURLs = uRLArray;
        }

        public void run() {
            ResourceScanner.Resource[] resourceArray;
            int n = 0;
            ArrayList<ResourceScanner.Resource> arrayList = new ArrayList<ResourceScanner.Resource>();
            int n2 = 0;
            while (n2 < this.docURLs.length) {
                if (ResourceScannerDialog.this.state == 1) {
                    n = 3;
                    break;
                }
                this.setMessages(Msg.msg("scan.scanning"), URLUtil.toShortLabel(this.docURLs[n2], 40), Msg.msg("scan.pleaseWait"));
                resourceArray = null;
                String string = null;
                try {
                    resourceArray = this.scanner.scan(this.docURLs[n2]);
                }
                catch (NotWellFormedException notWellFormedException) {
                    string = Msg.msg("parseError", notWellFormedException.getEntityLocation(), new Integer(notWellFormedException.getLineNumber()), new Integer(notWellFormedException.getColumnNumber()), notWellFormedException.getMessageWithoutLocation());
                }
                catch (IOException iOException) {
                    string = MiscUtil.reason(iOException);
                }
                catch (Exception exception) {
                    string = MiscUtil.detailedReason(exception);
                }
                if (string != null) {
                    n = 2;
                    this.addLines(new String[]{Msg.msg("cannotOpen", URLUtil.toLabel(this.docURLs[n2]), string)}, new int[]{3});
                    break;
                }
                if (resourceArray.length > 1) {
                    Arrays.sort(resourceArray, new Comparator(this){
                        private final /* synthetic */ ScanThread this$1;
                        {
                            this.this$1 = scanThread;
                        }

                        public int compare(Object object, Object object2) {
                            ResourceScanner.Resource resource = (ResourceScanner.Resource)object;
                            ResourceScanner.Resource resource2 = (ResourceScanner.Resource)object2;
                            return resource.getSystemId().compareTo(resource2.getSystemId());
                        }
                    });
                }
                if (resourceArray.length > 0) {
                    String[] stringArray = new String[1 + resourceArray.length];
                    int[] nArray = new int[1 + resourceArray.length];
                    stringArray[0] = Msg.msg("scan.relativePaths", URLUtil.toLabel(this.docURLs[n2]));
                    stringArray[0] = "\n" + stringArray[0] + "\n";
                    nArray[0] = 4;
                    int n3 = 0;
                    while (n3 < resourceArray.length) {
                        ResourceScanner.Resource resource = resourceArray[n3];
                        arrayList.add(resource);
                        stringArray[1 + n3] = resource.getSystemId();
                        switch (resource.getType()) {
                            case 0: {
                                nArray[1 + n3] = 0;
                                break;
                            }
                            case 1: {
                                nArray[1 + n3] = 1;
                                break;
                            }
                            default: {
                                nArray[1 + n3] = 2;
                            }
                        }
                        ++n3;
                    }
                    this.addLines(stringArray, nArray);
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
            if (ResourceScannerDialog.this.state == 1) {
                n = 3;
            }
            if (n == 0) {
                n = 1;
                resourceArray = new ResourceScanner.Resource[arrayList.size()];
                arrayList.toArray(resourceArray);
                this.setMessages(Msg.msg("scan.foundResources", new Integer(resourceArray.length)), ResourceScannerDialog.NO_MESSAGE, ResourceScannerDialog.NO_MESSAGE);
            } else {
                resourceArray = null;
                if (n == 3) {
                    this.setMessages(Msg.msg("scan.canceledByUser"), ResourceScannerDialog.NO_MESSAGE, ResourceScannerDialog.NO_MESSAGE);
                } else {
                    this.setMessages(Msg.msg("scan.stoppedOnError"), ResourceScannerDialog.NO_MESSAGE, ResourceScannerDialog.NO_MESSAGE);
                }
            }
            this.setDone(n, resourceArray);
        }

        private void setMessages(String string, String string2, String string3) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this, string, string2, string3){
                    private final /* synthetic */ String val$msg1;
                    private final /* synthetic */ String val$msg2;
                    private final /* synthetic */ String val$msg3;
                    private final /* synthetic */ ScanThread this$1;
                    {
                        this.this$1 = scanThread;
                        this.val$msg1 = string;
                        this.val$msg2 = string2;
                        this.val$msg3 = string3;
                    }

                    public void run() {
                        ResourceScannerDialog.access$300(ScanThread.access$200(this.this$1), this.val$msg1, this.val$msg2, this.val$msg3);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }

        private void addLines(String[] stringArray, int[] nArray) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this, stringArray, nArray){
                    private final /* synthetic */ String[] val$lines;
                    private final /* synthetic */ int[] val$styles;
                    private final /* synthetic */ ScanThread this$1;
                    {
                        this.this$1 = scanThread;
                        this.val$lines = stringArray;
                        this.val$styles = nArray;
                    }

                    public void run() {
                        ResourceScannerDialog.access$400(ScanThread.access$200(this.this$1), this.val$lines, this.val$styles);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }

        private void setDone(int n, ResourceScanner.Resource[] resourceArray) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this, n, resourceArray){
                    private final /* synthetic */ int val$status;
                    private final /* synthetic */ ResourceScanner.Resource[] val$resources;
                    private final /* synthetic */ ScanThread this$1;
                    {
                        this.this$1 = scanThread;
                        this.val$status = n;
                        this.val$resources = resourceArray;
                    }

                    public void run() {
                        ResourceScannerDialog.access$500(ScanThread.access$200(this.this$1), this.val$status, this.val$resources);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }

        static /* synthetic */ ResourceScannerDialog access$200(ScanThread scanThread) {
            return scanThread.ResourceScannerDialog.this;
        }
    }
}

