/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.edit.ResourceScanner;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.Bitmap;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.MultiLineLabel;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.ResourceInfo;
import com.xmlmind.xmleditapp.kit.ResourceScannerDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ResourcesDialog
extends DialogBase
implements MouseListener {
    private JLabel docLabel;
    private JLabel saveLabel;
    private ResourceTableModel tableModel;
    private JTable table;
    private URL docURL;
    private URL saveURL;
    private ResourceScanner resourceScanner;
    private ResourceInfo[] result = null;
    private static final ResourceAction[] RESOURCE_ACTIONS = new ResourceAction[]{new ResourceAction(Msg.msg("res.ignore"), 0), new ResourceAction(Msg.msg("res.reference"), 1), new ResourceAction(Msg.msg("res.copy"), 2)};
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$kit$ResourcesDialog;

    public ResourcesDialog(Component component) {
        super(component, Msg.msg("res.title"), true);
        this.initialize(component, 90);
    }

    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(new ImageIcon((class$com$xmlmind$xmleditapp$kit$ResourcesDialog == null ? (class$com$xmlmind$xmleditapp$kit$ResourcesDialog = ResourcesDialog.class$("com.xmlmind.xmleditapp.kit.ResourcesDialog")) : class$com$xmlmind$xmleditapp$kit$ResourcesDialog).getResource("resources.gif")));
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Msg.msg("res.document"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.docLabel = new JLabel("<Source URL>");
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        jPanel.add((Component)this.docLabel, gridBagConstraints);
        jLabel = new JLabel(Msg.msg("res.savedAs"));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.saveLabel = new JLabel("<Destination URL>");
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.saveLabel, gridBagConstraints);
        MultiLineLabel multiLineLabel = new MultiLineLabel(Msg.msg("res.question"));
        multiLineLabel.setFont(jLabel.getFont());
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        jPanel.add((Component)multiLineLabel, gridBagConstraints);
        JScrollPane jScrollPane = this.createTable();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.table.addMouseListener(this);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        String string = Msg.msg("res.ignoreAll");
        JButton jButton = new JButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(jButton, string);
        jButton.setActionCommand("ignoreAll");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        string = Msg.msg("res.referenceAll");
        jButton = new JButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(jButton, string);
        jButton.setActionCommand("referenceAll");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        string = Msg.msg("res.copyAll");
        jButton = new JButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(jButton, string);
        jButton.setActionCommand("copyAll");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        return jPanel;
    }

    public ResourceInfo[] getResources(ResourceInfo[] resourceInfoArray, URL uRL, URL uRL2, ResourceScanner resourceScanner) {
        this.docURL = uRL;
        this.saveURL = uRL2;
        this.resourceScanner = resourceScanner;
        this.docLabel.setText(URLUtil.toLabel(uRL));
        this.saveLabel.setText(URLUtil.toLabel(uRL2));
        ((ResourceTableModel)this.table.getModel()).setResources(resourceInfoArray);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.table.requestFocus();
        this.setVisible(true);
        return this.result;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.listSubResources(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.listSubResources(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void listSubResources(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = mouseEvent.getPoint();
            int n = this.table.rowAtPoint(point);
            int n2 = this.table.columnAtPoint(point);
            if (n >= 0 && n2 == 0) {
                ResourceInfo resourceInfo = ((ResourceTableModel)this.table.getModel()).getResource(n);
                if (resourceInfo.includedElement != null && this.resourceScanner != null) {
                    ResourceScannerDialog resourceScannerDialog = new ResourceScannerDialog(this);
                    resourceScannerDialog.getResources(this.resourceScanner, new URL[]{resourceInfo.getLocation()}, false);
                }
            }
        }
    }

    public void ignoreAll() {
        this.changeAllActions(0);
    }

    public void referenceAll() {
        this.changeAllActions(1);
    }

    public void copyAll() {
        this.changeAllActions(2);
    }

    private void changeAllActions(int n) {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
            return;
        }
        this.table.clearSelection();
        ResourceTableModel resourceTableModel = (ResourceTableModel)this.table.getModel();
        ResourceInfo[] resourceInfoArray = resourceTableModel.getResources();
        int n2 = 0;
        while (n2 < resourceInfoArray.length) {
            ResourceInfo resourceInfo = resourceInfoArray[n2];
            resourceInfo.action = n;
            switch (n) {
                case 0: {
                    resourceInfo.newLocation = resourceInfo.location;
                    break;
                }
                case 1: {
                    resourceInfo.newLocation = resourceInfo.referenceAs;
                    break;
                }
                default: {
                    resourceInfo.newLocation = resourceInfo.copyTo;
                }
            }
            if (resourceInfo.newLocation == null) {
                resourceInfo.newLocation = "";
            }
            ++n2;
        }
        resourceTableModel.fireTableDataChanged();
    }

    public void ok() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
            return;
        }
        this.table.clearSelection();
        ResourceInfo[] resourceInfoArray = ((ResourceTableModel)this.table.getModel()).getResources();
        ArrayList<ResourceInfo> arrayList = new ArrayList<ResourceInfo>();
        HashMap<URL, ResourceInfo> hashMap = new HashMap<URL, ResourceInfo>();
        String string = null;
        int n = -1;
        int n2 = 0;
        block3: while (n2 < resourceInfoArray.length) {
            ResourceInfo resourceInfo = resourceInfoArray[n2];
            switch (resourceInfo.action) {
                case 1: 
                case 2: {
                    String string2 = resourceInfo.location;
                    String string3 = resourceInfo.newLocation = resourceInfo.newLocation.trim();
                    URL uRL = resourceInfo.getLocation();
                    if (uRL == null) {
                        n = n2;
                        string = Msg.msg("res.invalidLocation", string2);
                        break block3;
                    }
                    if (string3.length() == 0) {
                        n = n2;
                        string = Msg.msg("res.missingNewLocation", string2);
                        break block3;
                    }
                    URL uRL2 = resourceInfo.getNewLocation(this.saveURL);
                    if (uRL2 == null) {
                        n = n2;
                        string = Msg.msg("res.invalidLocation", string3);
                        break block3;
                    }
                    arrayList.add(resourceInfo);
                    if (resourceInfo.action == 2) {
                        if (!ResourcesDialog.fileExists(uRL)) {
                            n = n2;
                            string = Msg.msg("res.missingResource", string2);
                            break block3;
                        }
                        if (uRL2.equals(uRL)) {
                            n = n2;
                            string = Msg.msg("res.cannotCopyToItself", string2);
                            break block3;
                        }
                        ResourceInfo resourceInfo2 = (ResourceInfo)hashMap.get(uRL2);
                        if (resourceInfo2 != null) {
                            n = n2;
                            string = Msg.msg("res.cannotCopyToSameLocation", resourceInfo2.location, string2, string3);
                            break block3;
                        }
                        hashMap.put(uRL2, resourceInfo);
                    }
                }
                default: {
                    ++n2;
                }
            }
        }
        if (string != null) {
            this.table.requestFocus();
            this.table.setRowSelectionInterval(n, n);
            Alert.showError(this, string);
            return;
        }
        this.result = new ResourceInfo[arrayList.size()];
        arrayList.toArray(this.result);
        this.setVisible(false);
        this.dispose();
    }

    private static final boolean fileExists(URL uRL) {
        File file = FileUtil.urlToFile(uRL);
        if (file == null) {
            return true;
        }
        return file.exists();
    }

    public void cancel() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    private JScrollPane createTable() {
        this.tableModel = new ResourceTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(4);
        this.table.setShowGrid(true);
        Font font = this.table.getFont();
        font = new Font(font.getFamily(), 0, Math.max(10, font.getSize() - 1));
        this.table.setFont(font);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        FontMetrics fontMetrics = this.table.getFontMetrics(font);
        int n = 10 + 40 * fontMetrics.charWidth('x');
        String string = Msg.msg("res.source");
        int n2 = fontMetrics.stringWidth(string);
        if (n2 < n) {
            n2 = n;
        }
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setHeaderValue(string);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setResizable(true);
        Color color = this.table.getForeground();
        tableColumn.setCellRenderer(new SrcLocationRenderer(color));
        string = Msg.msg("res.action");
        int n3 = fontMetrics.stringWidth(string);
        int n4 = 0;
        while (n4 < RESOURCE_ACTIONS.length) {
            int n5 = fontMetrics.stringWidth(ResourcesDialog.RESOURCE_ACTIONS[n4].label) + 20;
            if (n3 < n5) {
                n3 = n5;
            }
            ++n4;
        }
        JComboBox<ResourceAction> jComboBox = new JComboBox<ResourceAction>(RESOURCE_ACTIONS);
        jComboBox.setFont(font);
        Dimension dimension = jComboBox.getPreferredSize();
        if (n3 < dimension.width) {
            n3 = dimension.width;
        }
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setHeaderValue(string);
        tableColumn.setPreferredWidth(n3);
        tableColumn.setResizable(false);
        tableColumn.setCellRenderer(new ActionRenderer(color));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        defaultCellEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(defaultCellEditor);
        string = Msg.msg("res.destination");
        int n6 = fontMetrics.stringWidth(string);
        if (n6 < n) {
            n6 = n;
        }
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setHeaderValue(string);
        tableColumn.setPreferredWidth(n6);
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(new DstLocationRenderer());
        JTextField jTextField = new JTextField();
        jTextField.setFont(font);
        defaultCellEditor = new DefaultCellEditor(jTextField);
        defaultCellEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(defaultCellEditor);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(n2 + n3 + n6 + 15, 11 * fontMetrics.getHeight()));
        return jScrollPane;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class DstLocationRenderer
    extends DefaultTableCellRenderer {
        private DstLocationRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ResourceInfo[] resourceInfoArray = ((ResourceTableModel)jTable.getModel()).getResources();
            ResourceInfo resourceInfo = resourceInfoArray[n];
            this.setEnabled(resourceInfo.action != 0);
            return this;
        }
    }

    private static final class ActionRenderer
    extends DefaultTableCellRenderer {
        private static final Bitmap dropdownBitmap = new Bitmap(7, 7, new byte[]{0, 0, 127, 62, 28, 8, 0});

        public ActionRenderer(Color color) {
            this.setIcon(new ImageIcon(dropdownBitmap.getImage(color)));
            this.setIconTextGap(2);
            this.setHorizontalTextPosition(10);
        }
    }

    private static final class SrcLocationRenderer
    extends DefaultTableCellRenderer {
        private static final Bitmap rightBitmap = new Bitmap(10, 7, new byte[]{6, 0, 30, 0, 126, 0, -2, 0, 126, 0, 30, 0, 6, 0});
        private static final Bitmap emptyBitmap = new Bitmap(10, 7, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        private Color appResColor;
        private Color entityColor;
        private Color xincludeColor;
        private Icon appResIcon;
        private Icon entityIcon;
        private Icon xincludeIcon;

        public SrcLocationRenderer(Color color) {
            this.appResColor = color;
            this.entityColor = new Color(color.getRed(), Math.min(255, color.getGreen() + 128), color.getBlue());
            this.xincludeColor = new Color(color.getRed(), color.getGreen(), Math.min(255, color.getBlue() + 128));
            this.appResIcon = new ImageIcon(emptyBitmap.getImage(this.appResColor));
            this.entityIcon = new ImageIcon(rightBitmap.getImage(this.entityColor));
            this.xincludeIcon = new ImageIcon(rightBitmap.getImage(this.xincludeColor));
            this.setIconTextGap(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ResourceInfo[] resourceInfoArray = ((ResourceTableModel)jTable.getModel()).getResources();
            ResourceInfo resourceInfo = resourceInfoArray[n];
            if (resourceInfo.includedElement != null) {
                if (resourceInfo.isXInclude) {
                    this.setForeground(this.xincludeColor);
                    this.setIcon(this.xincludeIcon);
                } else {
                    this.setForeground(this.entityColor);
                    this.setIcon(this.entityIcon);
                }
            } else {
                this.setForeground(this.appResColor);
                this.setIcon(this.appResIcon);
            }
            return this;
        }
    }

    private static final class ResourceTableModel
    extends AbstractTableModel {
        private ResourceInfo[] resources = new ResourceInfo[0];

        private ResourceTableModel() {
        }

        public void setResources(ResourceInfo[] resourceInfoArray) {
            if (resourceInfoArray == null) {
                this.resources = new ResourceInfo[0];
            } else {
                this.resources = new ResourceInfo[resourceInfoArray.length];
                int n = 0;
                while (n < resourceInfoArray.length) {
                    ResourceInfo resourceInfo = resourceInfoArray[n].copy();
                    resourceInfo.newLocation = resourceInfo.action == 2 ? resourceInfo.copyTo : resourceInfo.referenceAs;
                    if (resourceInfo.newLocation == null) {
                        resourceInfo.newLocation = "";
                    }
                    this.resources[n] = resourceInfo;
                    ++n;
                }
                if (this.resources.length > 1) {
                    Arrays.sort(this.resources, new Comparator(){

                        public int compare(Object object, Object object2) {
                            ResourceInfo resourceInfo = (ResourceInfo)object;
                            ResourceInfo resourceInfo2 = (ResourceInfo)object2;
                            if (resourceInfo.includedElement != resourceInfo2.includedElement) {
                                return resourceInfo.includedElement == null ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                            }
                            return resourceInfo.location.compareTo(resourceInfo2.location);
                        }
                    });
                }
            }
            this.fireTableDataChanged();
        }

        public ResourceInfo[] getResources() {
            return this.resources;
        }

        public ResourceInfo getResource(int n) {
            return this.resources[n];
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.resources.length;
        }

        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            ResourceInfo resourceInfo = this.resources[n];
            return resourceInfo.action != 0;
        }

        public Object getValueAt(int n, int n2) {
            ResourceInfo resourceInfo = this.resources[n];
            switch (n2) {
                case 0: {
                    return resourceInfo.location;
                }
                case 1: {
                    return RESOURCE_ACTIONS[resourceInfo.action];
                }
            }
            return resourceInfo.newLocation;
        }

        public void setValueAt(Object object, int n, int n2) {
            ResourceInfo resourceInfo = this.resources[n];
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    resourceInfo.action = ((ResourceAction)object).action;
                    switch (resourceInfo.action) {
                        case 0: {
                            resourceInfo.newLocation = resourceInfo.location;
                            break;
                        }
                        case 1: {
                            resourceInfo.newLocation = resourceInfo.referenceAs;
                            if (resourceInfo.newLocation != null) break;
                            resourceInfo.newLocation = "";
                            break;
                        }
                        default: {
                            resourceInfo.newLocation = resourceInfo.copyTo;
                            if (resourceInfo.newLocation != null) break;
                            resourceInfo.newLocation = "";
                        }
                    }
                    this.fireTableCellUpdated(n, 1);
                    this.fireTableCellUpdated(n, 2);
                    break;
                }
                default: {
                    resourceInfo.newLocation = (String)object;
                    this.fireTableCellUpdated(n, 2);
                }
            }
        }
    }

    private static final class ResourceAction {
        public String label;
        public int action;

        public ResourceAction(String string, int n) {
            this.label = string;
            this.action = n;
        }

        public String toString() {
            return this.label;
        }
    }
}

