/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.doc.CharRange;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.edit.SaveOptions;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.SaveOptionsInfo;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.spreadsheet.SpreadsheetHelper;
import com.xmlmind.xmleditapp.structformat.StructuredFormat;
import com.xmlmind.xmleditapp.structformat.StructuredFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

public class SaveDocument {
    protected App app;
    protected StructuredFormat structuredFormat;
    protected Configuration configuration;

    public SaveDocument(App app, StructuredFormat structuredFormat, Configuration configuration) {
        this.app = app;
        this.structuredFormat = structuredFormat;
        this.configuration = configuration;
    }

    public App getApp() {
        return this.app;
    }

    public StructuredFormat getStructuredFormat() {
        return this.structuredFormat;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean saveDocument(Document document, File file) {
        String string = null;
        try {
            this.doSaveDocument(document, file);
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        if (string != null) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotSave", file, string));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveDocument(Document document, File file) throws IOException, StructuredFormatException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        URL uRL = FileUtil.fileToURL(file);
        try {
            this.doSaveDocument(document, fileOutputStream, uRL);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    public void doSaveDocument(Document document, OutputStream outputStream, URL uRL) throws IOException, StructuredFormatException {
        if (this.structuredFormat == null) {
            SaveOptions saveOptions = this.getSaveOptions(document);
            DocumentUtil.saveDocument(document, outputStream, saveOptions);
        } else {
            this.structuredFormat.saveDocument(document, outputStream, uRL, null);
        }
        outputStream.flush();
    }

    public SaveOptions getSaveOptions(Document document) {
        if (this.structuredFormat == null) {
            Object object;
            SaveOptionsInfo saveOptionsInfo = null;
            int n = 0;
            if (this.configuration != null && (saveOptionsInfo = (SaveOptionsInfo)this.configuration.get("saveOptions")) != null) {
                n = saveOptionsInfo.getOptions();
            }
            Preferences preferences = this.app.getPreferences();
            boolean bl = saveOptionsInfo != null && !preferences.getBoolean("overrideConfiguration", false);
            SaveOptions saveOptions = new SaveOptions();
            saveOptions.preserveEntityRefs = true;
            saveOptions.preserveXIncludes = true;
            saveOptions.usePreferredPrefixes = true;
            saveOptions.useDefaultNamespace = true;
            saveOptions.xmlEncoding = bl && (n & 1) != 0 ? saveOptionsInfo.getEncoding() : preferences.getString("encoding", "UTF-8");
            saveOptions.indent = bl && (n & 2) != 0 ? saveOptionsInfo.getIndent() : preferences.getInt("indent", -1, 16, 2);
            saveOptions.maxLineLength = bl && (n & 4) != 0 ? saveOptionsInfo.getMaxLineLength() : preferences.getInt("maxLineLength", 40, Integer.MAX_VALUE, 78);
            saveOptions.addOpenLines = bl && (n & 8) != 0 ? saveOptionsInfo.isAddingOpenLines() : preferences.getBoolean("addOpenLines", true);
            saveOptions.saveCharsAsEntityRefs = bl && (n & 0x20) != 0 ? saveOptionsInfo.getSaveCharsAsEntityRefs() : preferences.getBoolean("saveCharsAsEntityRefs", true);
            saveOptions.charsSavedAsEntityRefs = bl && (n & 0x40) != 0 ? saveOptionsInfo.getCharsSavedAsEntityRefs() : ((object = preferences.getString("charsSavedAsEntityRefs", null)) != null ? CharRange.parseRanges((String)object) : null);
            saveOptions.favorInteroperability = bl && (n & 0x80) != 0 ? saveOptionsInfo.getFavorInteroperability() : preferences.getBoolean("favorInteroperability", true);
            if (bl && (n & 0x10) != 0) {
                saveOptions.cdataSectionElements = saveOptionsInfo.getCdataSectionElements();
            }
            if (document != null) {
                object = (DocumentType)document.getProperty("DOCUMENT_TYPE");
                if (!DocumentTypeUtil.isConstrainedDocumentType((DocumentType)object) && preferences.getBoolean("dontIndentUnconstrainedDocs", false)) {
                    saveOptions.indent = -1;
                }
                SpreadsheetHelper.configureSaveOptions(saveOptions, document);
            }
            return saveOptions;
        }
        return null;
    }

    public String getEncoding() {
        if (this.structuredFormat == null) {
            SaveOptions saveOptions = this.getSaveOptions(null);
            return saveOptions.xmlEncoding;
        }
        return this.structuredFormat.getDefaultEncoding();
    }
}

