/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.LocationInfo;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doc.XNodeSelector;
import com.xmlmind.xmledit.edit.DocumentResource;
import com.xmlmind.xmledit.edit.ResourceScanner;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.edit.XIncluderUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.MultiLineLabel;
import com.xmlmind.xmledit.imagetoolkit.XMLImageUtil;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.Log;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.ResourceInfo;
import com.xmlmind.xmleditapp.kit.ResourceScannerDialog;
import com.xmlmind.xmleditapp.kit.ResourcesDialog;
import com.xmlmind.xmleditapp.kit.SavedDocument;
import com.xmlmind.xmleditapp.kit.XMLLoader;
import com.xmlmind.xmleditapp.structformat.StructuredFormat;
import com.xmlmind.xmleditapp.upload.Upload;
import com.xmlmind.xmleditapp.upload.UploadDialog;
import com.xmlmind.xmleditapp.upload.UploadInvoker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class SavedDocumentBase
extends SavedDocument
implements UploadInvoker {
    protected URL url = null;
    protected boolean firstUpdate = true;

    protected SavedDocumentBase(App app, Document document, StructuredFormat structuredFormat, Configuration configuration) {
        super(app, document, structuredFormat, configuration);
    }

    public boolean initialize() {
        this.url = this.document.getLocation();
        return true;
    }

    public boolean initialize(URL uRL) {
        URL uRL2 = this.document.getLocation();
        DocumentResource[] documentResourceArray = (DocumentResource[])this.document.getProperty("DOCUMENT_RESOURCES");
        ArrayList arrayList = new ArrayList();
        if (!URLUtil.getDirectory(uRL2, true).equals(URLUtil.getDirectory(uRL, true))) {
            SavedDocumentBase.getResourceInfo1(uRL2, uRL, this.document, arrayList);
            if (documentResourceArray != null) {
                SavedDocumentBase.getResourceInfo2(uRL2, uRL, this.document, documentResourceArray, arrayList);
            }
        }
        int n = arrayList.size();
        ResourceInfo[] resourceInfoArray = null;
        if (n > 0) {
            resourceInfoArray = new ResourceInfo[n];
            arrayList.toArray(resourceInfoArray);
            resourceInfoArray = this.editResources(resourceInfoArray, uRL2, uRL);
            if (resourceInfoArray == null) {
                return false;
            }
            n = resourceInfoArray.length;
        }
        if (n > 0) {
            Object object;
            boolean bl = this.updateReferences(resourceInfoArray, false, uRL);
            File file = this.saveDocumentToTempFile(this.document, uRL);
            if (file == null) {
                if (bl) {
                    this.updateReferences(resourceInfoArray, true, uRL);
                    UndoManager undoManager = (UndoManager)this.document.getProperty("UNDO_MANAGER");
                    if (undoManager != null) {
                        undoManager.reset();
                    }
                }
                return false;
            }
            boolean bl2 = this.copyAllFiles(file, resourceInfoArray, uRL);
            file.delete();
            if (bl) {
                if (!bl2) {
                    this.updateReferences(resourceInfoArray, true, uRL);
                }
                if ((object = (UndoManager)this.document.getProperty("UNDO_MANAGER")) != null) {
                    ((UndoManager)object).reset();
                }
            }
            if (!bl2) {
                return false;
            }
            this.document.putLocationInfo(uRL.toExternalForm(), false);
            this.url = uRL;
            if (bl) {
                object = this.document.getRootElement();
                int n2 = this.document.getDocumentListenerCount(true);
                int n3 = 0;
                while (n3 < n2) {
                    DocumentListener documentListener = this.document.getDocumentListener(n3, true);
                    if (documentListener instanceof DocumentView) {
                        ((DocumentView)documentListener).rebuildView((Node)object);
                    }
                    ++n3;
                }
            }
            return true;
        }
        if (!this.saveDocument(this.document, uRL)) {
            return false;
        }
        this.document.putLocationInfo(uRL.toExternalForm(), false);
        this.url = uRL;
        return true;
    }

    private static final void getResourceInfo1(final URL uRL, final URL uRL2, Document document, final ArrayList arrayList) {
        final boolean bl = "file".equals(uRL.getProtocol());
        final boolean bl2 = "file".equals(uRL2.getProtocol());
        final String string = URLUtil.getRoot(uRL, true).toExternalForm();
        final String string2 = URLUtil.getRoot(uRL2, true).toExternalForm();
        Traversal.traverse(document.getRootElement(), new Traversal.HandlerBase(){

            public Object enterElement(Element element) {
                boolean bl3;
                InclusionInfo inclusionInfo = (InclusionInfo)element.getProperty("INCLUSION_INFO");
                if (inclusionInfo != null && ((bl3 = inclusionInfo.isXInclude()) || !inclusionInfo.isDTDModule())) {
                    String string3 = inclusionInfo.getSystemId();
                    URL uRL3 = inclusionInfo.getParentBase(element);
                    LocationInfo locationInfo = (LocationInfo)element.getProperty("LOCATION_INFO");
                    String string22 = locationInfo != null ? locationInfo.getLocation() : null;
                    SavedDocumentBase.addResourceInfo(null, null, element, bl3, string3, uRL3, string22, 0, uRL, bl, string, uRL2, bl2, string2, arrayList);
                    return Traversal.LEAVE_ELEMENT;
                }
                return null;
            }
        });
    }

    private static final void getResourceInfo2(URL uRL, URL uRL2, Document document, DocumentResource[] documentResourceArray, ArrayList arrayList) {
        boolean bl = "file".equals(uRL.getProtocol());
        boolean bl2 = "file".equals(uRL2.getProtocol());
        String string = URLUtil.getRoot(uRL, true).toExternalForm();
        String string2 = URLUtil.getRoot(uRL2, true).toExternalForm();
        Element element = document.getRootElement();
        int n = 0;
        while (n < documentResourceArray.length) {
            XNode[] xNodeArray = documentResourceArray[n].getSelector().select(element);
            int n2 = documentResourceArray[n].getAction();
            int n3 = 0;
            while (n3 < xNodeArray.length) {
                block8: {
                    String string3;
                    URL uRL3;
                    Element element2;
                    Attribute attribute;
                    block9: {
                        XNode xNode;
                        block7: {
                            xNode = xNodeArray[n3];
                            attribute = null;
                            element2 = null;
                            uRL3 = null;
                            string3 = null;
                            if (!(xNode instanceof Attribute)) break block7;
                            attribute = (Attribute)xNode;
                            if (!SavedDocumentBase.insideDocumentEntity(attribute.element)) break block8;
                            string3 = attribute.value;
                            uRL3 = attribute.element.getLocation();
                            break block9;
                        }
                        if (!(xNode instanceof Element)) break block9;
                        element2 = (Element)xNode;
                        if (!SavedDocumentBase.insideDocumentEntity(element2)) break block8;
                        string3 = element2.getText();
                        uRL3 = element2.getLocation();
                    }
                    if (string3 != null && (string3 = string3.trim()).length() == 0) {
                        string3 = null;
                    }
                    if (string3 != null) {
                        SavedDocumentBase.addResourceInfo(attribute, element2, null, false, string3, uRL3, null, n2, uRL, bl, string, uRL2, bl2, string2, arrayList);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    private static final boolean insideDocumentEntity(Element element) {
        return element.lookupProperty("INCLUSION_INFO") == null;
    }

    private static final void addResourceInfo(Attribute attribute, Element element, Element element2, boolean bl, String string, URL uRL, String string2, int n, URL uRL2, boolean bl2, String string3, URL uRL3, boolean bl3, String string4, ArrayList arrayList) {
        int n2 = -1;
        String string5 = null;
        String string6 = null;
        URL uRL4 = null;
        boolean bl4 = true;
        try {
            uRL4 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL4 == null) {
            bl4 = false;
            try {
                uRL4 = new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL4 == null || uRL4.getPath().endsWith("/")) {
            arrayList.add(new ResourceInfo(attribute, element, element2, bl, string, string2, 0, string5, string6));
            return;
        }
        if (URLUtil.trimFragment(uRL4).equals(uRL)) {
            return;
        }
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        if (bl4) {
            string5 = uRL4.toExternalForm();
            string6 = URLUtil.getRawBaseName(uRL4);
            if ("file".equals(uRL4.getProtocol()) && !bl3) {
                n2 = 2;
            } else if (n == 0) {
                n2 = 1;
            }
        } else {
            string6 = string;
            if (string3.equals(string4)) {
                string5 = URLUtil.getRelativeRawPath(uRL4, uRL3);
                if (n == 0) {
                    String string7;
                    int n3;
                    n2 = 1;
                    if (!bl4 && (n3 = (string7 = uRL2.getPath()).lastIndexOf(47)) >= 0) {
                        string7 = string7.substring(0, n3 + 1);
                        if (uRL4.getPath().startsWith(string7)) {
                            n2 = 2;
                        }
                    }
                }
            } else {
                string5 = uRL4.toExternalForm();
                if ("file".equals(uRL4.getProtocol()) && !bl3) {
                    n2 = 2;
                } else if (n == 0) {
                    n2 = 2;
                }
            }
        }
        arrayList.add(new ResourceInfo(attribute, element, element2, bl, string, string2, n2, string5, string6));
    }

    private boolean updateReferences(ResourceInfo[] resourceInfoArray, boolean bl, URL uRL) {
        boolean bl2 = false;
        int n = 0;
        while (n < resourceInfoArray.length) {
            String string;
            String string2;
            String string3;
            String string4;
            ResourceInfo resourceInfo = resourceInfoArray[n];
            if (!bl) {
                string4 = resourceInfo.location;
                string3 = resourceInfo.location2;
                string2 = resourceInfo.newLocation;
                string = null;
            } else {
                string4 = resourceInfo.newLocation;
                string3 = resourceInfo.newLocation2;
                string2 = resourceInfo.location;
                string = resourceInfo.location2;
            }
            if (!string2.equals(string4)) {
                if (resourceInfo.attribute != null) {
                    resourceInfo.attribute.element.putAttribute(resourceInfo.attribute.name, string2);
                } else if (resourceInfo.element != null) {
                    resourceInfo.element.setText(string2);
                } else {
                    InclusionInfo inclusionInfo = (InclusionInfo)resourceInfo.includedElement.getProperty("INCLUSION_INFO");
                    inclusionInfo.setSystemId(string2);
                    if (resourceInfo.includedElement.hasProperty("LOCATION_INFO")) {
                        if (!bl) {
                            resourceInfo.newLocation2 = inclusionInfo.getXPointedElementLocation() == null ? resourceInfo.newLocation : XIncluderUtil.relativeLocation(inclusionInfo.getXPointedElementLocation(), resourceInfo.newLocation, uRL);
                            string = resourceInfo.newLocation2;
                        }
                        resourceInfo.includedElement.putLocationInfo(string, resourceInfo.isXInclude);
                    }
                }
                bl2 = true;
            }
            ++n;
        }
        return bl2;
    }

    private ResourceInfo[] editResources(ResourceInfo[] resourceInfoArray, URL uRL, URL uRL2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 0;
        while (n < resourceInfoArray.length) {
            object5 = resourceInfoArray[n];
            object4 = ((ResourceInfo)object5).getLocation();
            String string = object4 == null ? ((URL)object4).toExternalForm() : ((ResourceInfo)object5).location;
            object3 = (ResourceInfo[])hashMap.get(string);
            if (object3 == null) {
                hashMap.put(string, new ResourceInfo[]{object5});
            } else {
                object2 = new ResourceInfo[((ResourceInfo[])object3).length + 1];
                System.arraycopy(object3, 0, object2, 0, ((Object)object3).length);
                object2[((Object)object3).length] = object5;
                hashMap.put(string, object2);
            }
            ++n;
        }
        object5 = new ResourceInfo[hashMap.size()];
        int n2 = 0;
        object4 = hashMap.values().iterator();
        while (object4.hasNext()) {
            object3 = (ResourceInfo[])object4.next();
            object5[n2++] = object3[0].copy();
        }
        object3 = new ResourcesDialog(this.app.getDialogParent());
        object5 = ((ResourcesDialog)object3).getResources((ResourceInfo[])object5, uRL, uRL2, this.createResourceScanner());
        if (object5 == null) {
            return null;
        }
        object2 = new ArrayList();
        int n3 = 0;
        while (n3 < ((Object)object5).length) {
            object = object5[n3];
            URL uRL3 = ((ResourceInfo)object).getLocation();
            String string = uRL3 == null ? uRL3.toExternalForm() : ((ResourceInfo)object).location;
            ResourceInfo[] resourceInfoArray2 = (ResourceInfo[])hashMap.get(string);
            int n4 = 0;
            while (n4 < resourceInfoArray2.length) {
                ResourceInfo resourceInfo = resourceInfoArray2[n4];
                resourceInfo.action = ((ResourceInfo)object).action;
                resourceInfo.newLocation = ((ResourceInfo)object).newLocation;
                ((ArrayList)object2).add(resourceInfo);
                ++n4;
            }
            ++n3;
        }
        object = new ResourceInfo[((ArrayList)object2).size()];
        ((ArrayList)object2).toArray((T[])object);
        return object;
    }

    private ResourceScanner createResourceScanner() {
        ResourceScanner resourceScanner = new ResourceScanner();
        XMLLoader xMLLoader = this.app.getXMLLoader();
        resourceScanner.setDocumentTypeDetector(xMLLoader.getDocumentTypeDetector());
        resourceScanner.setDocumentTypeCache(xMLLoader.getDocumentTypeCache());
        DocumentResource[] documentResourceArray = (DocumentResource[])this.document.getProperty("DOCUMENT_RESOURCES");
        if (documentResourceArray != null) {
            XNodeSelector[] xNodeSelectorArray = new XNodeSelector[documentResourceArray.length];
            int n = 0;
            while (n < documentResourceArray.length) {
                xNodeSelectorArray[n] = documentResourceArray[n].getSelector();
                ++n;
            }
            resourceScanner.setResourceSelectors(xNodeSelectorArray);
        }
        return resourceScanner;
    }

    private boolean copyAllFiles(File file, ResourceInfo[] resourceInfoArray, URL uRL) {
        CopyItem copyItem;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        URL[] uRLArray;
        HashMap<CopyItem, CopyItem> hashMap = new HashMap<CopyItem, CopyItem>();
        boolean bl = false;
        if (resourceInfoArray != null) {
            URL[] uRLArray2;
            uRLArray = new HashMap();
            n = 0;
            while (n < resourceInfoArray.length) {
                uRLArray2 = resourceInfoArray[n];
                if (uRLArray2.action == 2 && uRLArray2.includedElement != null) {
                    object4 = uRLArray2.getLocation();
                    object3 = uRLArray2.getNewLocation(uRL);
                    if (object4 != null && object3 != null && !((URL)object4).equals(object3)) {
                        ResourceInfo[] resourceInfoArray2 = (ResourceInfo[])uRLArray.get(object4);
                        if (resourceInfoArray2 == null) {
                            uRLArray.put(object4, new ResourceInfo[]{uRLArray2});
                        } else {
                            object2 = new ResourceInfo[resourceInfoArray2.length + 1];
                            System.arraycopy(resourceInfoArray2, 0, object2, 0, resourceInfoArray2.length);
                            object2[resourceInfoArray2.length] = uRLArray2;
                            uRLArray.put(object4, object2);
                        }
                    }
                }
                ++n;
            }
            if (uRLArray.size() > 0) {
                bl = true;
                uRLArray2 = new URL[uRLArray.size()];
                uRLArray.keySet().toArray(uRLArray2);
                object4 = new ResourceScannerDialog(this.app.getDialogParent());
                object3 = ((ResourceScannerDialog)object4).getResources(this.createResourceScanner(), uRLArray2, true);
                if (object3 == null) {
                    return false;
                }
                int n2 = 0;
                while (n2 < ((ResourceScanner.Resource[])object3).length) {
                    object2 = object3[n2];
                    boolean bl2 = ((ResourceScanner.Resource)object2).getSystemId().startsWith("/");
                    ResourceInfo[] resourceInfoArray3 = (ResourceInfo[])uRLArray.get(((ResourceScanner.Resource)object2).getScannedURL());
                    int n3 = 0;
                    while (n3 < resourceInfoArray3.length) {
                        object = resourceInfoArray3[n3];
                        copyItem = new CopyItem(((ResourceScanner.Resource)object2).getLocation(), ((ResourceScanner.Resource)object2).getLocation(((ResourceInfo)object).getNewLocation(uRL)));
                        if (copyItem.src != null && copyItem.dst != null && !copyItem.src.equals(copyItem.dst)) {
                            if (bl2) {
                                copyItem.warn = true;
                            }
                            SavedDocumentBase.addCopyItem(hashMap, copyItem);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            int n4 = 0;
            while (n4 < resourceInfoArray.length) {
                object4 = resourceInfoArray[n4];
                if (((ResourceInfo)object4).action == 2) {
                    copyItem = new CopyItem(((ResourceInfo)object4).getLocation(), ((ResourceInfo)object4).getNewLocation(uRL));
                    if (copyItem.src != null && copyItem.dst != null && !copyItem.src.equals(copyItem.dst)) {
                        SavedDocumentBase.addCopyItem(hashMap, copyItem);
                    }
                }
                ++n4;
            }
        }
        copyItem = new CopyItem(FileUtil.fileToURL(file), uRL);
        hashMap.put(copyItem, copyItem);
        uRLArray = new URL[2 * hashMap.size()];
        n = 0;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            copyItem = (CopyItem)iterator.next();
            uRLArray[n++] = copyItem.src;
            uRLArray[n++] = copyItem.dst;
        }
        object4 = URLUtil.getRoot(uRL, true);
        object3 = null;
        int n5 = 0;
        while (n5 < uRLArray.length) {
            object2 = uRLArray[n5];
            URL uRL2 = uRLArray[n5 + 1];
            if (!URLUtil.getRoot(uRL2, true).equals(object4)) {
                object3 = Msg.msg("cannotCopyToDifferentRoots", URLUtil.toLabel((URL)object2), URLUtil.toLabel(uRL2), URLUtil.toLabel((URL)object4));
                break;
            }
            int n6 = n5 + 2;
            while (n6 < uRLArray.length) {
                URL uRL3 = uRLArray[n6];
                object = uRLArray[n6 + 1];
                if (uRL2.equals(object)) {
                    object3 = Msg.msg("twoSourcesForTheSameDestination", URLUtil.toLabel((URL)object2), URLUtil.toLabel(uRL3), URLUtil.toLabel(uRL2));
                    break;
                }
                if (uRL2.equals(uRL3)) {
                    object3 = Msg.msg("overwritesSource", URLUtil.toLabel((URL)object2), URLUtil.toLabel(uRL2));
                    break;
                }
                n6 += 2;
            }
            n5 += 2;
        }
        boolean bl3 = false;
        if (object3 != null) {
            Alert.showError(this.app.getDialogParent(), (String)object3);
        } else if (!bl || SavedDocumentBase.confirmCopyAllFiles(hashMap, this.app.getDialogParent())) {
            bl3 = this.copy(uRLArray);
        }
        SavedDocumentBase.deleteTmpFiles(hashMap);
        return bl3;
    }

    private static final void addCopyItem(HashMap hashMap, CopyItem copyItem) {
        if (XMLImageUtil.isXMLImage(copyItem.src)) {
            File file = null;
            ArrayList arrayList = new ArrayList();
            try {
                file = XMLImageUtil.createCopiableImageFile(copyItem.src, copyItem.dst, arrayList);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file == null) {
                hashMap.put(copyItem, copyItem);
            } else {
                URL uRL = FileUtil.fileToURL(file);
                int n = arrayList.size();
                int n2 = 0;
                while (n2 < n) {
                    URL uRL2 = (URL)arrayList.get(n2);
                    URL uRL3 = (URL)arrayList.get(n2 + 1);
                    CopyItem copyItem2 = new CopyItem(uRL2, uRL3);
                    if (uRL.equals(uRL2)) {
                        copyItem2.srcIsTmpFile = true;
                    }
                    hashMap.put(copyItem2, copyItem2);
                    n2 += 2;
                }
            }
        } else {
            hashMap.put(copyItem, copyItem);
        }
    }

    private static final void deleteTmpFiles(HashMap hashMap) {
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            File file;
            CopyItem copyItem = (CopyItem)iterator.next();
            if (!copyItem.srcIsTmpFile || (file = FileUtil.urlToFile(copyItem.src)) == null) continue;
            file.delete();
        }
    }

    private static boolean confirmCopyAllFiles(HashMap hashMap, Component component) {
        Object object;
        final CopyItem[] copyItemArray = new CopyItem[hashMap.size()];
        hashMap.values().toArray(copyItemArray);
        Arrays.sort(copyItemArray, new Comparator(){

            public int compare(Object object, Object object2) {
                CopyItem copyItem = (CopyItem)object;
                CopyItem copyItem2 = (CopyItem)object2;
                return URLUtil.toLabel(copyItem.dst).compareTo(URLUtil.toLabel(copyItem2.dst));
            }
        });
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public String getColumnName(int n) {
                if (n == 0) {
                    return Msg.msg("CCAF.sourceFile");
                }
                return Msg.msg("CCAF.destinationFile");
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return copyItemArray.length;
            }

            public Object getValueAt(int n, int n2) {
                return URLUtil.toLabel(n2 == 0 ? copyItemArray[n].src : copyItemArray[n].dst);
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        JTable jTable = new JTable(abstractTableModel);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(false);
        jTable.setSelectionMode(0);
        jTable.setAutoResizeMode(4);
        jTable.setShowGrid(true);
        jTable.setIntercellSpacing(new Dimension(3, 3));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < copyItemArray.length) {
            object = copyItemArray[n3];
            int n4 = URLUtil.toLabel(((CopyItem)object).src).length();
            if (n4 > n) {
                n = n4;
            }
            if ((n4 = URLUtil.toLabel(((CopyItem)object).dst).length()) > n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (n < 10) {
            n = 10;
        } else if (n > 60) {
            n = 60;
        }
        if (n2 < 10) {
            n2 = 10;
        } else if (n2 > 60) {
            n2 = 60;
        }
        object = jTable.getFont();
        object = new Font(((Font)object).getFamily(), 0, Math.max(10, ((Font)object).getSize() - 1));
        jTable.setFont((Font)object);
        FontMetrics fontMetrics = jTable.getFontMetrics((Font)object);
        n2 *= fontMetrics.charWidth('x');
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(n *= fontMetrics.charWidth('x'));
        tableColumn.setResizable(true);
        CellRenderer cellRenderer = new CellRenderer(copyItemArray);
        tableColumn.setCellRenderer(cellRenderer);
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(cellRenderer);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(2 + n + 2 + n2 + 2, 2 + 20 * (fontMetrics.getHeight() + 2)));
        int n5 = JOptionPane.showConfirmDialog(component, new Object[]{Msg.msg("CCAF.confirmCopyAllFiles"), jScrollPane}, Msg.msg("confirm"), 2);
        return n5 == 0;
    }

    protected abstract boolean copy(URL[] var1);

    public boolean update() {
        boolean bl = this.saveDocument(this.document, this.url);
        if (bl) {
            this.firstUpdate = false;
        }
        return bl;
    }

    private boolean saveDocument(Document document, URL uRL) {
        File file = this.saveDocumentToTempFile(document, uRL);
        if (file == null) {
            return false;
        }
        URL[] uRLArray = new URL[]{FileUtil.fileToURL(file), uRL};
        boolean bl = this.copy(uRLArray);
        file.delete();
        return bl;
    }

    private File saveDocumentToTempFile(Document document, URL uRL) {
        String string = URIUtil.unescape(URLUtil.getRawBaseName(uRL));
        if (string.length() < 3) {
            string = "xxe";
        }
        File file = null;
        String string2 = null;
        try {
            file = File.createTempFile(string, null);
            this.doSaveDocument(document, file);
        }
        catch (Exception exception) {
            string2 = MiscUtil.reason(exception);
        }
        if (string2 != null) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotSave", URLUtil.toLabel(uRL), string2));
            file.delete();
            return null;
        }
        return file;
    }

    protected UploadDialog newUploadDialog() {
        UploadDialog uploadDialog = new UploadDialog(this.app.getDialogParent());
        String string = Msg.msg("fileCopy");
        Log.clear(string);
        uploadDialog.setMessageLog(string);
        return uploadDialog;
    }

    public void beginUpload() {
    }

    public boolean uploading(URL uRL, URL uRL2, int n, int n2) {
        this.app.showStatus(Upload.uploadingMessage(uRL, uRL2, n, n2), false);
        return true;
    }

    public boolean missingSource(URL uRL) {
        this.app.showStatus(Upload.missingSourceMessage(uRL), false);
        return true;
    }

    public void endUpload() {
        this.app.showStatus("", true);
    }

    private static final class CellRenderer
    extends MultiLineLabel
    implements TableCellRenderer {
        private CopyItem[] items;
        private Color evenBg = Color.white;
        private Color oddBg = new Color(255, 228, 181);
        private Color plainFg = Color.black;
        private Color warnFg = new Color(128, 0, 0);
        private Font plainFont = null;
        private Font warnFont = null;

        public CellRenderer(CopyItem[] copyItemArray) {
            super("", 2);
            this.items = copyItemArray;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.plainFont == null) {
                this.plainFont = jTable.getFont();
                this.warnFont = new Font(this.plainFont.getFamily(), 1, this.plainFont.getSize());
            }
            if (n % 2 == 0) {
                this.setBackground(this.evenBg);
            } else {
                this.setBackground(this.oddBg);
            }
            if (this.items[n].warn) {
                this.setForeground(this.warnFg);
                this.setFont(this.warnFont);
            } else {
                this.setForeground(this.plainFg);
                this.setFont(this.plainFont);
            }
            if (bl) {
                Color color = this.getForeground();
                this.setForeground(this.getBackground());
                this.setBackground(color);
            }
            this.setText((String)object);
            return this;
        }
    }

    private static final class CopyItem {
        public URL src;
        public URL dst;
        public boolean warn;
        public boolean srcIsTmpFile;

        public CopyItem(URL uRL, URL uRL2) {
            this.src = uRL;
            this.dst = uRL2;
            this.warn = false;
            this.srcIsTmpFile = false;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof CopyItem)) {
                return false;
            }
            CopyItem copyItem = (CopyItem)object;
            return this.src.equals(copyItem.src) && this.dst.equals(copyItem.dst);
        }

        public int hashCode() {
            return this.src.hashCode() ^ this.dst.hashCode();
        }
    }
}

