/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.util.FileUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class URLHistory {
    public static final int DEFAULT_CAPACITY = 15;
    public static final URL[] EMPTY = new URL[0];
    protected ArrayList urlList = new ArrayList();
    protected int capacity;

    public static URLHistory fromStrings(String[] stringArray) {
        URLHistory uRLHistory = new URLHistory();
        if (stringArray != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2].trim();
                if (string.length() != 0) {
                    URL uRL = null;
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL != null) {
                        uRLHistory.urlList.add(uRL);
                        if (++n == 15) break;
                    }
                }
                ++n2;
            }
        }
        return uRLHistory;
    }

    public URLHistory() {
        this(15);
    }

    public URLHistory(int n) {
        this.setCapacity(n);
    }

    public void setCapacity(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        this.capacity = n = (n + 2) / 3 * 3;
        this.checkSize();
    }

    protected void checkSize() {
        int n;
        while ((n = this.urlList.size()) >= this.capacity) {
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            int n5 = n - 1;
            while (n5 >= 0) {
                URL uRL = (URL)this.urlList.get(n5);
                if (uRL.getProtocol().equals("file")) {
                    if (n2 < 0) {
                        n2 = n5;
                    }
                } else {
                    if (n3 < 0) {
                        n3 = n5;
                    }
                    ++n4;
                }
                --n5;
            }
            if (n2 < 0 || n3 > n2 && n4 > this.capacity / 3) {
                this.urlList.remove(n3);
                continue;
            }
            this.urlList.remove(n2);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void add(URL uRL) {
        this.urlList.remove(uRL);
        this.checkSize();
        this.urlList.add(0, uRL);
    }

    public void remove(URL uRL) {
        this.urlList.remove(uRL);
    }

    public int size() {
        return this.urlList.size();
    }

    public URL[] getAll() {
        return this.urlList.toArray(EMPTY);
    }

    public URL lastAdded() {
        if (this.urlList.size() > 0) {
            return (URL)this.urlList.get(0);
        }
        return null;
    }

    public File lastAddedFile() {
        int n = this.urlList.size();
        int n2 = 0;
        while (n2 < n) {
            File file = FileUtil.urlToFile((URL)this.urlList.get(n2));
            if (file != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public String[] toStrings() {
        int n = this.urlList.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            URL uRL = (URL)this.urlList.get(n2);
            stringArray[n2] = uRL.toExternalForm();
            ++n2;
        }
        return stringArray;
    }
}

