/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit;

import com.xmlmind.xmledit.dialog.LoadDocument;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.DocumentTypeCache;
import com.xmlmind.xmledit.edit.Loader;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.DocumentTypeDetectorImpl;
import com.xmlmind.xmleditapp.kit.Msg;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class XMLLoader
implements Console,
DocumentTypeCache.OpenedDocuments {
    protected App app;
    protected Loader docLoader;
    public static final Namespace[] UNRESTRICTED_NAMESPACES = new Namespace[]{Namespace.XSD, Namespace.RNG, Namespace.XHTML, Namespace.DOCBOOK};
    public static final String UNRESTRICTED_NS_URI_PREFIX = "http://www.xmlmind.com/xmleditor/schema/";

    public XMLLoader(App app) {
        this.app = app;
        URL[] uRLArray = app.getXMLCatalogURLs();
        if (uRLArray.length > 0) {
            XMLCatalogs.set(uRLArray);
        }
        this.docLoader = new Loader();
        this.docLoader.setConsole(this);
        AppDocumentTypeDetector appDocumentTypeDetector = new AppDocumentTypeDetector(app);
        this.docLoader.setDocumentTypeDetector(appDocumentTypeDetector);
        Loader.setDefaultDocumentTypeDetector(appDocumentTypeDetector);
        this.docLoader.setAddedProperties(32776);
        this.docLoader.setXIncludeAware(true);
        this.docLoader.setCacheIncludedDocuments(Integer.MAX_VALUE);
        this.docLoader.setMarkingInclusionsAsReadOnly(true);
    }

    public void applyOpenPreferences() {
        Preferences preferences = this.app.getPreferences();
        int n = this.docLoader.getAddedProperties();
        n = preferences.getBoolean("ignoreStyleSheetPI", false) ? (n &= 0xFFFFFDFF) : (n |= 0x200);
        this.docLoader.setAddedProperties(n);
        this.docLoader.setGuessingIgnorableWhitespace(preferences.getBoolean("guessIgnorableWhitespace", true));
        this.docLoader.setUsingHelperDocumentType(preferences.getBoolean("useHelperDocumentType", true));
    }

    public void applySchemaPreferences() {
        boolean bl;
        Preferences preferences = this.app.getPreferences();
        boolean bl2 = this.docLoader.getDocumentTypeCache() != null;
        if (bl2 != (bl = preferences.getBoolean("useDocTypeCache", true))) {
            Object object;
            this.clearDocumentTypeCache();
            File file = null;
            if (bl && (object = this.app.getUserPreferencesDirectory()) != null && !(file = new File((File)object, "ser")).isDirectory()) {
                file = null;
            }
            object = null;
            if (file != null) {
                try {
                    object = new DocumentTypeCache((DocumentTypeCache.OpenedDocuments)this, file);
                }
                catch (IOException iOException) {
                    System.err.println("XXE internal error: cannot use '" + file + "' as a DocumentTypeCache: " + MiscUtil.detailedReason(iOException));
                }
            }
            Loader.setDefaultDocumentTypeCache((DocumentTypeCache)object);
            this.docLoader.setDocumentTypeCache((DocumentTypeCache)object);
        }
    }

    public boolean clearDocumentTypeCache() {
        DocumentTypeCache documentTypeCache = this.docLoader.getDocumentTypeCache();
        if (documentTypeCache == null) {
            return false;
        }
        try {
            documentTypeCache.clear();
        }
        catch (IOException iOException) {
            System.err.println("XXE internal error: cannot clear DocumentTypeCache: " + MiscUtil.detailedReason(iOException));
        }
        return true;
    }

    public DocumentTypeCache getDocumentTypeCache() {
        return this.docLoader.getDocumentTypeCache();
    }

    public Object[] load(URL uRL) {
        Object[] objectArray;
        DocumentTypeDetectorImpl documentTypeDetectorImpl = this.getDocumentTypeDetector();
        documentTypeDetectorImpl.resetDetectedConfiguration();
        this.app.showStatus(Msg.msg("loadingDocument", URLUtil.toLabel(uRL)), false);
        Document document = LoadDocument.loadDocument(uRL, this.docLoader, this.app.getDialogParent());
        this.app.showStatus("", true);
        if (document == null) {
            return null;
        }
        if ("Professional".equals("Standard") && (objectArray = XMLLoader.checkRootElementNS(document)) != null) {
            Alert.showInfo(this.app.getDialogParent(), Msg.msg("grammarRestriction", URLUtil.toLabel(uRL), XMLLoader.joinUnrestrictedNamespaces(), UNRESTRICTED_NS_URI_PREFIX, objectArray.getURI()) + "\n\n" + Msg.msg("notRestrictedInProEdition"));
            return null;
        }
        objectArray = new Object[]{document, documentTypeDetectorImpl.getDetectedConfiguration()};
        return objectArray;
    }

    public DocumentTypeDetectorImpl getDocumentTypeDetector() {
        return (DocumentTypeDetectorImpl)this.docLoader.getDocumentTypeDetector();
    }

    public Document doLoadDocument(File file) throws IOException {
        return LoadDocument.loadDocument(FileUtil.fileToURL(file), this.docLoader);
    }

    public static Namespace checkRootElementNS(Document document) {
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        if (documentType == null || documentType.isDTD() || documentType instanceof UnconstrainedDocumentType) {
            return null;
        }
        Namespace namespace = document.getRootElement().getNamespace();
        if (namespace.getURI().startsWith(UNRESTRICTED_NS_URI_PREFIX)) {
            return null;
        }
        int n = 0;
        while (n < UNRESTRICTED_NAMESPACES.length) {
            if (namespace == UNRESTRICTED_NAMESPACES[n]) {
                return null;
            }
            ++n;
        }
        return namespace;
    }

    public static String joinUnrestrictedNamespaces() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < UNRESTRICTED_NAMESPACES.length) {
            if (n > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append('\"');
            stringBuffer.append(UNRESTRICTED_NAMESPACES[n].getURI());
            stringBuffer.append('\"');
            ++n;
        }
        return stringBuffer.toString();
    }

    public void showMessage(String string, int n) {
        this.app.showStatus(string);
    }

    public Document[] getOpenedDocuments() {
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        Document[] documentArray = new Document[openedDocumentArray.length];
        int n = 0;
        while (n < openedDocumentArray.length) {
            documentArray[n] = openedDocumentArray[n].getDocument();
            ++n;
        }
        return documentArray;
    }

    protected static final class AppDocumentTypeDetector
    extends DocumentTypeDetectorImpl {
        protected App app;

        public AppDocumentTypeDetector(App app) {
            this.app = app;
        }

        public Configuration[] getConfigurations() {
            return this.app.getConfigurations();
        }
    }
}

