/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.AppToggleAction;
import com.xmlmind.xmleditapp.kit.ContextualAction;
import com.xmlmind.xmleditapp.kit.EditAction;
import com.xmlmind.xmleditapp.kit.EditToggleAction;
import com.xmlmind.xmleditapp.kit.gui.BeanProperty;
import com.xmlmind.xmleditapp.kit.gui.BeanPropertyList;
import com.xmlmind.xmleditapp.kit.gui.ContextCase;
import com.xmlmind.xmleditapp.kit.gui.ContextSwitch;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.Msg;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.xml.sax.Attributes;

final class ActionSpec
extends GUIItemSpec
implements BeanPropertyList {
    public String className;
    public String classImplementsCommand;
    public String commandName;
    public String commandParameter;
    public boolean commandIsEditingContextSensitive;
    public ContextSwitch contextSwitch;
    public String name;
    public String label;
    public URL icon;
    public URL selectedIcon;
    public String toolTip;
    public String accelerator;
    public String acceleratorOnMac;
    public BeanProperty[] beanProperties;
    private boolean created;
    private AppAction action;

    ActionSpec() {
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if ("action".equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.name = GUIItemSpec.getNMTOKEN(attributes, "name", null);
                if (this.name == null) {
                    GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
                }
                this.label = GUIItemSpec.getNonEmptyToken(attributes, "label", null);
                URL uRL = gUISpec.getLocatorURL();
                this.icon = GUIItemSpec.getURL(attributes, "icon", uRL, null);
                this.selectedIcon = GUIItemSpec.getURL(attributes, "selectedIcon", uRL, null);
                this.toolTip = GUIItemSpec.getNonEmptyToken(attributes, "toolTip", null);
                this.accelerator = GUIItemSpec.getNonEmptyToken(attributes, "accelerator", null);
                this.acceleratorOnMac = GUIItemSpec.getNonEmptyToken(attributes, "acceleratorOnMac", null);
            } else {
                GUIItemSpec.unknownChildElement(string, gUISpec);
            }
        } else if ("class".equals(string)) {
            this.classImplementsCommand = GUIItemSpec.getNMTOKEN(attributes, "implementsCommand", null);
        } else if ("command".equals(string)) {
            this.commandName = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (this.commandName == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            }
            this.commandParameter = GUIItemSpec.getNonEmptyToken(attributes, "parameter", null);
            this.commandIsEditingContextSensitive = GUIItemSpec.getBoolean(attributes, "editingContextSensitive", true);
        } else if ("context".equals(string)) {
            ContextSwitch contextSwitch = new ContextSwitch();
            gUISpec.pushLoader(contextSwitch);
            contextSwitch.startElement(string, attributes, gUISpec);
        } else if ("property".equals(string)) {
            BeanProperty beanProperty = new BeanProperty();
            gUISpec.pushLoader(beanProperty);
            beanProperty.startElement(string, attributes, gUISpec);
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if ("class".equals(string)) {
            this.className = GUIItemSpec.getClassName(cArray, n);
        } else if (!"command".equals(string) && "action".equals(string)) {
            gUISpec.popLoader();
            if (this.label == null && this.icon == null) {
                this.invalidElement2("action", Msg.msg("missingOrInvalidLabelAndIcon"), gUISpec);
                this.name = null;
            }
            int n2 = 0;
            if (this.className != null) {
                ++n2;
            }
            if (this.commandName != null) {
                ++n2;
            }
            if (this.contextSwitch != null) {
                ++n2;
            }
            if (n2 != 1) {
                this.invalidElement("action", gUISpec);
                this.name = null;
            }
            if (this.name != null) {
                gUISpec.actionSet.put(this.name, this);
            }
        }
    }

    public void translate(HashMap hashMap) {
        String string;
        if (this.label != null && (string = (String)hashMap.get(this.label)) != null) {
            this.label = string;
        }
        if (this.toolTip != null && (string = (String)hashMap.get(this.toolTip)) != null) {
            this.toolTip = string;
        }
    }

    public void addBeanProperty(BeanProperty beanProperty) {
        if (this.beanProperties == null) {
            this.beanProperties = new BeanProperty[]{beanProperty};
        } else {
            int n = this.beanProperties.length;
            BeanProperty[] beanPropertyArray = new BeanProperty[n + 1];
            System.arraycopy(this.beanProperties, 0, beanPropertyArray, 0, n);
            beanPropertyArray[n] = beanProperty;
            this.beanProperties = beanPropertyArray;
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.print("action ");
        printWriter.print(this.name);
        if (this.label != null) {
            printWriter.print(" label=");
            printWriter.print(this.label);
        }
        if (this.icon != null) {
            printWriter.print(" icon=");
            printWriter.print(this.icon);
        }
        if (this.selectedIcon != null) {
            printWriter.print(" selectedIcon=");
            printWriter.print(this.selectedIcon);
        }
        if (this.toolTip != null) {
            printWriter.print(" toolTip=");
            printWriter.print(this.toolTip);
        }
        if (this.accelerator != null) {
            printWriter.print(" accelerator=");
            printWriter.print(this.accelerator);
        }
        if (this.acceleratorOnMac != null) {
            printWriter.print(" acceleratorOnMac=");
            printWriter.print(this.acceleratorOnMac);
        }
        printWriter.println();
        if (this.className != null) {
            printWriter.print("* class ");
            printWriter.print(this.className);
            if (this.classImplementsCommand != null) {
                printWriter.print(" implementsCommand=");
                printWriter.print(this.classImplementsCommand);
            }
            printWriter.println();
        }
        if (this.commandName != null) {
            printWriter.print("* command ");
            printWriter.print(this.commandName);
            if (this.commandParameter != null) {
                printWriter.print(" parameter=");
                printWriter.print(this.commandParameter);
            }
            if (!this.commandIsEditingContextSensitive) {
                printWriter.print(" editingContextSensitive=false");
            }
            printWriter.println();
        }
        if (this.contextSwitch != null) {
            printWriter.print("* ");
            this.contextSwitch.list(printWriter);
        }
        if (this.beanProperties != null) {
            int n = 0;
            while (n < this.beanProperties.length) {
                printWriter.print("* ");
                this.beanProperties[n].list(printWriter);
                ++n;
            }
        }
    }

    public AppAction createAction(GUISpec gUISpec) {
        if (!this.created) {
            Object object;
            int n;
            this.created = true;
            this.action = null;
            if (this.className != null) {
                try {
                    this.action = (AppAction)Class.forName(this.className).newInstance();
                }
                catch (Exception exception) {
                    this.cannotInstantiate(this.className, exception, gUISpec);
                }
                if (this.action != null && this.classImplementsCommand != null) {
                    Commands.register(this.classImplementsCommand, (Command)((Object)this.action));
                }
            } else if (this.commandName != null) {
                this.action = new EditAction(this.commandName, this.commandParameter, this.commandIsEditingContextSensitive);
            } else {
                ContextCase[] contextCaseArray = this.contextSwitch.contextCases;
                n = contextCaseArray.length;
                object = new String[n - 1];
                AppAction[] appActionArray = new AppAction[n - 1];
                int n2 = 0;
                AppAction appAction = null;
                boolean bl = false;
                int n3 = 0;
                while (n3 < n) {
                    ContextCase contextCase = contextCaseArray[n3];
                    if (contextCase.configuration == null) {
                        appAction = contextCase.create(gUISpec);
                        if (appAction == null) {
                            bl = true;
                        }
                    } else {
                        appActionArray[n2] = contextCase.create(gUISpec);
                        if (appActionArray[n2] == null) {
                            bl = true;
                        } else {
                            object[n2] = contextCase.configuration;
                            ++n2;
                        }
                    }
                    ++n3;
                }
                if (!bl) {
                    this.action = new ContextualAction((String[])object, appActionArray, appAction, this.contextSwitch.editingContextSensitive);
                }
            }
            if (this.action != null) {
                if (this.label != null) {
                    this.action.setLabel(DialogUtil.buttonLabel(this.label));
                    char c = DialogUtil.buttonMnemonic(this.label);
                    if (c != '\u0000') {
                        this.action.setMnemonic(c);
                    }
                }
                if (this.icon != null) {
                    ImageIcon imageIcon = new ImageIcon(this.icon);
                    if (imageIcon.getImageLoadStatus() != 8) {
                        gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("badIcon", this.icon)));
                    } else {
                        this.action.setIcon(imageIcon);
                    }
                }
                if (this.selectedIcon != null) {
                    ImageIcon imageIcon = new ImageIcon(this.selectedIcon);
                    if (imageIcon.getImageLoadStatus() != 8) {
                        gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("badIcon", this.selectedIcon)));
                    } else if (this.action instanceof AppToggleAction) {
                        ((AppToggleAction)this.action).setSelectedIcon(imageIcon);
                        Icon icon = this.action.getIcon();
                        if (icon != null) {
                            ((AppToggleAction)this.action).setUnselectedIcon(icon);
                        }
                    } else if (this.action instanceof EditToggleAction) {
                        ((EditToggleAction)this.action).setSelectedIcon(imageIcon);
                        Icon icon = this.action.getIcon();
                        if (icon != null) {
                            ((EditToggleAction)this.action).setUnselectedIcon(icon);
                        }
                    }
                }
                KeyStroke keyStroke = null;
                if (this.acceleratorOnMac != null && PlatformUtil.IS_MAC_OS) {
                    this.accelerator = this.acceleratorOnMac;
                }
                if (this.accelerator != null) {
                    if (this.accelerator.indexOf("mod") >= 0) {
                        String string = PlatformUtil.IS_MAC_OS ? "meta" : "ctrl";
                        this.accelerator = StringUtil.replaceAll(this.accelerator, "mod", string);
                    }
                    if ((keyStroke = KeyStroke.getKeyStroke(this.accelerator)) == null) {
                        gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("badAccelerator", this.accelerator)));
                    }
                }
                if ((keyStroke = gUISpec.app.getAccelerator(this.action, keyStroke)) != null) {
                    this.action.setAccelerator(keyStroke);
                }
                if (this.toolTip == null && this.label != null) {
                    this.toolTip = this.action.getLabel();
                    if (this.toolTip.endsWith("...")) {
                        this.toolTip = this.toolTip.substring(0, this.toolTip.length() - 3);
                    }
                }
                if (this.toolTip != null) {
                    if (keyStroke != null && (n = keyStroke.getKeyCode()) != 0) {
                        object = new StringBuffer(this.toolTip);
                        ((StringBuffer)object).append(" [");
                        int n4 = keyStroke.getModifiers();
                        if (n4 != 0) {
                            ((StringBuffer)object).append(KeyEvent.getKeyModifiersText(n4));
                            ((StringBuffer)object).append('-');
                        }
                        ((StringBuffer)object).append(KeyEvent.getKeyText(n));
                        ((StringBuffer)object).append(']');
                        this.toolTip = ((StringBuffer)object).toString();
                    }
                    this.action.setToolTip(this.toolTip);
                }
                if (this.beanProperties != null) {
                    n = 0;
                    while (n < this.beanProperties.length) {
                        this.beanProperties[n].apply(this.action, gUISpec);
                        ++n;
                    }
                }
                if (!this.addPart(this.action, this.name, gUISpec)) {
                    this.action = null;
                }
            }
        }
        return this.action;
    }
}

