/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.gui.GUIItemLoad;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSkip;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.Msg;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

abstract class GUIItemSpec
implements GUIItemLoad {
    public static final int INSERT_NONE = 0;
    public static final int INSERT_AT_BEGIN = 1;
    public static final int INSERT_AT_END = 2;
    public String systemId;
    public int lineNumber;
    public int columnNumber;

    GUIItemSpec() {
    }

    public void translate(HashMap hashMap) {
    }

    public abstract void list(PrintWriter var1);

    protected void recordLocation(GUISpec gUISpec) {
        Locator locator = gUISpec.getLocator();
        this.systemId = locator.getSystemId();
        this.lineNumber = locator.getLineNumber();
        this.columnNumber = locator.getColumnNumber();
    }

    protected static final String getClassName(char[] cArray, int n) {
        String string = new String(cArray, 0, n).trim();
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    protected static final String getNMTOKEN(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        if (string3 == null) {
            return string2;
        }
        if (!XMLUtil.isNmtoken(string3 = string3.trim())) {
            string3 = string2;
        }
        return string3;
    }

    protected static final String getNonEmptyToken(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        if (string3 == null) {
            return string2;
        }
        if ((string3 = XMLUtil.collapseWhiteSpace(string3)).length() == 0) {
            string3 = string2;
        }
        return string3;
    }

    protected static final boolean getBoolean(Attributes attributes, String string, boolean bl) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return bl;
        }
        boolean bl2 = "true".equals(string2 = string2.trim()) ? true : ("false".equals(string2) ? false : bl);
        return bl2;
    }

    protected static final int getInt(Attributes attributes, String string, int n, int n2, int n3) {
        int n4;
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return n3;
        }
        try {
            n4 = Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            n4 = n3;
        }
        if (n4 < n || n4 > n2) {
            n4 = n3;
        }
        return n4;
    }

    protected static final double getDouble(Attributes attributes, String string, double d, double d2, double d3) {
        double d4;
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return d3;
        }
        try {
            d4 = Double.parseDouble(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            d4 = d3;
        }
        if (d4 < d || d4 > d2) {
            d4 = d3;
        }
        return d4;
    }

    protected static final URL getURL(Attributes attributes, String string, URL uRL, URL uRL2) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return uRL2;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return uRL2;
        }
        URL uRL3 = GUIItemSpec.resolveURL(string2, uRL);
        if (uRL3 == null) {
            uRL3 = uRL2;
        }
        return uRL3;
    }

    protected static final URL resolveURL(String string, URL uRL) {
        URL uRL2 = null;
        try {
            uRL2 = XMLCatalogs.resolveURI(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {}
        return uRL2;
    }

    protected static final void missingOrInvalidAttribute(String string, GUISpec gUISpec) {
        gUISpec.errorList.add(new GUISpec.Error(gUISpec.getLocator(), Msg.msg("missingOrInvalidAttribute", string)));
    }

    protected static final void unknownChildElement(String string, GUISpec gUISpec) {
        gUISpec.errorList.add(new GUISpec.Error(gUISpec.getLocator(), Msg.msg("unknownElement", string)));
        GUIItemSkip gUIItemSkip = new GUIItemSkip(string);
        gUISpec.pushLoader(gUIItemSkip);
        gUIItemSkip.startElement(string, null, gUISpec);
    }

    protected final void invalidElement(String string, GUISpec gUISpec) {
        gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("invalidElement", string)));
    }

    protected final void invalidElement2(String string, String string2, GUISpec gUISpec) {
        gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("invalidElement2", string, string2)));
    }

    protected final void componentNotDefined(String string, String string2, GUISpec gUISpec) {
        gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("componentNotDefined", string, string2)));
    }

    protected final void cannotInstantiate(String string, Exception exception, GUISpec gUISpec) {
        Throwable throwable = exception;
        if (exception instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)exception).getCause();
        }
        gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("cannotInstantiate", string, MiscUtil.reason(exception))));
    }

    protected final boolean addPart(AppPart appPart, String string, GUISpec gUISpec) {
        if (gUISpec.app.getPart(string) != null) {
            gUISpec.errorList.add(new GUISpec.Error(this, Msg.msg("partAlreadyDefined", string)));
            return false;
        }
        gUISpec.app.addPart(appPart, string);
        return true;
    }
}

