/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.Tab;
import com.xmlmind.xmledit.guiutil.TabbedSplitPane;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xsd.datatype.LanguageType;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.gui.ActionSpec;
import com.xmlmind.xmleditapp.kit.gui.CommandSpec;
import com.xmlmind.xmleditapp.kit.gui.EditorListenerSpec;
import com.xmlmind.xmleditapp.kit.gui.GUIItemLoad;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSkip;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.LayoutSpec;
import com.xmlmind.xmleditapp.kit.gui.MenuBarSpec;
import com.xmlmind.xmleditapp.kit.gui.MenuItemsSpec;
import com.xmlmind.xmleditapp.kit.gui.MenuSpec;
import com.xmlmind.xmleditapp.kit.gui.Msg;
import com.xmlmind.xmleditapp.kit.gui.OpenedDocumentHookSpec;
import com.xmlmind.xmleditapp.kit.gui.PaneSpec;
import com.xmlmind.xmleditapp.kit.gui.PartSpec;
import com.xmlmind.xmleditapp.kit.gui.PreferencesSheetSpec;
import com.xmlmind.xmleditapp.kit.gui.PreferencesSheetsSpec;
import com.xmlmind.xmleditapp.kit.gui.PropertySpec;
import com.xmlmind.xmleditapp.kit.gui.StatusBarSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolBarItemsSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolBarSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolSpec;
import com.xmlmind.xmleditapp.kit.gui.TranslationSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class GUISpec
extends DefaultHandler
implements GUIItemLoad {
    ArrayList translationList = new ArrayList();
    HashMap commandSet = new HashMap();
    HashMap propertySet = new HashMap();
    HashMap openedDocumentHookSet = new HashMap();
    HashMap editorListenerSet = new HashMap();
    HashMap preferencesSheetSet = new HashMap();
    HashMap preferencesSheetsSet = new HashMap();
    HashMap partSet = new HashMap();
    HashMap toolSet = new HashMap();
    HashMap paneSet = new HashMap();
    HashMap actionSet = new HashMap();
    HashMap statusBarSet = new HashMap();
    HashMap toolBarItemsSet = new HashMap();
    HashMap toolBarSet = new HashMap();
    HashMap menuItemsSet = new HashMap();
    HashMap menuSet = new HashMap();
    HashMap menuBarSet = new HashMap();
    LayoutSpec layout = null;
    ArrayList errorList = new ArrayList();
    App app;
    private URL specURL;
    private Stack locatorStack;
    private Stack loaderStack;
    private boolean expectGUI;
    private char[] chars;
    private int charCount;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$kit$gui$GUISpec;

    public Error[] load(URL uRL) {
        this.translationList.clear();
        this.commandSet.clear();
        this.propertySet.clear();
        this.openedDocumentHookSet.clear();
        this.editorListenerSet.clear();
        this.preferencesSheetSet.clear();
        this.preferencesSheetsSet.clear();
        this.partSet.clear();
        this.toolSet.clear();
        this.paneSet.clear();
        this.actionSet.clear();
        this.statusBarSet.clear();
        this.toolBarItemsSet.clear();
        this.toolBarSet.clear();
        this.menuItemsSet.clear();
        this.menuSet.clear();
        this.menuBarSet.clear();
        this.layout = null;
        this.errorList.clear();
        this.specURL = uRL;
        this.locatorStack = new Stack();
        this.loaderStack = new Stack();
        this.chars = new char[256];
        this.charCount = 0;
        this.pushLoader(this);
        this.expectGUI = true;
        this.parse(uRL);
        this.locatorStack = null;
        this.loaderStack = null;
        Error[] errorArray = new Error[this.errorList.size()];
        this.errorList.toArray(errorArray);
        return errorArray;
    }

    private boolean parse(URL uRL) {
        SAXParser sAXParser = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            this.errorList.add(new Error(uRL.toExternalForm(), -1, -1, Msg.msg("cannotCreateParser", MiscUtil.reason(exception))));
            return false;
        }
        try {
            sAXParser.parse(uRL.toExternalForm(), (DefaultHandler)this);
        }
        catch (IOException iOException) {
            String string = uRL.toExternalForm();
            this.errorList.add(new Error(string, -1, -1, Msg.msg("cannotParse", string, MiscUtil.reason(iOException))));
            return false;
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (StopParsingException stopParsingException) {
            return false;
        }
        return true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locatorStack.push(locator);
    }

    public void endDocument() throws SAXException {
        this.locatorStack.pop();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.topLoader().startElement(string2, attributes, this);
        this.charCount = 0;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.charCount + n2 > this.chars.length) {
            char[] cArray2 = new char[this.chars.length + Math.max(n2, 256)];
            System.arraycopy(this.chars, 0, cArray2, 0, this.charCount);
            this.chars = cArray2;
        }
        System.arraycopy(cArray, n, this.chars, this.charCount, n2);
        this.charCount += n2;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.topLoader().endElement(string2, this.chars, this.charCount, this);
        this.charCount = 0;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.fatalError(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errorList.add(new Error(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), Msg.msg("xmlSyntax", sAXParseException.getMessage())));
        throw sAXParseException;
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        GUIItemLoad gUIItemLoad = null;
        if ("action".equals(string)) {
            gUIItemLoad = new ActionSpec();
        } else if ("toolBar".equals(string)) {
            gUIItemLoad = new ToolBarSpec();
        } else if ("statusBar".equals(string)) {
            gUIItemLoad = new StatusBarSpec();
        } else if ("menu".equals(string)) {
            gUIItemLoad = new MenuSpec();
        } else if ("tool".equals(string)) {
            gUIItemLoad = new ToolSpec();
        } else if ("pane".equals(string)) {
            gUIItemLoad = new PaneSpec();
        } else if ("menuBar".equals(string)) {
            gUIItemLoad = new MenuBarSpec();
        } else if ("part".equals(string)) {
            gUIItemLoad = new PartSpec();
        } else if ("menuItems".equals(string)) {
            gUIItemLoad = new MenuItemsSpec();
        } else if ("toolBarItems".equals(string)) {
            gUIItemLoad = new ToolBarItemsSpec();
        } else if ("preferencesSheet".equals(string)) {
            gUIItemLoad = new PreferencesSheetSpec();
        } else if ("preferencesSheets".equals(string)) {
            gUIItemLoad = new PreferencesSheetsSpec();
        } else if ("layout".equals(string)) {
            gUIItemLoad = new LayoutSpec();
        } else if ("translation".equals(string)) {
            gUIItemLoad = new TranslationSpec();
        } else if ("command".equals(string)) {
            gUIItemLoad = new CommandSpec();
        } else if ("openedDocumentHook".equals(string)) {
            gUIItemLoad = new OpenedDocumentHookSpec();
        } else if ("editorListener".equals(string)) {
            gUIItemLoad = new EditorListenerSpec();
        } else if ("property".equals(string)) {
            gUIItemLoad = new PropertySpec();
        } else if ("include".equals(string)) {
            URL uRL = null;
            String string2 = attributes.getValue("location");
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                try {
                    uRL = XMLCatalogs.resolveURI(string2, this.getLocatorURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) {
                this.errorList.add(new Error(this.getLocator(), Msg.msg("missingOrInvalidAttribute", "location")));
            } else {
                this.pushLoader(this);
                this.expectGUI = true;
                if (!this.parse(uRL)) {
                    throw new StopParsingException();
                }
            }
        } else if ("gui".equals(string)) {
            if (this.expectGUI) {
                this.expectGUI = false;
            } else {
                this.errorList.add(new Error(this.getLocator(), Msg.msg("unknownElement", string)));
                gUIItemLoad = new GUIItemSkip(string);
            }
        } else {
            this.errorList.add(new Error(this.getLocator(), Msg.msg("unknownElement", string)));
            gUIItemLoad = new GUIItemSkip(string);
        }
        if (gUIItemLoad != null) {
            this.pushLoader(gUIItemLoad);
            gUIItemLoad.startElement(string, attributes, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if ("gui".equals(string)) {
            this.popLoader();
        }
    }

    Locator getLocator() {
        return (Locator)this.locatorStack.peek();
    }

    URL getLocatorURL() {
        URL uRL = null;
        try {
            uRL = new URL(this.getLocator().getSystemId());
        }
        catch (MalformedURLException malformedURLException) {}
        return uRL;
    }

    void pushLoader(GUIItemLoad gUIItemLoad) {
        this.loaderStack.push(gUIItemLoad);
    }

    void popLoader() {
        this.loaderStack.pop();
    }

    GUIItemLoad topLoader() {
        return (GUIItemLoad)this.loaderStack.peek();
    }

    public Error[] layout(Container container, Component component, App app, LayoutInfo layoutInfo) {
        Object[] objectArray;
        Component component2;
        Component component3;
        Component component4;
        Component component5;
        Container container2;
        Component component6;
        Component component7;
        if (this.errorList.size() > 0) {
            throw new IllegalStateException("spec has load errors");
        }
        if (this.layout == null) {
            this.layout = new LayoutSpec();
            this.layout.systemId = this.specURL == null ? null : this.specURL.toExternalForm();
            this.layout.lineNumber = -1;
            this.layout.columnNumber = -1;
        }
        this.translateMessages();
        this.app = app;
        this.layout.createHidden(this);
        this.layout.createPreferencesSheets(this);
        if (container instanceof JFrame) {
            component7 = (JFrame)container;
            component6 = this.layout.createMenuBar(this);
            if (component6 != null) {
                component7.setJMenuBar((JMenuBar)component6);
            }
            container2 = component7.getContentPane();
            ((JComponent)container2).setBorder(new EmptyBorder(1, 1, 1, 1));
        } else if (container instanceof JApplet) {
            component7 = (JApplet)container;
            component6 = this.layout.createMenuBar(this);
            if (component6 != null) {
                ((JApplet)component7).setJMenuBar((JMenuBar)component6);
            }
            container2 = ((JApplet)component7).getContentPane();
            ((JComponent)container2).setBorder(new EmptyBorder(1, 1, 1, 1));
        } else if (container instanceof JInternalFrame) {
            component7 = (JInternalFrame)container;
            component6 = this.layout.createMenuBar(this);
            if (component6 != null) {
                ((JInternalFrame)component7).setJMenuBar((JMenuBar)component6);
            }
            container2 = ((JInternalFrame)component7).getContentPane();
            ((JComponent)container2).setBorder(new EmptyBorder(1, 1, 1, 1));
        } else {
            container2 = container;
        }
        container2.setLayout(new BorderLayout(1, 1));
        component7 = this.layout.createTopToolBars(this);
        if (component7 != null) {
            container2.add(component7, "North");
        }
        if ((component6 = this.layout.createBottomToolBars(this)) != null) {
            container2.add(component6, "South");
        }
        if ((component5 = this.layout.createLeftToolBars(this)) != null) {
            container2.add(component5, "West");
        }
        if ((component4 = this.layout.createRightToolBars(this)) != null) {
            container2.add(component4, "East");
        }
        if ((component3 = this.layout.createLeftPanes(this)) != null) {
            if (component3 instanceof TabbedSplitPane) {
                layoutInfo.leftTabs = (TabbedSplitPane)component3;
                layoutInfo.leftTabsTopHeight = this.layout.leftPanes.topHeight;
            }
            layoutInfo.leftSplit = new JSplitPane(1, component3, component);
            layoutInfo.leftSplit.setOneTouchExpandable(true);
            layoutInfo.leftSplit.setContinuousLayout(false);
            layoutInfo.leftSplit.setResizeWeight(0.0);
            layoutInfo.leftSplitWidth = this.layout.leftPanes.width;
            component = layoutInfo.leftSplit;
        }
        if ((component2 = this.layout.createRightPanes(this)) != null) {
            if (component2 instanceof TabbedSplitPane) {
                layoutInfo.rightTabs = (TabbedSplitPane)component2;
                layoutInfo.rightTabsTopHeight = this.layout.rightPanes.topHeight;
            }
            layoutInfo.rightSplit = new JSplitPane(1, component, component2);
            layoutInfo.rightSplit.setOneTouchExpandable(true);
            layoutInfo.rightSplit.setContinuousLayout(false);
            layoutInfo.rightSplit.setResizeWeight(1.0);
            layoutInfo.rightSplitWidth = this.layout.rightPanes.width;
            component = layoutInfo.rightSplit;
        }
        container2.add(component, "Center");
        layoutInfo.label = this.layout.label;
        layoutInfo.width = this.layout.width;
        layoutInfo.height = this.layout.height;
        if (this.layout.icon != null) {
            objectArray = Toolkit.getDefaultToolkit().createImage(this.layout.icon);
            if (objectArray != null) {
                objectArray = ImageResource.loadImage((Image)objectArray);
            }
            layoutInfo.icon = objectArray;
        }
        this.app = null;
        objectArray = new Error[this.errorList.size()];
        this.errorList.toArray(objectArray);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    private void translateMessages() {
        GUIItemSpec gUIItemSpec;
        HashMap hashMap = this.getMessageMap();
        if (hashMap == null) {
            return;
        }
        Iterator iterator = this.preferencesSheetsSet.values().iterator();
        while (iterator.hasNext()) {
            gUIItemSpec = (PreferencesSheetsSpec)iterator.next();
            ((PreferencesSheetsSpec)gUIItemSpec).translate(hashMap);
        }
        iterator = this.paneSet.values().iterator();
        while (iterator.hasNext()) {
            gUIItemSpec = (PaneSpec)iterator.next();
            ((PaneSpec)gUIItemSpec).translate(hashMap);
        }
        iterator = this.actionSet.values().iterator();
        while (iterator.hasNext()) {
            gUIItemSpec = (ActionSpec)iterator.next();
            ((ActionSpec)gUIItemSpec).translate(hashMap);
        }
        iterator = this.menuSet.values().iterator();
        while (iterator.hasNext()) {
            gUIItemSpec = (MenuSpec)iterator.next();
            ((MenuSpec)gUIItemSpec).translate(hashMap);
        }
        if (this.layout != null) {
            this.layout.translate(hashMap);
        }
    }

    private HashMap getMessageMap() {
        Serializable serializable;
        int n = this.translationList.size();
        if (n == 0) {
            return null;
        }
        HashMap[] hashMapArray = new HashMap[n];
        int n2 = 0;
        while (n2 < n) {
            serializable = ((TranslationSpec)this.translationList.get((int)n2)).location;
            hashMapArray[n2] = new HashMap();
            GUISpec.initMessageMap((URL)serializable, hashMapArray[n2]);
            ++n2;
        }
        if (hashMapArray.length == 1) {
            return hashMapArray[0];
        }
        serializable = new HashMap();
        int n3 = 0;
        while (n3 < hashMapArray.length) {
            ((HashMap)serializable).putAll(hashMapArray[n3]);
            ++n3;
        }
        return serializable;
    }

    private static final void initMessageMap(URL uRL, HashMap hashMap) {
        int n;
        URL uRL2 = URLUtil.getDirectory(uRL);
        String string = URIUtil.unescape(URLUtil.getRawBaseName(uRL));
        if (!string.endsWith(".properties")) {
            return;
        }
        int n2 = string.lastIndexOf(95);
        if (n2 < 0) {
            return;
        }
        if ((n = string.indexOf(46, ++n2)) != n2 + 2) {
            return;
        }
        String string2 = string.substring(n2, n);
        if (!LanguageType.isKnownLanguage(string2)) {
            return;
        }
        String string3 = Locale.getDefault().getLanguage();
        if (string2.equals(string3)) {
            return;
        }
        Properties properties = GUISpec.loadProperties(uRL);
        if (properties == null) {
            return;
        }
        String string4 = string.substring(0, n2) + string3 + string.substring(n);
        URL uRL3 = null;
        try {
            uRL3 = new URL(uRL2, URIUtil.quotePath(string4));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Properties properties2 = null;
        if ((uRL3 == null || (properties2 = GUISpec.loadProperties(uRL3)) == null) && (uRL3 = (class$com$xmlmind$xmleditapp$kit$gui$GUISpec == null ? (class$com$xmlmind$xmleditapp$kit$gui$GUISpec = GUISpec.class$("com.xmlmind.xmleditapp.kit.gui.GUISpec")) : class$com$xmlmind$xmleditapp$kit$gui$GUISpec).getClassLoader().getResource(string4)) != null) {
            properties2 = GUISpec.loadProperties(uRL3);
        }
        if (properties2 == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string5 = properties2.getProperty((String)entry.getKey());
            if (string5 == null) continue;
            hashMap.put(entry.getValue(), string5);
        }
    }

    private static final Properties loadProperties(URL uRL) {
        Properties properties = new Properties();
        try {
            GUISpec.loadProperties(uRL, properties);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadProperties(URL uRL, Properties properties) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            properties.load(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public void list(PrintWriter printWriter) {
        int n = this.translationList.size();
        int n2 = 0;
        while (n2 < n) {
            GUIItemSpec gUIItemSpec = (GUIItemSpec)this.translationList.get(n2);
            if (n2 == 0) {
                printWriter.println();
            }
            gUIItemSpec.list(printWriter);
            ++n2;
        }
        GUISpec.listAll(this.commandSet, printWriter);
        GUISpec.listAll(this.propertySet, printWriter);
        GUISpec.listAll(this.openedDocumentHookSet, printWriter);
        GUISpec.listAll(this.editorListenerSet, printWriter);
        GUISpec.listAll(this.preferencesSheetSet, printWriter);
        GUISpec.listAll(this.preferencesSheetsSet, printWriter);
        GUISpec.listAll(this.partSet, printWriter);
        GUISpec.listAll(this.toolSet, printWriter);
        GUISpec.listAll(this.paneSet, printWriter);
        GUISpec.listAll(this.actionSet, printWriter);
        GUISpec.listAll(this.statusBarSet, printWriter);
        GUISpec.listAll(this.toolBarItemsSet, printWriter);
        GUISpec.listAll(this.toolBarSet, printWriter);
        GUISpec.listAll(this.menuItemsSet, printWriter);
        GUISpec.listAll(this.menuSet, printWriter);
        GUISpec.listAll(this.menuBarSet, printWriter);
        if (this.layout != null) {
            printWriter.println();
            this.layout.list(printWriter);
        }
    }

    private static final void listAll(HashMap hashMap, PrintWriter printWriter) {
        int n = hashMap.size();
        Map.Entry[] entryArray = new Map.Entry[n];
        hashMap.entrySet().toArray(entryArray);
        if (n > 1) {
            Arrays.sort(entryArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = (String)((Map.Entry)object).getKey();
                    String string2 = (String)((Map.Entry)object2).getKey();
                    return string.compareTo(string2);
                }
            });
        }
        int n2 = 0;
        while (n2 < n) {
            GUIItemSpec gUIItemSpec = (GUIItemSpec)entryArray[n2].getValue();
            printWriter.println();
            gUIItemSpec.list(printWriter);
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (System.getProperty("javax.xml.parsers.SAXParserFactory") == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.jclark.xml.jaxp.SAXParserFactoryImpl");
        }
    }

    private static final class StopParsingException
    extends RuntimeException {
        private StopParsingException() {
        }
    }

    public static final class LayoutInfo {
        public String label;
        public Image icon;
        public int width;
        public int height;
        public JSplitPane leftSplit;
        public double leftSplitWidth;
        public JSplitPane rightSplit;
        public double rightSplitWidth;
        public TabbedSplitPane leftTabs;
        public double leftTabsTopHeight;
        public TabbedSplitPane rightTabs;
        public double rightTabsTopHeight;

        public void applyLayoutPreferences(Preferences preferences) {
            int n;
            Object object;
            Object object2;
            Object object3;
            Object[] objectArray;
            Object[] objectArray2 = new Object[]{this.leftTabs, "leftTab", this.rightTabs, "rightTab"};
            int n2 = 0;
            while (n2 < objectArray2.length) {
                objectArray = (Object[])objectArray2[n2];
                String string = (String)objectArray2[n2 + 1];
                if (objectArray != null) {
                    objectArray.setHorizontalRatio(preferences.getDouble(string + "s.horizontalRatio", objectArray.getHorizontalRatio()));
                    object3 = null;
                    object2 = null;
                    object = objectArray.getAllTabs();
                    n = 0;
                    while (n < ((Tab[])object).length) {
                        Tab tab = object[n];
                        String string2 = string + "." + tab.getComponent().getName();
                        boolean bl = preferences.getBoolean(string2 + ".atStart", tab.isAtStart());
                        boolean bl2 = preferences.getBoolean(string2 + ".selected", tab.isSelected());
                        if (bl2) {
                            if (object3 == null && bl) {
                                object3 = tab;
                            } else if (object2 == null && !bl) {
                                object2 = tab;
                            }
                        }
                        objectArray.moveTab(tab, bl);
                        ++n;
                    }
                    if (object3 != null) {
                        objectArray.selectTab((Tab)object3);
                    }
                    if (object2 != null) {
                        objectArray.selectTab((Tab)object2);
                    }
                }
                n2 += 2;
            }
            objectArray = new Object[]{this.rightSplit, "rightSplit", new Double(1.0 - this.rightSplitWidth), this.leftSplit, "leftSplit", new Double(this.leftSplitWidth)};
            int n3 = 0;
            while (n3 < objectArray.length) {
                object3 = (JSplitPane)objectArray[n3];
                object2 = (String)objectArray[n3 + 1];
                object = (Double)objectArray[n3 + 2];
                if (object3 != null) {
                    n = preferences.getInt((String)object2 + ".dividerLocation", 0, ((JComponent)object3).getWidth(), -1);
                    if (n != -1) {
                        ((JSplitPane)object3).setDividerLocation(n);
                    } else {
                        ((JSplitPane)object3).setDividerLocation((Double)object);
                    }
                    ((Container)object3).validate();
                }
                n3 += 3;
            }
        }

        public void saveLayoutPreferences(Preferences preferences) {
            Object[] objectArray = new Object[]{this.leftTabs, "leftTab", this.rightTabs, "rightTab"};
            int n = 0;
            while (n < objectArray.length) {
                TabbedSplitPane tabbedSplitPane = (TabbedSplitPane)objectArray[n];
                String string = (String)objectArray[n + 1];
                if (tabbedSplitPane != null) {
                    preferences.putDouble(string + "s.horizontalRatio", tabbedSplitPane.getHorizontalRatio());
                    Tab[] tabArray = tabbedSplitPane.getAllTabs();
                    int n2 = 0;
                    while (n2 < tabArray.length) {
                        Tab tab = tabArray[n2];
                        String string2 = string + "." + tab.getComponent().getName();
                        preferences.putBoolean(string2 + ".atStart", tab.isAtStart());
                        preferences.putBoolean(string2 + ".selected", tab.isSelected());
                        ++n2;
                    }
                }
                n += 2;
            }
            if (this.leftSplit != null) {
                preferences.putInt("leftSplit.dividerLocation", this.leftSplit.getDividerLocation());
            }
            if (this.rightSplit != null) {
                preferences.putInt("rightSplit.dividerLocation", this.rightSplit.getDividerLocation());
            }
        }
    }

    public static final class Error
    implements Comparable {
        public String systemId;
        public int lineNumber;
        public int columnNumber;
        public String message;

        public Error(GUIItemSpec gUIItemSpec, String string) {
            this(gUIItemSpec.systemId, gUIItemSpec.lineNumber, gUIItemSpec.columnNumber, string);
        }

        public Error(Locator locator, String string) {
            this(locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber(), string);
        }

        public Error(String string, int n, int n2, String string2) {
            this.systemId = string;
            this.lineNumber = n;
            this.columnNumber = n2;
            this.message = string2;
        }

        public String getMessageWithLocation() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Msg.msg("location", this.systemId, new Integer(this.lineNumber), new Integer(this.columnNumber)));
            stringBuffer.append(": ");
            stringBuffer.append(this.message);
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            String string;
            Error error = (Error)object;
            String string2 = this.systemId != null ? this.systemId : "";
            String string3 = string = error.systemId != null ? error.systemId : "";
            if (string2.equals(string)) {
                if (this.lineNumber == error.lineNumber) {
                    return this.columnNumber - error.columnNumber;
                }
                return this.lineNumber - error.lineNumber;
            }
            return string2.compareTo(string);
        }
    }
}

