/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.ToolBarList;
import com.xmlmind.xmleditapp.kit.gui.ToolBarRef;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.xml.sax.Attributes;

final class Group
extends ToolBarRef
implements ToolBarList {
    public ToolBarRef[] toolBars;
    private ArrayList toolBarList;

    public Group() {
        super("group");
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if ("group".equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.toolBarList = new ArrayList();
            } else {
                GUIItemSpec.unknownChildElement(string, gUISpec);
            }
        } else if ("toolBar".equals(string) || "tool".equals(string) || "statusBar".equals(string)) {
            ToolBarRef toolBarRef = new ToolBarRef(string);
            gUISpec.pushLoader(toolBarRef);
            toolBarRef.startElement(string, attributes, gUISpec);
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        gUISpec.popLoader();
        if (this.toolBarList.size() < 2) {
            this.invalidElement("group", gUISpec);
        } else {
            this.toolBars = new ToolBarRef[this.toolBarList.size()];
            this.toolBarList.toArray(this.toolBars);
            ((ToolBarList)((Object)gUISpec.topLoader())).addToolBar(this);
        }
        this.toolBarList = null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        if (this.toolBars.length != group.toolBars.length) {
            return false;
        }
        int n = 0;
        while (n < this.toolBars.length) {
            if (!this.toolBars[n].equals(group.toolBars[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void list(PrintWriter printWriter) {
        printWriter.print("\tgroup");
        if (this.stretch > 0.0) {
            printWriter.print(" stretch=");
            printWriter.print(this.stretch);
        }
        printWriter.println();
        int n = 0;
        while (n < this.toolBars.length) {
            printWriter.print('\t');
            this.toolBars[n].list(printWriter);
            ++n;
        }
    }

    public void addToolBar(ToolBarRef toolBarRef) {
        if (!this.toolBarList.contains(toolBarRef)) {
            this.toolBarList.add(toolBarRef);
        }
    }

    boolean checkVertical() {
        int n = 0;
        while (n < this.toolBars.length) {
            if (this.toolBars[n].type != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Component createToolBar(boolean bl, GUISpec gUISpec) {
        Component[] componentArray = new Component[this.toolBars.length];
        Component component = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.toolBars.length) {
            ToolBarRef toolBarRef = this.toolBars[n2];
            Component component2 = toolBarRef.createToolBar(bl, gUISpec);
            if (component2 != null) {
                componentArray[n2] = component = component2;
                ++n;
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return component;
            }
        }
        return this.compose(bl, componentArray);
    }

    private Component compose(boolean bl, Component[] componentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 1;
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 1;
        gridBagConstraints.anchor = bl ? 11 : 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (bl) {
            int n = 0;
            while (n < this.toolBars.length) {
                Component component = componentArray[n];
                if (component != null) {
                    double d = this.toolBars[n].stretch;
                    if (d > 0.0) {
                        gridBagConstraints.fill = 3;
                        gridBagConstraints.weighty = d;
                    } else {
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.weighty = 0.0;
                    }
                    jPanel.add(component, gridBagConstraints);
                    ++gridBagConstraints.gridy;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.toolBars.length) {
                Component component = componentArray[n];
                if (component != null) {
                    double d = this.toolBars[n].stretch;
                    if (d > 0.0) {
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.weightx = d;
                    } else {
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.weightx = 0.0;
                    }
                    jPanel.add(component, gridBagConstraints);
                    ++gridBagConstraints.gridx;
                }
                ++n;
            }
        }
        return jPanel;
    }
}

