/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.Hidden;
import com.xmlmind.xmleditapp.kit.gui.MenuBarSpec;
import com.xmlmind.xmleditapp.kit.gui.Panes;
import com.xmlmind.xmleditapp.kit.gui.PreferencesSheetsSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolBars;
import java.awt.Component;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JMenuBar;
import org.xml.sax.Attributes;

final class LayoutSpec
extends GUIItemSpec {
    public String menuBar;
    public ToolBars topToolBars;
    public ToolBars bottomToolBars;
    public ToolBars rightToolBars;
    public ToolBars leftToolBars;
    public Panes leftPanes;
    public Panes rightPanes;
    public String preferencesSheets;
    public Hidden hidden;
    public String label;
    public URL icon;
    public int width;
    public int height;
    boolean insert;

    LayoutSpec() {
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if ("layout".equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.label = GUIItemSpec.getNonEmptyToken(attributes, "label", null);
                this.icon = GUIItemSpec.getURL(attributes, "icon", gUISpec.getLocatorURL(), null);
                this.width = GUIItemSpec.getInt(attributes, "width", 1, 10000, -1);
                this.height = GUIItemSpec.getInt(attributes, "height", 1, 10000, -1);
            } else {
                GUIItemSpec.unknownChildElement(string, gUISpec);
            }
        } else if ("topToolBars".equals(string) || "bottomToolBars".equals(string) || "rightToolBars".equals(string) || "leftToolBars".equals(string)) {
            ToolBars toolBars = new ToolBars(string);
            gUISpec.pushLoader(toolBars);
            toolBars.startElement(string, attributes, gUISpec);
        } else if ("rightPanes".equals(string) || "leftPanes".equals(string)) {
            Panes panes = new Panes(string);
            gUISpec.pushLoader(panes);
            panes.startElement(string, attributes, gUISpec);
        } else if ("hidden".equals(string)) {
            Hidden hidden = new Hidden();
            gUISpec.pushLoader(hidden);
            hidden.startElement(string, attributes, gUISpec);
        } else if ("menuBar".equals(string)) {
            this.menuBar = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (this.menuBar == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            }
        } else if ("preferencesSheets".equals(string)) {
            this.preferencesSheets = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (this.preferencesSheets == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            }
        } else if ("insert".equals(string)) {
            this.insert = true;
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if ("layout".equals(string)) {
            gUISpec.popLoader();
            if (this.menuBar == null && this.topToolBars == null && this.bottomToolBars == null && this.leftToolBars == null && this.rightToolBars == null && this.leftPanes == null && this.rightPanes == null && this.preferencesSheets == null && this.hidden == null && !this.insert) {
                this.invalidElement(string, gUISpec);
            } else if (gUISpec.layout == null || !this.insert) {
                gUISpec.layout = this;
            } else {
                gUISpec.layout.merge(this);
            }
        }
    }

    private void merge(LayoutSpec layoutSpec) {
        if (layoutSpec.menuBar != null) {
            this.menuBar = layoutSpec.menuBar;
        }
        if (layoutSpec.topToolBars != null) {
            this.topToolBars = layoutSpec.topToolBars;
        }
        if (layoutSpec.bottomToolBars != null) {
            this.bottomToolBars = layoutSpec.bottomToolBars;
        }
        if (layoutSpec.leftToolBars != null) {
            this.leftToolBars = layoutSpec.leftToolBars;
        }
        if (layoutSpec.rightToolBars != null) {
            this.rightToolBars = layoutSpec.rightToolBars;
        }
        if (layoutSpec.leftPanes != null) {
            this.leftPanes = layoutSpec.leftPanes;
        }
        if (layoutSpec.rightPanes != null) {
            this.rightPanes = layoutSpec.rightPanes;
        }
        if (layoutSpec.preferencesSheets != null) {
            this.preferencesSheets = layoutSpec.preferencesSheets;
        }
        if (layoutSpec.hidden != null) {
            this.hidden = layoutSpec.hidden;
        }
        if (layoutSpec.label != null) {
            this.label = layoutSpec.label;
        }
        if (layoutSpec.icon != null) {
            this.icon = layoutSpec.icon;
        }
        if (layoutSpec.width > 0) {
            this.width = layoutSpec.width;
        }
        if (layoutSpec.height > 0) {
            this.height = layoutSpec.height;
        }
    }

    public void translate(HashMap hashMap) {
        String string;
        if (this.label != null && (string = (String)hashMap.get(this.label)) != null) {
            this.label = string;
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.print("layout");
        if (this.label != null) {
            printWriter.print(" label=");
            printWriter.print(this.label);
        }
        if (this.icon != null) {
            printWriter.print(" icon=");
            printWriter.print(this.icon);
        }
        if (this.width > 0) {
            printWriter.print(" width=");
            printWriter.print(this.width);
        }
        if (this.height > 0) {
            printWriter.print(" height=");
            printWriter.print(this.height);
        }
        printWriter.println(':');
        if (this.menuBar != null) {
            printWriter.print("* menuBar: ");
            printWriter.println(this.menuBar);
        }
        if (this.topToolBars != null) {
            printWriter.print("* ");
            this.topToolBars.list(printWriter);
        }
        if (this.bottomToolBars != null) {
            printWriter.print("* ");
            this.bottomToolBars.list(printWriter);
        }
        if (this.leftToolBars != null) {
            printWriter.print("* ");
            this.leftToolBars.list(printWriter);
        }
        if (this.rightToolBars != null) {
            printWriter.print("* ");
            this.rightToolBars.list(printWriter);
        }
        if (this.leftPanes != null) {
            printWriter.print("* ");
            this.leftPanes.list(printWriter);
        }
        if (this.rightPanes != null) {
            printWriter.print("* ");
            this.rightPanes.list(printWriter);
        }
        if (this.preferencesSheets != null) {
            printWriter.print("* preferencesSheets: ");
            printWriter.println(this.preferencesSheets);
        }
        if (this.hidden != null) {
            printWriter.print("* ");
            this.hidden.list(printWriter);
        }
    }

    public JMenuBar createMenuBar(GUISpec gUISpec) {
        if (this.menuBar == null) {
            return null;
        }
        MenuBarSpec menuBarSpec = (MenuBarSpec)gUISpec.menuBarSet.get(this.menuBar);
        if (menuBarSpec == null) {
            this.componentNotDefined("menuBar", this.menuBar, gUISpec);
            return null;
        }
        return menuBarSpec.createMenuBar(gUISpec);
    }

    public Component createTopToolBars(GUISpec gUISpec) {
        if (this.topToolBars == null) {
            return null;
        }
        return this.topToolBars.createToolBars(gUISpec);
    }

    public Component createBottomToolBars(GUISpec gUISpec) {
        if (this.bottomToolBars == null) {
            return null;
        }
        return this.bottomToolBars.createToolBars(gUISpec);
    }

    public Component createLeftToolBars(GUISpec gUISpec) {
        if (this.leftToolBars == null) {
            return null;
        }
        return this.leftToolBars.createToolBars(gUISpec);
    }

    public Component createRightToolBars(GUISpec gUISpec) {
        if (this.rightToolBars == null) {
            return null;
        }
        return this.rightToolBars.createToolBars(gUISpec);
    }

    public Component createLeftPanes(GUISpec gUISpec) {
        if (this.leftPanes == null) {
            return null;
        }
        return this.leftPanes.createPanes(gUISpec);
    }

    public Component createRightPanes(GUISpec gUISpec) {
        if (this.rightPanes == null) {
            return null;
        }
        return this.rightPanes.createPanes(gUISpec);
    }

    public void createPreferencesSheets(GUISpec gUISpec) {
        if (this.preferencesSheets == null) {
            return;
        }
        PreferencesSheetsSpec preferencesSheetsSpec = (PreferencesSheetsSpec)gUISpec.preferencesSheetsSet.get(this.preferencesSheets);
        if (preferencesSheetsSpec == null) {
            this.componentNotDefined("preferencesSheets", this.preferencesSheets, gUISpec);
            return;
        }
        preferencesSheetsSpec.createPreferencesSheets(gUISpec);
    }

    public void createHidden(GUISpec gUISpec) {
        if (this.hidden == null) {
            return;
        }
        this.hidden.createHidden(gUISpec);
    }
}

