/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.AppMenuItems;
import com.xmlmind.xmleditapp.kit.gui.ActionSpec;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSkip;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.MenuItemsSpec;
import com.xmlmind.xmleditapp.kit.gui.Msg;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.xml.sax.Attributes;

final class MenuSpec
extends GUIItemSpec {
    public static final int ITEM_TYPE_SEPARATOR = 0;
    public static final int ITEM_TYPE_ACTION = 1;
    public static final int ITEM_TYPE_MENU = 2;
    public static final int ITEM_TYPE_MENU_ITEMS = 3;
    public String name;
    public String label;
    public String helpId;
    public Item[] items;
    private int insert;

    MenuSpec() {
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if ("menu".equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.name = GUIItemSpec.getNMTOKEN(attributes, "name", null);
                if (this.name == null) {
                    GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
                }
                this.label = GUIItemSpec.getNonEmptyToken(attributes, "label", null);
                this.helpId = GUIItemSpec.getNMTOKEN(attributes, "helpId", null);
            } else {
                String string2 = GUIItemSpec.getNMTOKEN(attributes, "name", null);
                if (string2 == null) {
                    GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
                } else {
                    this.addItem(2, string2);
                }
                GUIItemSkip gUIItemSkip = new GUIItemSkip("menu");
                gUISpec.pushLoader(gUIItemSkip);
                gUIItemSkip.startElement("menu", null, gUISpec);
            }
        } else if ("insert".equals(string)) {
            this.insert = this.items == null ? 2 : 1;
        } else if ("separator".equals(string)) {
            this.addItem(0, null);
        } else if ("action".equals(string)) {
            String string3 = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (string3 == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            } else {
                this.addItem(1, string3);
            }
        } else if ("menuItems".equals(string)) {
            String string4 = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (string4 == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            } else {
                this.addItem(3, string4);
            }
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if ("menu".equals(string)) {
            gUISpec.popLoader();
            if (this.name == null || this.items == null) {
                this.invalidElement("menu", gUISpec);
            } else {
                HashMap hashMap = gUISpec.menuSet;
                MenuSpec menuSpec = (MenuSpec)hashMap.get(this.name);
                if (menuSpec == null || this.insert == 0) {
                    menuSpec = this;
                    hashMap.put(this.name, this);
                } else {
                    menuSpec.merge(this);
                }
                int n2 = menuSpec.items.length - 1;
                int n3 = 0;
                while (n3 <= n2) {
                    Item item = menuSpec.items[n3];
                    if (item.type == 3 && n3 != n2) {
                        this.invalidElement2("menu", Msg.msg("menuItemsMustBeLast"), gUISpec);
                        hashMap.remove(this.name);
                        break;
                    }
                    ++n3;
                }
                if (menuSpec.label == null) {
                    this.invalidElement2("menu", Msg.msg("missingOrInvalidAttribute", "label"), gUISpec);
                    hashMap.remove(this.name);
                }
            }
        }
    }

    private void addItem(int n, String string) {
        Item item = new Item();
        item.type = n;
        item.name = string;
        if (this.items == null) {
            this.items = new Item[]{item};
        } else {
            int n2 = this.items.length;
            Item[] itemArray = new Item[n2 + 1];
            System.arraycopy(this.items, 0, itemArray, 0, n2);
            itemArray[n2] = item;
            this.items = itemArray;
        }
    }

    private void merge(MenuSpec menuSpec) {
        if (menuSpec.label != null) {
            this.label = menuSpec.label;
        }
        if (menuSpec.helpId != null) {
            this.helpId = menuSpec.helpId;
        }
        if (menuSpec.insert == 1) {
            int n = menuSpec.items.length;
            int n2 = this.items.length;
            Item[] itemArray = new Item[n + n2];
            System.arraycopy(menuSpec.items, 0, itemArray, 0, n);
            System.arraycopy(this.items, 0, itemArray, n, n2);
            this.items = itemArray;
        } else {
            int n = this.items.length;
            int n3 = menuSpec.items.length;
            Item[] itemArray = new Item[n + n3];
            System.arraycopy(this.items, 0, itemArray, 0, n);
            System.arraycopy(menuSpec.items, 0, itemArray, n, n3);
            this.items = itemArray;
        }
    }

    public void translate(HashMap hashMap) {
        String string = (String)hashMap.get(this.label);
        if (string != null) {
            this.label = string;
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.print("menu ");
        printWriter.print(this.name);
        if (this.label != null) {
            printWriter.print(" label=");
            printWriter.print(this.label);
        }
        if (this.helpId != null) {
            printWriter.print(" helpId=");
            printWriter.print(this.helpId);
        }
        printWriter.println(':');
        int n = 0;
        while (n < this.items.length) {
            Item item = this.items[n];
            printWriter.print("* ");
            switch (item.type) {
                case 0: {
                    printWriter.print("separator");
                    break;
                }
                case 1: {
                    printWriter.print("action");
                    break;
                }
                case 2: {
                    printWriter.print("menu");
                    break;
                }
                case 3: {
                    printWriter.print("menuItems");
                }
            }
            if (item.name != null) {
                printWriter.print(' ');
                printWriter.print(item.name);
            }
            printWriter.println();
            ++n;
        }
    }

    public JMenu createMenu(GUISpec gUISpec) {
        JMenu jMenu = new JMenu(DialogUtil.buttonLabel(this.label));
        DialogUtil.setMnemonic(jMenu, this.label);
        int n = 0;
        while (n < this.items.length) {
            Item item = this.items[n];
            switch (item.type) {
                case 0: {
                    jMenu.addSeparator();
                    break;
                }
                case 1: {
                    GUIItemSpec gUIItemSpec = (ActionSpec)gUISpec.actionSet.get(item.name);
                    if (gUIItemSpec == null) {
                        this.componentNotDefined("action", item.name, gUISpec);
                        break;
                    }
                    Serializable serializable = ((ActionSpec)gUIItemSpec).createAction(gUISpec);
                    if (serializable == null) break;
                    JMenuItem jMenuItem = jMenu.add((Action)((Object)serializable));
                    jMenuItem.setToolTipText(null);
                    if (((AppAction)serializable).getIcon() != null) break;
                    AppMenuItems.setNonIconic(jMenuItem);
                    break;
                }
                case 2: {
                    GUIItemSpec gUIItemSpec = (MenuSpec)gUISpec.menuSet.get(item.name);
                    if (gUIItemSpec == null) {
                        this.componentNotDefined("menu", item.name, gUISpec);
                        break;
                    }
                    Serializable serializable = ((MenuSpec)gUIItemSpec).createMenu(gUISpec);
                    if (serializable == null) break;
                    AppMenuItems.setNonIconic((AbstractButton)serializable);
                    jMenu.add((JMenuItem)serializable);
                    break;
                }
                case 3: {
                    GUIItemSpec gUIItemSpec = (MenuItemsSpec)gUISpec.menuItemsSet.get(item.name);
                    if (gUIItemSpec == null) {
                        this.componentNotDefined("menuItems", item.name, gUISpec);
                        break;
                    }
                    ((MenuItemsSpec)gUIItemSpec).createMenuItems(jMenu, gUISpec);
                }
            }
            ++n;
        }
        if (this.helpId != null) {
            gUISpec.app.setHelpId(jMenu, this.helpId);
        }
        return jMenu;
    }

    public static final class Item {
        public int type;
        public String name;
    }
}

